#ifndef _KVI_USERPOPUPMENU_H_INCLUDED_
#define _KVI_USERPOPUPMENU_H_INCLUDED_

// =============================================================================
//
//      --- kvi_userpopupmenu.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

#include "kvi_popupmenu.h"
#include "kvi_string.h"

class QFile;
class QPalette;

class KviUserPopupMenu;
class KviWindow;

typedef struct KviUserPopupMenuData
{
	KviStr            buffer;
	KviStr            text;
	KviStr            image;
	KviUserPopupMenu *menu;
	int               id;
};

/**
 * An item with id = 0, menu = 0 and buffer = " " is a separator.
 * Normal menu item buffers have the initial spaces stripped at
 * insertion time.
 */
class KviUserPopupMenu : public KviPopupMenu
{
	friend class KviPopupEditor;
	friend class KviUserToolBarEditor;

	Q_OBJECT
public:
	KviUserPopupMenu(QWidget *parent, const char *name);
	~KviUserPopupMenu();

	bool m_bLocked;              // Protects against self-modification
	void clearAll();
	const KviStr text(int id);
	int  insertNormalItem(const char *name, const char *img, const char *buffer);
	void  insertPopupItem(const char *name, const char *img, KviUserPopupMenu *menu);
	void insertSeparatorItem();
	void doPopup(const QWidget *receiver, const char *memberSlot);
	void doPopup(const QWidget *receiver, const char *memberSlot, QPoint pos);
	void doTestPopup(const QWidget *receiver, const char *memberSlot);
	void reloadMenu(const QWidget *parentWindow);
	void copyFromPopup(KviUserPopupMenu *popup);
	static bool saveAllPopups(const char *filename);
	static bool loadAllPopups(const char *filename, KviStr &error);
	virtual void setFont(const QFont &font);
	void setPaletteRecursive(const QPalette &pal);

	// Needed for KviUserToolBar
	void buildDataBuffer(KviStr &str);
	bool loadFromDataBuffer(KviStr &buffer, KviStr &error);
public slots:
	void localItemClicked(int id);
signals:
	void itemClicked(const KviStr &buffer);
	void testItemClicked(int id);
private:
	QPtrList<KviUserPopupMenuData> m_pDataList;

	KviUserPopupMenu *m_pParent;
	KviWindow        *m_pParentWindow;

	bool m_bInTestMode;
	void itemClickedRedirect(const KviStr &buffer, int id);
	void save(QFile *, const char *popupName);
	bool load(QFile *, const char *popupName, KviStr &error);
};

#endif // _KVI_USERPOPUPMENU_H_INCLUDED_
