// =============================================================================
//
//   Copyright (C) 1999-2000 Szymon Stefanek
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviStyle"

#include <qpixmap.h>

#define __KVIRC_PLUGIN__

#include "kvi_style.h"
#include "kvi_style_basic.h"
#include "kvi_style_images.h"
#include "kvi_style_images_pure.h"
#include "kvi_style_images_wood.h"
#include "kvi_style_pure.h"
#include "kvi_style_wood.h"
#include "kvirc_plugin.h"

// Basic style
QPixmap *button_pix;
QPixmap *button_def_pix;
QPixmap *arrow_pix;
QPixmap *check_pix;

QPixmap *pure_marble_pix;
QPixmap *wood_back_pix;

KviBasicStyle *m_basic_style;
KviPureStyle  *m_pure_style;
KviWoodStyle  *m_wood_style;

QStyle *style_plugin_get_basic_style()
{
	if( !m_basic_style )
		m_basic_style = new KviBasicStyle();
	return m_basic_style;
}

QStyle *style_plugin_get_pure_style()
{
	if( !pure_marble_pix )
		pure_marble_pix = new QPixmap(pure_marble_xpm);
	if( !m_pure_style )
		m_pure_style = new KviPureStyle();
	return m_pure_style;
}

QStyle *style_plugin_get_wood_style()
{
	if( !wood_back_pix )
		wood_back_pix = new QPixmap(wood_button_xpm);
	if( !m_wood_style )
		m_wood_style = new KviWoodStyle();
	return m_wood_style;
}

bool style_plugin_init(KviPluginCommandStruct *cmd)
{
	m_basic_style   = 0;
	m_pure_style    = 0;
	m_wood_style    = 0;
	button_pix      = new QPixmap(button_xpm);
	button_def_pix  = new QPixmap(button_def_xpm);
	arrow_pix       = new QPixmap(arrow_xpm);
	check_pix       = new QPixmap(check_xpm);
	pure_marble_pix = 0;
	wood_back_pix   = 0;

	kvirc_plugin_register_style(cmd->handle, "Basic", style_plugin_get_basic_style);
	kvirc_plugin_register_style(cmd->handle, "Pure",  style_plugin_get_pure_style);
	kvirc_plugin_register_style(cmd->handle, "Wood",  style_plugin_get_wood_style);
	return true;
}

void style_plugin_cleanup()
{
	if( pure_marble_pix ) {
		delete pure_marble_pix;
		pure_marble_pix = 0;
	}
	if( wood_back_pix ) {
		delete wood_back_pix;
		wood_back_pix = 0;
	}
	delete button_pix;      button_pix      = 0;
	delete button_def_pix;  button_def_pix  = 0;
	delete arrow_pix;       arrow_pix       = 0;
	delete check_pix;       check_pix       = 0;
}

/**
 * Your plugin definition structure.
 */
KviPlugin kvirc_plugin =
{
	"Style",
	"Sample GUI styles",
	"0.1",
	"Szymon Stefanek <stefanek@tin.it>",
	"<html>"
		"This plugin exports three GUI styles:<br>"
		"Basic, Pure and Wood."
		"</html>",
	style_plugin_init,
	style_plugin_cleanup,
	0,
	0
};
