/***************************************************************************
                          ktray.h  -  description
                             -------------------
    begin                : Die Nov 12 2002
    copyright            : (C) 2002 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#define HIGH  0
#define MED   1
#define LOW   2
 
#ifndef KTRAY_H
#define KTRAY_H

#include <ksystemtray.h>
#include <kpopupmenu.h>


#include <qpixmap.h>
#include <qaction.h>
#include <qtimer.h>
#include <qtooltip.h>
#include <qstring.h>
#include <qiconset.h>
#include <qfile.h>


#include "options.h"
#include "wwidget.h"
#include "smallwidget.h"

#include "wcard.h"

/**
  *@author Matthias Reif
  */

class KTray :  public KSystemTray  {
  Q_OBJECT
public: 
	KTray(QWidget* parent=0, const char *name=0);
	~KTray();
  /** No descriptions */
  void setState(int value);

private:

  QFile *confFile;
  QString device;

  QPixmap icons[11];

  KPopupMenu *popup;
  QAction    *openAction;
  QAction    *closeAction;
  QAction		 *smallAction;
  
  QTimer      *basicTimer;
  QTimer			*shortTimer;

  WWidget     *widget;
  SmallWidget *smallWidget;

  WCard       *card;

  Options     *options;

  int state;
  int med, high;

  int link, avg, signal, noise;

  
public slots: // Public slots
  /** No descriptions */
  void slotAct();
  void slotOpen();
  void slotClose();  
  /** No descriptions */
  void slotPolling(int value);
  /** No descriptions */
  void slotSmall();
protected: // Protected methods
  /** No descriptions */
  void mousePressEvent ( QMouseEvent * );
};

#endif
