/***************************************************************************
                          wcard.h  -  description
                             -------------------
    begin                : Mon Nov 11 2002
    copyright            : (C) 2002 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//#include <linux/types.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/ethernet.h>
//#include <net/if.h>

#ifndef WCARD_H
#define WCARD_H


#include <sys/ioctl.h>
//#include <sys/param.h>

#include <fcntl.h>
#include <linux/wireless.h>


struct BitRate {
  int   value;
  char  unit[5];
};

struct BitRatesArray {
  struct BitRate bitRate[IW_MAX_BITRATES];
  int    num;
};

typedef struct BitRatesArray BitRates;

/**
  *@author Matthias Reif
  */

class WCard {
public: 
	WCard(const char* dev);
	~WCard();
  /** No descriptions */
  int getLinkQual(int &link, int &avg, int &signal, int &noise);
  /** No descriptions */
  int getNetID();
  /** No descriptions */
  void setDevice(const char* name);
  /** No descriptions */
  char* getIP();
  /** No descriptions */
  char* getDevice();
  /** No descriptions */
  int getProtocol(char *protocol);
  /** No descriptions */
  int getMode();
  /** No descriptions */
  int setMode(int mode);
  /** No descriptions */
  int getFreq();
  /** No descriptions */
  int getBitRate(BitRates *br, int &index);
  /** No descriptions */
  int getAPMac(char *s);
  /** No descriptions */
  int getChannel(int &numFreq,double &freq, char* eh, int &numChannel, int &channel);
  /** No descriptions */
  bool isWave();
  /** No descriptions */
  int getTransmitPower(char *unit);
  /** No descriptions */
  bool getEncode(char* key);
  /** No descriptions */
  int getSensitivity(int &valueS, int &rangeS);
  /** No descriptions */
  int setSensitivity(int value);  
  /** No descriptions */
  int getRTS(int &value);
  /** No descriptions */
  bool hasLink();
  /** No descriptions */
  int setBitRate(int index);
  /** No descriptions */
  int getESSID(char *value);
  /** No descriptions */
  int setESSID(const char *value);
  /** No descriptions */
  bool getTraffic(int &sent, int &recv);
  /** No descriptions */
  int getNetworkID();
  /** No descriptions */
  int getNickName(char *name);
  /** No descriptions */
  int getRetryLimit(int &value);
  
protected:

  int ethFD;

  char* device;
  
  struct	iwreq* pwrq;
  struct iwreq wrq;

  typedef struct iw_statistics iwstat;
  iwstat* stats;
  typedef struct iw_range iwrange;
  iwrange* range;

  FILE	*procFile;
  char	*procBuffer;
  bool	procSuccessful;

};

#endif
