/***************************************************************************
                           kxenewfilesettings.h
                           --------------------
    begin                : Tue Dec 02 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : hartig@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXENEWFILESETTINGS_H
#define KXENEWFILESETTINGS_H

#include "kxesettings.h"

class KXENewFileSettingsPage;

/**
 * This class represents the group of configuration settings for
 * new files.
 *
 * @author Olaf Hartig
 */
class KXENewFileSettings : public KXESettings
{
	public:

		enum NewFileCreationBehaviour
		{
			CreateEmptyFile,
			CreateWithAssistance,
			UseDefaults
		};

		KXENewFileSettings( QObject * pParent = 0, const char * pszName = 0 );

		// The following functions can be used to access this object's settings.
		QString dfltVersion() const { return m_strDfltVersion; }
		QString dfltEncoding() const { return m_strDfltEncoding; }
		NewFileCreationBehaviour newFileCreaBehav() const { return m_enmNewFileCreaBehav; }

		/**
		 * Returns a list of all possible encodings.
		 */
		static QStringList encodings();

		/**
		 * Sets this object's new file creation behavior to the given one,
		 * updates the corresponding widget (in the config.dialog page
		 * @ref m_pDialogPage), stores this value to the given config.file
		 * and emits the signal @ref KXESettings::sigChanged.
		 */
		void setNewFileCreaBehav( NewFileCreationBehaviour, KConfig * );

		/**
		 * Derived from @ref KXESettings
		 */
		virtual QString dialogPageName() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual QString dialogPageHeader() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual QString dialogPageIcon() const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual QWidget * dialogPage( QFrame * pParent );

	protected:

		/**
		 * Derived from @ref KXESettings
		 */
		virtual void write( KConfig * ) const;
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void read( const KConfig * );
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void setFromPage();
		/**
		 * Derived from @ref KXESettings
		 */
		virtual void updatePage() const;

		// the settings itself
		QString m_strDfltVersion;
		QString m_strDfltEncoding;
		NewFileCreationBehaviour m_enmNewFileCreaBehav;

		/**
		 * the corresponding configuration dialog page
		 * It is created on demand by @ref dialogPage.
		 */
		KXENewFileSettingsPage * m_pDialogPage;

};

#endif
