//LabPlot : Graph4D.h

#ifndef GRAPH4D_H
#define GRAPH4D_H

#include <qtextstream.h>
#include "Graph.h"
#include "LRange.h"
#include "Point4D.h"
#include "defs.h"

class Graph4D: public Graph
{
public:
	Graph4D(QString n=QString(""), QString l=QString(""), LRange r[4]=0, LSource src=SFUNCTION, PType t=P2D, 
		Style st=Style(), Symbol sy=Symbol(), Point4D *p=0, int nr=0, bool ty=0, bool s=TRUE);
	Point4D *Data() { return ptr; }
	LRange Range(int i) { return range[i]; }
	void setRange(LRange *r) { range[0]=r[0];range[1]=r[1];range[2]=r[2];range[3]=r[3]; }
	bool GType() { return gtype; }
	void setGType(bool t) { gtype = t; }
	void save(QTextStream *t);
	void open(QTextStream *t,int version);
	QStringList Info();
	LRange ErrorDXRange();
	LRange ErrorDYRange();
private:
	bool gtype;						// 0 : x-y-dx-dy, 1: x-y-dy1-dy2
	Point4D *ptr;
	LRange *range;
};

#endif // GRAPH4D_H
