//LabPlot : SpreadsheetValuesDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include "SpreadsheetValuesDialog.h"

SpreadsheetValuesDialog::SpreadsheetValuesDialog(MainWin *mw, QTable *t, const char *name)
	: Dialog(0, name), mw(mw), table(t)
{
	setCaption(i18n("Spreadsheet")+i18n(" : ")+QString(name));

	QHBox *hb = new QHBox(vbox);

	// use selected range / max range
	int min=1,max = table->numRows();
	QTableSelection sel = table->selection(table->currentSelection());
	if (sel.isActive()) {
		min = sel.topRow()+1;
		max = sel.bottomRow()+1;
	}
	new QLabel(i18n("Range : "),hb);
	ale =  new KLineEdit(QString::number(min),hb);
	ale->setValidator(new QIntValidator(ale));
	new QLabel(i18n(" to "),hb);
	ble =  new KLineEdit(QString::number(max),hb);
	ble->setValidator(new QIntValidator(ble));
	
	hb = new QHBox(vbox);
	new QLabel(i18n(" Expression (sin(a+b), ...) : "),hb);
	exprle =  new KLineEdit("",hb);
		
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	
	setMinimumWidth(2*vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void SpreadsheetValuesDialog::apply_clicked() {
	QString expr = exprle->text();

	for(int i=ale->text().toInt();i<=ble->text().toInt();i++) {
		QString tmp(expr.lower());
		
		// replace a,b,c,d,...
		for(int j=0;j<table->numCols();j++)
			tmp = mw->parseExpression(tmp,table->text(i-1,j).toDouble(),j);
		
		double result = parse((char *) tmp.latin1());
		
		table->setText(i-1,table->currentColumn(),QString::number(result));
	}
}
