#include <stdlib.h>
#include "lists.h"

/* manipulation of bidirectional linked lists */
/* ------------------------------------------ */

/* 
 * doesn't take care about mutexes/race-conditions in
 * multi-threaded environnements
 */

void list_init(struct list_anchor_t *list)
/* resets all list_anchor_t fields to default values */
{
 list->first = NULL;
 list->last = NULL;
 list->count = 0;
}

struct list_hdr_t *list_add(struct list_anchor_t *list, int size)
/* appends an item to the end of the list */
{
 struct list_hdr_t *item;

 if ( !(item = malloc(size)) ) return(NULL);	// malloc() failed
 if ( (list->first == NULL) || (list->last == NULL) )
 {		// will be the first item in this list
   list_init(list);	// you never know...
   list->first = item;
   item->prev = NULL;
 }
 else
 {
   item->prev = list->last;
   list->last->next = item;
 }
 list->last = item;
 item->next = NULL;
 list->count++;
 return(item);
}

void list_del(struct list_anchor_t *list, struct list_hdr_t *item)
/* deletes indicated item from list */
{
 if ( list->first == NULL ) return; // no items in list...
 if ( list->first == list->last )
 {		// no other item in list
  list->first = NULL;
  list->last = NULL;
  list->count = 1;	// will be set to 0 at the end of the function
 }
 else if ( item == list->first )
 {		// first item in list
  ((struct list_hdr_t *)(item->next))->prev = NULL;
  list->first = item->next;
 }
 else if ( item == list->last )
 {		// last item in list
  ((struct list_hdr_t *)(item->prev))->next = NULL;
  list->last = item->prev;
 }
 else
 {		// item is somewhere in between
  ((struct list_hdr_t *)(item->prev))->next = item->next;
  ((struct list_hdr_t *)(item->next))->prev = item->prev;
 }
 free(item);
 list->count--;
}

void list_flush(struct list_anchor_t *list)
/* deletes all items in a list and calls list_init() */
{
 register struct list_hdr_t *dum, *item = list->first;

 while ( item )
 {
  dum = item;
  item = item->next;
  free(dum);
 }
 list_init(list);
}

int list_count(struct list_anchor_t *list)
/* counts all items in the list */
{
 register int cnt = 0;
 register struct list_hdr_t *item = list->first;

 while ( item )
 {
  cnt++;
  item = item->next;
 }
 return(cnt);
}

struct list_hdr_t *list_find(struct list_anchor_t *list, int id)
/* returns pointer to item whose id = id or NULL if nothing found */
{
 struct list_hdr_t *item = list->first;
 while ( item )
 {
  if ( item->id == id ) break;
  item = item->next;
 }
 if ( item != NULL ) return(item);
 else return(NULL);
}

int list_del_id(struct list_anchor_t *list, int id)
/* return number of deleted items */
{
 struct list_hdr_t *dum;
 register struct list_hdr_t *item = list->first;
 int cnt = 0;

 while ( item )
 {
  if ( item->id == id )
  {
   dum = item;
   list_del(list, dum);
   cnt++;
  }
  item = item->next;
 }
 return(cnt);
}

void *list_secure(struct list_anchor_t *list, struct list_hdr_t *item)
// checks, whether item still exists in list
// return: NULL if not found, *item if found
{
 struct list_hdr_t *ite = list->first;
 while ( (ite != NULL) && (ite != item) )
     ite = (struct list_hdr_t*)ite->next;
 if ( ite != item ) return(NULL);
 else return(ite);
}
