/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "MessageControl.h"

const int BORDER_SIZE = 5;

CMessageControl::CMessageControl(wxWindow* parent, int id, wxString* messages, int count, int maxLength) :
wxPanel(parent, id),
m_count(count),
m_messages(NULL)
{
	wxASSERT(messages != NULL);
	wxASSERT(m_count > 0);
	wxASSERT(maxLength > 0);

	wxStaticBoxSizer* sizer = new wxStaticBoxSizer(new wxStaticBox(this, -1, wxT("Messages")), wxVERTICAL);

	m_messages = new CMessageTextCtrl*[m_count];

	for (int i = 0; i < m_count; i++) {
		wxBoxSizer* messageSizer = new wxBoxSizer(wxHORIZONTAL);
		m_messages[i] = new CMessageTextCtrl(this, Text_Messages_Begin + i, wxEmptyString, false, wxDefaultPosition, wxSize(275, -1));
		m_messages[i]->SetMaxLength(maxLength);
		m_messages[i]->SetValue(messages[i]);
		messageSizer->Add(m_messages[i], 0, wxALL, BORDER_SIZE);

		wxRadioButton* messageButton = new wxRadioButton(this, Button_Messages_Begin + i, wxEmptyString);
		messageSizer->Add(messageButton, 0, wxALL, BORDER_SIZE);

		sizer->Add(messageSizer);
	}

	SetAutoLayout(true);

	sizer->Fit(this);
	sizer->SetSizeHints(this);

	SetSizer(sizer);
}

CMessageControl::~CMessageControl()
{
}

void CMessageControl::setMessage(int n, const wxString& text)
{
	wxASSERT(n >= 0 && n < m_count);

	m_messages[n]->SetValue(text);
}

wxString CMessageControl::getMessage(int n) const
{
	wxASSERT(n >= 0 && n < m_count);

	return m_messages[n]->GetValue().MakeUpper();
}
