/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441Lookups.h"

CFSK441Lookups::CFSK441Lookups()
{
}

CFSK441Lookups::~CFSK441Lookups()
{
}

bool CFSK441Lookups::lookupChar(const wxString& text, int& t1, int& t2, int& t3) const
{
	for (int i = 0; i < 69; i++) {
		if (multiToneTable[i].text == text) {
			t1 = multiToneTable[i].t1;
			t2 = multiToneTable[i].t2;
			t3 = multiToneTable[i].t3;
			return true;
		}
	}

	return false;
}

bool CFSK441Lookups::lookupSingleTones(int t1, int t2, int t3, wxString& text) const
{
	for (int i = 0; i < 4; i++) {
		if (t1 == singleToneTable[i].t1 &&
		    t2 == singleToneTable[i].t2 &&
		    t3 == singleToneTable[i].t3) {
			text = singleToneTable[i].text;
			return true;
		}
	}

	return false;
}

bool CFSK441Lookups::lookupMultiTones(int t1, int t2, int t3, wxString& text) const
{
	for (int i = 0; i < 69; i++) {
		if (t1 == multiToneTable[i].t1 &&
		    t2 == multiToneTable[i].t2 &&
		    t3 == multiToneTable[i].t3) {
			text = multiToneTable[i].text;
			return true;
		}
	}

	return false;
}

