/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT44App_H
#define	JT44App_H

#include <wx/wx.h>

#include "JT44Frame.h"

#include "common/Text.h"

#include "jt44/JT44Controller.h"
#include "jt44/JT44Levels.h"
#include "jt44/JT44Message.h"
#include "jt44/JT44FileReceive.h"

class CJT44App : public wxApp {

    public:
	CJT44App();
	virtual ~CJT44App();

	virtual bool OnInit();
	virtual int  OnExit();
	
	// This is overridden because dialog boxes from threads are bad news
#ifdef __WXDEBUG__
	virtual void OnAssert(const wxChar* file, int line, const wxChar* cond, const wxChar* msg);
#endif
	virtual void receiveCardMessage(CJT44Message* message) const;
	virtual void receiveFileMessage(CJT44Message* message) const;

	virtual void showCardLevels(CJT44Levels* levels) const;
	virtual void showFileLevels(CJT44Levels* levels) const;

	virtual void error(const wxString& text) const;

	virtual bool     getTXFirst() const;
	virtual void     setTXFirst(bool first) const;
	virtual bool     getTXEnable() const;
	virtual void     setTXEnable(bool enabled);

	virtual int      getMinSync() const;
	virtual void     setMinSync(int level) const;

	virtual void     getPersonal(wxString& callsign, wxString& locator) const;
	virtual void     setPersonal(const wxString& callsign, const wxString& locator) const;
	virtual int      getBand() const;
	virtual void     setBand(int band) const;
	virtual void     getPTT(wxString& type, wxString& device) const;
	virtual void     setPTT(const wxString& type, const wxString& device) const;
	virtual void     getSound(wxString& type, wxString& fileName, int& bits) const;
	virtual void     setSound(const wxString& type, const wxString& fileName, int bits) const;
	virtual wxString getReplacedMessage(int n) const;
	virtual wxString getOriginalMessage(int n) const;
	virtual void     setMessage(int n, const wxString& message);
	virtual void     getMessage(int n, wxString& message) const;

	virtual void     setRemote(const wxString& callsign, const wxString& locator);
	virtual void     setRecording(bool recording);
	virtual void     sendMessage(const wxString& message);
	virtual void     readFile(const wxString& fileName);

	virtual void     setSaving(bool saving);
	virtual void     logMessage(const CJT44Message& message) const;
	virtual void     deleteMessages() const;

    private:
	CJT44Frame*       m_frame;
	CJT44Controller*  m_controller;
	CText**           m_messages;
	CJT44FileReceive* m_file;
	bool              m_saving;
	bool              m_recording;
	bool              m_txEnable;

	void createController();
	void createFileReader();
	void readRegistry();
};

DECLARE_APP(CJT44App)

#endif
