/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT6MFileReceive.h"
#include "JT6MDefs.h"

#include "jt6mgui/JT6MApp.h"

#include <wx/debug.h>
#include <wx/log.h>

CJT6MFileReceive::CJT6MFileReceive() :
CJT6MReceive(),
m_fileName(wxEmptyString),
m_soundDev(NULL)
{
}

CJT6MFileReceive::~CJT6MFileReceive()
{
}

bool CJT6MFileReceive::getEndTime()
{
	return false;
}

void CJT6MFileReceive::setFileName(const wxString& fileName)
{
	wxASSERT(m_soundDev == NULL);

	m_fileName = fileName;

	m_soundDev = CSoundDev::createSoundDev(wxT("file"), fileName, JT6M_SAMPLE_RATE, 16);
	m_soundDev->openRead();
}

void CJT6MFileReceive::openSoundDevice()
{
	wxASSERT(m_soundDev != NULL);
}

void CJT6MFileReceive::closeSoundDevice()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->close();
	delete m_soundDev;

	m_soundDev = NULL;
}

void CJT6MFileReceive::recordAudio(const wxString& id, double* audioData, int length) const
{
	wxASSERT(audioData != NULL);
	wxASSERT(length > 0);
}

void CJT6MFileReceive::receiveMessage(CJT6MMessage* message) const
{
	::wxGetApp().receiveFileMessage(message);
}

void CJT6MFileReceive::showLevels(CJT6MLevels* levels) const
{
	::wxGetApp().showFileLevels(levels);
}

wxString CJT6MFileReceive::createId()
{
	wxString id = m_fileName;

	int pos = id.Find(wxT('/'), true);
	if (pos != -1) {
		wxString temp = id.Mid(pos + 1);
		id = temp;
	}

	pos = id.Find(wxT('.'));
	if (pos != -1) {
		wxString temp = id.Mid(0, pos);
		id = temp;
	}

	return id;
}

void CJT6MFileReceive::error(const wxString& text)
{
        ::wxLogError(wxT("%ld: %s"), GetId(), text.c_str());

	::wxGetApp().error(text);
}
