#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <sys/socket.h>
#include <sys/types.h>

#include "gnet_lib.h"
#include "gnet_channel.h"
#include "gnet_proto.h"
#include "gnet_msg.h"
#include "gnet_search.h"

static int
handle_bye(struct gnet *gnet, struct channel *chan){
    char *msg = chan->c_buf;
    char *data = msg + GNET_HDR_SIZE;

    TRACE("***got a bye message: %hu", GTOHS(*(uint16_t*)data));
    TRACE("%s", data + 2);

    gnet_drop_channel(gnet, chan);

    return 0;
}

static int
handle_ping(struct gnet *gnet, struct channel *chan){
    struct message *reply;
    char *msg = chan->c_buf;
    char *data;

    TRACE("got a ping");
    
    if(!(reply = gnet_create_message(GNET_ID(msg), GNET_MSG_PONG, GNET_TTL(msg) + GNET_HOPS(msg), 0, GNET_PONG_SIZE))){
	WARN("could not create reply message: %s", strerror(errno));
	return -1;
    }
    
    data = reply->m_data + GNET_HDR_SIZE;

    *(uint16_t*)data = HTOGS(gnet->g_cfg->listen_port);
    *(uint32_t*)(data + 6) = HTOGL(gnet->g_cfg->shared_files);
    *(uint32_t*)(data + 10) = HTOGL(gnet->g_cfg->shared_kb);

    if(gnet_deliver_message_one(gnet, chan, reply) < 0){
	WARN("could not deliver message: %s", strerror(errno));
	return -1;
    }

    return 0;
}

static int
handle_pong(struct gnet *gnet, struct channel *chan){
    
    TRACE("got a pong");
//    TRACE("FIXME");

    return 0;
}

static int
handle_query(struct gnet *gnet, struct channel *chan){
//    TRACE("got a query");
//    TRACE("FIXME");

    return 0;
}

static int
handle_query_hits(struct gnet *gnet, struct channel *chan){
    struct gnet_locator loc;
    uint8_t hits;
    char *msg = chan->c_buf;
    char *data = msg + GNET_HDR_SIZE;
    char *c;
    struct query *q;
    int i;

//    TRACE("got some query hits");

    if((q = gnet_find_query(gnet, msg))){
	hits = *data;
	loc.port = GTOHS(*(uint16_t*)(data + 1));
	memcpy(loc.ip, (data + 3), 4);
	loc.bwidth = GTOHL(*(uint32_t*)(data + 7));

	TRACE("0x%hhx hits, server %s:%hu, bandwidth %luKbps", hits, inet_ntoa(*(struct in_addr*)loc.ip), loc.port, loc.bwidth);

	c = data + 11;
	for(i = 0; i < hits; i++){

	    loc.index = GTOHL(*(uint32_t*)c);
	    loc.size = GTOHL(*(uint32_t*)(c + 4));
	    loc.name = c + 8;
	    memcpy(loc.guid, data + GNET_SIZE(msg) - 16, 16);

	    TRACE("file: %s, size: %lu, index: %lu", loc.name, loc.size, loc.index);

	    c += strlen(loc.name) + 9;

	    if(*c){
		TRACE("extension block present");
	    }

	    c += strlen(c) + 1;

	    if(q->call_back)
		q->call_back(q->ctx, &loc, q->id);
	}

    }

    return 0;
}

int
gnet_handle_message(struct gnet *gnet, struct channel *chan){
    char *msg = chan->c_buf;

    switch (GNET_TYPE(msg)){

    case GNET_MSG_PING:
	return handle_ping(gnet, chan);

    case GNET_MSG_PONG:
	return handle_pong(gnet, chan);

    case GNET_MSG_QUERY:
	return handle_query(gnet, chan);

    case GNET_MSG_QHITS:
	return handle_query_hits(gnet, chan);

    case GNET_MSG_BYE:
	return handle_bye(gnet, chan);

    default:
	WARN("unknown message 0x%hhx", GNET_TYPE(msg));
    }

    return 0;
}

