


#include <stdio.h>
#include <list>
#include <string>
#include <iostream>
#include <unistd.h>

#include <chipcard.h>
#include <engine/chameleon/inetsocket.h>
#include <engine/chameleon/inetaddr.h>
#include <engine/chameleon/ipcmessage.h>
#include <engine/chameleon/cryp.h>
#include <cards/ctgeldkarte.h>




int dumpATR() {
    CTPointer<CTCard> card;
    CTError err;
    string atr;

    card=new CTCard();
    fprintf(stderr,"Opening card.\n");
    err=card.ref().openCard();
    if (!err.isOk()) {
        fprintf(stderr,"%s\n",err.errorString().c_str());
        return 2;
    }
    fprintf(stderr,"Card is open.\n");
    atr=card.ref().atr();
    fprintf(stderr,"ATR is: %s\n",
	    CTMisc::bin2hex(atr).c_str());
    err=card.ref().closeCard();
    if (!err.isOk(0x62)) {
        fprintf(stderr,"%s\n",err.errorString().c_str());
        return 2;
    }
    return 0;

}


int testStatus() {
    CTPointer<CTCard> card;

    card=new CTCard();
    try {
	if (!card.ref().isInserted())
	    fprintf(stderr,"Card is not inserted.\n");
	else
	    fprintf(stderr,"Card is inserted.\n");
    }
    catch(CTError err) {
	fprintf(stderr,"%s\n",err.errorString().c_str());
	return 2;
    }
    return 0;
}


int testMemPin() {
    CTPointer<CTMemoryCard> card;
    CTError err;
    string pin;

    card=new CTMemoryCard();
    err=card.ref().openCard();
    if (!err.isOk()) {
        fprintf(stderr,"%s\n",err.errorString().c_str());
        return 2;
    }

    pin=(unsigned char) 0x12;
    pin+=(unsigned char) 0x34;
    cerr<<"Will now test pin.\n";
    err=card.ref().verifyPin(pin);
    if (!err.isOk()) {
	fprintf(stderr,"%s\n",err.errorString().c_str());
	return 2;
    }
    else {
	fprintf(stderr,"Result: %d %02x %02x \n",
		err.code(),
		err.subcode1(),
		err.subcode2());
    }
    err=card.ref().closeCard();
    if (!err.isOk(0x62)) {
        fprintf(stderr,"%s\n",err.errorString().c_str());
        return 2;
    }
    return 0;
}


int testChgPin() {
    CTPointer<CTMemoryCard> card;
    CTError err;
    string pin1;
    string pin2;

    card=new CTMemoryCard();
    err=card.ref().openCard();
    if (!err.isOk()) {
	fprintf(stderr,"%s\n",err.errorString().c_str());
	return 2;
    }

    pin1=(unsigned char) 0xff;
    pin1+=(unsigned char) 0xff;
    // new pin
    pin2=(unsigned char) 0x12;
    pin2+=(unsigned char) 0x34;
    cerr<<"Will now test pin.\n";
    err=card.ref().changePin(pin1,pin2);
    if (!err.isOk()) {
        fprintf(stderr,"%s\n",err.errorString().c_str());
        return 2;
    }
    else
	fprintf(stderr,"Result: %d %02x %02x \n",
		err.code(),
		err.subcode1(),
		err.subcode2());

    err=card.ref().closeCard();
    if (!err.isOk(0x62)) {
        fprintf(stderr,"%s\n",err.errorString().c_str());
        return 2;
    }
    return 0;
}


void showError(ERRORCODE err) {
    static char buffer[1024];

    fprintf(stderr,"Errorcode was: %08x\n",(unsigned int)err);
    if (!Error_ToString(err,buffer,sizeof(buffer)))
	fprintf(stderr,"No message available.\n");
    else
	fprintf(stderr,"Message: %s\n",buffer);
}


int testChameleon() {
    struct SOCKETSTRUCT sock;
    INETADDRESS ia;
    INETADDRESS ia2;
    ERRORCODE err;
    char buffer[8192];
    int size;

    err=InetAddr_Create(&ia,"192.168.115.254",80);
    if (!Error_IsOk(err)) {
	showError(err);
	return 2;
    }

    err=Socket_Open(&sock,SocketTypeTCP);
    if (!Error_IsOk(err)) {
	showError(err);
	return 2;
    }

    err=Socket_Connect(&sock,&ia);
    if (!Error_IsOk(err)) {
	showError(err);
	return 2;
    }
    fprintf(stderr,"Connected !!\n");

    err=Socket_GetPeerAddr(&sock,&ia2);
    if (!Error_IsOk(err)) {
	showError(err);
	return 2;
    }

    err=InetAddr_GetAddress(&ia2,buffer,sizeof(buffer));
    if (!Error_IsOk(err)) {
	showError(err);
	return 2;
    }
    fprintf(stderr,
	    "Peer address is \"%s\", Port %d\n",
	    buffer,
	    InetAddr_GetPort(&ia2));

    err=InetAddr_GetName(&ia2,buffer,sizeof(buffer));
    if (!Error_IsOk(err)) {
	showError(err);
	return 2;
    }
    fprintf(stderr,"Peer name is \"%s\"\n",buffer);

    strcpy(buffer,"GET /test.txt HTTP/1.0\n\n");
    size=strlen(buffer);
    err=Socket_Write(&sock,buffer,&size);
    if (!Error_IsOk(err)) {
	showError(err);
	return 2;
    }
    fprintf(stderr,"Writing done.\n");

    while(1) {
	size=sizeof(buffer);
	err=Socket_Read(&sock,buffer,&size);
	if (!Error_IsOk(err)) {
	    showError(err);
	    return 2;
	}
	if (size==0) {
	    fprintf(stderr,"Reading finished.\n");
            break;
	}
        buffer[size]=0;
	fprintf(stderr,"Reading done (size=%d).\n",size);
	fprintf(stderr,"Answer was: \n%s\n",buffer);
    }
    err=Socket_Close(&sock);
    if (!Error_IsOk(err)) {
	showError(err);
	return 2;
    }
    fprintf(stderr,"Success.\n");
    return 0;
}


int testRSACard(int argc, char **argv) {
  CTPointer<RSACard> card;
  CTError err;
  int i;
  string modulus;
  string tmp;

  try {
    card=new RSACard();
    err=card.ref().openCard();
    if (!err.isOk()) {
      fprintf(stderr,"%s\n",err.errorString().c_str());
      return 2;
    }

    fprintf(stderr,"Verify pin.\n");
//#error Please insert your pin into the last argument to verifyPin() below and comment out this line
    err=card.ref().verifyPin(0x90, "xyz");
    if (!err.isOk()) {
      fprintf(stderr,"%s\n",err.errorString().c_str());
      card.ref().closeCard();
      return 2;
    }

    fprintf(stderr,"Verify gateway pin (%s).\n",
	    card.ref().cardNumber().c_str());
    err=card.ref().verifyPin(0x91, card.ref().initialPin());
    if (!err.isOk()) {
      fprintf(stderr,"%s\n",err.errorString().c_str());
      card.ref().closeCard();
      return 2;
    }

    for (i=0x81; i<0x8b; i++) {
      RSACard::KeyDescriptor key(card.ref().readKeyDescriptor(i));
      fprintf(stderr,
	      "Key %02x: %02x, num=%d, ver=%d\n",
	      i,
	      card.ref().readKeyStatus(i),
	      key.keyNumber(),
	      key.keyVersion());
      /*
       err=card.ref().deleteKeyDescriptor(i);
       if (!err.isOk()) {
       fprintf(stderr,"Could not delete :%02x (%s)\n",
       i,err.errorString().c_str());
       }
       */
    }

    for (i=0x91; i<0x9b; i++) {
      RSACard::KeyDescriptor key(card.ref().readKeyDescriptor(i));
      fprintf(stderr,
	      "Key %02x: %02x, num=%d, ver=%d\n",
	      i,
	      card.ref().readKeyStatus(i),
	      key.keyNumber(),
	      key.keyVersion());
      /*
       err=card.ref().deleteKeyDescriptor(i);
       if (!err.isOk()) {
       fprintf(stderr,"Could not delete :%02x (%s)\n",
       i,err.errorString().c_str());
       }
       */
    }

    RSACard::KeyLogStatus st=card.ref().readKeyLogStatus();
    fprintf(stderr,"KeyLogStatus is: %d, %d, %d, %d, \n",
	    st.maxEntries, st.entries, st.oldENfree, st.oldDSfree);
    for (i=0; i<st.maxEntries; i++) {
      RSACard::BankDescription bd=card.ref().readBankDescription(i);
      fprintf(stderr,"Bank %d\n%s\n",i, bd.dump().c_str());
    }
    st.entries=0;
    st.oldENfree=0;
    st.oldDSfree=0;

    /*
     err=card.ref().writeKeyLogStatus(st);
     if (!err.isOk()) {
     fprintf(stderr,"Could not write Keylogstatus :%02x (%s)\n",
     i,err.errorString().c_str());
     }
     */

    /*
     for (i=0; i<5; i++) {
     fprintf(stderr,"Deleting bank %d\n",i);
     err=card.ref().deleteBankDescription(i);
     if (!err.isOk()) {
     fprintf(stderr,"Could not delete :%02x (%s)\n",
     i,err.errorString().c_str());
     }
     }
     */

    /*
    fprintf(stderr,"Create key:\n");
    card.ref().setTimeout(120);
    i=0x86;
    modulus=card.ref().createKey(i, false);
    fprintf(stderr,"Modulus is:\n%s\n",
	    CTMisc::bin2hex(modulus).c_str());
    fprintf(stderr,"Activate key:\n");
    err=card.ref().activateKey(i, 1, 2);
    if (!err.isOk()) {
      fprintf(stderr,"Could not activate key :%02x (%s)\n",
	      i,err.errorString().c_str());
    }
    fprintf(stderr,"Key is active.\n");
    */

    /*
    i=0x86;
    tmp=card.ref().readPublicKey(i);
    fprintf(stderr,"Modulus is:\n%s\n",
    CTMisc::bin2hex(tmp).c_str());
    */
    /*
    for (i=0; i<5; i++) {
      fprintf(stderr,"Bank %i: Bank: SignKey=%02x, CryptKey=%02x\n",
	      i,
	      card.ref().getKeyId(i, true, true),
	      card.ref().getKeyId(i, true, false));
      fprintf(stderr,"Bank %i: User: SignKey=%02x, CryptKey=%02x\n",
              i,
	      card.ref().getKeyId(i, false, true),
	      card.ref().getKeyId(i, false, false));
    }
    */


    err=card.ref().closeCard();
    if (!err.isOk(0x62)) {
      fprintf(stderr,"%s\n",err.errorString().c_str());
      return 2;
    }
  }
  catch (CTError xerr) {
    fprintf(stderr,"%s\n",xerr.errorString().c_str());
    return 3;
  }

    return 0;
}



int testResetSEQ(int argc, char **argv) {
  CTPointer<RSACard> card;
  CTError err;
  int i;
  string modulus;
  string tmp;

  try {
    card=new RSACard();
    err=card.ref().openCard();
    if (!err.isOk()) {
      fprintf(stderr,"%s\n",err.errorString().c_str());
      return 2;
    }

    fprintf(stderr,"Verify pin.\n");
    err=card.ref().verifyPin(0x90, "1122334455");
    if (!err.isOk()) {
      fprintf(stderr,"%s\n",err.errorString().c_str());
      card.ref().closeCard();
      return 2;
    }

    err=card.ref().verifyPin(0x91, card.ref().initialPin());
    if (!err.isOk()) {
      fprintf(stderr,"%s\n",err.errorString().c_str());
      card.ref().closeCard();
      return 2;
    }

    for (i=0; i<5; i++) {
      err=card.ref().writeSeq(i,0);
      if (!err.isOk())
	fprintf(stderr,"Error: %s\n",err.errorString().c_str());
    } // for

    err=card.ref().closeCard();
    if (!err.isOk(0x62)) {
      fprintf(stderr,"%s\n",err.errorString().c_str());
      return 2;
    }
  }
  catch (CTError xerr) {
    fprintf(stderr,"%s\n",xerr.errorString().c_str());
    return 3;
  }

    return 0;
}


int testGK(int argc, char **argv) {
  CTPointer<CTGeldKarte> card;
  CTError err;
  float v;

  card=new CTGeldKarte();

  err=card.ref().openCard();
  if (!err.isOk()) {
    fprintf(stderr,"Error: %s\n",err.errorString().c_str());
    return 2;
  }
  try {
    v=card.ref().readLoadedValue();
    fprintf(stderr,
	    "Card is loaded with %6.2f %s\n",
	    v,
            card.ref().cardData().currency().c_str());
    v=card.ref().readMaxLoadedValue();
    fprintf(stderr,
	    "Card can be loaded with %6.2f %s\n",
	    v,
            card.ref().cardData().currency().c_str());
    v=card.ref().readMaxTransactionValue();
    fprintf(stderr,
	    "Card can transfer %6.2f %s\n",
	    v,
            card.ref().cardData().currency().c_str());
  }
  catch(CTError xerr) {
    fprintf(stderr,"%s\n",xerr.errorString().c_str());
    return 3;
  }

  err=card.ref().closeCard();
  if (!err.isOk(0x62)) {
    fprintf(stderr,"%s\n",err.errorString().c_str());
    return 2;
  }
  return 0;
}


int main(int argc, char **argv) {
    string cmd;

    if (argc>1) {
        cmd=argv[1];
    }
    else
        cmd="hae ?";
    fprintf(stderr,"command is: %s\n",cmd.c_str());
    if (cmd=="atr")
        return dumpATR();
    else if (cmd=="chgpin") {
	return testChgPin();
    }
    else if (cmd=="status") {
	return testStatus();
    }
    else if (cmd=="chameleon") {
	return testChameleon();
    }
    else if (cmd=="rsa") {
      return testRSACard(argc, argv);
    }
    else if (cmd=="seq") {
      return testResetSEQ(argc, argv);
    }
    else if (cmd=="gk") {
      return testGK(argc, argv);
    }
    else {
	fprintf(stderr,"Unknown command.\n");
        return 1;
    } // switch
    return 0;
}

