/*  Inti-GConf: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  schema.cc - GConfSchema C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "schema.h"

using namespace Inti;

/*  GConf::Schema
 */

GConf::Schema::Schema()
: schema_(gconf_schema_new())
{
}

GConf::Schema::Schema(ValueType type)
: schema_(gconf_schema_new())
{
	set_type(type);
}

GConf::Schema::Schema(const GConfSchema* src)
: schema_(gconf_schema_copy(src))
{
}

GConf::Schema::Schema(const Schema& src)
: schema_(gconf_schema_copy(src.gconf_schema()))
{
}

GConf::Schema&
GConf::Schema::operator=(const Schema& src)
{
	if (src.schema_ == schema_)
		return *this;
		
	if (schema_)
		gconf_schema_free(schema_);
		
	schema_ = gconf_schema_copy(src.schema_);
	return *this;
}

GConf::ValueType 
GConf::Schema::get_type() const
{
	return (ValueType)gconf_schema_get_type(gconf_schema());
}

GConf::ValueType
GConf::Schema::get_list_type() const
{
	return (ValueType)gconf_schema_get_list_type(gconf_schema());
}

GConf::ValueType 
GConf::Schema::get_car_type() const
{
	return (ValueType)gconf_schema_get_car_type(gconf_schema());
}

GConf::ValueType
GConf::Schema::get_cdr_type() const
{
	return (ValueType)gconf_schema_get_cdr_type(gconf_schema());
}

String 
GConf::Schema::get_locale() const
{
	return gconf_schema_get_locale(gconf_schema());
}

String 
GConf::Schema::get_short_desc() const
{
	return gconf_schema_get_short_desc(gconf_schema());
}

String 
GConf::Schema::get_long_desc() const
{
	return gconf_schema_get_long_desc(gconf_schema());
}

String 
GConf::Schema::get_owner() const
{
	return gconf_schema_get_owner(gconf_schema());
}

GConf::Value
GConf::Schema::get_default_value() const
{
	return Value(gconf_schema_get_default_value(gconf_schema()));
}

void 
GConf::Schema::set_type(ValueType type)
{
	gconf_schema_set_type(gconf_schema(), (GConfValueType)type);
}

void 
GConf::Schema::set_list_type(ValueType type)
{
	gconf_schema_set_list_type(gconf_schema(), (GConfValueType)type);
}

void
GConf::Schema::set_car_type(ValueType type)
{
	gconf_schema_set_car_type(gconf_schema(), (GConfValueType)type);
}

void 
GConf::Schema::set_cdr_type(ValueType type)
{
	gconf_schema_set_cdr_type(gconf_schema(), (GConfValueType)type);
}

void 
GConf::Schema::set_locale(const String& locale)
{
	gconf_schema_set_locale(gconf_schema(), locale.c_str());
}

void 
GConf::Schema::set_short_desc(const String& desc)
{
	gconf_schema_set_short_desc(gconf_schema(), desc.c_str());
}

void 
GConf::Schema::set_long_desc(const String& desc)
{
	gconf_schema_set_long_desc(gconf_schema(), desc.c_str());
}

void 
GConf::Schema::set_owner(const String& owner)
{
	gconf_schema_set_owner(gconf_schema(), owner.c_str());
}

void 
GConf::Schema::set_default_value(const Value& value)
{
	gconf_schema_set_default_value(gconf_schema(), value.gconf_value());
}

