/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  relation.cc - AtkRelation and AtkRelationSet C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "relation.h"
#include "private/relation_p.h"
#include "object.h"

using namespace Inti;

/*  Atk::Relation
 */

Atk::Relation::Relation(AtkRelation *relation, bool reference)
: G::Object((GObject*)relation, reference)
{
}
	
Atk::Relation::Relation(const std::vector<Atk::Object*>& targets, AtkRelationType relationship)
: G::Object((GObject*)RelationClass::create())
{
	g_return_if_fail(!targets.empty());
	int count = targets.size();
	GPtrArray *array = g_ptr_array_sized_new(count);

	int i = 0;
	while (i < count)
	{
		targets[i]->ref();
		g_ptr_array_add(array, targets[i]->atk_object());
		++i;
	}

	atk_relation()->target = array;
	atk_relation()->relationship = relationship;
}

Atk::Relation::~Relation()
{
}
	
AtkRelationClass* 
Atk::Relation::atk_relation_class() const
{ 
	return get_class<AtkRelationClass>(); 
}
	
Atk::Relation::operator AtkRelation* () const 
{ 
	return this ? atk_relation() : 0; 
}
	
AtkRelationType
Atk::Relation::get_relation_type() const
{
	return atk_relation_get_relation_type(atk_relation());
}

bool
Atk::Relation::get_target(std::vector<Atk::Object*>& targets) const
{
	g_return_val_if_fail(targets.empty(), false);
	GPtrArray *tmp_targets = atk_relation_get_target(atk_relation());
	int count = tmp_targets->len;

	int i = 0;
	while (i < count)
	{
		targets.push_back(G::Object::wrap<Atk::Object>((AtkObject*)g_ptr_array_index(tmp_targets, i)));
		++i;
	}
	return !targets.empty();
}		
	
/*  Atk::RelationClass
 */

void
Atk::RelationClass::init(AtkRelationClass *g_class)
{
	G::ObjectClass::init((GObjectClass*)g_class);
}

GType
Atk::RelationClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(ATK_TYPE_RELATION, (GClassInitFunc)init);
	}
	return type;
}

void*
Atk::RelationClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Atk::RelationSet
 */
 
Atk::RelationSet::RelationSet(AtkRelationSet *set, bool reference)
: G::Object((GObject*)set, reference)
{
}
	
Atk::RelationSet::RelationSet()
: G::Object((GObject*)RelationSetClass::create())
{
}

Atk::RelationSet::~RelationSet()
{
}
	
AtkRelationSetClass* 
Atk::RelationSet::atk_relation_set_class() const 
{ 
	return get_class<AtkRelationSetClass>(); 
}

Atk::RelationSet::operator AtkRelationSet* () const 
{ 
	return this ? atk_relation_set() : 0; 
}

bool
Atk::RelationSet::contains(RelationType relationship) const
{
	return atk_relation_set_contains(atk_relation_set(), (AtkRelationType)relationship);
}

int
Atk::RelationSet::get_n_relations() const
{
	return atk_relation_set_get_n_relations(atk_relation_set());
}

Atk::Relation*
Atk::RelationSet::get_relation(int index) const
{
	AtkRelation *relation = atk_relation_set_get_relation(atk_relation_set(), index);
	return relation ? G::Object::wrap<Relation>(relation) : 0;
}

Atk::Relation*
Atk::RelationSet::get_relation(RelationType relationship) const
{
	AtkRelation *relation = atk_relation_set_get_relation_by_type(atk_relation_set(), (AtkRelationType)relationship);
	return relation ? G::Object::wrap<Relation>(relation) : 0;
}
	
void 
Atk::RelationSet::add(Relation& relation)
{
	atk_relation_set_add(atk_relation_set(), relation.atk_relation());
}

void 
Atk::RelationSet::remove(Relation& relation)
{
	atk_relation_set_remove(atk_relation_set(), relation.atk_relation());
}

/*  Atk::RelationSetClass
 */

void
Atk::RelationSetClass::init(AtkRelationSetClass *g_class)
{
	G::ObjectClass::init((GObjectClass*)g_class);
}

GType
Atk::RelationSetClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(ATK_TYPE_RELATION_SET, (GClassInitFunc)init);
	}
	return type;
}

void*
Atk::RelationSetClass::create()
{
	return g_object_new(get_type(), 0);
}




