/* interactor.c
   Copyright 2002 by Christian Stimming <stimming@tuhh.de> */

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <openhbci/interactorcb.h>
#include <openhbci/progressmonitorcb.h>
#include "interactor.h"


#define LOCALSIZE 1024

/* All these are heavily copied from aqmoney by Martin Preu. */

int msgInputPin(const HBCI_User *user,
		char **pinbuf,
		int minsize,
		int newPin, 
		void *user_data)
{
    const HBCI_Bank * b;
    char *localbuf = (char *)malloc(LOCALSIZE*sizeof(char));

    printf("Pineingabe fuer ");
    if (user) {
        b=HBCI_User_bank(user);
        if (b) {
	    printf("BLZ %s", HBCI_Bank_bankCode(b));
        }
        else
            printf("<unbekannte Bank>");
	printf(", Benutzerkennung %s", HBCI_User_userId(user));
    } /* if user is valid */
    else
        printf("<unbekannter User>");
    printf("\n");

    /* FIXME: only show asterisks, dont use gets ! */
    fgets(localbuf, LOCALSIZE*sizeof(char), stdin);
    /* Removes trailing \n, if it exists */
    if (strlen(localbuf)>0 && (localbuf[strlen(localbuf)-1] == '\n'))
	localbuf[strlen(localbuf)-1] = '\0';

    *pinbuf = localbuf;

    /* done */
    return 1;
}


int msgInsertCardOrAbort(const HBCI_User *user, MediumType t, void *user_data)
{
    const HBCI_Bank * b;

    printf("Bitte Karte einlegen fuer ");
    if (user) {
        b=HBCI_User_bank(user);
        if (b) {
	    printf("BLZ %s", HBCI_Bank_bankCode(b));
        }
        else
            printf("<unbekannte Bank>");
    } /* if user is valid */
    else
        printf("<unbekannter User>");
    printf("\n");
    printf("<Bitte druecken Sie ENTER>\n");
    getchar();

    return 1;
}


int msgInsertCorrectCardOrAbort(const HBCI_User *user, MediumType t,
				void *user_data)
{
    const HBCI_Bank *b;

    printf("Bitte korrekte Karte einlegen fuer ");
    if (user) {
        b=HBCI_User_bank(user);
        if (b) {
	    printf("BLZ %s", HBCI_Bank_bankCode(b));
        }
        else
            printf("<unbekannt Bank>");
    } /* if user is valid */
    else
	printf("<unbekannt Bank>");
    printf("\n");
    printf("<Bitte druecken Sie ENTER>\n");
    getchar();

    return 1;
}


void msgStateResponse(const char *msg, void *user_data)
{
    fprintf(stdout,"my-msgStateResponse: %s\n",msg);
}

int keepAlive()
{
    /*fprintf(stdout, "my-keepAlive: returning 1\n"); */
    return 1;
}


HBCI_Interactor *
new_interactor()
{
    HBCI_InteractorCB *inter;
    inter = HBCI_InteractorCB_new2(NULL,
				   &msgInputPin,
				   &msgInsertCardOrAbort,
				   &msgInsertCorrectCardOrAbort,
				   &msgStateResponse,
				   &keepAlive,
				   NULL,
				   NULL,
				   NULL);

    return HBCI_InteractorCB_Interactor(inter);
}

/* ---------------------------------------------------------- */

void jobStarted(JobProgressType type, int actions, void *user_data)
{
    const char *msg;
    switch(type){
    case JOB_OPENINGDIALOG:
	msg = "Erffne Dialog";
	break;
    case JOB_CLOSINGDIALOG:
	msg = "Schliee Dialog";
	break;
	/** Opening network connection. */
    case    JOB_OPENINGNETWORK:
	msg = "Beginne Netzwerkverbindung";
	break;
	/** Closing network connection. */
    case    JOB_CLOSINGNETWORK:
	msg = "Schliee Netzwerkverbindung";
	break;
	/** Get balance */
    case    JOB_GET_BALANCE:
	msg = "Job: Saldo abholen";
	break;
	/** Get transaction statement */
    case    JOB_GET_TRANS:
	msg = "Job: Umstze abholen";
	break;
	/** Transfer money */
    case    JOB_NEW_TRANSFER:
	msg = "Job: Neue berweisung";
	break;
	/** Debit note */
    case    JOB_DEBIT_NOTE:
	msg = "";
	break;
	/** Get standing orders */
    case    JOB_GET_STO:
	msg = "";
	break;
	/** Create a new standing order */
    case    JOB_NEW_STO:
	msg = "";
	break;
	/** Delete a standing order */
    case    JOB_DELETE_STO:
	msg = "";
	break;
	/** Get account list */
    case    JOB_GET_ACCOUNTS:
	msg = "Job: Kontenliste abholen";
	break;
	/** Get SystemId */
    case    JOB_GET_SYSTEMID:
	msg = "Job: System-Kennung abgleichen";
	break;
	/** Get keys */
    case    JOB_GET_KEYS:
	msg = "Job: Schlssel holen";
	break;
	/** Send keys */
    case    JOB_SEND_KEYS:
	msg = "Job: Schlssel senden";
	break;
    case JOB_DISABLE_KEYS:
	msg = "Job: Schlssel sperren";
	break;
    case JOB_CHANGE_KEYS:
	msg = "Job: Schlssel ndern";
	break;
    case JOB_GET_STATUS:
	msg = "Job: Statusreport holen";
	break;
    }
    
    fprintf(stdout,"Jobstart (w/ %d actions): %s\n",actions, msg);
}
HBCI_ProgressMonitor *
new_pmonitor()
{
    HBCI_ProgressMonitorCB *pmon;
    pmon = HBCI_ProgressMonitorCB_new(NULL,
				      NULL,
				      NULL,
				      &jobStarted,
				      NULL,
				      NULL,
				      NULL,
				      NULL,
				      NULL);
    
    return HBCI_ProgressMonitorCB_ProgressMonitor(pmon);
}
