/***************************************************************************
 $RCSfile: accountjobs.cpp,v $
                             -------------------
    cvs         : $Id: accountjobs.cpp,v 1.28 2003/06/13 21:50:00 aquamaniac Exp $
    begin       : Mon Nov 26 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


/*
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

// #include <stdio.h> // DEBUG
#include <list>

#include "accountjobs.h"

#include "error.h"
#include "hbcistring.h"
#include "swiftparser.h"
#include "accountsegs.h"
#include "bankimpl.h"

namespace HBCI {

/*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 JOBGetBalance
 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 */


JOBGetBalance::JOBGetBalance(Pointer<Customer> cust,
                             Pointer<Account> acc):Job(cust),_acc(acc){

}


JOBGetBalance::~JOBGetBalance(){
}


string JOBGetBalance::toString(int firstseg){
    string result;

    _startSegment = firstseg;
    SEGGetBalance gb(_customer);
    gb.setData(_acc);
    result=gb.toString(firstseg);
    _lastSegment = firstseg;
    return result;
}


void JOBGetBalance::parseResponse(const string& response){
    unsigned int pos;

    pos=0;
    SEGBalance b(_customer);
    if (!b.parse(response,0))
        throw Error("JOBGetBalance::parseResponse",
                        "Error parsing.",0);
    _ab=b.getBalance();
}



/*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 JOBSingleTransfer
 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 */

JOBSingleTransfer::jobData::jobData() {
    maxPurposeLines=0;
}


JOBSingleTransfer::jobData::~jobData() {
}




JOBSingleTransfer::JOBSingleTransfer(Pointer<Customer> cust,
                                     const Transaction& xa)
:Job(cust)
,_xaction(xa)
{
}


JOBSingleTransfer::~JOBSingleTransfer(){
}


string JOBSingleTransfer::toString(int firstseg){
    string result;

    if (_bank.ref().hbci()->isReadOnly())
        throw Error("JOBSingleTransfer::toString",
                        "job not allowed, we are in readonly mode",0);
    _startSegment = firstseg;
    SEGSingleTransfer st(_customer);
    st.setData(_xaction);
    result=st.toString(firstseg);
    _lastSegment = firstseg;
    return result;
}



void JOBSingleTransfer::parseResponse(const string& response){
}


JOBSingleTransfer::jobData *JOBSingleTransfer::getJobData() const 
{
    const bpdJob *jp;
    string tmp;
    jobData *jd;
    unsigned int pos;
    int key;

    BankImpl &bank = 
        dynamic_cast<BankImpl&> (_bank.ref());

    // determine the segment-number we need (sets versionMin/versionMax)
    int versionMin = -1; 
    int versionMax = -1; 
    Seg::segment_number(versionMin, versionMax, 
			    bank.hbciVersion(),2,2,3,3,4,4);

    // get the job paramters for that job
    jp=bank.findJob("HIUEBS",versionMin,versionMax);
    if (jp==0)
        return 0;

    // parse the parameters
    jd=new jobData();
    tmp=jp->parameter();
    pos=0;
    // read max purpose lines
    jd->maxPurposeLines=atoi(String::nextDEG(tmp,pos).c_str());
    pos+=String::nextDEG(tmp, pos).length()+1;
    // read the textkeys
    while(pos<tmp.length()) {
        key=atoi(String::nextDEG(tmp,pos).c_str());
        jd->textKeys.push_back(key);
        pos+=String::nextDEG(tmp, pos).length()+1;
    }
    return jd;
}



/*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 JOBGetTurnover
 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 */


JOBGetTurnover::jobData::jobData() {
    savedForDays=0;
}


JOBGetTurnover::jobData::~jobData() {
}


JOBGetTurnover::jobData JOBGetTurnover::getJobData() const {
    const bpdJob *jp;
    string tmp;
    jobData jd;
    unsigned int pos;
    string jobid;

    BankImpl &bank = 
	dynamic_cast<BankImpl&> (_bank.ref());

    // determine the segment-number we need (sets versionMin/versionMax)
    int versionMin = -1; 
    int versionMax = -1; 
    Seg::segment_number(versionMin, versionMax, 
			    bank.hbciVersion(),4,4,4,4,5,5);

    // get the job paramters for that job, first try "HIKAZ"
    jp=bank.findJob("HIKAZS",versionMin,versionMax);
    if (!jp)
        // if not found try "HIKANS"
        jp=bank.findJob("HIKANS",versionMin,versionMax);
    if (jp==0)
        throw Error("JOBGetTurnover::getJobData()",
                        "job not supported",0);

    // parse the parameters
    tmp=jp->parameter();
    pos=0;
    // read max purpose lines
    jd.savedForDays=atoi(String::nextDEG(tmp,pos).c_str());
    pos+=String::nextDEG(tmp, pos).length()+1;

    // that's it
    return jd;
}



JOBGetTurnover::JOBGetTurnover(Pointer<Customer> cust,
                               Pointer<Account> account,
                               const Date& fromDate,
                               const Date& toDate)
:Job(cust)
,_acc(account)
,_fromdate(fromDate)
,_todate(toDate)
{
}

JOBGetTurnover::JOBGetTurnover(Pointer<Customer> cust,
                               Pointer<Account> account,
                               const Date& fromDate,
                               const Date& toDate,
			       Pointer<Job> lastJob)
:Job(cust)
,_acc(account)
,_fromdate(fromDate)
,_todate(toDate)
{
  _attachPoint = dynamic_cast<JOBGetTurnover&>(lastJob.ref()).
      _attachPoint;
}

JOBGetTurnover::~JOBGetTurnover(){
}


string JOBGetTurnover::toString(int firstseg){
    string result;

    _startSegment = firstseg;
    SEGGetTurnover gt(_customer);
    gt.setData(_acc,_fromdate,_todate,_attachPoint);
	// clear attachpoint
	_attachPoint = "";
    result=gt.toString(firstseg);
    _lastSegment = firstseg;
    return result;
}


void JOBGetTurnover::parseResponse(const string& response){
    unsigned int pos;
    unsigned int swiftPos;
    string mt940;
    transactionReport trep(_acc.ref().currency());

#if DEBUGMODE>1
    FILE *f;
#endif

    pos=String::nextDE(response, 0).length() + 1;
    swiftPos=0;
    mt940=String::nextDE(response, pos);
    mt940=mt940.substr(mt940.find("@",1)+1);

#if DEBUGMODE>2
    f=fopen("/tmp/mt940.dump","w+");
    if (f) {
        fwrite(mt940.data(),1,mt940.length(),f);
        fclose(f);
    }
#endif

    while (swiftPos<mt940.length()) {
        if (!SWIFTparser::readMT940(mt940, trep, swiftPos)) {
	    break;
	}
    } // while

    // save closing saldo
    _lastBalance=trep.balanceEnd();

    if (Hbci::debugLevel() > 2)
	trep.dump();
    
    // move transactions
    _transactions=trep.transactions();

}

bool JOBGetTurnover::attachMore() {
  list<segResponse> responses = getSegmentResponse();
  list<segResponse>::const_iterator it;
  
  for (it = responses.begin(); it != responses.end(); it++) {
	if (3040 == (*it).code && (*it).param != "") {
	  _attachPoint = (*it).param;
	}
  }

  return ("" != _attachPoint);
}

/*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 JOBDebitNote
 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 */

JOBDebitNote::jobData::jobData()
:maxPurposeLines(0)
{
}


JOBDebitNote::jobData::~jobData() {
}


JOBDebitNote::JOBDebitNote(Pointer<Customer> cust,
			   const Transaction& xa)
:Job(cust)
,_xaction(xa)
{
}


JOBDebitNote::~JOBDebitNote(){
}


string JOBDebitNote::toString(int firstseg){
    string result;

    if (_bank.ref().hbci()->isReadOnly())
        throw Error("JOBDebitNote::toString",
                        "job not allowed, we are in readonly mode",0);
    _startSegment = firstseg;
    SEGDebitNote st(_customer);
    st.setData(_xaction);
    result=st.toString(firstseg);
    _lastSegment = firstseg;
    return result;
}


void JOBDebitNote::parseResponse(const string& response){
}


JOBDebitNote::jobData *JOBDebitNote::getJobData() const {
    const bpdJob *jp;
    string tmp;
    jobData *jd;
    unsigned int pos;
    int key;

    BankImpl &bank = 
	dynamic_cast<BankImpl&> (_bank.ref());

    // determine the segment-number we need (sets versionMin/versionMax)
    int versionMin = -1; 
    int versionMax = -1; 
    Seg::segment_number(versionMin, versionMax, 
			    bank.hbciVersion(),2,2,2,2,4,4);

    // get the job paramters for that job
    jp=bank.findJob("HILASS",versionMin,versionMax);
    if (jp==0)
        return 0;

    // parse the parameters
    jd=new jobData();
    tmp=jp->parameter();
    pos=0;
    // read max purpose lines
    jd->maxPurposeLines=atoi(String::nextDEG(tmp,pos).c_str());
    pos+=String::nextDEG(tmp, pos).length()+1;
    // read the textkeys
    while(pos<tmp.length()) {
        key=atoi(String::nextDEG(tmp,pos).c_str());
        jd->textKeys.push_back(key);
        pos+=String::nextDEG(tmp, pos).length()+1;
    }
    return jd;
}


/*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 JOBGetStandingOrders
 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 */

JOBGetStandingOrders::JOBGetStandingOrders(Pointer<Customer> cust,
					   Pointer<Account> account)
  :Job(cust), _acc(account)
{
}

JOBGetStandingOrders::JOBGetStandingOrders(Pointer<Customer> cust,
					   Pointer<Job> lastJob)
  : Job(cust)
{
  _attachPoint = dynamic_cast<JOBGetStandingOrders&>(lastJob.ref()).
      _attachPoint;
  _acc = dynamic_cast<JOBGetStandingOrders&>(lastJob.ref())._acc;
}

JOBGetStandingOrders::~JOBGetStandingOrders(){
}


string JOBGetStandingOrders::toString(int firstseg){
    string result;

    _startSegment = firstseg;
	SEGGetStandingOrders st(_customer);
	st.setData(_acc, _attachPoint);
	// clear attachpoint
	_attachPoint = "";
    result=st.toString(firstseg);
    _lastSegment = firstseg;
    return result;
}


const list<Pointer<StandingOrder> > &
JOBGetStandingOrders::getOrders() const {
  return _orders;
}


void JOBGetStandingOrders::parseResponse(const string& response){
    unsigned int pos = 0;
	string segment;
	
	while (pos < response.length()) {
	    segment = String::nextSEG(response, pos);
		pos += segment.length() + 1;
		SEGStandingOrder st;
	    st.parse(response, 0);
		Pointer<StandingOrder> order = st.getOrder();
		_orders.push_back(order);
	}
}


bool JOBGetStandingOrders::attachMore() {
  list<segResponse> responses = getSegmentResponse();
  list<segResponse>::const_iterator it;
  
  for (it = responses.begin(); it != responses.end(); it++) {
	if (3040 == (*it).code && (*it).param != "") {
	  _attachPoint = (*it).param;
	}
  }

  return ("" != _attachPoint);
}


/*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 JOBNewStandingOrder
 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 */

JOBNewStandingOrder::JOBNewStandingOrder(Pointer<Customer> cust,
					 Pointer<Account> account,
					 const StandingOrder& newOrder)
  :Job(cust), _acc(account), _newOrder(newOrder)
{
}

JOBNewStandingOrder::~JOBNewStandingOrder(){
}


string JOBNewStandingOrder::toString(int firstseg){
    string result;
    SEGStandingOrder st(_customer);

    if (_bank.ref().hbci()->isReadOnly())
        throw Error("JOBNewStandingOrder::toString",
                        "job not allowed, we are in readonly mode",0);
    _startSegment = firstseg;
	
	list<string> otherNames = _newOrder.otherName();	
	if (otherNames.size() > 0)
	  st._recName1 = (* otherNames.begin());
	if (otherNames.size() > 1)
	  st._recName2 = (* ++otherNames.begin());

	st._myInstituteCode = _newOrder.ourBankCode();
	st._myCountryCode = _newOrder.ourCountryCode();
	st._myAccountNumber = _newOrder.ourAccountId();
	st._myAccountSuffix = _newOrder.ourSuffix();
	st._recInstituteCode = _newOrder.otherBankCode();
	st._recCountryCode = _newOrder.otherCountryCode();
	st._recAccountNumber = _newOrder.otherAccountId();
	st._recAccountSuffix = _newOrder.otherSuffix();
	st._value = _newOrder.value();
	st._textKey1 = 
	    String::num2string(_newOrder.transactionCode());
	st._textKey2 = "";
	st._purpose = _newOrder.description();

	// details
	st._firstExecution = _newOrder.firstExecutionDate();
	st._lastExecution = _newOrder.lastExecutionDate();
	st._monthly = _newOrder.period();
	st._cycle= _newOrder.cycle();
	st._execDay = _newOrder.execDay();

	result = st.toString(firstseg, "HKDAE");

    _lastSegment = firstseg;
    return result;
}


void JOBNewStandingOrder::parseResponse(const string& response){
}



/*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 JOBDeleteStandingOrder
 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 */

JOBDeleteStandingOrder::JOBDeleteStandingOrder(Pointer<Customer> cust,
					       Pointer<Account> account,
					       const StandingOrder& order2Delete)
  :Job(cust), _acc(account), _order2Delete(order2Delete)
{
}

JOBDeleteStandingOrder::~JOBDeleteStandingOrder(){
}


string JOBDeleteStandingOrder::toString(int firstseg){
    string result;
    SEGStandingOrder st(_customer);

    if (_bank.ref().hbci()->isReadOnly())
        throw Error("JOBDeleteStandingOrder::toString",
                        "job not allowed, we are in readonly mode",0);
    _startSegment = firstseg;

	list<string> otherNames = _order2Delete.otherName();	
	if (otherNames.size() > 0)
	  st._recName1 = (* otherNames.begin());
	if (otherNames.size() > 1)
	  st._recName2 = (* ++otherNames.begin());

	st._myInstituteCode = _order2Delete.ourBankCode();
	st._myCountryCode = _order2Delete.ourCountryCode();
	st._myAccountNumber = _order2Delete.ourAccountId();
	st._myAccountSuffix = _order2Delete.ourSuffix();
	st._recInstituteCode = _order2Delete.otherBankCode();
	st._recCountryCode = _order2Delete.otherCountryCode();
	st._recAccountNumber = _order2Delete.otherAccountId();
	st._recAccountSuffix = _order2Delete.otherSuffix();
	st._value = _order2Delete.value();
	st._textKey1 = 
	    String::num2string(_order2Delete.transactionCode());
	st._textKey2 = "";
	st._purpose = _order2Delete.description();
	st._date = _order2Delete.executionDate();

	// details
	st._firstExecution = _order2Delete.firstExecutionDate();
	st._lastExecution = _order2Delete.lastExecutionDate();
	st._monthly = _order2Delete.period();
	st._cycle= _order2Delete.cycle();
	st._execDay = _order2Delete.execDay();

	result = st.toString(firstseg, "HKDAL");

    _lastSegment = firstseg;
    return result;
}


void JOBDeleteStandingOrder::parseResponse(const string& response){
}

} // namespace HBCI
