/***************************************************************************
 $RCSfile: statusreport.cpp,v $
                             -------------------
    cvs         : $Id: statusreport.cpp,v 1.3 2003/05/21 12:01:41 cstim Exp $
    begin       : Sun May 17 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#include "statusreport.h"
#include "hbcistring.h"
#include <assert.h>

namespace HBCI {


MessageReference::MessageReference()
:_msgNumber(-1)
{
}


MessageReference::MessageReference(const string &deg)
:_msgNumber(-1)
{
  unsigned int spos;

  spos=0;
  _dialogId=String::nextDEG(deg,spos);
  spos+=String::nextDEG(deg,spos).length()+1;
  _msgNumber=atoi(String::nextDEG(deg,spos).c_str());
}


MessageReference::MessageReference(const string &did, int msgnum)
:_dialogId(did)
,_msgNumber(msgnum)
{
}


MessageReference::~MessageReference(){
}


string MessageReference::toString() const {
  string result;

  result=_dialogId+":";
  result+=String::num2string(_msgNumber);
  return result;
}


bool MessageReference::operator==(const MessageReference &ref) const{
  return (ref._dialogId==_dialogId &&
          ref._msgNumber==_msgNumber);
}
int MessageReference::cmp(const MessageReference &other) const
{
  return (operator==(other) ? 0 :
	  (_dialogId < other._dialogId ? -1 :
	   (_dialogId > other._dialogId ? 1 :
	    (_msgNumber < other._msgNumber ? -1 : 1))));
}





StatusReport::StatusReport()
  :_segref(-1)
  ,_code(-1)
{
}


StatusReport::~StatusReport(){
}


string StatusReport::dump() const {
  string result;

  result="Status Report\n";
  result+="Date.............: ";
  result+=_date.toString();
  result+="\n";
  result+="Time.............: ";
  result+=_time.toString();
  result+="\n";
  result+="Message Reference: ";
  result+=_msgref.dialogId()+":";
  result+=String::num2string(_msgref.messageNumber());
  result+="\n";
  if (_segref!=-1) {
    result+="Segment..........: ";
    result+=String::num2string(_segref);
    result+="\n";
  }
  result+="Result...........: ";
  result+=String::num2string(_code);
    result+="\n";
  result+="Group Reference..: ";
  result+=_ged;
  result+="\n";
  result+=" Result Text.....: ";
  result+=_text;
  result+="\n";

  return result;
}



} /* namespace */


HBCI_MessageReference *
HBCI_MessageReference_new(const char *did, int msgnum)
{
  return new HBCI_MessageReference(did ? did : "", msgnum);
}
HBCI_MessageReference *
HBCI_MessageReference_new_deg(const char *deg)
{
  return new HBCI::MessageReference(deg ? deg : "");
}
void HBCI_MessageReference_delete(HBCI_MessageReference *h)
{
  delete (h);
}
const char *
HBCI_MessageReference_dialogId(const HBCI_MessageReference *h)
{
  assert(h);
  return h->dialogId().c_str();
}
int 
HBCI_MessageReference_messageNumber(const HBCI_MessageReference *h)
{
  assert(h);
  return h->messageNumber();
}
char * 
HBCI_MessageReference_toString(const HBCI_MessageReference *h)
{
  assert(h);
  return hbci_strdup(h->toString());
}
int HBCI_MessageReference_equal(const HBCI_MessageReference *h1,
				const HBCI_MessageReference *h2)
{
  assert(h1);
  assert(h2);
  return h1->operator==(*h2);
}
int HBCI_MessageReference_cmp(const HBCI_MessageReference *h1,
			      const HBCI_MessageReference *h2)
{
  assert(h1);
  assert(h2);
  return h1->cmp(*h2);
}



const HBCI_Date *HBCI_StatusReport_date(const HBCI_StatusReport *h)
{
  assert(h);
  return &(h->date());
}
const HBCI_Time *HBCI_StatusReport_time(const HBCI_StatusReport *h)
{
  assert(h);
  return &(h->time());
}
int HBCI_StatusReport_result(const HBCI_StatusReport *h)
{
  assert(h);
  return h->result();
}
const char *
HBCI_StatusReport_groupReference(const HBCI_StatusReport *h)
{
  assert(h);
  return h->groupReference().c_str();
}
const char *HBCI_StatusReport_resultText(const HBCI_StatusReport *h)
{
  assert(h);
  return h->resultText().c_str();
}
const HBCI_MessageReference *
HBCI_StatusReport_messageReference(const HBCI_StatusReport *h)
{
  assert(h);
  return &(h->messageReference());
}
int HBCI_StatusReport_segment(const HBCI_StatusReport *h)
{
  assert(h);
  return h->segment();
}
char *HBCI_StatusReport_dump(const HBCI_StatusReport *h)
{
  assert(h);
  return hbci_strdup(h->dump());
}
unsigned int 
list_HBCI_StatusReport_size(const list_HBCI_StatusReport *l)
{
  assert(l);
  return l->size();
}
void *list_HBCI_StatusReport_foreach(const list_HBCI_StatusReport *l,
				     list_HBCI_StatusReport_cb func,
				     void *user_data)
{
  assert(l);
  assert(func);
  void *ret = NULL;

  typedef std::list<HBCI::StatusReport> list_type;
  
  for (list_type::const_iterator iter = l->begin(); iter != l->end(); ++iter)
    {
      ret = (*func)( &(*iter), user_data );
      if (ret)
	break;
    }
  
  return ret;
}

      
  
