/*
 * pam_krb5_sess.c
 *
 * PAM session management functions for pam_openafs-krb5
 * 
 *
 */
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <syslog.h>
#include <pwd.h>
#include <stdio.h>

#define KERBCACHE "KRB5CCNAME"
#define AKLOG "/usr/bin/aklog"
#define UNLOG "/usr/bin/unlog"
#define KDESTROY "/usr/bin/kdestroy"

#define MAXBUF 256

/* A useful logging macro */
/* from libpam-krb5 */
#define DLOG(error_func, error_msg) \
if (debug) \
    syslog(LOG_DEBUG, "pam_openafs-krb5: %s: %s", \
	   error_func, error_msg)
#define ELOG(error_func, error_msg) \
    syslog(LOG_ERR, "pam_openafs-krb5: %s: %s", \
	   error_func, error_msg)


#include <security/pam_appl.h>
#include <security/pam_modules.h>

/* Initiate session management */
int
pam_sm_open_session(pam_handle_t *pamh, int flags, int argc, const char **argv)
{
  pid_t pid;
  int debug = 0;
  int status;
  int i;

  for (i = 0; i < argc; i++) {
    if (strcmp(argv[i], "debug") == 0) {
      debug = 1;
      break;
    }
  }
  
  DLOG("open_session","fork..");
  
  pid=fork();  
  
  if(pid==0) { /* il figlio */ 
    
    const char *name;
    struct passwd *pw;
    char *envi[2];
    char namecache[]={KERBCACHE};
    const char *filecache;
    char buf[MAXBUF];    
    envi[1]=NULL;
    
    /* ???? */
    if(pam_get_user(pamh, &name, "") != PAM_SUCCESS )
      exit(-1);
    
    
    pw=getpwnam (name);
    if(!pw) {
      ELOG("getpwnam","Unable to get the user UID");
      exit(-1);
    }
    
    if(setuid(pw->pw_uid) < 0) {
      ELOG("setuid","Unable to set the appropriate UID");
      exit(-1);
    }
    
    filecache=pam_getenv(pamh,namecache);    
    snprintf(buf,MAXBUF-1,"%s=%s",namecache,filecache);
    envi[0]=buf;
    DLOG("ENVIRONNEMENT", envi[0]);
    
    execle( AKLOG,"aklog",NULL,envi);
    
    ELOG("open_session","fatal error");
    exit(-1);
  }
  waitpid(pid, &status, 0);
  if(WIFEXITED(status)) {
    DLOG("KRB5 OPENSESSION", "OK !");
    return PAM_SUCCESS;
  }
  return PAM_SESSION_ERR;
}


/* Terminate session management */
int
pam_sm_close_session(pam_handle_t *pamh, 
		     int flags, int argc, const char **argv)
{
  const char *name;
  struct passwd *pw;
  char *envi[2];
  char namecache[]={KERBCACHE};
  const char *filecache;
  char buf[MAXBUF];    
  int i,debug=0;
  int UID=-1;
  pid_t pid;
  int status;

  envi[1]=NULL;
  for (i = 0; i < argc; i++) {
    if (strcmp(argv[i], "debug") == 0) {
      debug = 1;
      break;
    }
  }
  
  
  /* ???? */
  if(pam_get_user(pamh, &name, "") != PAM_SUCCESS )
    exit(-1);
  
  
  pw=getpwnam (name);
  if(!pw) {
    ELOG("getpwnam","Unable to get the user UID");
    exit(-1);
  }
  
  UID=pw->pw_uid;
  if(setuid(UID) < 0) {
    ELOG("setuid","Unable to set the appropriate UID");
    exit(-1);
  }
  
  filecache=pam_getenv(pamh,namecache);    
  snprintf(buf,MAXBUF-1,"%s=%s",namecache,filecache);
  envi[0]=buf;
  DLOG("ENVIRONNEMENT", envi[0]);
  
  DLOG("close_session","fork..1");  
  
  pid=fork();      
  if(pid==0) { /* il figlio */ 
    execle( UNLOG,"unlog",NULL,envi);    
    ELOG("close_session","execle fatal error");
    exit(-1);
  }
  waitpid(pid, &status, 0);
  if(!WIFEXITED(status)) {
    ELOG("KRB5 CLOSESSION", "ERROR In fork 1!");
    return PAM_SESSION_ERR;
  }
  
  DLOG("close_session","fork..2");  
  pid=fork();      
  if(pid==0) { /* il figlio */ 
    execle( KDESTROY,"kdestroy",NULL,envi);    
    ELOG("execle","fatal error");
    exit(-1);
  }
  waitpid(pid, &status, 0);
  if(!WIFEXITED(status)) {
    ELOG("KRB5 CLOSESSION", "ERROR In fork 2!");
    return PAM_SESSION_ERR;
  }
  
  return PAM_SUCCESS;
}







