/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
#ifndef _PROFILE_H
#define _PROFILE_H

#include "mas/mas_types.h"
#include "mas/mas_cmatrix.h"

const char   profile_name[]         = "sbuf";
const char   profile_purpose[]      = "Buffer an audio stream";
const char   profile_description[]  = "The sbuf device buffers incoming audio data, preserving the data segment boundaries, and the interpacket timing relationships.  It offers its own output pacing algorithm, and can be used to provide correctly paced audio output from an erratic or incorrectly paced source.  In \"keep\" mode, data is not discarded, and the sbuf device can be used as a server side cache for sound clips.  ";
const char   profile_license[]      = "Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.\n\nPermission is hereby granted, free of charge, to any person\nobtaining a copy of this software and associated documentation\nfiles (the \"Software\"), to deal in the Software without\nrestriction, including without limitation the rights to use, copy,\nmodify, merge, publish, distribute, sublicense, and/or sell copies\nof the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be\nincluded in all copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\nEXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\nMERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\nNONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS\nBE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN\nACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN\nCONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n";
const uint8  profile_major_version  = 0;
const uint8  profile_minor_version  = 6;
const uint8  profile_teeny_version  = 0;
const uint8  profile_patchlevel  = 0;
const char   profile_build_host[]   = "mas.shiman.com";
const char   profile_build_date[]   = __DATE__;
const char   profile_reentrant      = TRUE;
const char   profile_ntpts_acc      = FALSE;
const char   profile_mts_acc        = TRUE;

const char*  profile_action_names[] =
{
    "mas_dev_init_instance",
    "mas_dev_exit_instance",
    "mas_dev_terminate",
    "mas_dev_configure_port",
    "mas_dev_terminate",
    "mas_dev_show_state",
    "mas_source_play",
    "mas_source_play_on_mark",
    "mas_source_stop",
    "mas_source_pause",
    "mas_source_poll",
    "mas_source_rebuffer",
    "mas_sbuf_post",
    "mas_get",
    "mas_set",
    "" /* needs terminator */
};

const char* mas_sbuf_cmatrix[][6] = 
{
    { "format", "resolution", "channels", "sampling rate", "endian",  "" },
    { "*",      "8",          "*",        "*",             "*",    "" },
    { "*",      "16",         "*",        "*",             "*",    "" },
    { "*",      "20",         "*",        "*",             "*",    "" },
    { "*",      "24",         "*",        "*",             "*",    "" },
    { "",       "",           "",         ""    ,          "",        "" },
};

/* These are the symbol names of the characteristic matrices used by
   this device.  The loader must resolve these.  They may include
   local characteristic matrices, or standard ones from
   mas_cmatrix.h.  The list must be null terminated. */
char* profile_cmatrix_names[] =
{
    "mas_sbuf_cmatrix",
    "" /* needs terminator */
};

const char* profile_ports[][3] =
{
    { "sink", "sink", "mas_sbuf_cmatrix" },
    { "source", "source", "mas_sbuf_cmatrix" },
    { "", "", "" },
};


void *profile_clock_names = NULL;
void *mas_dev_init_library = NULL;

#endif /* _PROFILE_H */
