
# hashlines.py
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#


import sys
import getopt
import string
import optlib
import regex
import regsub

def hashLines (fname):
    lines = open (fname, "r").readlines ()
    outlines = []
    sub = regsub.sub
    re = regex.compile ('\(# *line.*\)\n')
    changed = None
    for i in xrange (len (lines)):
        line = lines [i]
        newline = sub (re, '#line %d "%s"' % (i, fname), line)
        if newline != line:
            changed = 1
            lines [i] = newline
    if changed:
        open (fname, "w").writelines (lines)

def main (args):
    options, fileArgs = parseOptions (args)
    for fname in fileArgs:
        hashLines (fname)

# chapter options
def usage ():
    sys.stderr.write ('Usage: hashlines.py [options] fileargs\n')
    sys.stderr.write ('    -h                   this help screen\n')
    try:
        sys.stderr.write ("    " + main.__doc__)
    except:
        pass
    sys.exit (0)

def parseOptions (args):
    args = optlib.expandFileArgs (args)
    options, fileArgs = getopt.getopt (args, "h")
    for o in options:
        option, optval = o
        if option == '-h':
            usage ()
            continue
    return Options(), fileArgs

class Options:
    def __init__ (self):
        pass

    def dump (self):
        pass

optionStrings = []

# end chapter options

# entry when called as script
if __name__ == "__main__":
    try:
        main (sys.argv[1:])
    except KeyboardInterrupt:
        sys.stderr.write ("Aborted\n")
        sys.exit (255)