#!/devtool/local/bin/perl

use Cwd;

BEGIN {
	if ($^O =~ /win32/i)
	{
		my $testdrive = "d:";
		if (( (caller())[1] =~ /^(.:)/ ) || (cwd() =~ /^(.:)/)) { 
			$testdrive = $1;	
		}
		else { 
			print ("Waring: Can't determine test drive from callers path\n"); 
			print ("        set testdrive to $testdrive (default)\n"); 
		}
		push @INC, "$testdrive\\devtool\\bin";
		push @INC, "$testdrive\\devtool\\lib";
		push @INC, "$testdrive\\devtool\\lib\\perl5";
		push @INC, "$testdrive\\devtool\\lib\\Perl";

		push @INC, (	"$testdrive\\SAP_DB\TESTDB", 
				"$testdrive\\SAP_DB\\TESTDB\\lib");
	} else {
		unshift @INC, (	"/devtool/TOOL/tool/lib/perl5", 
				"/devtool/TOOL/tool/lib/Perl", 
				"/devtool/TOOL/tool/bin", 
				"/SAP_DB/TESTDB", 
				"/SAP_DB/TESTDB/lib");
	}
}

use Sys::Hostname;
use testdb;
use QAConnect;
use Getopt::Long;

$| = 1;

print "\n\nbenchmark v0.1a (c)2004, SAP AG\n\n";

my %opts;

unless (GetOptions(\%opts, 'host=s', 'weekday=i', 'hour=i', 'rel_filter=s', 'debug'))
{
	print <<HELP_END;
Usage:	benchmark	[-host <host>] [-weekday <number>] [-hour <number>]
			[-rel_filter <reg-ex>]

Where:		-host <host>		sets an alternative host name
		-weekday <number>	sets (pretends) the day of week
		-hour <number>		pretends a special hour
		-rel_filter <reg-ex>	Just selects special releases

HELP_END
	exit(1);
}

$opts{'host'} 		= ($opts{'host'} 	? $opts{'host'} 	: hostname());
$opts{'weekday'} 	= ($opts{'weekday'}	? $opts{'weekday'}	: (localtime (time))[6]);
$opts{'hour'}		= ($opts{'hour'} 	? $opts{'hour'} 	: (localtime (time))[2]);

my ($rc, $href) 	= QAConnect::httpsql_request("QADB_HTTPSQL", "select * from BENCHMARK_TIMES", 1);

my $inst_path		= $ENV{'PATH'};
my %tests;
my %tdb;

if ($rc)
{
	my $max_rows 	= scalar(@{$href->{'Rows'}->{'Row'}});
	my $act_row 	= 0;
	
	while ($act_row < $max_rows)
	{
		my $host_filter = $href->{'Rows'}->{"Row"}[$act_row]->{'HOST'};
		my $day_filter	= $href->{'Rows'}->{"Row"}[$act_row]->{'DAY_FILTER'};
		my $hour_filter	= $href->{'Rows'}->{"Row"}[$act_row]->{'HOUR_FILTER'};
		my $release	= $href->{'Rows'}->{"Row"}[$act_row]->{'RELEASE'};
		my $test_string	= $href->{'Rows'}->{"Row"}[$act_row]->{'TEST_STRING'};
		
		$act_row ++;
		
		# Filter all unwanted entries:
		if ($opts{'host'} !~ /$host_filter/i) {
			dbgout("Host $opts{'host'} doesn't match filter '$host_filter'.");
			next;
		}
		if ($opts{'weekday'} !~ /$day_filter/) {
			dbgout("Weekday $opts{'weekday'} doesn't match weekday filter '$day_filter'.");
			next;
		}
		if ($opts{'hour'} !~ /$hour_filter/) {
			dbgout("Hour '$opts{'hour'}' doesn't match hour filter '$hour_filter'.");
			next;
		}
		if ($opts{'rel_filter'} && ($release !~ /$opts{'rel_filter'}/)) {
			dbgout("Release filter '$opts{'rel_filter'}' doesn't match release '$release'.");
			next;
		}
		
		# Now, generate test parameters:
		push @{$tests{$release}}, $test_string;
		dbgout("Added test '$release':'$test_string'.");
	}
}

foreach my $inst_rel (keys %tests) {

	print "Creating testdb entry for '$inst_rel':\n\n";
	
	$ENV{'PATH'} 		= $inst_path;
	my ($rel, $state) 	= ($1, $2) if ($inst_rel =~ /^(\d{4})(.*)$/);
	$tdb{$inst_rel} 	= testdb->new({'version' => $rel, 'status' => $state});

	$tdb{$inst_rel}->preClean();
	$tdb{$inst_rel}->installLC();
	$tdb{$inst_rel}->installTF();

}

system("x_server");
foreach my $test_rel (keys %tests) {

	print "\nEntering Release '$test_rel':\n\n";
	foreach my $test (@{$tests{$test_rel}})
	{
		print "Running test '$test'.\n";
		$tdb{$test_rel}->run_single_test("$test");
	}
}

print "All done!\n\n";

exit(0);

sub dbgout
{
	my $str = shift;
	print ">>DEBUG: $str\n" if ($opts{'debug'});
}
