#! /usr/bin/perl
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

package testdb;

@ISA = ('Exporter');
@EXPORT = ('new');

use Cwd;
BEGIN {
	if (!($^O =~ /MSWin32/i)) {
		unshift @INC, "/SAP_DB/TESTDB/lib";
		unshift @INC, "/devtool/TOOL/tool/lib";
		unshift @INC, "/devtool/TOOL/tool/lib/perl5";
		unshift @INC, "/devtool/TOOL/tool/bin";
		unshift @INC, "/devtool/local/bin";
		}
	else
	{
		my $testdrive = "d:";
		if (( (caller())[1] =~ /^(.:)/ ) || (cwd() =~ /^(.:)/)) { 
			$testdrive = $1;	
		}
		else { 
			print ("Waring: Can't determine test drive from callers path\n"); 
			print ("        set testdrive to $testdrive (default)\n"); 
		}
		push @INC, "$testdrive\\devtool\\bin";
		push @INC, "$testdrive\\devtool\\lib";
		push @INC, "$testdrive\\devtool\\lib\\perl5";
		push @INC, "$testdrive\\devtool\\lib\\Perl";
		push @INC, "$testdrive\\SAP_DB\\TESTDB";
	    system("NET USE L: \\\\pwdfm017\\LC_POOL ");
	}
	unshift @INC, ".";
}

use Getopt::Long;
use Sys::Hostname;
use File::Copy;
use Net::SMTP;
use Net::FTP;
use File::Path;
use qadb;
use IniFile;


if ($^O =~ /MSWin32/i) {
	require File::DosGlob ;
	import  File::DosGlob 'glob';
	require WinLink;
	import  WinLink;
	require Win32::TieRegistry;
	import  Win32::TieRegistry;
	require Win32::Process;
	import  Win32::Process;
}

1;


sub new {
	#
	# Lets get initialized
	#
	my $name = shift;
	my $options = shift;
	my $sess_opts = shift;

	
	my $self = {};
		
	$self->{'cmdcount'};
	$self->{'path'} = $ENV{'PATH'};
	$self->{'hostname'} = hostname();
	
	
	##
	## Basic settings: things we should know about:
	##
	$self->{'versions'}    = ['7402', '7403', '7404', '7405', '7500', '7501', '7600', '7601', '8000'];
	$self->{'status'}      = ['DEV', 'COR', 'RAMP', 'HOT'];
	$self->{'profiles'}    = ['workday', 'weekend'];
	$self->{'hostname'}    = hostname();
	$self->{'error_text'}  = "";
	$self->{'error_code'}  = 0;
	$self->{'prot_count'}  = 0;
	$self->{'log_count'}   = 0;
	$self->{'noset_lcok'}  = 0;
	$self->{'no_objstat'}  = 0;
	$self->{'dbtypes'}      = ();
	$self->{'instcomponents'} = ();
	$self->{'instcomponents'}->{'all'} = 1; 
	$self->{'forced_instcomponents'} = (); 
	$self->{'verbose'}      = ((defined ${$options}{'verbose'}) ? ${$options}{'verbose'} : 0 ) ;
	$ENV{'RELVER'}           = "R74"; # Well, this will have to be taken into getVersionDep someday.
	$ENV{'MAXCPU'}           = '2';
	umask 0000;
	
	if ($^O =~ /MSWin32/i) {
		
		
		$self->{'testdrive'}  = "d:";
		if (( (caller())[1] =~ /^(.:)/ ) || (cwd() =~ /^(.:)/)) { 
			$self->{'testdrive'} = $1;	
		}
		else { 
			print ("Waring: Can't determine test drive from callers path\n"); 
			print ("        set testdrive to $self->{'testdrive'} (default)\n"); 
		}
						
		$self->{'delimit'}       = "\\"; # As we know, Windows uses backslashes
		$self->{'pathsep'}       = ";";
		$self->{'rootdir'}       = "$self->{'testdrive'}\\SAP_DB\\";
		$self->{'rmcmd'}         = "del /s /q ";
		$self->{'xserver_param'} = "";
		$self->{'instwrap'}      = "";
		$self->{'indeppath'}     = "$self->{'testdrive'}\\sapdb\\programs";
		$self->{'indepdata'}     = "$self->{'testdrive'}\\sapdb\\data";
		$self->{'path'}          = "$self->{'indeppath'}\\bin;" .
		                           "$self->{'indeppath'}\\pgm;" .
		                           "$self->{'testdrive'}\\devtool\\perl\\bin;" .
		                           "$self->{'testdrive'}\\devtool\\bin;" .
		                           "$self->{'testdrive'}\\devtool\\adminbin;" .
		                           "$self->{'testdrive'}\\devtool\\pgm;" .
		                           "$self->{'testdrive'}\\devtool\\posix;" .
		                           "$self->{'testdrive'}\\devtool\\Perl;" .
		                           "$self->{'testdrive'}\\devtool\\python\\bin;" . $self->{'path'};
		$self->{'globtemp'}      = "$self->{'testdrive'}\\temp";
		
		$ENV{'JTEST_TOOL'}       = "$self->{'testdrive'}\\devtool\\";
		$ENV{'TOOLVARS'}         = "$self->{'testdrive'}\\devtool\\bin\\toolvars.pl";
		$ENV{'TOOL'}             = "$self->{'testdrive'}\\devtool";
		$ENV{'TOOLEXT'}          = ".pl";
		$ENV{'TOOLSHELL'}        = "$self->{'testdrive'}\\devtool\\perl\\bin\\perl";
		$ENV{'PYTHON'}           = "$self->{'testdrive'}\\devtool\\python";
		$ENV{'PERL'}             = "$self->{'testdrive'}\\depot\\tools\\gen\\ntintel\\OpenSource\\perl\\5.6.1\\";
		$ENV{'PERL5LIB'}        .= $ENV{'TOOL'} . "\\bin;" . $ENV{'TOOL'} ."\\perl;" . $ENV{'TOOL'} ."\\Perl\\site;" . $ENV{'TOOL'} ."\\Perl\\site\\lib";
		$ENV{'ISWDFNACHT'}       = 1;
		$ENV{'PYTHONPATH'}       = "$self->{'testdrive'}\\devtool\\lib\\Python";
	} else {
		$self->{'delimit'}       = "/";
		$self->{'pathsep'}       = ":";
		$self->{'rootdir'}       = "/SAP_DB/";
		$self->{'user'}          = "remuser";
		$self->{'group'}         = "sapsys";
		$self->{'instwrap'}      = $self->{'rootdir'} . "TESTDB/tinysudo";
		$self->{'rmcmd'}         = "rm -rf ";
		$self->{'vserverext'}    = ".old";
		$self->{'ininame'}       =  "/usr/spool/sql/ini/SAP_DBTech.ini";
		$self->{'xserver_param'} = " -Y";
		$self->{'path'}          = "/devtool/local/bin:/devtool/TOOL/tool/pgm:/devtool/TOOL/tool/Posix:/usr/bin/X11:.:" . $self->{'path'};
		$self->{'path'}         .= ":/usr/bin:/bin:/usr/local/bin:/devtool/local/bin:/devtool/TOOL/tool/bin";
		$self->{'globtemp'}      = "/tmp";
		$self->{'libappend'}     = "/lib";
		$self->{'indeppath'}     = "/SAP_DB/programs";
		$self->{'indepdata'}     = "/SAP_DB/data";
		$ENV{'TOOL'}             = "/devtool/TOOL/tool";
		$ENV{'TOOLEXT'}          = ".pl";
		$ENV{'TOOLSHELL'}        = "/devtool/local/bin/perl";
		$ENV{'PYTHON'}           = "/devtool/TOOL/tool/Python";
		$ENV{'PERL'}             = "/devtool/local";
		$ENV{'PERL5LIB'}         = $ENV{'TOOL'} . "/bin:" . $ENV{'TOOL'} . "/lib/perl5";
		$ENV{'RELVER'}           = "R74"; # Well, this will have to be taken into getVersionDep someday.
		$ENV{'JTEST_TOOL'}       = $ENV{'TOOL'};
		$ENV{'TOOLVARS'}         = $ENV{'TOOL'} . "/bin/toolvars";
		$ENV{'ISWDFNACHT'}       = '1';
		$ENV{'PYTHONPATH'}       = "/devtool/TOOL/tool/lib/Python";
	}
	
	##################################################################
	# parameter checking
	##################################################################
	
	if ($self->{'hostname'} eq "us0062") {
        $self->{'path'}     .= ":/usr/j2se/jre/bin:/sapdb/programs/bin:/sapdb/programs/pgm:/opt/WS6U2/SUNWspro/bin:/opt/WS6U2/SUNWspro";
        $self->{'bits'}      = "64";
        $self->{'platform'}  = "sun_64";
	$self->{'libappend'} = "/lib/lib64";
        $ENV{'BIT64'}        = '1';
	
    }
    elsif ($self->{'hostname'} eq "us4010") {
        $self->{'path'}     .= ":/usr/j2se/jre/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/sapmnt/global/tools/compiler/WS6U2/SUNWspro/WS6U2/bin:/sapmnt/global/tools/compiler/WS6U2/SUNWspro/WS6U2";
        $self->{'bits'}      = "64";
        $self->{'platform'}  = "sun_64";
	$self->{'libappend'} = "/lib/lib64";
        $ENV{'BIT64'}        = '1';
    }
    elsif ($self->{'hostname'} eq "ds0116") {
        $self->{'path'}     .= ":/usr/opt/java131/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
        $self->{'bits'}      = "64";
        $self->{'platform'}  = "alphaosf";
        $ENV{'BIT64'}        = '1';
    }
    elsif ($self->{'hostname'} eq "is0025") {
        $self->{'path'}     .= ":/usr/java130/jre/sh:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
        $self->{'bits'}      = "64";
        $self->{'platform'}  = "rs6000_51_64";
	$self->{'libappend'} = "/lib/lib64";
        $ENV{'BIT64'}        = '1';
    }
    elsif ($self->{'hostname'} eq "isi041") {
        $self->{'path'}     .= ":/usr/java14_64/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
        $self->{'bits'}      = "64";
        $self->{'platform'}  = "rs6000_51_64";
	$self->{'libappend'} = "/lib/lib64";
        $ENV{'BIT64'}        = '1';
    }
    
    elsif ($self->{'hostname'} eq "is0026") {
        $self->{'path'}         .= ":/usr/java131/jre/sh:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
        $self->{'bits'}          = "64";
        $self->{'platform'}      = "rs6000_64";
        $self->{'xserver_param'} = ""; # This is secialy needed for this release
	$self->{'libappend'}     = "/lib/lib64";
        $ENV{'BIT64'}            = '1';
        pop @versions; # Currently, SAP DB 7.4.3 is only availble von AIX 5, not an AIX 4
    }
    elsif ($self->{'hostname'} =~ "^hs0102") {
        $self->{'path'}          = "/opt/java1.3/jre/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/opt/aCC/bin:/opt/ansic/bin:" . $self->{'path'};
        $self->{'bits'}          = "64";
        $self->{'platform'}      = "hp_64";
	$self->{'libappend'}	 = "/lib/lib64";
        $ENV{'BIT64'}            = '1';
        $ENV{'UNIX95'}           = "1";
        $ENV{'TZ'}               = "MET-1METDST";
	$ENV{'RTEHSS_VERBOSE'}   = '1';
    }
        elsif ($self->{'hostname'} =~ "^hs0030") {
        $self->{'path'}          = "/opt/java1.3/jre/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/opt/aCC/bin:/opt/ansic/bin:" . $self->{'path'};
        $self->{'bits'}          = "64";
        $self->{'platform'}      = "hp_64";
	$self->{'libappend'}	 = "/lib/lib64";
        $ENV{'BIT64'}            = '1';
        $ENV{'UNIX95'}           = "1";
        $ENV{'TZ'}               = "MET-1METDST";
	$ENV{'RTEHSS_VERBOSE'}   = '1';
    }
        elsif ($self->{'hostname'} =~ "^hs0116") {
        $self->{'path'}          = "/opt/java1.3/jre/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/opt/aCC/bin:/opt/ansic/bin:" . $self->{'path'};
        $self->{'bits'}          = "64";
        $self->{'platform'}      = "hpia64";
	$self->{'libappend'}	 = "/lib/lib64";
        $ENV{'BIT64'}            = '1';
        $ENV{'UNIX95'}           = "1";
        $ENV{'TZ'}               = "MET-1METDST";
	$ENV{'RTEHSS_VERBOSE'}   = '1';
    }
        elsif ($self->{'hostname'} eq "ld0319") {
                $self->{'path'}    .= ":/usr/lib/java/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
                $self->{'bits'}     = "32";
                $self->{'platform'} = "linuxintel";
		delete $ENV{'BIT64'}; # Someday, this belongs to getHostDep
    }
    elsif ($self->{'hostname'} =~ "^ldp001") {
		$self->{'path'}    .= ":/usr/lib/java/bin:/SAP_DB/programs/bin:/SAP_DB/programs/pgm";
		$self->{'bits'}     = "32";
		$self->{'platform'} = "linux2.6ia32";
		$self->{'cpio_prepare'} = "mount -t proc proc /proc";
		$self->{'cpio_param'}	= "c";
        $ENV{'TZ'}               = "MET-1METDST";
		delete $ENV{'BIT64'}; # Someday, this belongs to getHostDep
    }
	elsif ($self->{'hostname'} eq "ls3007") {
		$self->{'bits'}     = "64";
		$self->{'platform'} = "linuxia64";
		$self->{'path'}    .= ":/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/usr/java/j2sdk1.4.2/jre/bin:";
	}
	elsif ($self->{'hostname'} eq "ld0148") {
		$self->{'bits'}     = "64";
		$self->{'platform'} = "linuxia64";
		$self->{'path'}    .= ":/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/usr/java/j2sdk1.4.2/jre/bin:";
	}
	elsif ($self->{'hostname'} eq "ls3101") {
		$self->{'bits'}     = "64";
		$self->{'platform'} = "linuxx86_64";
		$self->{'cpio_prepare'} = "mount -t proc proc /proc";
		$self->{'path'}    .= ":/SAP_DB/programs/bin:/SAP_DB/programs/pgm:/usr/lib/java/jre/bin:";
	}
	
	elsif ($self->{'hostname'} eq "PWDF0238") {
		$self->{'path'}         .= ";C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\IDE;C:\\Program Files\\";
		$self->{'path'}         .= "Microsoft Visual Studio .NET\\VC7\\BIN;C:\\Program Files\\Microsoft Visual Studio .N";
		$self->{'path'}         .= "ET\\Common7\\Tools;C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\Tools\\bin";
		$self->{'path'}         .= "\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\Tools\\bin;C:\\P";
		$self->{'path'}         .= "rogram Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\bin;C:\\WINNT\\Microsoft.NE";
		$self->{'path'}         .= "T\\Framework\\v1.0.3705;";
		$ENV{'INCLUDE'}          = "C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\ATLMFC\\INCLUDE;C:\\Program Files\\"
			     . "Microsoft Visual Studio .NET\\VC7\\INCLUDE;C:\\Program Files\\Microsoft Visual Studio .NET\\"
			     . "VC7\\PlatformSDK\\include\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\include;C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\include;"
			     . "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\include\\";
		$ENV{'LIB'}              = "C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\ATLMFC\\LIB;C:\\Program Files\\"
			     . "Microsoft Visual Studio .NET\\VC7\\LIB;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\lib\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\lib;C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\lib;"
			     . "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\Lib\\";
		$ENV{'VSINSTALLDIR'}     = "C:\\Program Files\\Microsoft Visual Studio .NET";
		$ENV{'FrameworkDir'}     = "C:\\WINNT\\Microsoft.NET\\Framework";
		$ENV{'FrameworkVersion'} = "v1.0.3705";
		$ENV{'FrameworkSDKDir'}  = "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK";
		$self->{'bits'}          = "32";
		$self->{'platform'}      = "NTintel";
	}
    	elsif ($self->{'hostname'} eq "pwdf2027") {
		$self->{'path'}         .= ";C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Common7\\IDE;C:\\Program F"
					. "iles\\Microsoft Visual Studio .NET 2003\\VC7\\BIN;C:\\Program Files\\Microsoft V"
					. "isual Studio .NET 2003\\Common7\\Tools;C:\\Program Files\\Microsoft Visual Studi"
					. "o .NET 2003\\Commsetprerelease;C:\\Program Files\\Microsoft Visual"
					. " Studio .NET 2003\\Common7\\Tools\\bin;C:\\Program Files\\Microsoft Visual Studi"
					. "o .NET 2003\\SDK\\v1.1\\bin;C:\\WINNT\\Microsoft.NET\\Framework\\v1.1.4322;";
		$ENV{'INCLUDE'}         = "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\ATLMFC\\INCLUDE;C:\\P"
					. "rogram Files\\Microsoft Visual Studio .NET 2003\\VC7\\INCLUDE;C:\\Program Files\\"
					. "Microsoft Visual Studio .NET 2003\\VC7\\PlatformSDK\\include\\prerelease;C:\\Pr"
					. "ogram Files\\Microsoft Visual Studio .NET 2003\\VC7\\PlatformSDK\\include;C:\\Pr"
					. "ogram Files\\Microsoft Visual Studio .NET 2003\\SDK\\v1.1\\include;C:\\Program F"
					. "iles\\Microsoft Visual Studio .NET 2003\\SDK\\v1.1\\include\\";
		$ENV{'LIB'}             = "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\ATLMFC\\LIB;C:\\Progr"
					. "am Files\\Microsoft Visual Studio .NET 2003\\VC7\\LIB;C:\\Program Files\\Microso"
					. "ft Visual Studio .NET 2003\\VC7\\PlatformSDK\\lib\\prerelease;C:\\Program Files\\"
					. "Microsoft Visual Studio .NET 2003\\VC7\\PlatformSDK\\lib;C:\\Program Files\\Mic"
					. "rosoft Visual Studio .NET 2003\\SDK\\v1.1\\lib;C:\\Program Files\\Microsoft Visu"
					. "al Studio .NET 2003\\SDK\\v1.1\\Lib\\";
		$ENV{'VSINSTALLDIR'}     = "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Common7\\IDE";
		$ENV{'FrameworkDir'}     = "C:\\WINNT\\Microsoft.NET\\Framework";
		$ENV{'FrameworkVersion'} = "v1.1.4322";
		$ENV{'FrameworkSDKDir'}  = "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\SDK\\v1.1";
		$self->{'bits'}          = "32";
		$self->{'platform'}      = "NTintel";
	}
	   	elsif ($self->{'hostname'} eq "pwdf2737") {
		$self->{'path'}         .= ";C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Common7\\IDE;C:\\Program F"
					. "iles\\Microsoft Visual Studio .NET 2003\\VC7\\BIN;C:\\Program Files\\Microsoft V"
					. "isual Studio .NET 2003\\Common7\\Tools;C:\\Program Files\\Microsoft Visual Studi"
					. "o .NET 2003\\Commsetprerelease;C:\\Program Files\\Microsoft Visual"
					. " Studio .NET 2003\\Common7\\Tools\\bin;C:\\Program Files\\Microsoft Visual Studi"
					. "o .NET 2003\\SDK\\v1.1\\bin;C:\\WINNT\\Microsoft.NET\\Framework\\v1.1.4322;";
		$ENV{'INCLUDE'}         = "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\ATLMFC\\INCLUDE;C:\\P"
					. "rogram Files\\Microsoft Visual Studio .NET 2003\\VC7\\INCLUDE;C:\\Program Files\\"
					. "Microsoft Visual Studio .NET 2003\\VC7\\PlatformSDK\\include\\prerelease;C:\\Pr"
					. "ogram Files\\Microsoft Visual Studio .NET 2003\\VC7\\PlatformSDK\\include;C:\\Pr"
					. "ogram Files\\Microsoft Visual Studio .NET 2003\\SDK\\v1.1\\include;C:\\Program F"
					. "iles\\Microsoft Visual Studio .NET 2003\\SDK\\v1.1\\include\\";
		$ENV{'LIB'}             = "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\ATLMFC\\LIB;C:\\Progr"
					. "am Files\\Microsoft Visual Studio .NET 2003\\VC7\\LIB;C:\\Program Files\\Microso"
					. "ft Visual Studio .NET 2003\\VC7\\PlatformSDK\\lib\\prerelease;C:\\Program Files\\"
					. "Microsoft Visual Studio .NET 2003\\VC7\\PlatformSDK\\lib;C:\\Program Files\\Mic"
					. "rosoft Visual Studio .NET 2003\\SDK\\v1.1\\lib;C:\\Program Files\\Microsoft Visu"
					. "al Studio .NET 2003\\SDK\\v1.1\\Lib\\";
		$ENV{'VSINSTALLDIR'}     = "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Common7\\IDE";
		$ENV{'FrameworkDir'}     = "C:\\WINNT\\Microsoft.NET\\Framework";
		$ENV{'FrameworkVersion'} = "v1.1.4322";
		$ENV{'FrameworkSDKDir'}  = "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\SDK\\v1.1";
		$self->{'bits'}          = "32";
		$self->{'platform'}      = "NTintel";
	}
	elsif ($self->{'hostname'} =~ /pwdf2313/) {
		$self->{'path'}         .= "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Common7\\IDE;C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\BIN;C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Common7\\Tools;C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Common7\\Tools\\bin\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET 2003\\Common7\\Tools\\bin;C:\\Program Files\\Microsoft Visual Studio .NET 2003\\SDK\\v1.1\\bin;C:\\WINNT\\Microsoft.NET\\Framework\\v1.1.4322;D:\\depot\\tools\\gen\\ntintel\\OpenSource\\perl\\5.6.1\\bin;d:\\devtool\\perl\\bin;d:\\devtool\\bin;d:\\devtool\\posix;d:\\devtool\\adminbin;d:\\sapdb\\programs\\bin;d:\\sapdb\\programs\\pgm;";
		$ENV{'INCLUDE'}          = "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\ATLMFC\\INCLUDE;C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\INCLUDE;C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\PlatformSDK\\include\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\PlatformSDK\\include;C:\\Program Files\\Microsoft Visual Studio .NET 2003\\SDK\\v1.1\\include;";
		$ENV{'ComSpec'}          = "C:\\WINDOWS\\system32\\cmd.exe";
		$ENV{'CPU'}              = "IA64";
		$ENV{'DEBUGMSG'}         = "RETAIL";
		$ENV{'DXSDKROOT'}        = "C:\\Program Files\\Microsoft Platform SDK";
		$ENV{'INETSDK'}          = "C:\\Program Files\\Microsoft Platform SDK";
		$ENV{'Lib'}              = "C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\ATLMFC\\LIB;C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\LIB;C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\PlatformSDK\\lib\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET 2003\\VC7\\PlatformSDK\\lib;C:\\Program Files\\Microsoft Visual Studio .NET 2003\\SDK\\v1.1\\lib;";
		$ENV{'MSSdk'}            = "C:\\Program Files\\Microsoft Platform SDK";
		$ENV{'Mstools'}          = "C:\\Program Files\\Microsoft Platform SDK";
		$ENV{'MSVCVer'}          = "Win64";
		$ENV{'BIT64'}      = '1';
		$self->{'bits'} = "64";
		$self->{'platform'} = "NTia64";
	}
    	elsif ($self->{'hostname'} =~ "P48289") {
		$self->{'path'}         .= ";C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\IDE;C:\\Program Files\\";
		$self->{'path'}         .= "Microsoft Visual Studio .NET\\VC7\\BIN;C:\\Program Files\\Microsoft Visual Studio .N";
		$self->{'path'}         .= "ET\\Common7\\Tools;C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\Tools\\bin";
		$self->{'path'}         .= "\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\Tools\\bin;C:\\P";
		$self->{'path'}         .= "rogram Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\bin;C:\\WINNT\\Microsoft.NE";
		$self->{'path'}         .= "T\\Framework\\v1.0.3705;";
		$ENV{'INCLUDE'}          = "C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\ATLMFC\\INCLUDE;C:\\Program Files\\"
			     . "Microsoft Visual Studio .NET\\VC7\\INCLUDE;C:\\Program Files\\Microsoft Visual Studio .NET\\"
			     . "VC7\\PlatformSDK\\include\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\include;C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\include;"
			     . "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\include\\";
		$ENV{'LIB'}              = "C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\ATLMFC\\LIB;C:\\Program Files\\"
			     . "Microsoft Visual Studio .NET\\VC7\\LIB;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\lib\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\lib;C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\lib;"
			     . "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\Lib\\";
		$ENV{'VSINSTALLDIR'}     = "C:\\Program Files\\Microsoft Visual Studio .NET";
		$ENV{'FrameworkDir'}     = "C:\\WINNT\\Microsoft.NET\\Framework";
		$ENV{'FrameworkVersion'} = "v1.0.3705";
		$ENV{'FrameworkSDKDir'}  = "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK";
		$self->{'bits'}          = "32";
		$self->{'platform'}      = "NTintel";
    }

    elsif ($self->{'hostname'} eq "itanium21") {
        $self->{'path'}         .= ";C:\\Program Files (x86)\\Java\\j2sdk1.4.2.beta;C:\\Program Files\\Microsoft Platform SDK\\Bin\\Win64;C:\\Program Files\\Microsoft Platform SDK\\";
        $self->{'path'}         .= "Bin;C:\\Program Files\\Microsoft Platform SDK\\Bin\\WinNT;C:\\WINNT;C:\\WINNT\\system32;";
        $ENV{'INCLUDE'}          = "C:\\Program Files\\Microsoft Platform SDK\\Include\\prerelease;C:\\Program Files\\Microsoft Platform SDK\\Include\\Win64\\crt;C:\\Program Files\\Microsoft Platform SDK\\Include\\Win64\\crt\\sys;C:\\Program Files\\Microsoft Platform SDK\\Include\\Win64\\mfc;C:\\Program Files\\Microsoft Platform SDK\\Include\\Win64\\atl;C:\\Program Files\\Microsoft Platform SDK\\Include;C:\\Program Files\\Microsoft Platform SDK\\Include\\DShowIDL;C:\\Program Files\\Microsoft Platform SDK\\PATCH\\include";
        $ENV{'ComSpec'}          = "C:\\WINDOWS\\system32\\cmd.exe";
        $ENV{'CPU'}              = "IA64";
        $ENV{'DEBUGMSG'}         = "RETAIL";
        $ENV{'DXSDKROOT'}        = "C:\\Program Files\\Microsoft Platform SDK";
        $ENV{'INETSDK'}          = "C:\\Program Files\\Microsoft Platform SDK";
        $ENV{'Lib'}              = "C:\\Program Files\\Microsoft Platform SDK\\Lib\\Prerelease\\IA64;C:\\Program Files\\Microsoft Platform SDK\\Lib\\IA64;C:\\Program Files\\Microsoft Platform SDK\\Lib\\IA64\\mfc;C:\\Program Files\\Microsoft Platform SDK\\PATCH\\lib";
        $ENV{'MSSdk'}            = "C:\\Program Files\\Microsoft Platform SDK";
        $ENV{'Mstools'}          = "C:\\Program Files\\Microsoft Platform SDK";
        $ENV{'MSVCVer'}          = "Win64";
        $ENV{'BIT64'}      = '1';
        $self->{'bits'} = "64";
        $self->{'platform'} = "NTia64";
    }
    elsif ($self->{'hostname'} eq "P65951") {
		$self->{'path'}         .= ";C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\IDE;C:\\Program Files\\";
		$self->{'path'}         .= "Microsoft Visual Studio .NET\\VC7\\BIN;C:\\Program Files\\Microsoft Visual Studio .N";
		$self->{'path'}         .= "ET\\Common7\\Tools;C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\Tools\\bin";
		$self->{'path'}         .= "\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\Common7\\Tools\\bin;C:\\P";
		$self->{'path'}         .= "rogram Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\bin;C:\\WINNT\\Microsoft.NE";
		$self->{'path'}         .= "T\\Framework\\v1.0.3705;";
		$ENV{'INCLUDE'}          = "C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\ATLMFC\\INCLUDE;C:\\Program Files\\"
			     . "Microsoft Visual Studio .NET\\VC7\\INCLUDE;C:\\Program Files\\Microsoft Visual Studio .NET\\"
			     . "VC7\\PlatformSDK\\include\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\include;C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\include;"
			     . "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\include\\";
		$ENV{'LIB'}              = "C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\ATLMFC\\LIB;C:\\Program Files\\"
			     . "Microsoft Visual Studio .NET\\VC7\\LIB;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\lib\\prerelease;C:\\Program Files\\Microsoft Visual Studio .NET\\VC7\\"
			     . "PlatformSDK\\lib;C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\lib;"
			     . "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK\\Lib\\";
		$ENV{'VSINSTALLDIR'}     = "C:\\Program Files\\Microsoft Visual Studio .NET";
		$ENV{'FrameworkDir'}     = "C:\\WINNT\\Microsoft.NET\\Framework";
		$ENV{'FrameworkVersion'} = "v1.0.3705";
		$ENV{'FrameworkSDKDir'}  = "C:\\Program Files\\Microsoft Visual Studio .NET\\FrameworkSDK";
		$self->{'bits'}          = "32";
		$self->{'platform'}      = "NTintel";
    }
    else {
        print "The host $self->{'hostname'} ist not known in the configuration\n(See sub getdep!)\n";
        exit(1);
    }

    if (defined ${$options}{'ID'}) {
	    if (defined $sess_opts) {
		    $self->{'qah'} = qadb->new({'ID' => ${$options}{'ID'}}, $sess_opts);
	    } else {
		    $self->{'qah'} = qadb->new({'ID' => ${$options}{'ID'}});
	    }
		$self->{'qah'}->get_testlist();
		$self->{'version'} = $self->{'qah'}->{'VERSION'};
		$self->{'status'}  = $self->{'qah'}->{'QASTATUS'};
		if (${$options}{'profile'} eq 'weekend') {
			$self->{'profile'} = 'weekend';
		}
		else {
			$self->{'profile'} = 'workday';
		}
	} else {
		$self->{'version'} = ${$options}{'version'};
		$self->{'status'}  = ${$options}{'status'};
		if (${$options}{'profile'} eq 'weekend') {
			$self->{'profile'} = 'weekend';
		}
		else {
			$self->{'profile'} = 'workday';
		}
		
		if (defined $sess_opts) {
			$self->{'qah'} = qadb->new_test({'QASTATUS' => $self->{'status'}, 'VERSION' => $self->{'version'}}, $sess_opts);
		} else {
			$self->{'qah'} = qadb->new_test({'QASTATUS' => $self->{'status'}, 'VERSION' => $self->{'version'}});
		}
		if ($qah->{'error_code'} != 0) {
			print "Exiting:\n" . $qah->{'error_text'} . "\n";
			exit(1);
		}
	}
	print $self->{'qah'}->{'platformname'} . "\n";
	$self->{'platform'} = $self->{'qah'}->{'platformname'};
	$ENV{'PLATFORM'} = $self->{'platform'};
	
	$self->{'node'} = $self->{'version'} . $self->{'status'};


    ##################################################################
    # Find out which files to usee
    ##################################################################
    if ((($self->{'status'} eq "RAMP")or ($self->{'status'} =~ /HOT/)) && !($^O =~ /MSWin32/i)){
        print "################\n/bas/SAP_DB/$self->{'version'}/pkg/$self->{'platform'}/LC_$self->{'version'}??_$self->{'bits'}_$self->{'status'}";
        @subdirs           = glob ("/bas/SAP_DB/$self->{'version'}/pkg/$self->{'platform'}/LC_$self->{'version'}??_$self->{'bits'}_$self->{'status'}");
        sort (@subdirs);
        $self->{'subdir'}  = pop(@subdirs);

        @files             = (glob "$self->{'subdir'}/" . $self->{'qah'}->{'LCPOOLID'} . "/SAPDB$self->{'version'}*.SAR");
        $self->{'srcfile'} = pop(@files);

        $self->{'srcdir'}  = "$self->{'subdir'}/" . $self->{'qah'}->{'LCPOOLID'};
        $self->{'build'}   = substr($self->{'subdir'}, length("/bas/SAP_DB/$self->{'version'}/pkg/$self->{'platform'}/LC_$self->{'version'}"), 2);
        $self->{'sdbinst'} = $self->{'srcdir'} . "/SAPDB_COMPONENTS/SDBINST";
    }

    elsif  ((($self->{'status'} eq "RAMP")or ($self->{'status'} =~ /HOT/)) && ($^O =~ /MSWin32/i)) {
        @subdirs = glob ("L:\\LC_$self->{'version'}??_$self->{'bits'}_$self->{'status'}");
        sort (@subdirs);
        $self->{'subdir'}  = pop(@subdirs);
        $self->{'srcdir'}  = $self->{'subdir'} . "\\" . $self->{'qah'}->{'LCPOOLID'};
        @files             = (glob ("$self->{'srcdir'}\\SAPDB$self->{'version'}*.SAR"));
        $self->{'srcfile'} = pop(@files);
        $self->{'build'}   = substr($self->{'subdir'}, length("L:\\LC_$self->{'version'}"), 2);
        $self->{'sdbinst'} = $self->{'srcdir'} . "\\SAPDB_COMPONENTS\\SDBINST.EXE";
    }

    elsif (($self->{'status'} ne "RAMP") && !($^O =~ /MSWin32/i)) {
        $self->{'subdir'} = "/bas/SAP_DB/$self->{'version'}/pkg/$self->{'platform'}/LC_$self->{'version'}_$self->{'bits'}_$self->{'status'}";
        @files = (glob "$self->{'subdir'}/LastBuild/SAPDB$self->{'version'}*.SAR");

        $self->{'srcfile'} = pop(@files);
        $self->{'srcdir'}  = "$self->{'subdir'}/LastBuild";
        $self->{'build'}   = substr($self->{'srcfile'}, -6 ,2);
        $self->{'sdbinst'} = $self->{'srcdir'} . $self->{'delimit'} . "SAPDB_COMPONENTS" . $self->{'delimit'} . "SDBINST";
    }
    elsif (($self->{'status'} ne "RAMP") && ($^O =~ /MSWin32/i)) {
        $self->{'subdir'}   = "L:\\LC_$self->{'version'}_$self->{'bits'}_$self->{'status'}";
        $self->{'srcdir'}   = $self->{'subdir'} . "\\" . $self->{'qah'}->{'LCPOOLID'};

        @files              = (glob "$self->{'srcdir'}\\SAPDB$self->{'version'}*.SAR");
        $self->{'srcfile'}  = pop(@files);
        $self->{'build'}    = substr($self->{'srcfile'}, -6, 2);
        $self->{'sdbinst'}  = $self->{'srcdir'} . "\\SAPDB_COMPONENTS\\SDBINST.EXE";
    }

    $self->{'tempdir'}    = $self->{'rootdir'} . $self->{'node'} . $self->{'delimit'} . "tmp";
    $self->{'dbroot'}     = $self->{'rootdir'} . $self->{'node'} . $self->{'delimit'} . "db";
    $self->{'testdir'}    = $self->{'rootdir'} . $self->{'node'} . $self->{'delimit'} . "test";
    $self->{'configfile'} = $self->{'rootdir'} . $self->{'node'} . $self->{'delimit'} . "etc" . $self->{'delimit'} . "db-keys";
    $self->{'jtest_root'} = $self->{'testdir'} . $self->{'delimit'}. "jtest";


    if ((!$self->{'dbh'}->{'SESSION_ID'}) && (-e $self->{'configfile'})) {
	    my $etc_ref = IniFile::load($self->{'configfile'});
	    if ($etc_ref->{'IDSESSION'}) {
		    print "Re-Initializing session # $etc_ref->{'IDSESSION'}..";
		    $self->{'qah'}->create_session({'ID' => $etc_ref->{'IDSESSION'}});
		    print "..OK\n";
	    }
    }
	$ENV{'INDEPPATH'}   = $self->{'indeppath'};
	
	if (!($^O =~ /MSWin32/i)) {
		$ENV{'INDEPLIB'}	= $self->{'indeppath'} . $self->{'libappend'};
		$self->{'homedir'}	= $self->{'tempdir'};
	} else {
		$self->{'homedir'}	= "$self->{'tesdrive'}\\temp";
	}
	
	$self->{'vserver'}  = $self->{'indeppath'} . $self->{'delimit'} . "pgm" . $self->{'delimit'} . "vserver";
	
	$self->{'path'}     = $self->{'testdir'} . $self->{'delimit'} . "pc" . $self->{'delimit'} . "bin" . $self->{'pathsep'} . $self->{'dbroot'} . $self->{'delimit'} . "bin". $self->{'pathsep'} . $self->{'dbroot'} . $self->{'delimit'} . "pgm" . $self->{'pathsep'} . $self->{'path'};
	$ENV{'HOME'}        = $self->{'homedir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
	$ENV{'PYTHONPATH'} .= $self->{'pathsep'} . $self->{'dbroot'} . $self->{'delimit'} . "misc";
	$ENV{'TEST_ROOT'}   = $self->{'testdir'};
	$ENV{'TESTROOT'}    = $self->{'testdir'};
	
	if ((int($self->{'version'} == 7500)) && (($self->{'qah'}->{'IDPLATFORM'} != 16) && ($self->{'qah'}->{'IDPLATFORM'} != 15))) {  # Prevent Precompiler-Installations in linuxx86_64 
		$self->{'sapdbsdk'} = $self->{'indeppath'} . $self->{'delimit'} . "sdk" . $self->{'delimit'} . "7403";
	} else {
		$self->{'sapdbsdk'} = $self->{'indeppath'} . $self->{'delimit'} . "sdk" . $self->{'delimit'} . $self->{'version'};
	}
	
	$ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
	
	
	$ENV{'TMP'}         = $self->{'tempdir'};
	$ENV{'TEMP'}        = $self->{'tempdir'};
	
	# hang in precompiler version (given by $options{'PCVERSION'}) if it differs from kernel version
	if ((defined ${$options}{'pcversion'}) &&  
	   (($pcoptions{'version'} !~ /^$self->{'versions'}$/) || ($pcoptions{'status'} !~ /^$self->{'status'}$/)))
	{
		
		%pcoptions = %$options;
		if ( ${$options}{'pcversion'} =~ /^(\d{4})(DEV|COR|RAMP|HOT)/)
		{
			$pcoptions{'version'} = $1;
			$pcoptions{'status'}  = $2; 
			delete $pcoptions{'pcversion'};  # prevent recursion
			attach_pcversion ($self, \%pcoptions);			
		}
	}
	
	$self->{'noset_lcok'}  = 1  if (${$options}{'noset_lcok'}); 
	if (${$options}{'no_objstat'})	{
		$self->{'no_objstat'}  = 1; 
		$self->{'noset_lcok'} = 1;	
	}
	
	# dbtypes all|ascii|unicode
	if (defined ${$options}{'dbtype'})
	{
		my @dbtypes = split ",",${$options}{'dbtype'};
		foreach (@dbtypes) {
			$self->{'dbtypes'}->{$_} = 1;		
		}
	}
	else {
		$self->{'dbtypes'}->{'all'} = 1;
	}
	
	# don't install precompiler for releases < 7.4.02 
	$self->{'instcomponents'}->{'no_cpc'} = 1 if ((int($self->{'version'}) < 7403) && (! defined $self->{'pchandle'}));
	# no odbc under 7600
   	$self->{'instcomponents'}->{'no_odbc'} = 1 if (int($self->{'version'}) == 7600);
   	$self->{'instcomponents'}->{'no_cpc'} = 1 if (int($self->{'version'}) == 7600);
   	
	# normally I read it from a table in qadb for defaults of the release
	if (defined ${$options}{'instcomponents'})
	{
		my @instcomps = split ",",${$options}{'instcomponents'};
		foreach (@instcomps) {
			unless ( /^all|no_/ ) {
				delete $self->{'instcomponents'}->{'all'};
				delete $self->{'instcomponents'}->{"no_$_"};
			}
			$self->{'instcomponents'}->{$_} = 1;		
		}
	}
   	
   	for $x (keys(%$self)) {
		print "$x = " . $self->{$x} . "\n";
	}
   	
	return bless $self;
}


sub attach_pcversion
{
	my $self = shift;
	my $pcoptions = shift;
	$self->{'pchandle'} = testdb->new($pcoptions);
	$self->{'sapdbsdk'} = $self->{'indeppath'} . $self->{'delimit'} . "sdk" . $self->{'delimit'} . $self->{'pchandle'}->{'version'};
}

sub unlock {
	my $self = shift;
	return $self->{'qah'}->unlock();
}

sub lock {
	my $self = shift;
	
	$self->{'qah'} = $self->{'qah'}->lock();
	return 0;
}
#
# Provide a terminal
#
sub term {
	$self = shift;
	$ENV{'PATH'}        = $self->{'path'};
	$ENV{'HOME'}        = $self->{'homedir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
	$ENV{'INSTROOT'}    = $self->{'dbroot'};
	$ENV{'TEST_ROOT'}   = $self->{'testdir'};
	$ENV{'TESTROOT'}    = $self->{'testdir'};
	$ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
	$ENV{'TMP'}         = $self->{'tempdir'};
	$ENV{'TEMP'}        = $self->{'tempdir'};
	$ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
	$ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
	if ($^O =~ /MSWin32/i) {
		system ("cmd");
	}
	else {
		system ("xterm &");
	}
}

sub cmd {
	$self = shift;
	$cmd  = shift;
	
	$ENV{'PATH'}        = $self->{'path'};
	$ENV{'HOME'}        = $self->{'homedir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
	$ENV{'INSTROOT'}    = $self->{'dbroot'};
	$ENV{'TEST_ROOT'}   = $self->{'testdir'};
	$ENV{'TESTROOT'}    = $self->{'testdir'};
	$ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
	$ENV{'TMP'}         = $self->{'tempdir'};
	$ENV{'TEMP'}        = $self->{'tempdir'};
	$ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
	$ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
	
	&doCmd($self, $cmd);
}

##################################################################
# subs
##################################################################
##################################################################
# preClean:
# Throws away current instances, unregisters the installation
# and erases tempoary and test directorys.
##################################################################
sub preClean {
	$self = shift;
	my $full_clean = shift;
	$ENV{'PATH'}		 = $self->{'path'};
	$ENV{'HOME'}		 = $self->{'homedir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}	 = $self->{'jtest_root'};
	$ENV{'INSTROOT'}	 = $self->{'dbroot'};
	$ENV{'TEST_ROOT'}	 = $self->{'testdir'};
	$ENV{'TESTROOT'}	 = $self->{'testdir'};
	$ENV{'SAPDBSDK'}	 = $self->{'sapdbsdk'};
	$ENV{'TMP'}		 = $self->{'tempdir'};
	$ENV{'TEMP'}		 = $self->{'tempdir'};
	$ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
	$ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);

	&doCmd($self, "x_niserver stop");
	&doCmd($self, "x_server $self->{'xserver_param'}");
	open (DBLIST, 'dbmcli db_enum|');
	my $x = "";
	while (<DBLIST>) {
		if ($full_clean) {
			if ( /fast/ ) {
				s/^(\w+)\s+.*$/$1 /;
				$x = $_;
				chomp($x);
				foreach $y ("control,control", "dbm,dbm", "superdba,colduser") {
					print "dbmcli -u $x -d $x\n";
					&doCmd($self, "dbmcli -u $y -d $x db_stop");
					&doCmd($self, "dbmcli -u $y -d $x db_clear");
					&doCmd($self, "dbmcli -u $y -d $x db_drop");
				}
				#&doCmd($self, "$self->{'rmcmd'} $self->{'indepdata'}$self->{'delimit'}wrk$self->{'delimit'}$x")
				print "########### DELETE DB-DIR ##############################\n";
				print "$self->{'rmcmd'} $self->{'indepdata'}$self->{'delimit'}wrk$self->{'delimit'}$x\n";
			}			
		} else {
			if ($self->{'verbose'}) {
			    print "$_ \n";
			    print $self->{'node'} . "\n";
			}
	
			if ( /fast/ && /$self->{node}/i ) {
				s/^(\w+)\s+.*$/$1 /;
				$x = $_;
				chomp($x);
				foreach $y ("control,control", "dbm,dbm", "superdba,colduser") {
					print "dbmcli -u $x -d $x\n";
					&doCmd($self, "dbmcli -u $y -d $x db_stop");
					&doCmd($self, "dbmcli -u $y -d $x db_clear");
					&doCmd($self, "dbmcli -u $y -d $x db_drop");
				}
				&doCmd($self, "$self->{'rmcmd'} $self->{'indepdata'}$self->{'delimit'}wrk$self->{'delimit'}$x");
				print "########### DELETE DB-DIR ##############################\n";
				print "$self->{'rmcmd'} $self->{'indepdata'}$self->{'delimit'}wrk$self->{'delimit'}$x\n";
	
			}
		}
    }

    &doCmd($self, "x_niserver stop");
    print "#######################################################################################\n";
    &doCmd($self, "x_server stop");

    # If we were called with -noinstall, it is _not_ usefull to
    # deregister the installation.
    if (!($options{'noinstall'})) {
    &doCmd($self, "dbmcli inst_unreg $self->{'dbroot'}");
    }

   # if ($^O =~ /MSWin32/i) {
   #     &doCmd($self, "kill dbmsrv.exe");
   # }


    &doCmd($self, "$self->{'rmcmd'} $self->{'tempdir'}" . $self->{'delimit'} . "*");
    
    unless ($^O =~ /MSWin32/i) {
	    &doCmd($self, "$self->{'rmcmd'} $self->{'tempdir'}" . $self->{'delimit'} . ".[xX]*");
    }
    
    &doCmd($self, "$self->{'rmcmd'} $self->{'testdir'}" . $self->{'delimit'} . "* ");
}

##################################################################
# installLC:
# installs the LC depending on the informations we have
# already figured out.
##################################################################
sub installLC {
	$ENV{'PATH'}        = $self->{'path'};
	$ENV{'HOME'}        = $self->{'homedir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
	$ENV{'INSTROOT'}    = $self->{'dbroot'};
	$ENV{'TEST_ROOT'}   = $self->{'testdir'};
	$ENV{'TESTROOT'}    = $self->{'testdir'};
	$ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
	$ENV{'TMP'}         = $self->{'tempdir'};
	$ENV{'TEMP'}        = $self->{'tempdir'};
	$ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
	$ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
	my $self = shift;
	my $components = shift;
	
	my $rc;
	my $sig;
	my $core;
	my $outbuf;
	
	$self->{'qah'}->create_session({'SESSION_TYPE' => 'TBS'});
	print "\tWriting config to $self->{'configfile'} ...." . (IniFile::SaveSimpleCfg($self->{'configfile'}, {'IDMAKE' => $self->{'qah'}->{'ID'}, 'IDSESSION' => $self->{'qah'}->{'SESSION_ID'}}) ? "OK":"FAILED")  . "\n";

	
	my %components_to_install = %{$self->{'instcomponents'}};
	if ($components)
	{
		foreach (split ",", $components)
		{
			unless ( /^all|no_/ ) {
				delete $components_to_install{'all'};
			}
			$components_to_install{$_} = 1;		
			delete $components_to_install{"no_$_"};
		}
	}
	$self->{'forced_instcomponents'} = \%components_to_install;
	
	my $install_list = undef;
	my %instlist;
    foreach (keys %components_to_install)
	{
		if ($install_list)
		{ $install_list .= ", $_"; }
		else
		{ $install_list .= "$_"; }
	}
		
	$self->{qah}->write_log("$self->{'hostname'} - Install: $install_list");	
	
	system("x_server stop");
	
	&doCmd($self, "uptime");
	if (! $self->{'noset_lcok'}) 	{
		$self->{'qah'}->execDML("UPDATE makes SET lcok = FALSE, IDOBJSTATUS = 1100 WHERE id = $self->{'qah'}->{'ID'}");
	}
	if ($^O =~ /MSWin32/i) {
			
		#
		# Tempoary for the current 7600COR SQLDBC-only-release
		#
		#if (($self->{'version'} =~ /7600/) && ($self->{'status'} =~ /COR/)) {
		#	$self->{'inst_param'} = " -b -package \"Base,Database Connectivity\" -dbc_path $self->{'dbroot'}";
		#	
		#	&instloginit($self);
		#	($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'inst_param'} ");
		#	&instlogwrite($self, "LC installation - Core installation log file");
		#	
		#	if ($rc != 0) {
		#	    send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - Core installation failed.", $outbuf);
		#	}
		#	return;
		#}
		$self->{'odbcinst_param'} = " -b -profile ODBC  ";
		$self->{'inst_param'} = " -b -profile Server  -depend $self->{'dbroot'} ";
		$self->{'loader_param'} = " -b -profile Loader -loader_path $self->{'indeppath'}";
		
		if ($self->to_install("server"))
		{
			&instloginit($self);
			($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'inst_param'} ");
			&instlogwrite($self, "LC installation - core installation log file");
			if ($rc != 0) {
				send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - Core installation failed.", $outbuf);
				##### RESTART THE x_server
				($rc, $sig, $core, $outbuf) = &doCmd($self, "x_server $self->{'xserver_param'}");
				undef $self;
				return;
			}
		}
		
		if ($self->to_install("loader"))
		{
			### Loader installation ########################################
			if (int($self->{'version'}) >= 7500) {
				&instloginit($self);
				($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'loader_param'} ");
				&instlogwrite($self, "LC installation - Loader installation log file");
				if ($rc != 0) {
					send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - Loader installation failed.", $outbuf);
				}
			}
		}
	
		#system("x_server $self->{'xserver_param'}");
		open (LTFD, (">" . $self->{'subdir'} . $self->{'delimit'} . "LastTest"));
		print LTFD $self->{'buildidx'} . "\n";
		close (LTFD);
	} else {
		# Set the lastTest-Directory correctly:
		# First, the old LastTest has to be unlinked
		if (-e $self->{'subdir'} . $self->{'delimit'} . "LastTest") {
			if (!($options{'dry'})) {
				if ($options{'verbose'}) {
					print "Unlinking LastTest $self->{'subdir'}" . $self->{'delimit'} . "LastTest\n"
				}
				unlink ($self->{'subdir'} . "" . $self->{'delimit'} . "LastTest") || print "Could not erase LastTest!\n";
			} else {
				print "Normaly, the LastTest ($self->{'subdir'}" . $self->{'delimit'} . "LastTest) would be erased now.\n";
			}
		}
		# then, create a new link
		if (!($options{'dry'})) {
			if ($options{'verbose'}) {
				print "Linking $self->{'subdir'}" . $self->{'delimit'} . "$self->{'qah'}->{'LCPOOLID'} to LastTest\n";
			}
			symlink ($self->{'subdir'} .  $self->{'delimit'} . $self->{'qah'}->{'LCPOOLID'}, $self->{'subdir'} . $self->{'delimit'} . "LastTest") ||
			print "Could not link $self->{'subdir'}" . $self->{'delimit'} . $self->{'qah'}->{'LCPOOLID'} . " to LastTest\n";
		} else {
			print "Normaly:\nLinking $self->{'subdir'}" . $self->{'delimit'} . "$self->{'qah'}->{'LCPOOLID'} to LastTest\n";
		}
		# End of link-setting
		
		# perform the installation itself
		if ($self->{'version'} >= 7500) {
			$self->{'odbcinst_param'} = " -b -profile ODBC ";
			$self->{'inst_param'} = " -b -profile Server -depend $self->{'dbroot'} ";
			$self->{'loader_param'} = " -b -profile Loader -loader_path $self->{'indeppath'}";
		} else {
			$self->{'odbcinst_param'} = " -b -profile ODBC -o $self->{'user'} -g $self->{'group'}  ";
			$self->{'inst_param'} = " -b -profile Server -o $self->{'user'} -g $self->{'group'} -depend $self->{'dbroot'} ";
			$self->{'loader_param'} = " -b -profile Loader -o $self->{'user'} -g $self->{'group'} -loader_path $self->{'indeppath'}";
		}
		
		###################
		if ($self->to_install("server"))
		{
			&instloginit($self);
			($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'inst_param'} ");
			&instlogwrite($self, "LC installation - core installation log file");
			if ($rc != 0) {
				send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - Core installation failed.", $outbuf);
				$self->update_idobjstatus(1109); 
				##### RESTART THE x_server
				($rc, $sig, $core, $outbuf) = &doCmd($self, "x_server $self->{'xserver_param'}");
				undef $self;
				return;
			}
		}
		
		if ($self->to_install("loader"))
		{
			if (int($self->{'version'}) >= 7500) {
				($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'loader_param'} ");
				if ($rc != 0) {
					send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - Loader installation failed.", $outbuf);
				}
			}
		}
	}
	
	
	if ($self->to_install("webtools") )
	{
		print "##### Webtools ##############################################\n";
		
		if (($self->{'version'} <= 7403) and (!($^O =~ /MSWin32/)))  {
			$self->{'webtool_param'} = " -b -profile Webtools  -o $self->{'user'} -g $self->{'group'}";
		} else { 
			$self->{'webtool_param'} = " -b -profile Webtools ";
		}
		
		&instloginit($self);
		($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'webtool_param'} ");
		&instlogwrite($self, "LC installation - Webtools installation log file");
	
		if ($rc != 0) {
			send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - Webtools installation failed.", $outbuf);
		}
		if (($self->{'version'} =~ /7600/) && ($self->{'status'} =~ /DEV/)) {
			($rc, $sig, $core, $outbuf) = &doCmd($self, "echo y | $self->{'instwrap'} $self->{'indeppath'}" . $self->{'delimit'} . "bin" . $self->{'delimit'} . "sdbuninst -autoresolve -package Webtools");
			
			if ($rc != 0) {
				send_error($self, 1109, $rc, $sig, $core, "LC installation - removing old Webtools failed.", $outbuf);
			}
		}
	}
	
	if ($self->to_install("odbc"))
	{
		### ODBC ###############################################################
		# Okay, dann machen wir mal etwas ODBC
		# First, remove the currently installed ODBC package
		print "##### ODBC ##################################################\n";
		if (!($^O =~ /MSWin32/i)) {
			($rc, $sig, $core, $outbuf) = &doCmd($self, "echo y | $self->{'instwrap'} $self->{'indeppath'}" . $self->{'delimit'} . "bin" . $self->{'delimit'} . "sdbuninst -autoresolve -package ODBC");
			if ($rc != 0) {
				send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - removing old ODBC failed.", $outbuf);
			}
			# Then install the package we want.
			&instloginit($self);
			($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'odbcinst_param'} ");
			&instlogwrite($self, "LC installation - ODBC installation log file");
			if ($rc != 0) {
				send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - ODBC installation failed.", $outbuf);
			}
		}
	}
	
	if ($self->to_install("cpc"))
	{
		print "##### C Precompiler ##########################################\n";
		my $pcinsthandle = defined $self->{'pchandle'} ? $self->{'pchandle'} : $self;
		my $pcqadbhandle = undef;
		&instloginit($self);
		$pcinsthandle->{'cpc_param'} = " -b -profile \"C Precompiler\" ";
		if ((int($pcinsthandle->{'version'}) == 7403) &&  (!($^O =~ /MSWin32/i))) {
			$pcinsthandle->{'cpc_param'} .= " -o $pcinsthandle->{'user'} -g $pcinsthandle->{'group'}";
		}
		
		unless ( $pcinsthandle == $self ) {
			$self->{qah}->write_log("$self->{'hostname'} - Install precompiler ".
			      "<a href=\"Make_Details.jsp?id=$pcinsthandle->{'qah'}->{'ID'}\">".
			      "$pcinsthandle->{'version'}$pcinsthandle->{'status'}<\/a>");
			
			$pcinsthandle->{qah}->write_log("$self->{'hostname'} - Install precompiler in ".
			      "<a href=\"Make_Details.jsp?id=$self->{'qah'}->{'ID'}\">".
			      "$self->{'version'}$self->{'status'}<\/a>");	
			$pcinsthandle->{'sdbinstlogfile'} = $self->{'sdbinstlogfile'};
			$pcqadbhandle = $pcinsthandle->{qah};
			$pcinsthandle->{qah} = $self->{qah};
			$pcinsthandle->{'log_count'} = $self->{'log_count'};
			$pcinsthandle->{'prot_count'} = $self->{'prot_count'};
			# unregister precompiler runtime of kernel version (installed by server installation)
			&doCmd($self, "irconf -r -p $self->{'indeppath'}$self->{'delimit'}runtime$self->{'delimit'}$self->{'version'}");
		}
		
		($rc, $sig, $core, $outbuf) = &doCmd($pcinsthandle, " $pcinsthandle->{'instwrap'} $pcinsthandle->{'sdbinst'} $pcinsthandle->{'cpc_param'} ");
		
		&instlogwrite($pcinsthandle, "LC installation - CPC installation log file");	
		
		if ($rc != 0) {
			send_error($pcinsthandle, 1109, $rc, $sig, $core, "Error: LC installation - CPC installation failed.", $outbuf);
			if ( defined $pcqadbhandle ) {
				$pcinsthandle->{qah} = $pcqadbhandle;
				send_error($pcinsthandle, 1109, $rc, $sig, $core, "Error: LC installation - CPC installation failed.", $outbuf);
				$errcnt++;
			}
		}
	
		unless ( $pcinsthandle == $self ) {
			# set all back to original
			$self->{'log_count'}  = $pcinsthandle->{'log_count'};
			$self->{'prot_count'} = $pcinsthandle->{'prot_count'};
			$self->{'pchandle'}->{'qah'} = $pcqadbhandle;
		}
	}
	
	if ($self->to_install("testcomponents"))
	{	
		#####SIMULATOR##########################################################
		# Okay, now we will install the files for the lc-simulator
		#
		if ((int($self->{'version'}) >= 7500) or (int($self->{'version'}) >= 7403)) {
			print "##### Testcomponents ########################################\n";
			
			if ($self->{'version'} =~ /7600/) {
				($rc, $sig, $core, $outbuf) = &doCmd($self, "echo y | $self->{'instwrap'} $self->{'indeppath'}" . $self->{'delimit'} . "bin" . $self->{'delimit'} . "sdbuninst -autoresolve -package \"SAP CRYPTOLIB\"");
				
				if ($rc != 0) {
					send_error($self, 1109, $rc, $sig, $core, "LC installation - removing old cRYPTOLIB failed.", $outbuf);
				}
			}
			
			$self->{'test_param'} = "-a " . $self->{'srcdir'} . $self->{'delimit'} . "TEST_COMPONENTS -b -profile all -tstknl_path $self->{'dbroot'} -lc_sim_path $self->{'dbroot'} -test_apps_path $self->{'dbroot'}";
			
			&instloginit($self);
			($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'test_param'} ");
			&instlogwrite($self, "LC installation - Testcomponents installation log file");
			
			if ($rc != 0) {
				send_error($self, 1109, $rc, $sig, $core, "Error: LC installation - Testcomponents installation failed.", $outbuf);
			}
			
		} else {
			print "#####SIMULATOR###############################################################\nStart copying simulator files:\n";
			($rc, $sig, $core, $outbuf) = &doCmd($self, "x_server $self->{'xserver_param'}");

			open LIST_FH, ($self->{'srcdir'} . $self->{'delimit'}. "simul.lst") or return throw_err("Could not open $self->{'srcdir'}$self->{'delimit'}simul.lst\n");
			
			while(<LIST_FH>) {
				# At first: Figure out what the sourcename is
				my $srcfile  = "$self->{'srcdir'}$self->{'delimit'}sys$self->{'delimit'}src$self->{'delimit'}lcsrc$self->{'delimit'}$_";
				# Then find the target-directory:
				
				my $destfile = "$self->{'dbroot'}$self->{'delimit'}$_";
				chomp $srcfile;
				chomp $destfile;
				print "$srcfile -> $destfile\n";
				checkdir ($destfile);
				copy ($srcfile, $destfile) or throw_err ("Could not copy $srcfile to $destfile:\n$! \n");
				chmod ((stat($srcfile))[2], $destfile);
			}
		}
	}
	
	##### RESTART THE x_server
	($rc, $sig, $core, $outbuf) = &doCmd($self, "x_server $self->{'xserver_param'}");
	
	
	$self->update_idobjstatus(1110); 
}


##################################################################
# installLC:
# installs the LC depending on the informations we have
# already figured out.
##################################################################
sub installLCComplete {
	my $self = shift;
	my $components = shift;
	
	$ENV{'PATH'}        = $self->{'path'};
	$ENV{'HOME'}        = $self->{'tempdir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
	$ENV{'INSTROOT'}    = $self->{'dbroot'};
	$ENV{'TEST_ROOT'}   = $self->{'testdir'};
	$ENV{'TESTROOT'}    = $self->{'testdir'};
	$ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
	$ENV{'TMP'}         = $self->{'tempdir'};
	$ENV{'TEMP'}        = $self->{'tempdir'};
	$ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
	$ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
	
	my $rc;
	my $sig;
	my $core;
	my $outbuf;
	my $errcnt = 0;
	
	my %components_to_install = %{$self->{'instcomponents'}};
	if ($components)
	{
		foreach (split ",", $components)
		{
			unless ( /^all|no_/ ) {
				delete $components_to_install{'all'};
			}
			$components_to_install{$_} = 1;		
			delete $components_to_install{"no_$_"};
		}
	}
	$self->{'forced_instcomponents'} = \%components_to_install;
	
	my $install_list = undef;
	my %instlist;
    foreach (keys %components_to_install)
	{
		if ($install_list)
		{ $install_list .= ", $_"; }
		else
		{ $install_list .= "$_"; }
	}
		
	$self->{qah}->write_log("$self->{'hostname'} - Install complete: $install_list");	
	
	# no options under windows
	my $user_group_options = ( ($^O =~ /MSWin32/i) ? "" : "-o $self->{'user'} -g $self->{'group'} ");
	
	&doCmd($self, "uptime");
	
	if ( -f  "$self->{'indeppath'}/bin/x_server". (($^O =~ /MSWin32/i) ? ".exe" : "") )	{
		&doCmd($self, "x_server stop");
	}
	
	if (! $self->{'noset_lcok'}) 	{
		$self->{'qah'}->execDML("UPDATE makes SET lcok = FALSE, IDOBJSTATUS = 1100 WHERE id = $self->{'qah'}->{'ID'}");
	}
	
    # perform the installation itself
    $self->{'odbcinst_param'} = " -b -profile ODBC ";
    $self->{'inst_param'} = " -b -profile Server $user_group_options -depend $self->{'dbroot'} -indep_prog $self->{'indeppath'} -indep_data $self->{'indepdata'} ";
    
	if ($self->to_install("server"))
	{
		&instloginit($self);
	
        ($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'inst_param'} ");
		&instlogwrite($self, "LC installation - Core installation log file");
	
        if ($rc != 0) {
            send_error($self, 1109, $rc, $sig, $core, "LC installation - Core installation failed.", $outbuf);
            $errcnt ++;
        }
    }
	
	if ($self->to_install("loader"))
	{
		if ($self->{'version'} =~ /7500/) {
			$self->{'loader_param'} = " -b -profile Loader -loader_path $self->{'indeppath'}";
			print "##### Loader ##############################################\n";
			&instloginit($self);
			
			($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'loader_param'} ");
			&instlogwrite($self, "LC installation - Loader installation log file");
			if ($rc != 0) {
				send_error($self, 1109, $rc, $sig, $core, "LC installation - Loader installation failed.", $outbuf);
				$errcnt++;
			}
		}
	}
	
	if ($self->to_install("webtools"))
	{
		print "##### Webtools ##############################################\n";
		
		&instloginit($self);
	
		if (($self->{'version'} > 7403) and ($^O =~ /MSWin32/i))  {	
			$self->{'webtool_param'} = " -b -profile Webtools ";
		} else { 
			$self->{'webtool_param'} = " -b -profile Webtools  $user_group_options";
		}
		
		($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'webtool_param'} ");
		&instlogwrite($self, "LC installation - Webtools installation log file");
		
		if ($rc != 0) {
			send_error($self, 1109, $rc, $sig, $core, "LC installation - Webtools installation failed.", $outbuf);
			$errcnt++;
		}
			
	}
	
	if ($self->to_install("testcomponents"))
	{
		if ((int($self->{'version'}) >= 7500) or (int($self->{'version'}) >= 7403))
		{	
			&instloginit($self);
			print "##### Testcomponents ########################################\n";
			
			$self->{'test_param'} = "-a " . $self->{'srcdir'} . $self->{'delimit'} . "TEST_COMPONENTS -b -profile all -tstknl_path $self->{'dbroot'} -lc_sim_path $self->{'dbroot'} -test_apps_path $self->{'dbroot'}";
			
			($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'test_param'} ");
			&instlogwrite($self, "LC installation - Testcomponents installation log file");
			
			if ($rc != 0) {
				send_error($self, 1109, $rc, $sig, $core, "LC installation - Testcomponents installation failed.", $outbuf);
				$errcnt++;
			}
		}
		else {
			print "#####SIMULATOR###############################################################\nStart copying simulator files:\n";
			
			open LIST_FH, ($self->{'srcdir'} . $self->{'delimit'}. "simul.lst") or return throw_err("Could not open $self->{'srcdir'}$self->{'delimit'}simul.lst\n");
			
			while(<LIST_FH>) {
				# At first: Figure out what the sourcename is
				my $srcfile  = "$self->{'srcdir'}$self->{'delimit'}sys$self->{'delimit'}src$self->{'delimit'}lcsrc$self->{'delimit'}$_";
				# Then find the target-directory:
				
				my $destfile = "$self->{'dbroot'}$self->{'delimit'}$_";
				chomp $srcfile;
				chomp $destfile;
				print "$srcfile -> $destfile\n";
				checkdir ($destfile);
				copy ($srcfile, $destfile) or throw_err ("Could not copy $srcfile to $destfile:\n$! \n");
				chmod ((stat($srcfile))[2], $destfile);
			}
		}
	}
	
	
	if ($self->to_install("cpc"))
	{
		print "##### C Precompiler ##########################################\n";
		my $pcinsthandle = defined $self->{'pchandle'} ? $self->{'pchandle'} : $self;
		my $pcqadbhandle = undef;
		&instloginit($self);
		$pcinsthandle->{'cpc_param'} = " -b -profile \"C Precompiler\"  $user_group_options";
		
		unless ( $pcinsthandle == $self ) {
			$self->{qah}->write_log("$self->{'hostname'} - Install precompiler ".
			      "<a href=\"Make_Details.jsp?id=$pcinsthandle->{'qah'}->{'ID'}\">".
			      "$pcinsthandle->{'version'}$pcinsthandle->{'status'}<\/a>");
			
			$pcinsthandle->{qah}->write_log("$self->{'hostname'} - Install precompiler in ".
			      "<a href=\"Make_Details.jsp?id=$self->{'qah'}->{'ID'}\">".
			      "$self->{'version'}$self->{'status'}<\/a>");	
			$pcinsthandle->{'sdbinstlogfile'} = $self->{'sdbinstlogfile'};
			$pcqadbhandle = $pcinsthandle->{qah};
			$pcinsthandle->{qah} = $self->{qah};
			$pcinsthandle->{'log_count'} = $self->{'log_count'};
			$pcinsthandle->{'prot_count'} = $self->{'prot_count'};
			# unregister precompiler runtime of kernel version (installed by server installation)
			&doCmd($self, "irconf -r -p $self->{'indeppath'}$self->{'delimit'}runtime$self->{'delimit'}$self->{'version'}");
		}
		
		($rc, $sig, $core, $outbuf) = &doCmd($pcinsthandle, " $pcinsthandle->{'instwrap'} $pcinsthandle->{'sdbinst'} $pcinsthandle->{'cpc_param'} ");
		
		&instlogwrite($pcinsthandle, "LC installation - CPC installation log file");	
		
		if ($rc != 0) {
			send_error($pcinsthandle, 1109, $rc, $sig, $core, "LC installation - CPC installation failed.", $outbuf);
			if ( defined $pcqadbhandle ) {
				$pcinsthandle->{qah} = $pcqadbhandle;
				send_error($pcinsthandle, 1109, $rc, $sig, $core, "LC installation - CPC installation failed.", $outbuf);
				$errcnt++;
			}
		}
	
		unless ( $pcinsthandle == $self ) {
			# set all back to original
			$self->{'log_count'}  = $pcinsthandle->{'log_count'};
			$self->{'prot_count'} = $pcinsthandle->{'prot_count'};
			$self->{'pchandle'}->{'qah'} = $pcqadbhandle;
		}
	}
		
	if ($self->to_install("odbc"))
	{		
		&instloginit($self);
		#####ODBC###############################################################
		# Okay, dann machen wir mal etwas ODBC
		print "##### ODBC #####################################################\n";
		
		# Then install the package we want.
		($rc, $sig, $core, $outbuf) = &doCmd($self, " $self->{'instwrap'} $self->{'sdbinst'} $self->{'odbcinst_param'} ");
		&instlogwrite($self, "LC installation - ODBC installation log file");
		
		if ($rc != 0) {
			send_error($self, 1109, $rc, $sig, $core, "LC installation - ODBC installation failed.", $outbuf);
			$errcnt++;
		}
	}
	
	$self->{'qah'}->execDML("UPDATE chrs SET idmake = $self->{'qah'}->{'ID'}, idchr_stat = 3 WHERE idserver = $self->{'qah'}->{'IDSERVER'} AND chrcnt = '" . $self->{'dir'} . "'");
	
	##### RESTART THE x_server
	($rc, $sig, $core, $outbuf) = &doCmd($self, "x_server $self->{'xserver_param'}");
	if ($rc != 0) {
		$errcnt++;	
	}
	
	if ($errcnt) {
		$self->{'qah'}->write_log("$self->{'hostname'} - ERROR: Installion on $self->{'hostname'} failed ($errcnt error".(($errcnt > 1) ? "s" : "").")");	
		$self->update_idobjstatus(1109); 
	}
	else {
		$self->{'qah'}->write_log("$self->{'hostname'} - SUCCESS: Installion successfully finished");	
		$self->update_idobjstatus(1110); 
	}
}

######################################
# check for components to install
######################################
sub to_install
{
	my $self = shift;
	my $component = shift;
	my $install = 0;
	if ( ($self->{'forced_instcomponents'}->{'all'} || $self->{'forced_instcomponents'}->{$component}) && ! $self->{'forced_instcomponents'}->{"no_$component"})
	{  $install = 1; }
	return $install;
}

##################################################################
#  removeAll:
#  removes a complete installation again.
##################################################################
sub removeAll
{
    my $self = shift;
	print "##### Removing everything ######################################\n";
	print "##### Running preClean() #######################################\n";
    $self->preClean("ALL");
	print "##### Uninstalling Software ####################################\n";
	my ($rc, $sig, $core, $outbuf) = &doCmd($self, "echo y | sdbuninst -all");
	$self->{'qah'}->write_log($rc ? "$self->{'hostname'} - ERROR: Uninstallation of all components on $self->{'hostname'} failed (RC=$rc, SIG=$sig, CORE=$core)!" : "$self->{'hostname'} - SUCCESS: All components on $self->{'hostname'} successfully uninstalled.");
	print "##### Clearing DB path #########################################\n";
	my $wildcard = ($^O =~ /win32/i) ? '*.*' : '*';
	my $del_count = unlink glob("$self->{'rootdir'}/7*/*/$wildcard");
	$self->{'qah'}->write_log($del_count ? "$self->{'hostname'} - CLEAR DB PATH: Successfully deleted $del_count files." : "$self->{'hostname'} - CLEAR DB PATH: WARNING! No files deleted.");
	print "##### Removing indep directories ###############################\n";
	($rc, $sig, $core, $outbuf) = &doCmd($self, "$self->{'rmcmd'} $self->{'indepdata'} $self->{'indeppath'}");
	$self->{'qah'}->write_log($rc ? "$self->{'hostname'} - ERROR: Removing indep directories failed! (RC=$rc, SIG=$sig, CORE=$core)!" : "$self->{'hostname'} - SUCCESS: All indep directories removed.");
}

##################################################################
# installTF:
# installs the Java TestFrame depending on the informations we
# have already figured out.
##################################################################
sub installTF {
	$self = shift;
	$options = shift;
	
	my @packages_to_install    = ();
	my @cpcpackages_to_install = ();
	my $unpack_command      = undef;
	my @mandatorypackages   = ("jr_testframe_dep.sar", "jr_testframe_exe.sar", "jr_testframe_ind.sar","jtinstall.pl");
	my @testpackages_sut    = ("jr_sut.sar");
	my @testpackages_mut    = ("jr_mut.sar");
	my @testpackages_tp2    = ("jr_tp2.sar");
	my @testpackages_cpc    = ("tr_cpct.sar", "tr_cpctu.sar");
	my @testpackages_odbc   = ("tr_odbctest.sar");
	my @testpackages_sqldbc = ("tr_sqldbc.sar");

	$ENV{'PATH'}        = $self->{'path'};
	$ENV{'HOME'}        = $self->{'homedir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
	$ENV{'INSTROOT'}    = $self->{'dbroot'};
	$ENV{'TEST_ROOT'}   = $self->{'testdir'};
	$ENV{'TESTROOT'}    = $self->{'testdir'};
	$ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
	$ENV{'TMP'}         = $self->{'tempdir'};
	$ENV{'TEMP'}        = $self->{'tempdir'};
	$ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
	$ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
	
	$self->update_idobjstatus(1111); 
	
	if (defined ${$options}{'components'}) 	{	
		@packages_to_install = @mandatorypackages;
		push @testcomponents, split ",", ${$options}{'components'}; 
		foreach $component (@testcomponents)
		{
			# check for existing of test components 
			my @packages = eval "\@testpackages_$component";
			if (scalar(@packages) == 0)			{
				send_error ($self, 1119, 1, 0, 0, "TestFrame installation - wrong component name.", "component name '$component' not known");
			}
			else		{
				# special handling for install of another precompiler
				if ( ($component =~ /^cpc$/ ) && (defined $self->{'pchandle'})) {				
					push @cpcpackages_to_install, @packages;
				}				
				else {
					push @packages_to_install, @packages;
				}
			}
		}
	}
	
	$unpack_command = "cd $self->{'tempdir'} && SAPCAR -xvf $self->{'srcdir'}" . $self->{'delimit'} . "test" . $self->{'delimit'} . "jtest" . $self->{'delimit'} . "alltestpkg.sar ";
	$unpack_command .= join " ", @packages_to_install;
	
	my ($rc, $sig, $core, $outbuf) = &doCmd($self, $unpack_command);
	if ($rc != 0) {
		send_error($self, 1119, $rc, $sig, $core, "TestFrame installation - SAPCAR failed.", $outbuf);
	}
	
	# use another precompiler - patch tr_cpct.sar and tr_cpctu.sar from used precomiler
	if ((defined $self->{'pchandle'}) && 
	   (( ! defined ${$options}{'components'}) || ( scalar (@cpcpackages_to_install) > 0 ))) {
	   	# use other precompiler - patch tr_cpct.sar and tr_cpctu.sar from used precomiler
		($rc, $sig, $core, $outbuf) = &doCmd($self, "cd $self->{'tempdir'} && SAPCAR -xvf $self->{'pchandle'}->{'srcdir'}" . 
		                              $self->{'delimit'} . "test" . $self->{'delimit'} . "jtest" . $self->{'delimit'} . "alltestpkg.sar ".
		                              join " ", @testpackages_cpc);
		if ($rc != 0) {
			send_error($self, 1119, $rc, $sig, $core, "PCTest installation for testframe - SAPCAR failed.", $outbuf);
		}		                              
	}
		
	($rc, $sig, $core, $outbuf) = &doCmd($self, "cd $self->{'tempdir'} && perl jtinstall.pl -n -jr $self->{'jtest_root'} -ir $self->{'dbroot'}");
	
	if ($rc != 0) {
		send_error($self, 1119, $rc, $sig, $core, "TestFrame installation - jtinstall failed.", $outbuf);
	} else {
		$self->get_jtrun_version();
		$self->update_idobjstatus(1120); 
	}
	if (!($^O =~ /MSWin32/i)) {
		&doCmd($self, "cd $self->{'testdir'} && chmod -R ug+w *");
		&doCmd($self, "cd $self->{'testdir'} && chown -R remuser:lcadm *");
	}
}

##################################################################
# runTF:
# run the Java TestFrame.
##################################################################
sub runTF {
	$self = shift;
	my %tests = ();
	$ENV{'PATH'}        = $self->{'path'};
	$ENV{'HOME'}        = $self->{'homedir'}; # For the PC-Tests.
	$ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
	$ENV{'INSTROOT'}    = $self->{'dbroot'};
	$ENV{'TEST_ROOT'}   = $self->{'testdir'};
	$ENV{'TESTROOT'}    = $self->{'testdir'};
	$ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
	$ENV{'TMP'}         = $self->{'tempdir'};
	$ENV{'TEMP'}        = $self->{'tempdir'};
	$ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
	$ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
	
	if (($self->{'hostname'} =~ /P(WDF|\d\d\d)/i) && ($^O =~ /MSWin32/i)  && ($self->{'version'} == 7402)) {
		&doCmd($self, "irconf -i -p $self->{'testdrive'}\\sapdb\\programs\\runtime\\7402");
	}
	
	&doCmd($self, "irconf -a");
	&doCmd($self, "irconf -s");
	my $testlist;
	
	if ($self->{'profile'} eq "weekend") {
		$testlist = $self->{'qah'}->{weekendtests};
	}
	else {
		$testlist = $self->{'qah'}->{worktests};
	}
	
	foreach my $x (@$testlist) {
		$tests{$x} = $self->{'qah'}->{'testnames'}->{$x};
	}
	
	$myNameAppend = substr($self->{'version'}, 0, 2) . substr($self->{'version'}, 3, 1) . substr($self->{'status'}, 0, 1);
	
	while (($key, $value) = each(%tests)) {
		$tests{$key} = $value . $myNameAppend;
	}
	
	my @testq = keys(%tests);
	
	
	my $qmsg = "The following tests will be performed:<BR><OL>";
	foreach $x (@$testlist) {
		$qmsg .= "<LI>$x ($tests{$x})</LI>";
	}
	$qmsg .= "</OL>";
	
	$self->{'qah'}->write_log("$self->{'hostname'} - $qmsg");
	$self->update_idobjstatus(2000);  ## START OF TESTING
	&doCmd($self, "dbmcli dbm_version");
	foreach $x (@$testlist) {
		$cmd = ("cd $self->{'jtest_root'} && perl jtrun.pl -R $self->{'dbroot'} -bits $self->{'bits'} -scheduled -monitor -MAKEKEY $self->{'qah'}->{'ID'}  -QA $self->{'status'} -LCP $self->{'qah'}->{'LCPOOLID'} -sr -CL $self->{'qah'}->{'CHANGELIST'} -d $tests{$x} $x \n");
		&doCmd($self, $cmd);
	}
	
	$self->update_idobjstatus(3000);  ## END OF TESTING
	$self->{'qah'}->write_log("$self->{'hostname'} - All Tests are done.");
	return $self->{qah}->check_lcok();
}

#
# This Method is for performing only a single test-sequence (mostly for debug-purposes)
sub run_single_test {
    $self = shift;
    $testname = shift;
    
    $ENV{'PATH'}         = $self->{'path'};
    $ENV{'HOME'}         = $self->{'homedir'}; # For the PC-Tests.
    $ENV{'JTEST_ROOT'}   = $self->{'jtest_root'};
    $ENV{'INSTROOT'}     = $self->{'dbroot'};
    $ENV{'TEST_ROOT'}    = $self->{'testdir'};
    $ENV{'TESTROOT'}     = $self->{'testdir'};
    $ENV{'SAPDBSDK'}	 = $self->{'sapdbsdk'};
    $ENV{'TMP'}          = $self->{'tempdir'};
    $ENV{'TEMP'}         = $self->{'tempdir'};
    $ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
    $ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
    
    my %tests            = ();

    $tests{"$testname"} = $self->{'qah'}->{'testnames'}->{$testname};
    &doCmd($self, "irconf -a");
    &doCmd($self, "irconf -s");
 

    $myNameAppend = substr($self->{'version'}, 0, 2) . substr($self->{'version'}, 3, 1) . substr($self->{'status'}, 0, 1);
    while (($key, $value) = each(%tests)) {
         $tests{$key} = $value . $myNameAppend;
    }

    my @testq = keys(%tests);

    if ($options{'verbose'}) {
        print "The following tests will be performed:\n\n";
        foreach $x (@testq) {
            print "$x\t (Testname = ${tests{$x}})\n";
        }
    }

    foreach $x (@testq) {
        $cmd = ("cd $self->{'jtest_root'} && perl jtrun.pl -R $self->{'dbroot'} -bits $self->{'bits'} -scheduled -monitor -QA $self->{'status'} -MAKEKEY $self->{'qah'}->{'ID'} -LCP $self->{'qah'}->{'LCPOOLID'} -sr -CL $self->{qah}->{'CHANGELIST'} -d $tests{$x} $x \n");
	&doCmd($self, $cmd);
    }
    return ;
}


#
sub set_qa_relevance
{
	$self = shift;
	my $relevance = shift;
	if ( $relevance ) {
		if ($relevance =~ /both|all/)
		{ $self->{'relevance'} = "all"; } # { $self->{'relevance'} = "kernel,pc"; }
		else
		{ $self->{'relevance'} = $relevance; }
	}
	elsif ( ! defined $self->{'pchandle'}) {
		$self->{'relevance'} = "kernel";
	}
	elsif  ( $self->{'pchandle'}->{'status'} =~ /DEV/i)	{
		if ( $self->{'status'} =~ /DEV/i ) {
			$self->{'relevance'} = "kernel";
		}
		else {
			$self->{'relevance'} = "pc";
		}
	}
	elsif  ( $self->{'pchandle'}->{'status'} =~ /COR/i)	{
		if ( $self->{'status'} =~ /DEV/i ) {
			$self->{'relevance'} = "kernel";
		}
		else {
			$self->{'relevance'} = "pc";
		}
	}
	elsif  ( $self->{'pchandle'}->{'status'} =~ /RAMP/i)	{
		if ( $self->{'status'} =~ /RAMP/i ) {
			$self->{'relevance'} = "all";
		}
		else {
			$self->{'relevance'} = "kernel";
		}
	}			
	return;
}

#
# This Method is for performing only a  pctest sequence 
sub already_cpc_tested
{
   my $self = shift;
   my $condition = "TESTNAME = 'interfaces.Precompiler' AND ";
   my $count = 0;
   my $pchandle = $self->{'pchandle'};
   if ($self->{'relevance'} =~ /all/) { 
   		$condition = "MAKEKEY = $self->{'qah'}->{'ID'} AND MAKEKEY2 = $pchandle->{'qah'}->{'ID'}";
   }
   elsif ($self->{'relevance'} =~ /kernel/)  {
   		$condition = "MAKEKEY = $self->{'qah'}->{'ID'} AND substr(DBNAME, 3,length(DBNAME)) = '".
   		substr($pchandle->{'version'}, 0, 2).substr($pchandle->{'version'}, 3, 1).
   		substr($pchandle->{'status'}, 0, 1)."'";
   }
   elsif ($self->{'relevance'} =~ /pc/)  {
   		$condition = "MAKEKEY2 = $self->{'pchandle'}->{'qah'}->{'ID'} AND DBVERSION = '". 
   		substr($self->{'version'}, 0, 1).".".substr($self->{'version'}, 1, 1).".".
   		substr($self->{'version'}, 2, 2).".".$self->{'build'}."' AND QALEVEL = '".
   		substr($self->{'status'}, 0, 1)."'";
   }
   if ($condition)
   {
   		$count = $self->{'qah'}->select_count("JAVATESTINFO", $condition);
   } 
   return $count;
}

#
# This Method is for performing only a  pctest sequence 
sub run_cpc_test {
    $self = shift;
    $testnames = shift;
    
    $ENV{'PATH'}         = $self->{'path'};
    $ENV{'HOME'}         = $self->{'homedir'}; # For the PC-Tests.
    $ENV{'JTEST_ROOT'}   = $self->{'jtest_root'};
    $ENV{'INSTROOT'}     = $self->{'dbroot'};
    $ENV{'TEST_ROOT'}    = $self->{'testdir'};
    $ENV{'TESTROOT'}     = $self->{'testdir'};
    $ENV{'SAPDBSDK'}	 = $self->{'sapdbsdk'};
    $ENV{'TMP'}          = $self->{'tempdir'};
    $ENV{'TEMP'}         = $self->{'tempdir'};
    $ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
    $ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);
    
    my %tests            = ();
    my $dbnamehandle = (defined $self->{'pchandle'}) ? $self->{'pchandle'} : $self;
    my $makeid_option_string = "-MAKEKEY "; 
    my $makeid_to_patch = 0;
    
    if ( $self->{'relevance'} !~ /all|both|pc/)
    {
    	$makeid_option_string .= $self->{'qah'}->{'ID'};
    }
    else
    {   	
		# jtrun < 4.0 patch of makeids necessary
	    if  ( $self->get_jtrun_version() < 40 )
	    {
	    	$makeid_to_patch = ($self->{'relevance'} =~ /all/) ? 42 : ($self->{'relevance'} =~ /pc/) ?  24 : 17; 		 	
	    	$makeid_option_string .= $makeid_to_patch;
	    }
	    else
	    {
	    	$makeid_option_string .= ($self->{'relevance'} =~ /all/) ? $self->{'qah'}->{'ID'} : 0;
	    	$makeid_option_string .= " -MAKEKEY2 ". $self->{'pchandle'}->{'qah'}->{'ID'};
	    }
	}
 
    $dbname = substr($dbnamehandle->{'version'}, 0, 2).
              substr($dbnamehandle->{'version'}, 3, 1).
              substr($dbnamehandle->{'status'}, 0, 1);
    
    # anytime this test will get cpc tests from qadb 
    # $tests{"$testname"} = $self->{'qah'}->{'testnames'}->{$testname};
    if ($self->{'verbose'}) 
    {
    	print ("Start cpc test of $self->{'version'}$self->{'status'}($self->{'qah'}->{'ID'}) database with ".
    	  ((defined $self->{'pchandle'}) ? "$self->{'pchandle'}->{'version'}$self->{'pchandle'}->{'status'}($self->{'pchandle'}->{'qah'}->{'ID'})" : "the same").
    	  " Precompiler\n");
    }
        
    &doCmd($self, "irconf -a");
    &doCmd($self, "irconf -s");
    
    # ascii test
    if ($self->{'dbtypes'}->{'all'} || $self->{'dbtypes'}->{'ascii'})
    {
		$cmd = ("cd $self->{'jtest_root'} && perl jtrun.pl -R $self->{'dbroot'} ".
		        "-bits $self->{'bits'} -scheduled -monitor -QA $self->{'status'} ".
		        "$makeid_option_string -LCP $self->{'qah'}->{'LCPOOLID'} ".
		        "-mail burkhard.diesing ".
		        "-sr -CL $self->{qah}->{'CHANGELIST'} -d PA$dbname ". 
		        "-c oltptest.cfg -pf Precompiler.par com.sap.sapdb.oltptest.interfaces.Precompiler");
		        &doCmd($self, $cmd);
	
    }
    if ($makeid_to_patch)
    {
    	$self->patch_makeids ($makeid_to_patch, 
    	               ($self->{'relevance'} =~ /all/) ? $self->{'qah'}->{'ID'} : 0, 
    	               $self->{'pchandle'}->{'qah'}->{'ID'});
    }
    
    # unicode test with unicode database in default mode ascii
    if ($self->{'dbtypes'}->{'all'} || $self->{'dbtypes'}->{'unicode'} || $self->{'dbtypes'}->{'unicode_ascii'} )
    {
    	$cmd = ("cd $self->{'jtest_root'} && perl jtrun.pl -R $self->{'dbroot'} ".
		        "-bits $self->{'bits'} -scheduled -monitor -QA $self->{'status'} ".
		        "$makeid_option_string -LCP $self->{'qah'}->{'LCPOOLID'} ".
		        "-mail burkhard.diesing ".		        
		        "-sr -CL $self->{qah}->{'CHANGELIST'} -d PU$dbname ". 
		        "-c oltptest_unicode.cfg -pf PrecompilerUni.par com.sap.sapdb.oltptest.interfaces.Precompiler");
		&doCmd($self, $cmd);			        
    }
   
   	if ($makeid_to_patch)
    {
    	$self->patch_makeids ($makeid_to_patch, 
    	               ($self->{'relevance'} =~ /all/) ? $self->{'qah'}->{'ID'} : 0, 
    	               $self->{'pchandle'}->{'qah'}->{'ID'});
    }
   	
    # unicode test with unicode database in default mode unicode
#	    if ($self->{'dbtypes'}->{'all'} || $self->{'dbtypes'}->{'unicode'} || $self->{'dbtypes'}->{'unicode_unicode'} )
#	    { 	
#	    	$cmd = ("cd $self->{'jtest_root'} && perl jtrun.pl -R $self->{'dbroot'} ".
#			        "-bits $self->{'bits'} -scheduled -monitor -QA $self->{'status'} ".
#			        "$makeid_option_string -LCP $self->{'qah'}->{'LCPOOLID'} ".
# 			        "-mail burkhard.diesing ".
#			        "-sr -CL $self->{qah}->{'CHANGELIST'} -d UU$dbname ". 
#			        "-c oltptest_unicode.cfg -pf PrecompilerUni.par com.sap.sapdb.oltptest.interfaces.Precompiler");
#			        &doCmd($self, $cmd);
#	    }
	
	if ($makeid_to_patch)
    {
    	$self->patch_makeids ($makeid_to_patch, 
    	               ($self->{'relevance'} =~ /all/) ? $self->{'qah'}->{'ID'} : 0, 
    	               $self->{'pchandle'}->{'qah'}->{'ID'});
    }
   
    return ;
}

sub run_lowtrack {
    # For letting the SUT run parallel
    $self = shift;
    $ENV{'PATH'}        = $self->{'path'};
    $ENV{'HOME'}        = $self->{'homedir'}; # For the PC-Tests.
    $ENV{'JTEST_ROOT'}  = $self->{'jtest_root'};
    $ENV{'INSTROOT'}    = $self->{'dbroot'};
    $ENV{'TEST_ROOT'}   = $self->{'testdir'};
    $ENV{'TESTROOT'}    = $self->{'testdir'};
    $ENV{'SAPDBSDK'}    = $self->{'sapdbsdk'};
    $ENV{'TMP'}         = $self->{'tempdir'};
    $ENV{'TEMP'}        = $self->{'tempdir'};
    $ENV{'CORRECTION_LEVEL'} = substr($self->{'version'}, 2, 2);
    $ENV{'RELVER'}           = "R" . substr($self->{'version'}, 0, 2);

    my %tests = ();

    my $testlist;
    if ($self->{'profile'} eq "weekend") {
        $testlist = $self->{'qah'}->{'lowtests_we'};
    }
    else {
        $testlist = $self->{'qah'}->{'lowtests'};
    }

    foreach my $x (@$testlist) {
        $tests{$x} = $self->{'qah'}->{'testnames'}->{$x};
    }


    $myNameAppend = substr($self->{'version'}, 0, 2) . substr($self->{'version'}, 3, 1) . substr($self->{'status'}, 0, 1);

    while (($key, $value) = each(%tests)) {
        $tests{$key} = $value . $myNameAppend;
    }

    my @testq = my @testq = keys(%tests);;
    #foreach $x (sort(keys(%tests))) {
    #   $tmp =  substr($x, 1, 1000);
    #   push(@testq, $tmp);
    #   $tests{$tmp} = $tests{$x};
    #}


    if ($options{'verbose'}) {
        print "The following tests will be performed:\n\n";
        foreach $x (@testq) {
            print "$x\t (Testname = ${tests{$x}})\n";
        }
    }
    
    # Paralell running tests should run in reverted sequences for avoiding
    # lock-problems with conflicting tests (this is mainly done for the
    # oltptest-sequence)
    
    foreach $x (@testq) {
        $cmd = ("cd $self->{'jtest_root'} && perl jtrun.pl -R $self->{'dbroot'} -bits $self->{'bits'} -scheduled -monitor -QA $self->{'status'} -MAKEKEY $self->{'qah'}->{'ID'} -LCP $self->{'qah'}->{'LCPOOLID'} -sr -CL $self->{qah}->{'CHANGELIST'} -d $tests{$x} $x \n");
	&doCmd($self, $cmd);
    }
 
 
    return;
}

#
# Helpers
#

sub doCmd {
	my $self    = shift;
	$kommando = pop(@_);
	my $rc      = 0;
	my $sig     = 0;
	my $core    = 0;
	my $outbuf = "$self->{'hostname'} - CMD: \r\n $kommando \r\n";
	
	if ($options{'verbose'}) {
		print ($kommando . "\n");
	}

	if (!($self->{'dry'})) {		
		$outbuf .= `$kommando 2>&1`;
				
		$rc = ($? >> 8);    # Evaluate return code by dividing by 256
		$signum = ($? & 127);   # get the signal caused the program to abort
		$core = ($? & 128); # get any core errors, if exist
		
		if (length($outbuf) < 1000) {
			$self->{qah}->write_log($outbuf);
		}
		else {
			if (length($kommando) > 299) {
				$kommando = substr($kommando, 0, 290) . "...";
			}
			
			$self->{qah}->write_prot("p" . $self->{'prot_count'} . $$, $outbuf, "$self->{'hostname'} - $kommando");
			$self->{'prot_count'}++;
		}
		if ($self->{qah}->{error_code} != 0) {
			print "Error in output-handling of $kommando \nI will ignore it.\nOutput:\n$outbuf";
			$self->{qah}->{error_code} = 0;
		}
	}
	return wantarray ? ($rc, $sig, $core, $outbuf) : $rc;
}

##################################################################
# get_free_FH
#
# A 'bit dirty version' to get a unique filename for output.
##################################################################
sub get_free_FH
{
	my $count = 1;
	my $outstr = $count . ".out";
	
	while (-e $outstr) {
		$count ++;
		$outstr = $count . ".out";
	}
	return $outstr;
}

#############################
# update_idobjstatus
#############################
sub update_idobjstatus {
	my $self = shift;
	my $IDOBJSTATUS = shift;
	
	unless ($self->{'no_objstat'}) {
		if ($self->{'qah'}->{'SESSION_ID'}) {
			$self->{'qah'}->execDML("UPDATE install_sessions SET IDOBJSTATUS = $IDOBJSTATUS WHERE ID = " . $self->{'qah'}->{'SESSION_ID'});
		} else {
			$self->{'qah'}->update_columns({'IDOBJSTATUS' => $IDOBJSTATUS});
		}
	}
}

##################################################################
# send_error
#
# Reports an error via email and updates the status in qadb
##################################################################
sub send_error
{
	my $self = shift;
	my ($errcode, $rc, $sig, $core, $errstr, $outstr) = @_;
	
	my $smtp = Net::SMTP->new("mail.sap-ag.de");
	
	if (!(defined($smtp))) {
		print "Error in sending mail\n";
		return;
	}
	
	$smtp->mail("remuser\@$self->{'hostname'}.wdf.sap-ag.de");
	$smtp->to("falko.flessner\@sap.com", "ulrich.jansen\@sap.com");
	$smtp->data();
	#$smtp->datasend("To: falko.flessner\@sap.com; ulrich.jansen\@sap.com\n");
	$smtp->datasend("Subject: $self->{'hostname'} / TESTDB Error - $errstr ($errcode)\n");
	#$smtp->datasend("Priority: Urgent\nX-Priority: 1 (Highest)\n");
	$smtp->datasend("\n");
	$smtp->datasend("Platform      : $self->{'hostname'}\n");
	$smtp->datasend("Time          : " . (scalar localtime) . "\n\n");
	$smtp->datasend("Error Code    : $errcode\n\n");
	$smtp->datasend("Error Text    : $errstr\n\n");
	$smtp->datasend("Return Code   : $rc\n");
	$smtp->datasend("Signal cought : $sig (1=Yes, 0=No)\n");
	$smtp->datasend("Core error    : $core (1=Yes, 0=No)\n");
	$smtp->datasend("HTML Link     : http://pts.wdf.sap.corp:1081/TestMonitor/Make_Details.jsp?id=$self->{qah}->{ID}\n\n");
	$smtp->datasend("Original program output:\n\n");
	$smtp->datasend("$outstr\n");
	$smtp->dataend();
	$smtp->quit();
	
	$self->update_idobjstatus("$errcode");
	$self->{qah}->write_log("$self->{'hostname'} - $errstr RC=$rc SIG=$sig CORE=$core");
}

sub throw_err {
	my $errortext = shift;
	#my $smtp = Net::SMTP->new("mail.sap-ag.de");
	#$smtp->mail("remuser\@is0025.wdf.sap-ag.de");
	#$smtp->to("falko.flessner\@sap.com");
	#$smtp->data();
	#$smtp->datasend("To: falko.flessner\@sap.com\n");
	#$smtp->datasend("Subject: Error during qadb-run \n");
	#$smtp->datasend("Priority: Urgent\nX-Priority: 1 (Highest)\n");
	#$smtp->datasend("\n");
	#$smtp->datasend($errortext);
	#$smtp->dataend();
	#$smtp->quit;
	print $errortext;
	return $errortext;
}


sub checkdir
{
	local $path = shift;
	# convert \ to /
	$path =~ s/\\/\//g;
	if ($path =~ /^(.*)\/[^\/]*$/)
	{
		unless ( -d "$1" )
		{
			mkpath("$1", 0775) || throw_err "can't mkdir $path : $!";
		}
	}
}

sub instloginit {
	$self = shift;
	$self->{'sdbinstlogfile'} = $self->{'tempdir'} . $self->{'delimit'} . "l" . $self->{'log_count'} . $$; 
	checkdir ($self->{'sdbinstlogfile'});
	$ENV{'SDBINSTLOGFILE'} = $self->{'sdbinstlogfile'};
}

sub instlogwrite {
	$self = shift;
	$infotext = shift;
	my $sdbinstlog = " \n";
	if (-e $self->{'sdbinstlogfile'}) {
		open (LFH, $self->{'sdbinstlogfile'});
		while (<LFH>) {
			$sdbinstlog .= $_;
		}
		close LFH;
		
		$self->{'qah'}->write_prot("l" . $self->{'log_count'} . $$, $sdbinstlog, "$self->{'hostname'} - $infotext");
		if ($self->{qah}->{error_code} != 0) {
			print "Error in handling of $self->{'sdbinstlogfile'} \nI will ignore it.\nOutput:\n$sdbinstlog";
			$self->{qah}->{error_code} = 0;
		}
	}
	$self->{'log_count'}++;
}


################################################
# patch makeid for precompilertests            #
# paramater:                                   #
# 1. makeid to patch    (mandatory)            #
# 2. new make id        (optional)             #
# 2. new second make id (optional)             #
################################################
sub patch_makeids
{
	my ($self, $makeid_to_patch, $makeid1, $makeid2) = @_;	
	my $sqlstmt = "UPDATE JAVATESTINFO SET MAKEKEY = $makeid1";
	$sqlstmt .= ", MAKEKEY2 = $makeid2" if ($makeid2);
	$sqlstmt .= " WHERE MAKEKEY = $makeid_to_patch";
	print "Execute '$sqlstmt'\n";
	$self->{'qah'}->execDML($sqlstmt);
}


################################################################################
# read version of jtrun from jtrun.pl and set it to $self->{'jtrun_version'}
# necessary for feature check (for instance -makekey2)
# return:
#  if ok
#    version as number (40 = version 4.0)
#  else
#    undef
################################################################################
sub get_jtrun_version
{
	$self = shift;
	unless ( $self->{'jtrun_version'} )
	{
		$self->{'jtrun_version'} = undef;
		if (-f "$self->{'jtest_root'}/jtrun.pl")
		{
			open (JTR, "$self->{'jtest_root'}/jtrun.pl");
			while (<JTR>) {
				if (/^\s*\$version\s*=\s*\"(\d+).(\d)\"/)
				{
					$self->{'jtrun_version'} = $1.$2 + 0;	
					last;
				}
			}
			close JTR;
		}
	}
	return ($self->{'jtrun_version'});	
}

__END__

=head1 NAME

testdb - A perl module for testing SAP DB/liveCache-builds on preconfigured
testmachines.

=head1 NOTE

This module is intended for internal use only.
Although it is free software, it won't be very usefull for the wide world

=head1 CONSTRUCTOR

 use testdb;
 $tdh =  testdb->new({'version' => '7404', 'status' => 'DEV', 'profile' => 'weekend'}) ;

 if ($tdh->{error_code}) {
    print "Error:\n$tdh->{error_text}\n";
    return -1;
 }

=head1 DESCRIPTION

The C<testdb> class is a abstraction of the Tests in the SAP-internal QA-System
for SAP DB and liveCache.

With C<testdb>, you can clean up the system, install the latest makes, install all
compononts required for testing execute the tests.

=over 4

=item Prepare for the

A couple of informations are required to create a new entry. Following
the perl standards, the constructor of the class is named C<new>. It
requires a hash-reference with the following entries:

  Name          Description                   Example value

 version       4-digit Version              '7402'
 status        The quality-status           'DEV'
 profile       The test-profile             'workday' or 'weekend'

For AIX-Machines, the aditional "PLATFORM"-entry is required. This is
necssary becase the perl-interpreter does not make a difference between
AIX 4.x and AIX 5.x as we do it.

Currently, the followning values are accepted for PLATFORM:

    - sun_64
    - alphaosf
        - rs6000_51_64
    - rs6000_64
    - hp_64

Please keep in mind that a C<qadb>-instance normaly contains a variable
called C<ID> (you can access it with B<$qah-E<gt>{'ID'}>. This C<ID> identifies
a make-entry and will be needed later. So, I suggest to write this C<ID>
to the harddisk.

=back

=head1 METHODS

C<qadb> provides the following methods:

=over 4

=item $rv = update_columns({name1 => value1, ... , nameN => valueN});

Performs a update-statement on the main table. This should only be used
for updating IDOBJSTATUS, LCPOOLID, LC_OK and LCOK_TRANS.

It takes a hash-reference as arguement, filled with columnnames and the
corresponing values.

The "VARIABLES"-Section of this manual contains a complete description of all
fields.

Returns 0 on success.

=item $rv = write_log($log_text);

This adds a comment to the entry. The log-Text must not contain more than
1000 characters.

Returns 0 on success.

=item $rv = write_prot($prot_name, $prot  [, $info_text]);

Writes a protocoll to the WebDAV-server and creates a entry in the
appropriate table in the database.

It takes a protocolname, the protocol itself and a optional info text as
arguments.

If the info text is not provieded, the protocolname will be used for it.

Returns 0 on success.

=item $rv = unlock();

Releases the current DB-Connection, but don't forget about the Values.

This becomes necessary when the program forkes. See B<lock> for
further informations

Returns 0 on success.

=item $qah = lock();

Re-Creates the DB-Connection. This becomes necessary after performing
an B<unlock> in forking situations.

B<TAKE CARE:> this method will return a new instance. Overwrite the current one
with it. The following example will give you an idea how to do this:

   $qah->unlock();
   $pid = fork();
   $qah = $qah->lock();

   if ($pid) {
       #
       # go on here


=back

=head1 VARIABLES

C<qadb> contains the following variables. Variables corresponding with
fields in the database are marked with a X.

Please note that B<IDQASTATUS> and B<IDPLATFORM> differ from the
parameters B<QASTATUS> and B<PLATFORM> for the C<new>-constructor. The values stored in the
database are simple numeric representations of their alphanumeric
assignments. These assignments are stored in the tables B<PLATFORMS>
and B<QASTATUS>.

  Name         DB-Variable       Description

 ID                X            Identifies the complete build-process
 LCPOOLID          X            The number in the LC_POOL-directory
 VERSION           X            A four-digit version, eg. "7402"
 BUILDPFX          X            A two-digit buildprefix, eg. "05"
 IDPLATFORM        X            The numeric id of the platform
 IDQASTATUS        X            The numeric id if the QA-status
 IDOBJSTATUS       X            The numeric id of the make-status
 CHANGELIST        X            The Changelist-number
 TS                X            The timestamp of the last modification
 LCOK              X            Will be set when the tests are finished
                                successfully.
 LCOK_TRANS        X            Will be set after the LCOK-bit is
                                transfered into the appropriate structures
                in the filesystem.
 HISTCOUNT         X            Counts the number of changes in on these
                                informations. Will be updated automaticaly.
 error_code                     Conains the last error code set. After
                                successfull opterations it will be set to
                0.
 error_text                     Contains a human-readable description of
                                the last error.

=head1 ERROR HANDLING

Beneath the already introduced variables B<error_code> and B<error_text>
for error handling, a email will be sent in each case of a detected error.

The recipients of these Mails are currently hard-coded.

=head1 DBI INSTANCE

C<qadb> contains a ready-to-use DBI instance. It can be accessed by
B<$qah-E<gt>{dbh}>. Please use this with extreme care and use it
only if you can not avoid it.

The DBI documentation describes it in depth.

=head1 EXAMPLE

 use qadb;
 my $qah =  qadb->new({'VERSION' => '7403',
    'BUILDPFX'   => '07',
    'QASTATUS'   => 'DEV',
    'CHANGELIST' => '12345'}) ;

 if ($qah->{error_code} != 0) {
    print "Fehler:\n$qah->{error_text}\n";
    return -1;
 }

 if ($qah->update_columns({'LCPOOLID' => '012'}) != 0 ) {
     print "Error while update:\n$qah->{error_text}\n";
     return -1;
 }

 if ($qah->write_log("Hallo Welt, dies ist ein Test")) {
     print "Error while writing a log:\n$qah->{error_text}\n";
     return -1;
 }

 my $protocol = "";
 open (PROTOFILE, "/path/to/protocol") or die "Error reading protocol\n";

 while (<PROTOFILE>) {
     $protocol .= $_;
 }

 if ($qah->write_prot("make.log", $protocol, "This protocol contains the make-output.\n")) {
     print "Error while writing protocol make.log:\n$qah->{error_text}\n";
 }

=head1 COPYRIGHT

Copyright 2002 SAP AG

=cut


