# This is the database structure for the Media Mate web application.
# It is designed for use with MySQL.

CREATE TABLE global_history (
  entry_id mediumint(10) NOT NULL auto_increment,
  media_id varchar(5) NOT NULL default '',
  media_type varchar(20) NOT NULL default '',
  borrower_uid varchar(5) NOT NULL default '',
  date_borrowed varchar(25) NOT NULL default '',
  date_returned varchar(25) NOT NULL default '',
  KEY index_number (entry_id)
) TYPE=ISAM PACK_KEYS=1;

CREATE TABLE global_prefs (
  id mediumint(3) NOT NULL auto_increment,
  name varchar(15) NOT NULL default '',
  value varchar(50) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM COMMENT='Global Preferences';

INSERT INTO global_prefs VALUES (1, 'theme', 'Translucent_Blue');
INSERT INTO global_prefs VALUES (4, 'online', 'on');
INSERT INTO global_prefs VALUES (5, 'mta', '');
INSERT INTO global_prefs VALUES (6, 'j_server', '');
INSERT INTO global_prefs VALUES (7, 'j_port', '5222');
INSERT INTO global_prefs VALUES (8, 'j_username', '');
INSERT INTO global_prefs VALUES (9, 'j_password', '');
INSERT INTO global_prefs VALUES (11, 'lang', 'en');
INSERT INTO global_prefs VALUES (12, 'theme_credits', 'on');
INSERT INTO global_prefs VALUES (13, 'notify_new', '');

CREATE TABLE global_users (
  user_id mediumint(5) NOT NULL auto_increment,
  admin_level char(2) NOT NULL default '0',
  user_name varchar(15) NOT NULL default '',
  user_password varchar(50) NOT NULL default '',
  real_name varchar(40) NOT NULL default '',
  address_1 varchar(40) NOT NULL default '',
  address_2 varchar(40) NOT NULL default '',
  email_address varchar(100) NOT NULL default '',
  user_phone varchar(20) NOT NULL default '',
  jabber_id varchar(100) NOT NULL default '',
  PRIMARY KEY  (user_id)
) TYPE=MyISAM COMMENT='All Media Mate users have their details stored here.';

INSERT INTO global_users VALUES (1, '3', 'super', '4tuKHcjxpFYag', 'Mr Super User', '', '', '', '', '');

CREATE TABLE movies_list (
  movie_id int(11) NOT NULL auto_increment,
  movie_title varchar(70) NOT NULL default '',
  movie_director varchar(100) NOT NULL default '',
  year_released year(4) NOT NULL default '0000',
  movie_genre varchar(60) NOT NULL default '',
  running_time char(3) NOT NULL default '',
  starring_actors varchar(100) NOT NULL default '',
  movie_synopsis longtext NOT NULL,
  borrower_uid char(3) NOT NULL default '',
  date_due_back varchar(20) NOT NULL default '',
  movie_format varchar(20) NOT NULL default '',
  movie_region varchar(5) NOT NULL default '',
  reserved_uid char(3) NOT NULL default '',
  imdb_url varchar(150) NOT NULL default '',
  UNIQUE KEY index_number (movie_id)
) TYPE=ISAM PACK_KEYS=1;

INSERT INTO movies_list VALUES (1, 'Sample Movie', 'Tony Collins', '2003', 'Comedy', '000', 'Tony Collins', 'The Media Mate development team struggle to get people to use this software, resulting in many hilarious adventures.<br><br>You should delete this movie and enter some real ones.  Log in as the "super" user and use the trash can above to delete.  When adding new movies, all html is allowed.  Actually, it\'s required for things like line breaks - &lt;br&gt;.  Only super users will be adding movies, so there\'s no chance of anyone entering damaging code.', '', '', 'DVD', 'Four', '', '');

CREATE TABLE movies_prefs (
  id mediumint(3) NOT NULL auto_increment,
  name varchar(15) NOT NULL default '',
  value varchar(50) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM COMMENT='Preferences';

INSERT INTO movies_prefs VALUES (1, 'overdue', '14');
