/* md5.h: MD5 hashing taken from public domain source
   This has nothing to do with cryptography.
   Copyright (C) 1998 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _MD5_HASHING_H
#define _MD5_HASHING_H

typedef struct {
    unsigned int buf[4];
    unsigned int bits[2];
    int endianness;
    unsigned char in[64];
} Md5;

void md5_init (Md5 * m);
void md5_update (Md5 * m, unsigned char *buf, unsigned int len);
unsigned char *md5_digest (Md5 * m);
void md5_copy (Md5 * src, Md5 * dest);

/* convinience function */
char *md5_hash (const char *in, int len);

#endif				/* ! _MD5_HASHING_H */


