/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "udm_common.h"
#include "udm_utils.h"
#include "udm_env.h"
#include "udm_parser.h"
#include "udm_robots.h"
#include "udm_host.h"
#include "udm_hrefs.h"
#include "udm_server.h"
#include "udm_url.h"
#include "udm_proto.h"
#include "udm_alias.h"
#include "udm_log.h"
#include "udm_match.h"
#include "udm_stopwords.h"
#include "udm_guesser.h"
#include "udm_vars.h"
#include "udm_synonym.h"
#include "udm_doc.h"
#include "udm_result.h"
#include "udm_spell.h"
#include "udm_db.h"
#include "udm_db_int.h"
#include "udm_chinese.h"
#include "udm_mutex.h"

/**************************** DBAddr ***********************************/

__C_LINK UDM_ENV * __UDMCALL UdmEnvInit(UDM_ENV *Conf){
#ifdef MECAB
        char   *mecab_argv[] = { "mecab", "-F%m\" \"", "-E\" \"", "-B\" \"", NULL };
#endif

	if(!Conf){
		Conf=(UDM_ENV *)UdmMalloc(sizeof(UDM_ENV));
		bzero((void*)Conf, sizeof(*Conf));
		Conf->freeme=1;
	}else{
		bzero((void*)Conf, sizeof(*Conf));
	}
	
	Conf->WordParam.min_word_len=1;
	Conf->WordParam.max_word_len=32;
	Conf->url_number=0x7FFFFFFF;
	Conf->lcs=UdmGetCharSet("latin1");
	Conf->bcs=UdmGetCharSet("latin1");
#ifdef MECAB
	Conf->mecab = mecab_new (4, mecab_argv);
#endif
	
	return(Conf);
}
__C_LINK void __UDMCALL UdmEnvFree(UDM_ENV * Env){
#ifdef MECAB
        mecab_destroy (Env->mecab);
#endif
	UdmDBListFree(&Env->dbl);
	UdmRobotListFree(&Env->Robots);
	UdmResultFree(&Env->Targets);
	UdmParserListFree(&Env->Parsers);
	UdmStopListFree(&Env->StopWords);
	UdmHostListFree(&Env->Hosts);
	
	UdmMatchListFree(&Env->MimeTypes);
	UdmMatchListFree(&Env->Aliases);
	UdmMatchListFree(&Env->ReverseAliases);
	UdmMatchListFree(&Env->Filters);
	UdmMatchListFree(&Env->SectionFilters);
	
	UdmSynonymListFree(&Env->Synonyms);
	UdmVarListFree(&Env->Sections);
	UdmLangMapListSave(&Env->LangMaps);
	UdmLangMapListFree(&Env->LangMaps);
	UdmServerListFree(&Env->Servers);
	UdmSpellListListFree(&Env->Spells);
	UdmAffixListListFree(&Env->Affixes);
	UdmVarListFree(&Env->Vars);
	UdmChineseListFree(&Env->Chi);
	UdmChineseListFree(&Env->Thai);

	if(Env->freeme)UDM_FREE(Env);
}

__C_LINK char * __UDMCALL UdmEnvErrMsg(UDM_ENV * Conf){
  size_t	i;
  UDM_DB *db;

  for(i = 0; i<Conf->dbl.nitems; i++){
    db = &Conf->dbl.db[i];
    if (db->errcode) {
      char *oe = (char*)UdmStrdup(Conf->errstr);
      udm_snprintf(Conf->errstr, 2048, "DB err: %s - %s", db->errstr, oe);
      UDM_FREE(oe);
    }
  }
  return(Conf->errstr);
}

__C_LINK int __UDMCALL UdmSetLockProc(UDM_ENV * Conf,
                      __C_LINK void (*proc)(UDM_AGENT *A,
                                            int command, int type,
                                            const char *f,int l))
{
	Conf->LockProc=proc;
	return(0);
}

