/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.c,v 1.2 2003/06/03 16:35:53 ostborn Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"

int mplugins_processor_ippl_dlinit(mconfig *ext_conf) {
	config_processor *conf = NULL;

	if (0 != strcmp(ext_conf->version, VERSION)) {
		M_DEBUG2(ext_conf->debug_level, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "version string doesn't match: (mla) %s != (plugin) %s\n", ext_conf->version, VERSION);
		return -1;
	}

	conf = malloc(sizeof(config_processor));
	memset(conf, 0, sizeof(config_processor));

	/* init the internal variables */
	conf->watched_dports	= mlist_init();
	conf->watched_shosts	= mlist_init();
	conf->check_portscan	= 0;
	
	ext_conf->plugin_conf = conf;

	return 0;
}

int mplugins_processor_ippl_dlclose(mconfig *ext_conf) {
	config_processor *conf = ext_conf->plugin_conf;

	/* free the internal variables */
	mlist_free( conf->watched_dports );
	mlist_free( conf->watched_shosts );

	free(ext_conf->plugin_conf);
	ext_conf->plugin_conf = NULL;

	return 0;
}

int mplugins_processor_ippl_parse_config(mconfig *ext_conf, const char *filename, const char *section) {
	config_processor *conf = ext_conf->plugin_conf;

	const mconfig_values config_values[] = {
		/* configvalues */
		{"watched_dports", M_CONFIG_TYPE_MATCH, M_CONFIG_VALUE_APPEND, &(conf->watched_dports)},
		{"watched_shosts", M_CONFIG_TYPE_MATCH, M_CONFIG_VALUE_APPEND, &(conf->watched_shosts)},
		{"check_portscan", M_CONFIG_TYPE_STRING, M_CONFIG_VALUE_OVERWRITE, &(conf->cps_int)},

		{NULL, M_CONFIG_TYPE_INT, 0, NULL}
	};
	
	if (conf == NULL) return -1;

	return mconfig_parse_section(ext_conf, filename, section, config_values);
}


int mplugins_processor_ippl_set_defaults(mconfig *ext_conf) {
	config_processor *conf = ext_conf->plugin_conf;

	/* set some defaults, prepare the internals base on the configvalues */
	if (conf == NULL) return -1;
	
	/* for portscan checking */
	if (!strncmp(conf->cps_int, "yes", 3))
		conf->check_portscan = 1;
	else if (!strncmp(conf->cps_int, "no", 2))
		conf->check_portscan = 0;
	else {
		fprintf(stderr, "Processor_Ippl: Invalid value at check_portscan!\n"
			"Valid values are: (yes, no), got: %s\n"
			"Exiting...\n", conf->cps_int);
		return -1;
	}
	free(conf->cps_int);

	return 0;
}

int mplugins_init(mplugin *func) {
	func->dlinit = mplugins_processor_ippl_dlinit;
	func->dlclose = mplugins_processor_ippl_dlclose;
	func->parse_config = mplugins_processor_ippl_parse_config;
	func->set_defaults = mplugins_processor_ippl_set_defaults;
	func->get_next_record = NULL;
	func->insert_record = mplugins_processor_ippl_insert_record;
	func->gen_report = NULL;
        func->gen_history = NULL;

	return 0;
}
