/* 
 *   Creation Date: <1999/03/05 15:38:39 samuel>
 *   Time-stamp: <1999/03/05 15:56:26 samuel>
 *   
 *	<control_hw.h>
 *	
 *	Control hardware (videocontroller in the 7500, 8500)
 *   
 *   Copyright (C) 1999 Samuel Rydh (samuel@ibrium.se)
 *	
 *   Based upon hardware information from the linuxppc kernel:
 *
 *   	Copyright (C) 1998 Daniel Jacobowitz <dan@debian.org>
 *   	Copyright (C) 1996 Paul Mackerras.
 *   	Copyright (C) 1998 Jon Howell
 *    
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_CONTROL_HW
#define _H_CONTROL_HW

#include <sys/types.h>

/*
 * Structure of the registers for the RADDAC colormap device.
 */
#define DAC_REG_SIZE	0x10
#define DAC_SIZE     	0x40
enum { 
	dacr_addr=0, 
	dacr_d1, 
	dacr_d2, 
	dacr_lut 
};

#define CONTROL_REG_SIZE	0x10
#define CONTROL_SIZE		0x1000	/* this is what OF gives us... */

typedef struct cmap_regs {
        unsigned char 	addr;
        char pad1[15];
        unsigned char 	d1;
        char pad2[15];
        unsigned char 	d2;
        char pad3[15];
        unsigned char 	lut;
        char pad4[15];
} ph_cmap_regs_t;

#if 0
struct preg {                   /* padded register */
        unsigned r;
        char pad[12];
};

struct control_regs {
        struct preg vcount;     /* vertical counter */
        /* Vertical parameters are in units of 1/2 scan line */
        struct preg vswin;      /* between vsblank and vssync */
        struct preg vsblank;    /* vert start blank */
        struct preg veblank;    /* vert end blank (display start) */
        struct preg vewin;      /* between vesync and veblank */
        struct preg vesync;     /* vert end sync */
        struct preg vssync;     /* vert start sync */
        struct preg vperiod;    /* vert period */
        struct preg reg8;
        /* Horizontal params are in units of 2 pixels */
        struct preg hperiod;    /* horiz period - 2 */
        struct preg hsblank;    /* horiz start blank */
        struct preg heblank;    /* horiz end blank */
        struct preg hesync;     /* horiz end sync */
        struct preg hssync;     /* horiz start sync */
        struct preg rege;
        struct preg regf;
        struct preg reg10;
        struct preg reg11;
        struct preg ctrl;       /* display control */
        struct preg start_addr; /* start address: 5 lsbs zero */
        struct preg pitch;      /* addrs diff between scan lines */
        struct preg mon_sense;  /* monitor sense bits */
        struct preg flags;
        struct preg mode;
        struct preg reg18;
        struct preg reg19;
        struct preg res[6];
};
#endif

#define NUM_REGS_CONTROL	32
/* 32 registers */
enum {
	r_vcount=0, 	/* vertical counter */
	/* Vertical parameters are in units of 1/2 scan line */
	r_vswin,	/* between vsblank and vssync */
	r_vsblank,	/* vert start blank */
	r_veblank,	/* vert end blank (display start) */
	r_vewin,	/* between vesync and veblank */
	r_vesync,	/* vert end sync */
	r_vssync,	/* vert start sync */
	r_vperiod,	/* vert period */
	r_reg8,
	/* Horizontal params are in units of 2 pixels */
	r_hperiod,	/* horiz period - 2 */
	r_hsblank,	/* horiz start blank */
	r_heblank,	/* horiz end blank */
	r_hesync,	/* horiz end sync */
	r_hssync,	/* horiz start sync */
	r_rege,
	r_regf,
	r_reg10,
	r_reg11,
	r_ctrl,	 	/* display control */
	r_start_addr,	/* start address: 5 lsbs zero */
	r_pitch,	/* addrs diff between scan lines */
	r_mon_sense,	/* monitor sense bits */
	r_flags,
	r_mode,
	r_reg18,
	r_reg19,
	r_res1,
	r_res2,
	r_res3,
	r_res4,
	r_res5,
	r_res6,
};


#endif /* _H_CONTROL_HW */
