/* 
 *   Creation Date: <2002/01/09 22:46:39 samuel>
 *   Time-stamp: <2002/01/20 21:42:51 samuel>
 *   
 *	<MolUserClient.h>
 *	
 *	
 *   
 *   Copyright (C) 2002 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_MOLUSERCLIENT
#define _H_MOLUSERCLIENT

#include <IOKit/IOUserClient.h>

class MolExt;

class MolUserClient : public IOUserClient {

	OSDeclareDefaultStructors(MolUserClient)
private:
	task_t			molTask;
	int			sessId, sessMagic;
	MolExt 			*owner;
	IOMemoryMap	 	*kvarMap;
	bool			isRunning;
	
public:
	virtual void 		release() const;
//	virtual bool		attach( IOService *provider);
//	virtual void		detach( IOService *provider);
	virtual bool		start( IOService *provider );
	virtual void		stop( IOService *provider );

	virtual void		free();
	virtual IOReturn	clientClose( void );
	virtual IOReturn	clientDied( void );


	static IOUserClient	*withTask( task_t owningTask );
	bool			initWithTask( task_t owning_task );

	virtual IOExternalMethod *getTargetAndMethodForIndex( IOService ** targetP, UInt32 index );

	IOReturn		ccTest( ulong value );
#if 1
	/* Client functions */
	IOReturn		ccGetMolModVersion( int *ret );
	IOReturn		ccMapMregs( char **ret_addr );
	IOReturn		ccInit( int wanted_sess_id, int sess_magic );
	IOReturn		ccCleanup();
#endif
#if 0
	IOReturn		ccGetMolModVersion( int *ret );
	IOReturn		ccMapMregs( char **ret_addr );
	IOReturn		ccInit( int wanted_sess_id, int sess_magic );
	IOReturn		ccCleanup();
#endif
};


#endif   /* _H_MOLUSERCLIENT */

