/*

    mpv_gtk.c

    GTK (X Window) Interface (Linux/Unix)

    mp - Programmer Text Editor

    Copyright (C) 1991/2001 Angel Ortega <angel@triptico.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    http://www.triptico.com

*/

/*

    WARNING:

    This interface is far from complete. It does not work. Anything can happen.

*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "mp_core.h"
#include "mp_video.h"
#include "mp_iface.h"
#include "mp_lang.h"
#include "mp_synhi.h"


GtkWidget * window=NULL;
GtkWidget * menu=NULL;
GtkWidget * menu_bar=NULL;
GtkWidget * file_tabs=NULL;
GtkWidget * file_tabs_frame=NULL;
GtkWidget * entry=NULL;
GtkWidget * area=NULL;
GtkWidget * scrollbar=NULL;

GdkFont * _font_normal=NULL;
GdkFont * _font_italic=NULL;

static char _mpv_title_buffer[1024];
static char _mpv_status_line_buffer[1024];

/* readline buffer */
static char _mpv_readline_buf[1024];

/* confirmation value for gtk dialogs */
static int _mpv_confirm_value=-1;

/* font information */
char _mpv_font_face[80]="courier";
int _mpv_font_size=14;
int _mpv_font_width=0;


/*******************
	Code
*******************/

/**
 * mpv_strcasecmp - Case ignoring string compare
 * @s1: first string
 * @s2: second string
 *
 * Case ignoring string compare. System dependent
 * (strcasecmp in Unix, stricmp in Win32)
 */
int mpv_strcasecmp(char * s1, char * s2)
{
	return(strcasecmp(s1,s2));
}


void mpv_goto(int x, int y)
{
}


void mpv_char(int c, int color)
{
}


void mpv_str(char * str, int color)
{
}


void mpv_cursor(int x, int y)
{
}


void mpv_refresh(void)
{
}


static void _mpv_title_status(void)
{
	char tmp[2048];

	strncpy(tmp,"mp " VERSION, sizeof(tmp));

	if(_mpv_title_buffer[0]!='\0')
	{
		strcat(tmp," - ");
		strcat(tmp,_mpv_title_buffer);
	}

	if(_mpv_status_line_buffer[0]!='\0')
		strcat(tmp,_mpv_status_line_buffer);

	gtk_window_set_title(GTK_WINDOW(window), tmp);
}


void mpv_title(char * str)
{
	if(str)
		strncpy(_mpv_title_buffer,str,sizeof(_mpv_title_buffer));
	else
		_mpv_title_buffer[0]='\0';

	_mpv_title_status();
}


void mpv_status_line(char * str)
{
	if(str)
		strncpy(_mpv_status_line_buffer,str,sizeof(_mpv_status_line_buffer));
	else
		_mpv_status_line_buffer[0]='\0';

	_mpv_title_status();
}


static char * _mpv_filter_menu_label(char * label)
{
	static char tmp[1024];
	int n;

	for(n=0;*label && *label!='\t';label++)
	{
		if(*label!='&')
			tmp[n++]=*label;
	}
	tmp[n]='\0';

	return(tmp);
}


void mpv_add_menu(char * label)
/* adds a menu */
{
	GtkWidget * menu_item;

	if(menu_bar==NULL)
		menu_bar=gtk_menu_bar_new();

	menu=gtk_menu_new();

	label=_mpv_filter_menu_label(label);
	menu_item=gtk_menu_item_new_with_label(label);

	gtk_widget_show(menu_item);

	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), menu);

	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), menu_item);
}


static void _mpv_menu_item(int key)
/* menu click callback */
{
	mpi_action(_mp_active, key);

	mpi_draw_all(_mp_active);

	if(_mpi_exit_requested)
		gtk_main_quit();
}


void mpv_add_menu_item(char * label, int key, int * toggle)
/* adds a menu item */
{
	GtkWidget * menu_item;

	label=_mpv_filter_menu_label(label);

	if(*label=='-')
		menu_item=gtk_menu_item_new();
	else
		menu_item=gtk_menu_item_new_with_label(label);

	gtk_menu_append(GTK_MENU(menu), menu_item);

	gtk_signal_connect_object(GTK_OBJECT(menu_item), "activate",
		GTK_SIGNAL_FUNC(_mpv_menu_item), (gpointer) key);

	gtk_widget_show(menu_item);
}


int mpv_menu(void)
{
	return(0);
}


static void _gtk_really_modal(void)
{
	_mpv_confirm_value=-1;
	while(_mpv_confirm_value==-1)
		gtk_main_iteration();
}


static void _mpv_confirm_yes(GtkWidget * widget, gpointer data)
{
	_mpv_confirm_value=1;
	gtk_widget_destroy(GTK_WIDGET(widget));
}


static void _mpv_confirm_no(GtkWidget * widget, gpointer data)
{
	_mpv_confirm_value=0;
	gtk_widget_destroy(GTK_WIDGET(widget));
}


static void _mpv_confirm_yes_file(GtkWidget * widget, gpointer data)
{
	char * ptr;

	ptr=gtk_file_selection_get_filename(GTK_FILE_SELECTION(widget));
	strncpy(_mpv_readline_buf,ptr,sizeof(_mpv_readline_buf));

	_mpv_confirm_value=1;
	gtk_widget_destroy(GTK_WIDGET(widget));
}


static void _mpv_confirm_yes_entry(GtkWidget * widget, gpointer data)
{
	char * ptr;

	ptr=gtk_editable_get_chars(GTK_EDITABLE(entry),0,-1);
	strncpy(_mpv_readline_buf,ptr,sizeof(_mpv_readline_buf));

	g_free(ptr);

	entry=NULL;

	_mpv_confirm_value=1;
	gtk_widget_destroy(GTK_WIDGET(widget));
}


void mpv_alert(char * msg, char * msg2)
{
	char tmp[8192];
	GtkWidget * dlg;
	GtkWidget * label;
	GtkWidget * button;

	if(msg2==NULL)
		strncpy(tmp,msg,sizeof(tmp));
	else
		sprintf(tmp,msg,msg2);

	dlg=gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dlg),"mp " VERSION);
	gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(dlg)->vbox),5);

	label=gtk_label_new(tmp);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dlg)->vbox),label,TRUE,TRUE,0);
	gtk_widget_show(label);

	button=gtk_button_new_with_label("OK");
	gtk_signal_connect_object(GTK_OBJECT(button),"clicked",
		GTK_SIGNAL_FUNC(_mpv_confirm_yes),GTK_OBJECT(dlg));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dlg)->action_area),button,TRUE,TRUE,0);
	gtk_widget_show(button);

	gtk_widget_show(dlg);
	gtk_grab_add(dlg);
	_gtk_really_modal();
}


int mpv_confirm(char * prompt)
{
	GtkWidget * dlg;
	GtkWidget * label;
	GtkWidget * ybutton;
	GtkWidget * nbutton;

	dlg=gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dlg),"mp " VERSION);
	gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(dlg)->vbox),5);

	label=gtk_label_new(prompt);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dlg)->vbox),label,TRUE,TRUE,0);
	gtk_widget_show(label);

	ybutton=gtk_button_new_with_label(L(MSG_YES_STRING));
	gtk_signal_connect_object(GTK_OBJECT(ybutton),"clicked",
		GTK_SIGNAL_FUNC(_mpv_confirm_yes),GTK_OBJECT(dlg));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dlg)->action_area),ybutton,TRUE,TRUE,0);
	gtk_widget_show(ybutton);

	nbutton=gtk_button_new_with_label(L(MSG_NO_STRING));
	gtk_signal_connect_object(GTK_OBJECT(nbutton),"clicked",
		GTK_SIGNAL_FUNC(_mpv_confirm_no),GTK_OBJECT(dlg));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dlg)->action_area),nbutton,TRUE,TRUE,0);
	gtk_widget_show(nbutton);

	gtk_widget_show(dlg);
	gtk_grab_add(dlg);
	_gtk_really_modal();

	return(_mpv_confirm_value);
}


char * mpv_readline(int type, char * prompt, char * def)
{
	GtkWidget * dlg;
	GtkWidget * label;
	GtkWidget * ybutton;
	GtkWidget * nbutton;

	if(type==MPR_OPEN || type==MPR_SAVE)
	{
		dlg=gtk_file_selection_new(prompt);

		if(def != NULL)
			gtk_file_selection_set_filename(GTK_FILE_SELECTION(dlg),def);

		gtk_signal_connect_object(
			GTK_OBJECT(GTK_FILE_SELECTION(dlg)->ok_button),"clicked",
			GTK_SIGNAL_FUNC(_mpv_confirm_yes_file),GTK_OBJECT(dlg));
		gtk_signal_connect_object(
			GTK_OBJECT(GTK_FILE_SELECTION(dlg)->cancel_button),"clicked",
			GTK_SIGNAL_FUNC(_mpv_confirm_no),GTK_OBJECT(dlg));

		gtk_widget_show(dlg);
		gtk_grab_add(dlg);
		_gtk_really_modal();

		if(_mpv_confirm_value)
			return(_mpv_readline_buf);
	}
	else
	{
		dlg=gtk_dialog_new();
		gtk_window_set_title(GTK_WINDOW(dlg),"mp " VERSION);
		gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(dlg)->vbox),5);

		label=gtk_label_new(prompt);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dlg)->vbox),label,TRUE,TRUE,0);
		gtk_widget_show(label);

		entry=gtk_entry_new();

		if(def != NULL)
			gtk_entry_set_text(GTK_ENTRY(entry),def);

		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dlg)->vbox),entry,TRUE,TRUE,0);
		gtk_widget_show(entry);

		ybutton=gtk_button_new_with_label(L(MSG_YES_STRING));
		gtk_signal_connect_object(GTK_OBJECT(ybutton),"clicked",
			GTK_SIGNAL_FUNC(_mpv_confirm_yes_entry), GTK_OBJECT(dlg));
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dlg)->action_area),
			ybutton,TRUE,TRUE,0);
		gtk_widget_show(ybutton);

		nbutton=gtk_button_new_with_label(L(MSG_NO_STRING));
		gtk_signal_connect_object(GTK_OBJECT(nbutton),"clicked",
			GTK_SIGNAL_FUNC(_mpv_confirm_no),GTK_OBJECT(dlg));
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dlg)->action_area),
			nbutton,TRUE,TRUE,0);
		gtk_widget_show(nbutton);

		gtk_widget_show(dlg);
		gtk_grab_add(dlg);
		_gtk_really_modal();

		if(_mpv_confirm_value)
			return(_mpv_readline_buf);
	}

	return(NULL);
}


int mpv_list(char * title, mp_txt * txt)
{
	return(0);
}


int mpv_help(char * term, int synhi)
{
	return(0);
}


static GdkFont * _mpv_get_font(char * fontface, char * slant, int size)
{
	char tmp[1024];

	sprintf(tmp,"-*-%s-medium-%s-*-*-%d-*-*-*-*-*-*-*",
		fontface, slant, size);

	return(gdk_font_load(tmp));
}


int mpv_zoom(int inc)
{
	GdkFont * fn=NULL;
	GdkFont * fi=NULL;
	int s;

	inc*=2;

	for(s=_mpv_font_size+inc;s > 6 && s < 128;s+=inc)
	{
		fn=_mpv_get_font(_mpv_font_face, "r", s);

		if(fn==NULL) continue;

		fi=_mpv_get_font(_mpv_font_face, "i", s);

		if(fi==NULL)
			gdk_font_unref(fn);
		else
			break;
	}

	if(fn!=NULL && fi!=NULL)
	{
		_mpv_font_size=s;
		if(_font_normal!=NULL) gdk_font_unref(_font_normal);
		if(_font_italic!=NULL) gdk_font_unref(_font_italic);

		_font_normal=fn;
		_font_italic=fi;

		gdk_string_extents(_font_normal,"m",NULL,NULL,
			&_mpv_font_width,NULL,NULL);

		_mpv_x_size=(area->allocation.width / _mpv_font_width)+1;
		_mpv_y_size=(area->allocation.height / _mpv_font_size)+1;
	}

	return(0);
}


void mpv_scrollbar(int pos, int size, int max)
{
	GtkAdjustment * adjustment;

	printf("mpv_scrollbar\n");

	adjustment=gtk_range_get_adjustment(GTK_RANGE(scrollbar));

	adjustment->upper=(gfloat)max;
	adjustment->page_size=(gfloat)size;
	adjustment->value=(gfloat)pos;

	gtk_range_set_adjustment(GTK_RANGE(scrollbar),adjustment);

	gtk_adjustment_changed(adjustment);
	gtk_adjustment_value_changed(adjustment);
}


int mpv_insert_template(void)
{
	return(0);
}


void mpv_filetabs(void)
{
	int n;
	mp_txt * t;
	GtkWidget * l;

	return;

	/* delete possible previous tabs */
	for(n=0;n < 100;n++)
		gtk_notebook_remove_page(GTK_NOTEBOOK(file_tabs),0);

	for(t=_mp_txts,n=0;t!=NULL && n < 100;t=t->next,n++)
	{
		l=gtk_label_new(t->name);
		gtk_widget_show(l);

		gtk_notebook_append_page(GTK_NOTEBOOK(file_tabs),
			file_tabs_frame,l);

		if(_mp_active == t)
			gtk_notebook_set_page(GTK_NOTEBOOK(file_tabs), n);
	}
}


void mpv_about(void)
{
}


static gint _mpv_key(GtkWidget * widget, GdkEventKey * event)
{
	int n;

	printf("%d\n",event->keyval);
	printf("[%s](%d)\n",event->string,event->string[0]);
	printf("%04X\n",event->state);

	if(event->keyval==65451) mpv_zoom(1);
	if(event->keyval==65453) mpv_zoom(-1);

	gdk_draw_rectangle(area->window, area->style->white_gc,
		TRUE, 0, 0, area->allocation.width, area->allocation.height);

/*	  gdk_draw_string(area->window, _font_normal, area->style->black_gc,
		50, 50, "Minimum Profit");
*/
	for(n=0;n < 100;n++)
	{
		char tmp[100];

		sprintf(tmp,"lnea %d - %d",n,_mpv_font_width);
		gdk_draw_string(area->window, _font_normal, area->style->black_gc,
			0, n * _mpv_font_size, tmp);
	}

	mpv_scrollbar(_mp_active->y,_mpv_y_size,_mp_active->lasty+1);

	return(0);
}


static gint configure(GtkWidget * widget, GdkEventConfigure * event)
{
	printf("%d, %d\n",widget->allocation.width,
		widget->allocation.height);

	if(_mpv_font_width)
	{
		_mpv_x_size=(area->allocation.width / _mpv_font_width)+1;
		_mpv_y_size=(area->allocation.height / _mpv_font_size)+1;
	}

	return(TRUE);
}


int mpv_startup(void)
{
	GtkWidget * vbox;
	GtkWidget * hbox;

	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);

	gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		(GtkSignalFunc) gtk_main_quit, NULL);

	file_tabs=gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(file_tabs), GTK_POS_TOP);
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(file_tabs), 1);

	vbox=gtk_vbox_new(FALSE, 2);
	gtk_container_add(GTK_CONTAINER(window), vbox);
	gtk_box_pack_start(GTK_BOX(vbox),menu_bar,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),file_tabs,FALSE,FALSE,0);

	file_tabs_frame=gtk_frame_new(NULL);
	gtk_widget_show(file_tabs_frame);

	hbox=gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,0);

	area=gtk_drawing_area_new();
	gtk_box_pack_start(GTK_BOX(hbox),area,TRUE,TRUE,0);
	gtk_widget_set_usize(GTK_WIDGET(area),320,200);

	gtk_signal_connect(GTK_OBJECT(area),"configure_event",
		(GtkSignalFunc) configure, NULL);

	scrollbar=gtk_vscrollbar_new(NULL);
	gtk_box_pack_start(GTK_BOX(hbox),scrollbar,FALSE,FALSE,0);

	gtk_signal_connect(GTK_OBJECT(window),"key_press_event",
		(GtkSignalFunc) _mpv_key, NULL);

	gtk_widget_show_all(window);

/*	  _font_normal=gdk_font_load("-*-courier new-medium-r-*-*-24-*-*-*-*-*-*-*");
*/
	_mpv_font_size-=2;
	mpv_zoom(1);

	/* @#@ must be calculated using the font size and the screen size */
	_mpv_y_size=25;

	return(0);
}


void mpv_shutdown(void)
{
}


/**
 * usage - Prints the usage help.
 *
 * Prints the usage help to standard output.
 */
void usage(void)
{
	printf("mp " VERSION " (Gtk Interface) - Programmer Text Editor\n");
	printf("Copyright (C) 1991-2002 Angel Ortega <angel@triptico.com>\n");
	printf("%s\n", __DATE__ " " __TIME__);
	printf("This software is covered by the GPL license. NO WARRANTY.\n\n");

	printf("%s", L(MSG_USAGE_TEXT));
	printf("%s\n",mps_enumerate_modes());
}


int main(int argc, char * argv[])
/* main */
{
	int r;

	r=mpi_args_1(argc, argv);

	if(r==-1) { usage(); exit(0); }
	if(r==-2) { printf(VERSION "\n"); exit(0); }

	gtk_init(&argc,&argv);

	mp_startup();
	mps_startup();
	mpi_startup();
	mpv_startup();

	r=mpi_args_2(argc, argv);

	if(r==-1)
	{
		mpv_shutdown();
		printf("%s\n",L(MSG_BADMODE));
		printf("%s\n",mps_enumerate_modes());
		exit(1);
	}

	/* force the reading of the tags file, if one exists */
	mpi_find_tag(NULL,0);

	/* create empty text if no file is open */
	if(_mp_active==NULL)
	{
		mp_create_txt(L(MSG_UNNAMED));
		mps_auto_synhi(_mp_active);
	}

	_mp_active->mod=1;

	mpv_title(NULL);
	mpi_draw_all(_mp_active);

	/* bark if bad tags */
	if(r==-2)
		mpv_alert(L(MSG_TAGNOTFOUND),"");

	/* build _mpi_template_file */
	{
		char * home=getenv("HOME");

		if(home!=NULL)
			sprintf(_mpi_template_file,"%s/.mp_templates",home);
		else
			strncpy(_mpi_template_file,".mp_templates",sizeof(_mpi_template_file));
	}

	/* main loop */
	gtk_main();

	/* close everything */
	mpi_shutdown();

	mpv_shutdown();
	mp_shutdown();

	return(0);
}
