//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: alayout.cpp,v 1.1.1.1 2003/10/29 10:06:19 wschweer Exp $
//  (C) Copyright 2002 Werner Schweer (ws@seh.de)
//=========================================================

#include "alayout.h"

//---------------------------------------------------------
//   wadd
//---------------------------------------------------------

void TLLayout::wadd(int idx, QWidget* w)
      {
      li[idx] = new QWidgetItem(w);
      addItem(li[idx]);
      }

//---------------------------------------------------------
//   TLLayoutIterator
//---------------------------------------------------------

class TLLayoutIterator : public QGLayoutIterator
      {
      int idx;
      QPtrList<QLayoutItem> *list;

   public:
      TLLayoutIterator(QPtrList<QLayoutItem> *l) : idx(0), list(l) {}
      QLayoutItem *current()     { return idx < int(list->count()) ? list->at(idx) : 0; }
      QLayoutItem *next()        { idx++; return current(); }
      QLayoutItem *takeCurrent() { return list->take( idx ); }
      };

//---------------------------------------------------------
//   iterator
//---------------------------------------------------------

QLayoutIterator TLLayout::iterator()
      {
      return QLayoutIterator(new TLLayoutIterator(&ilist));
      }

void TLLayout::addItem(QLayoutItem *item)
      {
      ilist.append(item);
      }

TLLayout::~TLLayout()
      {
      deleteAllItems();
      }

//---------------------------------------------------------
//   setGeometry
//    perform geometry management for tracklist:
//
//         0         1         2
//   +-----------+--------+---------+
//   | Trackinfo | vline  | header 4| 0
//   |           |        +---------+
//   |     ^     |        |   ^     |
//   |           |        | <list>  | 1
//   |     012   |   3    |    5    |
//   +-----------+--------+---------+
//   |             hline     6      | 2
//   +------------------------------+
//   | ttools        7              | 3
//   +------------------------------+
//---------------------------------------------------------

void TLLayout::setGeometry(const QRect &rect)
      {
      QLayout::setGeometry(rect);
      int w = rect.width();
      int h = rect.height();

      QSize s0(0,0);
      int info = -1;
      if (!li[0]->isEmpty()) {
            s0 = li[0]->sizeHint();
            info = 0;
            }
      else if (!li[1]->isEmpty()) {
            s0 = li[1]->sizeHint();
            info = 1;
            }
      else if (!li[2]->isEmpty()) {
            s0 = li[2]->sizeHint();
            info = 2;
            }

      QSize s3 = li[3]->sizeHint();
      QSize s4 = li[4]->sizeHint();
      QSize s6 = li[6]->sizeHint();
      QSize s7 = li[7]->sizeHint();

      int y1 = 30;  // fixed
      int ah = h - s7.height() - s6.height() - y1;
      int aw = w - s3.width() - s0.width();

      int y2 = ah + s4.height();
      int y3 = y2 + s6.height();
      int x1 = s0.width();
      int x2 = x1 + s3.width();

      if (info != -1)
            li[info]->setGeometry(QRect(0, 0, s0.width(), y2));

// printf("setGeometry %d\n", x1);
      li[3]->setGeometry(QRect(x1, 0, s3.width(), y2));
      li[4]->setGeometry(QRect(x2, 0, aw,         s4.height()));
      li[5]->setGeometry(QRect(x2, y1, aw,        ah));

      li[6]->setGeometry(QRect(0,  y2,  w,        s6.height()));
      li[7]->setGeometry(QRect(3,  y3,  s7.width(), s7.height()));
      ((QWidget*)parent())->setMaximumSize(maximumSize());
      }

//---------------------------------------------------------
//   sizeHint
//---------------------------------------------------------

QSize TLLayout::sizeHint() const
      {
      return QSize(10, 100);
      }

//---------------------------------------------------------
//   minimumSize
//---------------------------------------------------------

QSize TLLayout::minimumSize() const
      {
      return QSize(10, 50);
      }

//---------------------------------------------------------
//   maximumSize
//---------------------------------------------------------

QSize TLLayout::maximumSize() const
      {
      int w0 = 0;
      if (!li[0]->isEmpty()) {
            w0 = li[0]->widget()->width();
            }
      else if (!li[1]->isEmpty()) {
            w0 = li[1]->widget()->width();
            }
      else if (!li[2]->isEmpty()) {
            w0 = li[2]->widget()->width();
            }
      int w3 = li[3]->widget()->sizeHint().width();
      int w4 = li[4]->widget()->sizeHint().width();
      return QSize((w0 + w3 + w4), 10000);
      }

