//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: listedit.h,v 1.1.1.1 2003/10/29 10:05:22 wschweer Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __LIST_EDIT_H__
#define __LIST_EDIT_H__

#include "midieditor.h"
#include "noteinfo.h"
#include "cobject.h"

class MidiEvent;
class MidiTrack;
class PartList;
class MidiPart;
class MidiPart;
class Xml;
class QActionGroup;
class QListView;
class QListViewItem;

//---------------------------------------------------------
//   ListEdit
//---------------------------------------------------------

class ListEdit : public MidiEditor {
      QListView* liste;
      QPopupMenu* menuEdit;
      QActionGroup* insertItems;
      QToolBar* listTools;
      MidiTrack* curTrack;
      MidiPart* curPart;
      int curPartId;

      enum { CMD_DELETE };
      
      Q_OBJECT
      virtual void closeEvent(QCloseEvent*);

   private slots:
      void editInsertNote();
      void editInsertSysEx();
      void editInsertCtrl7();
      void editInsertCtrl14();
      void editInsertMeta();
      void editInsertPitch();
      void editInsertCAfter();
      void editInsertPAfter();
      void editEvent(MidiEvent*, MidiPart*);
      void selectionChanged();
      void doubleClicked(QListViewItem*);
      void cmd(int cmd);

   public slots:
      void songChanged(int);

   signals:
      void deleted(int);

   public:
      ListEdit(PartList*);
      ~ListEdit();
      virtual void readStatus(Xml&);
      virtual void writeStatus(int, Xml&) const;
      };

#endif

