/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

/* i1mach.f -- translated by f2c (version of 16 February 1991  0:35:15).
   You must link the resulting object file with the libraries:
	-lf2c -lm -lc   (in that order)
*/

#include "f2c.h"


/* ---------------------------------------------------------------------- */
/*  function:  i1mach */
/*  this routine is from the port mathematical subroutine library */
/*  it is described in the bell laboratories computing science */
/*  technical report #47 by p.a. fox, a.d. hall and n.l. schryer */
/* --------------------------------------------------------------------- */

integer i1mach_(i)
integer *i;
{
    /* Initialized data */

    static struct {
	integer e_1[16];
	} equiv_0 = { { 5, 6, 5, 6, 32, 4, 2, 31, 2147483647, 2, 24, -127, 127, 
		56, -127, 127}  };


    /* Format strings */
    static char fmt_9000[] = "(\0021error    1 in i1mach - i out of bound\
s\002)";

    /* System generated locals */
    integer ret_val;

    /* Builtin functions */
    integer s_wsfe(), e_wsfe();
    /* Subroutine */ int s_stop();

    /* Local variables */
#define imach ((integer *)&equiv_0)
#define output ((integer *)&equiv_0 + 3)

    /* Fortran I/O blocks */
    static cilist io___3 = { 0, 0, 0, fmt_9000, 0 };



/*  i/o unit numbers. */

/*    i1mach( 1) = the standard input unit. */

/*    i1mach( 2) = the standard output unit. */

/*    i1mach( 3) = the standard punch unit. */

/*    i1mach( 4) = the standard error message unit. */

/*  words. */

/*    i1mach( 5) = the number of bits per integer storage unit. */

/*    i1mach( 6) = the number of characters per integer storage unit. */

/*  integers. */

/*    assume integers are represented in the s-digit, base-a form */

/* 		   sign ( x(s-1)*a**(s-1) + ... + x(1)*a + x(0) ) */

/* 		   where 0 .le. x(i) .lt. a for i=0,...,s-1. */

/*    i1mach( 7) = a, the base. */

/*    i1mach( 8) = s, the number of base-a digits. */

/*    i1mach( 9) = a**s - 1, the largest magnitude. */

/*  floating-point numbers. */

/*    assume floating-point numbers are represented in the t-digit, */
/*    base-b form */

/* 		   sign (b**e)*( (x(1)/b) + ... + (x(t)/b**t) ) */

/* 		   where 0 .le. x(i) .lt. b for i=1,...,t, */
/* 		   0 .lt. x(1), and emin .le. e .le. emax. */

/*    i1mach(10) = b, the base. */

/*  single-precision */

/*    i1mach(11) = t, the number of base-b digits. */

/*    i1mach(12) = emin, the smallest exponent e. */

/*    i1mach(13) = emax, the largest exponent e. */

/*  double-precision */

/*    i1mach(14) = t, the number of base-b digits. */

/*    i1mach(15) = emin, the smallest exponent e. */

/*    i1mach(16) = emax, the largest exponent e. */

/*  to alter this function for a particular environment, */
/*  the desired set of data statements should be activated by */
/*  removing the c from column 1.  also, the values of */
/*  i1mach(1) - i1mach(4) should be checked for consistency */
/*  with the local operating system. */



/* 	machine constants for the burroughs 1700 system. */

/* 	data imach( 1) /    7 / */
/* 	data imach( 2) /    2 / */
/* 	data imach( 3) /    2 / */
/* 	data imach( 4) /    2 / */
/* 	data imach( 5) /   36 / */
/* 	data imach( 6) /    4 / */
/* 	data imach( 7) /    2 / */
/* 	data imach( 8) /   33 / */
/* 	data imach( 9) / z1ffffffff / */
/* 	data imach(10) /    2 / */
/* 	data imach(11) /   24 / */
/* 	data imach(12) / -256 / */
/* 	data imach(13) /  255 / */
/* 	data imach(14) /   60 / */
/* 	data imach(15) / -256 / */
/* 	data imach(16) /  255 / */

/* 	machine constants for the burroughs 5700 system. */

/* 	data imach( 1) /   5 / */
/* 	data imach( 2) /   6 / */
/* 	data imach( 3) /   7 / */
/* 	data imach( 4) /   6 / */
/* 	data imach( 5) /  48 / */
/* 	data imach( 6) /   6 / */
/* 	data imach( 7) /   2 / */
/* 	data imach( 8) /  39 / */
/* 	data imach( 9) / o0007777777777777 / */
/* 	data imach(10) /   8 / */
/* 	data imach(11) /  13 / */
/* 	data imach(12) / -50 / */
/* 	data imach(13) /  76 / */
/* 	data imach(14) /  26 / */
/* 	data imach(15) / -50 / */
/* 	data imach(16) /  76 / */

/* 	machine constants for the burroughs 6700/7700 systems. */

/* 	data imach( 1) /   5 / */
/* 	data imach( 2) /   6 / */
/* 	data imach( 3) /   7 / */
/* 	data imach( 4) /   6 / */
/* 	data imach( 5) /  48 / */
/* 	data imach( 6) /   6 / */
/* 	data imach( 7) /   2 / */
/* 	data imach( 8) /  39 / */
/* 	data imach( 9) / o0007777777777777 / */
/* 	data imach(10) /   8 / */
/* 	data imach(11) /  13 / */
/* 	data imach(12) / -50 / */
/* 	data imach(13) /  76 / */
/* 	data imach(14) /  26 / */
/* 	data imach(15) / -32754 / */
/* 	data imach(16) /  32780 / */

/* 	machine constants for the cdc 6000/7000 series. */

/* 	data imach( 1) /    5 / */
/* 	data imach( 2) /    6 / */
/* 	data imach( 3) /    7 / */
/* 	data imach( 4) /    6 / */
/* 	data imach( 5) /   60 / */
/* 	data imach( 6) /   10 / */
/* 	data imach( 7) /    2 / */
/* 	data imach( 8) /   48 / */
/* 	data imach( 9) / 00007777777777777777b / */
/* 	data imach(10) /    2 / */
/* 	data imach(11) /   48 / */
/* 	data imach(12) / -974 / */
/* 	data imach(13) / 1070 / */
/* 	data imach(14) /   96 / */
/* 	data imach(15) / -927 / */
/* 	data imach(16) / 1070 / */

/* 	machine constants for the cray 1 */

/* 	data imach( 1) /   100 / */
/* 	data imach( 2) /   101 / */
/* 	data imach( 3) /   102 / */
/* 	data imach( 4) /   101 / */
/* 	data imach( 5) /    64 / */
/* 	data imach( 6) /	8 / */
/* 	data imach( 7) /	2 / */
/* 	data imach( 8) /    63 / */
/* 	data imach( 9) /  777777777777777777777b / */
/* 	data imach(10) /	2 / */
/* 	data imach(11) /    47 / */
/* 	data imach(12) / -8192 / */
/* 	data imach(13) /  8190 / */
/* 	data imach(14) /    95 / */
/* 	data imach(15) / -8192 / */
/* 	data imach(16) /  8190 / */

/* 	machine constants for the data general eclipse s/200 */

/* 	data imach( 1) /   11 / */
/* 	data imach( 2) /   12 / */
/* 	data imach( 3) /    8 / */
/* 	data imach( 4) /   10 / */
/* 	data imach( 5) /   16 / */
/* 	data imach( 6) /    2 / */
/* 	data imach( 7) /    2 / */
/* 	data imach( 8) /   15 / */
/* 	data imach( 9) /32767 / */
/* 	data imach(10) /   16 / */
/* 	data imach(11) /    6 / */
/* 	data imach(12) /  -64 / */
/* 	data imach(13) /   63 / */
/* 	data imach(14) /   14 / */
/* 	data imach(15) /  -64 / */
/* 	data imach(16) /   63 / */

/* 	machine constants for the harris slash 6 and slash 7 */

/* 	data imach( 1) /	 5 / */
/* 	data imach( 2) /	 6 / */
/* 	data imach( 3) /	 0 / */
/* 	data imach( 4) /	 6 / */
/* 	data imach( 5) /	24 / */
/* 	data imach( 6) /	 3 / */
/* 	data imach( 7) /	 2 / */
/* 	data imach( 8) /	23 / */
/* 	data imach( 9) / 8388607 / */
/* 	data imach(10) /	 2 / */
/* 	data imach(11) /	23 / */
/* 	data imach(12) /    -127 / */
/* 	data imach(13) /	127 / */
/* 	data imach(14) /	38 / */
/* 	data imach(15) /    -127 / */
/* 	data imach(16) /	127 / */

/* 	machine constants for the honeywell 600/6000 series. */

/* 	data imach( 1) /    5 / */
/* 	data imach( 2) /    6 / */
/* 	data imach( 3) /   43 / */
/* 	data imach( 4) /    6 / */
/* 	data imach( 5) /   36 / */
/* 	data imach( 6) /    6 / */
/* 	data imach( 7) /    2 / */
/* 	data imach( 8) /   35 / */
/* 	data imach( 9) / o377777777777 / */
/* 	data imach(10) /    2 / */
/* 	data imach(11) /   27 / */
/* 	data imach(12) / -127 / */
/* 	data imach(13) /  127 / */
/* 	data imach(14) /   63 / */
/* 	data imach(15) / -127 / */
/* 	data imach(16) /  127 / */

/* 	machine constants for the ibm 360/370 series, */
/* 	the xerox sigma 5/7/9 and the sel systems 85/86. */

/* 	data imach( 1) /   5 / */
/* 	data imach( 2) /   6 / */
/* 	data imach( 3) /   7 / */
/* 	data imach( 4) /   6 / */
/* 	data imach( 5) /  32 / */
/* 	data imach( 6) /   4 / */
/* 	data imach( 7) /   2 / */
/* 	data imach( 8) /  31 / */
/* 	data imach( 9) / z7fffffff / */
/* 	data imach(10) /  16 / */
/* 	data imach(11) /   6 / */
/* 	data imach(12) / -64 / */
/* 	data imach(13) /  63 / */
/* 	data imach(14) /  14 / */
/* 	data imach(15) / -64 / */
/* 	data imach(16) /  63 / */

/* 	machine constants for the pdp-10 (ka processor). */

/* 	data imach( 1) /    5 / */
/* 	data imach( 2) /    6 / */
/* 	data imach( 3) /    5 / */
/* 	data imach( 4) /    6 / */
/* 	data imach( 5) /   36 / */
/* 	data imach( 6) /    5 / */
/* 	data imach( 7) /    2 / */
/* 	data imach( 8) /   35 / */
/* 	data imach( 9) / "377777777777 / */
/* 	data imach(10) /    2 / */
/* 	data imach(11) /   27 / */
/* 	data imach(12) / -128 / */
/* 	data imach(13) /  127 / */
/* 	data imach(14) /   54 / */
/* 	data imach(15) / -101 / */
/* 	data imach(16) /  127 / */

/* 	machine constants for the pdp-10 (ki processor). */

/* 	data imach( 1) /    5 / */
/* 	data imach( 2) /    6 / */
/* 	data imach( 3) /    5 / */
/* 	data imach( 4) /    6 / */
/* 	data imach( 5) /   36 / */
/* 	data imach( 6) /    5 / */
/* 	data imach( 7) /    2 / */
/* 	data imach( 8) /   35 / */
/* 	data imach( 9) / "377777777777 / */
/* 	data imach(10) /    2 / */
/* 	data imach(11) /   27 / */
/* 	data imach(12) / -128 / */
/* 	data imach(13) /  127 / */
/* 	data imach(14) /   62 / */
/* 	data imach(15) / -128 / */
/* 	data imach(16) /  127 / */

/* 	machine constants for pdp-11 fortran supporting */
/* 	32-bit integer arithmetic. */

/* 	data imach( 1) /    5 / */
/* 	data imach( 2) /    6 / */
/* 	data imach( 3) /    5 / */
/* 	data imach( 4) /    6 / */
/* 	data imach( 5) /   32 / */
/* 	data imach( 6) /    4 / */
/* 	data imach( 7) /    2 / */
/* 	data imach( 8) /   31 / */
/* 	data imach( 9) / 2147483647 / */
/* 	data imach(10) /    2 / */
/* 	data imach(11) /   24 / */
/* 	data imach(12) / -127 / */
/* 	data imach(13) /  127 / */
/* 	data imach(14) /   56 / */
/* 	data imach(15) / -127 / */
/* 	data imach(16) /  127 / */

/* 	machine constants for pdp-11 fortran supporting */
/* 	16-bit integer arithmetic. */

/* 	data imach( 1) /    5 / */
/* 	data imach( 2) /    6 / */
/* 	data imach( 3) /    5 / */
/* 	data imach( 4) /    6 / */
/* 	data imach( 5) /   16 / */
/* 	data imach( 6) /    2 / */
/* 	data imach( 7) /    2 / */
/* 	data imach( 8) /   15 / */
/* 	data imach( 9) / 32767 / */
/* 	data imach(10) /    2 / */
/* 	data imach(11) /   24 / */
/* 	data imach(12) / -127 / */
/* 	data imach(13) /  127 / */
/* 	data imach(14) /   56 / */
/* 	data imach(15) / -127 / */
/* 	data imach(16) /  127 / */

/* 	machine constants for the univac 1100 series. */

/* 	note that the punch unit, i1mach(3), has been set to 7 */
/* 	which is appropriate for the univac-for system. */
/* 	if you have the univac-ftn system, set it to 1. */

/* 	data imach( 1) /    5 / */
/* 	data imach( 2) /    6 / */
/* 	data imach( 3) /    7 / */
/* 	data imach( 4) /    6 / */
/* 	data imach( 5) /   36 / */
/* 	data imach( 6) /    6 / */
/* 	data imach( 7) /    2 / */
/* 	data imach( 8) /   35 / */
/* 	data imach( 9) / o377777777777 / */
/* 	data imach(10) /    2 / */
/* 	data imach(11) /   27 / */
/* 	data imach(12) / -128 / */
/* 	data imach(13) /  127 / */
/* 	data imach(14) /   60 / */
/* 	data imach(15) /-1024 / */
/* 	data imach(16) / 1023 / */

/* 	machine constants for the vax-11 with */
/* 	fortran iv-plus compiler */


    if (*i < 1 || *i > 16) {
	goto L10;
    }

    ret_val = imach[*i - 1];
    return ret_val;

L10:
    io___3.ciunit = *output;
    s_wsfe(&io___3);
    e_wsfe();

    s_stop("", 0L);

} /* i1mach_ */

#undef output
#undef imach


