// modifier.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "modifier.h"
#include "controller.h"
#include "progressaction.h"

Modifier::Modifier() : _progressAction(nil) {}

Modifier::~Modifier() {
	Resource::unref_deferred(_progressAction);
}

Status 
Modifier::configure(Controller *controller) {
	Status status;
	if ((status = Super::configure(controller)) == Succeed) {
		_progressAction = controller->createProgressAction(message());
		_progressAction->ref();
	}
	return status;
}

int 
Modifier::showProgress(double theProgress) { 
	return (_progressAction) ? (*_progressAction)(theProgress) : true;
}

//********

ModifierChain::ModifierLink::ModifierLink(Modifier* m)
		: modifier(m), next(nil) {
}

ModifierChain::ModifierLink::~ModifierLink() {
	delete modifier;
}

//********

ModifierChain::ModifierChain(Modifier* m1, Modifier* m2, Modifier* m3)
		: list(nil) {
	list = new ModifierLink(m1);
	if (m2)
		list->next = new ModifierLink(m2);
	if (m3)
		list->next->next = new ModifierLink(m3);
}

ModifierChain::~ModifierChain() {
	for (ModifierLink* link = list; link != nil; ) {
		ModifierLink* next = link->next;
		delete link;
		link = next;
	}
}

Status
ModifierChain::configure(Controller *c) {
	if (!isConfigured()) {
		Status status = Fail;
		for (ModifierLink* link = list; link != nil; ) {
			status = link->modifier->configure(c);
			link = link->next;
			if(status != Succeed) break;
		}
		if (status == true)
			initialize();
	}
	return isConfigured() ? Succeed : Fail;
}

int
ModifierChain::apply() {
	int status = false;
	for (ModifierLink* link = list; link != nil; ) {
		status = link->modifier->apply();
		link = link->next;
		if (status != true) break;
	}
	return status;
}

// create reverse-order chain of reverse Modifiers

Modifier *
ModifierChain::createUndo() {
	Modifier* unDoer = nil;
	if (list != nil) {
		Modifier *m1, *m2 = nil, *m3 = nil;
		if (list->next) {
			if (list->next->next) {
				m1 = list->next->next->modifier->createUndo();
				m2 = list->next->modifier->createUndo();
				m3 = list->modifier->createUndo();
			}
			else {
				m1 = list->next->modifier->createUndo();
				m2 = list->modifier->createUndo();
				m3 = nil;
			}
		}
		else {
			m1 = list->modifier->createUndo();
		}
		unDoer = new ModifierChain(m1, m2, m3);
	}
	return unDoer;
}
