// phraser.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "phraser.h"
#include "envelope.h"
#include "valuerequester.h"

double Phraser::_savedGain = 1.0;

Phraser::Phraser(Data* output, Envelope *evp)
	: EnvelopeFunction(output, evp), _gain(_savedGain) {}

Phraser::Phraser(Data* output, Envelope *evp, double amp)
		: EnvelopeFunction(output, evp), _gain(amp) {
	initialize();
}

Requester *
Phraser::createRequester() {
	return new ValueRequester<double>(
		"Map Envelope onto Selected Region:",
		"Amplitude Factor for Envelope:",
		_gain
	);
}

void
Phraser::initialize() {
	if(_gain != 1.0)
		envelope->scaleSelf(_gain);
	Super::initialize();
}

void
Phraser::saveConfig() {
    _savedGain = _gain;	// store value
}

void 
Phraser::operator () (double *input, int count) {
    for (int n = 0; n < count; n++)
	input[n] *= envelope->next();
}
