unit UCESQLHighlighter;
 
// This file is machine-generated. Do not modify it manually.
 
interface
 
uses
  Classes, Graphics, UCEHighlighter;
 
const
  CR = #13;
  LF = #10;
 
// User defined start states and tokens.
 
 
const Normal = 2;
      MultilineComment = 4;
      EmbeddedCommand = 6;
 
 
const kwFirstKeyword = 257;
      kwADD = 257;
      kwALL = 258;
      kwALTER = 259;
      kwANALYZE = 260;
      kwAND = 261;
      kwAS = 262;
      kwASC = 263;
      kwASENSITIVE = 264;
      kwBEFORE = 265;
      kwBEGIN = 266;
      kwBETWEEN = 267;
      kwBIGINT = 268;
      kwBINARY = 269;
      kwBLOB = 270;
      kwBOTH = 271;
      kwBY = 272;
      kwCALL = 273;
      kwCASCADE = 274;
      kwCASE = 275;
      kwCHANGE = 276;
      kwCHAR = 277;
      kwCHARACTER = 278;
      kwCHECK = 279;
      kwCOLLATE = 280;
      kwCOLUMN = 281;
      kwCOLUMNS = 282;
      kwCONDITION = 283;
      kwCONNECTION = 284;
      kwCONSTRAINT = 285;
      kwCONTINUE = 286;
      kwCONVERT = 287;
      kwCREATE = 288;
      kwCROSS = 289;
      kwCURRENT_DATE = 290;
      kwCURRENT_TIME = 291;
      kwCURRENT_TIMESTAMP = 292;
      kwCURRENT_USER = 293;
      kwCURSOR = 294;
      kwDATABASE = 295;
      kwDATABASES = 296;
      kwDAY_HOUR = 297;
      kwDAY_MICROSECOND = 298;
      kwDAY_MINUTE = 299;
      kwDAY_SECOND = 300;
      kwDEC = 301;
      kwDECIMAL = 302;
      kwDECLARE = 303;
      kwDEFAULT = 304;
      kwDELAYED = 305;
      kwDELETE = 306;
      kwDESC = 307;
      kwDESCRIBE = 308;
      kwDETERMINISTIC = 309;
      kwDISTINCT = 310;
      kwDISTINCTROW = 311;
      kwDIV = 312;
      kwDOUBLE = 313;
      kwDROP = 314;
      kwDUAL = 315;
      kwEACH = 316;
      kwELSE = 317;
      kwELSEIF = 318;
      kwENCLOSED = 319;
      kwEND = 320;
      kwESCAPED = 321;
      kwEXISTS = 322;
      kwEXIT = 323;
      kwEXPLAIN = 324;
      kwFALSE = 325;
      kwFETCH = 326;
      kwFIELDS = 327;
      kwFLOAT = 328;
      kwFOR = 329;
      kwFORCE = 330;
      kwFOREIGN = 331;
      kwFOUND = 332;
      kwFROM = 333;
      kwFULLTEXT = 334;
      kwGOTO = 335;
      kwGRANT = 336;
      kwGROUP = 337;
      kwHAVING = 338;
      kwHIGH_PRIORITY = 339;
      kwHOUR_MICROSECOND = 340;
      kwHOUR_MINUTE = 341;
      kwHOUR_SECOND = 342;
      kwIF = 343;
      kwIGNORE = 344;
      kwIN = 345;
      kwINDEX = 346;
      kwINFILE = 347;
      kwINNER = 348;
      kwINOUT = 349;
      kwINSENSITIVE = 350;
      kwINSERT = 351;
      kwINT = 352;
      kwINTEGER = 353;
      kwINTERVAL = 354;
      kwINTO = 355;
      kwIS = 356;
      kwITERATE = 357;
      kwJOIN = 358;
      kwKEY = 359;
      kwKEYS = 360;
      kwKILL = 361;
      kwLEADING = 362;
      kwLEAVE = 363;
      kwLEFT = 364;
      kwLIKE = 365;
      kwLIMIT = 366;
      kwLINES = 367;
      kwLOAD = 368;
      kwLOCALTIME = 369;
      kwLOCALTIMESTAMP = 370;
      kwLOCK = 371;
      kwLONG = 372;
      kwLONGBLOB = 373;
      kwLONGTEXT = 374;
      kwLOOP = 375;
      kwLOW_PRIORITY = 376;
      kwMATCH = 377;
      kwMEDIUMBLOB = 378;
      kwMEDIUMINT = 379;
      kwMEDIUMTEXT = 380;
      kwMIDDLEINT = 381;
      kwMINUTE_MICROSECOND = 382;
      kwMINUTE_SECOND = 383;
      kwMOD = 384;
      kwNATURAL = 385;
      kwNOT = 386;
      kwNO_WRITE_TO_BINLOG = 387;
      kwNULL = 388;
      kwNUMERIC = 389;
      kwON = 390;
      kwOPTIMIZE = 391;
      kwOPTION = 392;
      kwOPTIONALLY = 393;
      kwOR = 394;
      kwORDER = 395;
      kwOUT = 396;
      kwOUTER = 397;
      kwOUTFILE = 398;
      kwPRECISION = 399;
      kwPRIMARY = 400;
      kwPRIVILEGES = 401;
      kwPROCEDURE = 402;
      kwPURGE = 403;
      kwREAD = 404;
      kwREAL = 405;
      kwREFERENCES = 406;
      kwREGEXP = 407;
      kwRENAME = 408;
      kwREPEAT = 409;
      kwREPLACE = 410;
      kwREQUIRE = 411;
      kwRESTRICT = 412;
      kwRETURN = 413;
      kwRETURNS = 414;
      kwREVOKE = 415;
      kwRIGHT = 416;
      kwRLIKE = 417;
      kwSCHEMA = 418;
      kwSCHEMAS = 419;
      kwSECOND_MICROSECOND = 420;
      kwSELECT = 421;
      kwSENSITIVE = 422;
      kwSEPARATOR = 423;
      kwSET = 424;
      kwSHOW = 425;
      kwSMALLINT = 426;
      kwSONAME = 427;
      kwSPATIAL = 428;
      kwSPECIFIC = 429;
      kwSQL = 430;
      kwSQLEXCEPTION = 431;
      kwSQLSTATE = 432;
      kwSQLWARNING = 433;
      kwSQL_BIG_RESULT = 434;
      kwSQL_CALC_FOUND_ROWS = 435;
      kwSQL_SMALL_RESULT = 436;
      kwSSL = 437;
      kwSTARTING = 438;
      kwSTRAIGHT_JOIN = 439;
      kwTABLE = 440;
      kwTABLES = 441;
      kwTERMINATED = 442;
      kwTHEN = 443;
      kwTINYBLOB = 444;
      kwTINYINT = 445;
      kwTINYTEXT = 446;
      kwTO = 447;
      kwTRAILING = 448;
      kwTRIGGER = 449;
      kwTRUE = 450;
      kwTRUNCATE = 451;
      kwUNDO = 452;
      kwUNION = 453;
      kwUNIQUE = 454;
      kwUNLOCK = 455;
      kwUNSIGNED = 456;
      kwUPDATE = 457;
      kwUSAGE = 458;
      kwUSE = 459;
      kwUSING = 460;
      kwUTC_DATE = 461;
      kwUTC_TIME = 462;
      kwUTC_TIMESTAMP = 463;
      kwVALUES = 464;
      kwVARBINARY = 465;
      kwVARCHAR = 466;
      kwVARCHARACTER = 467;
      kwVARYING = 468;
      kwWHEN = 469;
      kwWHERE = 470;
      kwWHILE = 471;
      kwWITH = 472;
      kwWRITE = 473;
      kwXOR = 474;
      kwYEAR_MONTH = 475;
      kwZEROFILL = 476;
      kwLastKeyword = 476;

const COMMENT_WITH_COMMAND = 477;
      EMBEDDED_COMMAND = 478;
      FLOATNUMBER = 479;
      IDENTIFIER = 480;
      INTEGERNUMBER = 481;
      KEYWORD = 482;
      MLCOMMENT = 483;
      SLCOMMENT = 484;
      STRINGCONSTANT = 485;
      SYMBOL = 486;
      SYSTEM_VARIABLE = 487;
      UNKNOWN = 488;
      USER_VARIABLE = 489;
      WHITESPACE = 490;


 
type
  TUCESQLHighlighter = class(TUCEHighlighter)
  private
    FCurrentToken: Integer;            // type of current token
    FInput: PChar;                     // input string to be tokenized
    FCurrentPos: Cardinal;             // current lexer position in FInput
    FTokenPos: Cardinal;               // current token position in FInput
    FLookahead: Char;                  // next char after current position
    FCurrentState,
    FStartState,
    FLineState: Cardinal;              // lexer states
    FLastChar: Char;                   // last matched char (#0 if no match)
    FPositions: array of Cardinal;     // for each rule the last marked position, zeroed when
                                       // rule has already been considered (allocated once)
    FMatchStack: array of Cardinal;    // stack containing matched rules (growing dynamically)
    FMatchCount: Integer;              // contains current number of matches
    FRejected: Boolean;                // current match rejected?
    FDoStop: Boolean;                  // token or eof found?
    FEOL: Boolean;
 
    FSystemVariableAttributes,
    FUserVariableAttributes,
    FCommentWithCOmmandAttributes,
    FEmbeddedCommandAttributes,
    FStringAttributes,
    FNumberAttributes,
    FKeyAttributes,
    FSymbolAttributes,
    FCommentAttributes,
    FIdentifierAttributes,
    FSpaceAttributes: THighlightAttributes;
    procedure RuleToToken(Rule: Integer);
    function IsKeyword: Boolean;
    function GetNextChar: Char;
    function MatchRule(var Rule: Integer): Boolean;
    function DoDefault: Boolean;
    function GetCurrentChar: Char;
    procedure SetAttribute(const Index: Integer; const Value: THighlightAttributes);
    procedure HighlightChange(Sender: TObject);
  protected
    procedure Reset; virtual;
    procedure SetMatch(I: Integer);
    procedure SetState(Value: Cardinal); virtual;
    procedure SetToken(Token: Integer);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
 
    function EOL: Boolean; override;
    function GetToken: string; override;
    function GetTokenInfo: TTokenData; override;
    procedure Next; override;
    procedure Reject;
    function GetAttribute(Index: Integer): THighlightAttributes; override;
    function GetAttributeCount: Integer; override;
    function GetIdentChars: TIdentChars; override;
    function GetLanguageName: string; override;
    function GetRange: Integer; override;
    procedure ResetRange; override;
    procedure SetRange(Value: Integer); override;
    procedure SetLine(const NewValue: string); override;
 
    property CurrentChar: Char read GetCurrentChar;
    property NextChar: Char read GetNextChar;
    property Lookahead: Char read FLookahead;
    property State: Cardinal read FCurrentState write SetState; // read to get current lexer state
                                                                // write to set start state for next run
    property TokenPosition: Cardinal read FTokenPos;
  published
    property CommentAttributes: THighlightAttributes index 1 read FCommentAttributes write SetAttribute;
    property CommentWithCommandAttributes: THighlightAttributes index 8 read FCommentWithCommandAttributes write SetAttribute;
    property EmbeddedCommandAttributes: THighlightAttributes index 7 read FEmbeddedCommandAttributes write SetAttribute;
    property IdentifierAttributes: THighlightAttributes index 2 read FIdentifierAttributes write SetAttribute;
    property KeyAttributes: THighlightAttributes index 3 read FKeyAttributes write SetAttribute;
    property NumberAttributes: THighlightAttributes index 4 read FNumberAttributes write SetAttribute;
    property SpaceAttributes: THighlightAttributes index 5 read FSpaceAttributes write SetAttribute;
    property StringAttributes: THighlightAttributes index 6 read FStringAttributes write SetAttribute;
    property SymbolAttributes: THighlightAttributes index 7 read FSymbolAttributes write SetAttribute;
    property SystemVariableAttributes: THighlightAttributes index 9 read FSystemVariableAttributes write SetAttribute;
    property UserVariableAttributes: THighlightAttributes index 10 read FuserVariableAttributes write SetAttribute;
  end;
 
//----------------------------------------------------------------------------------------------------------------------
 
implementation
 
uses
  SysUtils;
 
// DFA table

type TTransition = record
       CharClass : set of Char;
       NextState : Integer;
     end;

const
  MarkPositionCount = 43;
  MatchCount        = 43;
  TransitionCount   = 91;
  StateCount        = 46;

  MarkPositionTable : array[0..MarkPositionCount - 1] of Integer = (
    14, 14, 17, 0, 3, 16, 16, 2, 3, 16, 16, 16, 7, 16, 8, 16, 16, 10, 16, 16, 2, 
    16, 16, 12, 13, 14, 15, 0, 3, 1, 3, 3, 3, 5, 9, 11, 1, 3, 1, 4, 6, 1, 3);

  MatchTable : array [0..MatchCount - 1] of Integer = (
    14, 14, 17, 0, 3, 16, 16, 2, 3, 16, 16, 16, 7, 16, 8, 16, 16, 10, 16, 16, 2, 
    16, 16, 12, 13, 14, 15, 0, 3, 1, 3, 3, 3, 5, 9, 11, 1, 3, 1, 4, 6, 1, 3);

  TransitionTable : array [0..TransitionCount - 1] of TTransition = (
    (CharClass: [#0]; NextState: 8),
    (CharClass: [#0]; NextState: 8),
    (CharClass: [#0]; NextState: 8),
    (CharClass: [#1..#9, #11..' ']; NextState: 20),
    (CharClass: [#10]; NextState: 11),
    (CharClass: ['!', '%'..'&', '('..'*', ',', ':'..'?', '['..'^', '{'..#255]; NextState: 21),
    (CharClass: ['"']; NextState: 16),
    (CharClass: ['#']; NextState: 18),
    (CharClass: ['$', '.', 'A'..'Z', '_', 'a'..'z']; NextState: 12),
    (CharClass: ['''']; NextState: 15),
    (CharClass: ['+']; NextState: 10),
    (CharClass: ['-']; NextState: 17),
    (CharClass: ['/']; NextState: 19),
    (CharClass: ['0'..'9']; NextState: 9),
    (CharClass: ['@']; NextState: 14),
    (CharClass: ['`']; NextState: 13),
    (CharClass: [#0]; NextState: 8),
    (CharClass: [#1..#9, #11..' ']; NextState: 20),
    (CharClass: [#10]; NextState: 11),
    (CharClass: ['!', '%'..'&', '('..'*', ',', ':'..'?', '['..'^', '{'..#255]; NextState: 21),
    (CharClass: ['"']; NextState: 16),
    (CharClass: ['#']; NextState: 18),
    (CharClass: ['$', '.', 'A'..'Z', '_', 'a'..'z']; NextState: 12),
    (CharClass: ['''']; NextState: 15),
    (CharClass: ['+']; NextState: 10),
    (CharClass: ['-']; NextState: 17),
    (CharClass: ['/']; NextState: 19),
    (CharClass: ['0'..'9']; NextState: 9),
    (CharClass: ['@']; NextState: 14),
    (CharClass: ['`']; NextState: 13),
    (CharClass: [#0]; NextState: 8),
    (CharClass: [#1..')', '+'..#255]; NextState: 22),
    (CharClass: ['*']; NextState: 23),
    (CharClass: [#0]; NextState: 8),
    (CharClass: [#1..')', '+'..#255]; NextState: 22),
    (CharClass: ['*']; NextState: 23),
    (CharClass: [#0]; NextState: 8),
    (CharClass: [#1..')', '+'..#255]; NextState: 24),
    (CharClass: ['*']; NextState: 25),
    (CharClass: [#0]; NextState: 8),
    (CharClass: [#1..')', '+'..#255]; NextState: 24),
    (CharClass: ['*']; NextState: 25),
    (CharClass: ['$', 'A'..'D', 'F'..'Z', '_', 'a'..'d', 'f'..'z']; NextState: 29),
    (CharClass: ['.']; NextState: 27),
    (CharClass: ['0'..'9']; NextState: 26),
    (CharClass: ['E', 'e']; NextState: 28),
    (CharClass: ['0'..'9']; NextState: 30),
    (CharClass: [#1..' ']; NextState: 11),
    (CharClass: ['$', '.', '0'..'9', 'A'..'Z', '_', 'a'..'z']; NextState: 29),
    (CharClass: ['$', '.', '0'..'9', 'A'..'Z', '_', 'a'..'z']; NextState: 31),
    (CharClass: ['$', '.', '0'..'9', 'A'..'Z', '_', 'a'..'z']; NextState: 32),
    (CharClass: ['@']; NextState: 33),
    (CharClass: ['-']; NextState: 34),
    (CharClass: ['0'..'9']; NextState: 30),
    (CharClass: ['*']; NextState: 35),
    (CharClass: [#1..' ']; NextState: 11),
    (CharClass: [#1..')', '+'..#255]; NextState: 22),
    (CharClass: [#1..')', '+'..#255]; NextState: 24),
    (CharClass: ['$', 'A'..'D', 'F'..'Z', '_', 'a'..'d', 'f'..'z']; NextState: 29),
    (CharClass: ['.']; NextState: 27),
    (CharClass: ['0'..'9']; NextState: 26),
    (CharClass: ['E', 'e']; NextState: 28),
    (CharClass: ['$', '.', 'A'..'D', 'F'..'Z', '_', 'a'..'d', 'f'..'z']; NextState: 29),
    (CharClass: ['0'..'9']; NextState: 27),
    (CharClass: ['E', 'e']; NextState: 45),
    (CharClass: ['$', '.', 'A'..'Z', '_', 'a'..'z']; NextState: 29),
    (CharClass: ['+', '-']; NextState: 36),
    (CharClass: ['0'..'9']; NextState: 37),
    (CharClass: ['$', '.', '0'..'9', 'A'..'Z', '_', 'a'..'z']; NextState: 29),
    (CharClass: ['.']; NextState: 38),
    (CharClass: ['0'..'9']; NextState: 30),
    (CharClass: ['E', 'e']; NextState: 39),
    (CharClass: ['$', '.', '0'..'9', 'A'..'Z', '_', 'a'..'z']; NextState: 31),
    (CharClass: ['`']; NextState: 40),
    (CharClass: ['$', '.', '0'..'9', 'A'..'Z', '_', 'a'..'z']; NextState: 32),
    (CharClass: ['$', '.', '0'..'9', 'A'..'Z', '_', 'a'..'z']; NextState: 41),
    (CharClass: ['0'..'9']; NextState: 43),
    (CharClass: ['$', '.', 'A'..'Z', '_', 'a'..'z']; NextState: 29),
    (CharClass: ['0'..'9']; NextState: 37),
    (CharClass: ['0'..'9']; NextState: 38),
    (CharClass: ['E', 'e']; NextState: 44),
    (CharClass: ['+', '-']; NextState: 36),
    (CharClass: ['0'..'9']; NextState: 43),
    (CharClass: ['$', '.', '0'..'9', 'A'..'Z', '_', 'a'..'z']; NextState: 41),
    (CharClass: ['0'..'9']; NextState: 43),
    (CharClass: ['0'..'9']; NextState: 43),
    (CharClass: ['+', '-']; NextState: 42),
    (CharClass: ['0'..'9']; NextState: 43),
    (CharClass: ['$', '.', 'A'..'Z', '_', 'a'..'z']; NextState: 29),
    (CharClass: ['+', '-']; NextState: 42),
    (CharClass: ['0'..'9']; NextState: 37)
    );

  MarksLow : array [0..StateCount-1] of Integer = (
    0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 6, 7, 8, 10, 11, 12, 14, 16, 17, 19, 20, 22, 23, 
    24, 25, 26, 27, 29, 31, 32, 33, 33, 33, 34, 34, 35, 36, 36, 38, 39, 39, 40, 
    41, 41, 42, 42);

  MarksHigh : array [0..StateCount-1] of Integer = (
    -1, -1, -1, -1, -1, -1, 0, 1, 2, 5, 6, 7, 9, 10, 11, 13, 15, 16, 18, 19, 21, 
    22, 23, 24, 25, 26, 28, 30, 31, 32, 32, 32, 33, 33, 34, 35, 35, 37, 38, 38, 
    39, 40, 40, 41, 41, 42);

  MatchesLow : array [0..StateCount-1] of Integer = (
    0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 6, 7, 8, 10, 11, 12, 14, 16, 17, 19, 20, 22, 23, 
    24, 25, 26, 27, 29, 31, 32, 33, 33, 33, 34, 34, 35, 36, 36, 38, 39, 39, 40, 
    41, 41, 42, 42);

  MatchesHigh : array [0..StateCount-1] of Integer = (
    -1, -1, -1, -1, -1, -1, 0, 1, 2, 5, 6, 7, 9, 10, 11, 13, 15, 16, 18, 19, 21, 
    22, 23, 24, 25, 26, 28, 30, 31, 32, 32, 32, 33, 33, 34, 35, 35, 37, 38, 38, 
    39, 40, 40, 41, 41, 42);

  TransitionsLow : array [0..StateCount-1] of Integer = (
    0, 1, 2, 16, 30, 33, 36, 39, 42, 42, 46, 47, 48, 49, 50, 52, 52, 52, 54, 54, 
    55, 56, 56, 57, 57, 58, 58, 62, 65, 68, 69, 72, 74, 75, 76, 76, 76, 77, 79, 
    81, 83, 83, 84, 85, 86, 88);

  TransitionsHigh : array [0..StateCount-1] of Integer = (
    0, 1, 15, 29, 32, 35, 38, 41, 41, 45, 46, 47, 48, 49, 51, 51, 51, 53, 53, 54, 
    55, 55, 56, 56, 57, 57, 61, 64, 67, 68, 71, 73, 74, 75, 75, 75, 76, 78, 80, 
    82, 82, 83, 84, 85, 87, 90);

type // keyword table support
     TKeyword = record
       Keyword: String;
       Token: Integer;
     end;

const KeywordCount = 220;
      Keywords : array[0..KeywordCount - 1] of TKeyword = (
        (Keyword: 'ADD'; Token: kwADD), 
        (Keyword: 'ALL'; Token: kwALL), 
        (Keyword: 'ALTER'; Token: kwALTER), 
        (Keyword: 'ANALYZE'; Token: kwANALYZE), 
        (Keyword: 'AND'; Token: kwAND), 
        (Keyword: 'AS'; Token: kwAS), 
        (Keyword: 'ASC'; Token: kwASC), 
        (Keyword: 'ASENSITIVE'; Token: kwASENSITIVE), 
        (Keyword: 'BEFORE'; Token: kwBEFORE), 
        (Keyword: 'BEGIN'; Token: kwBEGIN), 
        (Keyword: 'BETWEEN'; Token: kwBETWEEN), 
        (Keyword: 'BIGINT'; Token: kwBIGINT), 
        (Keyword: 'BINARY'; Token: kwBINARY), 
        (Keyword: 'BLOB'; Token: kwBLOB), 
        (Keyword: 'BOTH'; Token: kwBOTH), 
        (Keyword: 'BY'; Token: kwBY), 
        (Keyword: 'CALL'; Token: kwCALL), 
        (Keyword: 'CASCADE'; Token: kwCASCADE), 
        (Keyword: 'CASE'; Token: kwCASE), 
        (Keyword: 'CHANGE'; Token: kwCHANGE), 
        (Keyword: 'CHAR'; Token: kwCHAR), 
        (Keyword: 'CHARACTER'; Token: kwCHARACTER), 
        (Keyword: 'CHECK'; Token: kwCHECK), 
        (Keyword: 'COLLATE'; Token: kwCOLLATE), 
        (Keyword: 'COLUMN'; Token: kwCOLUMN), 
        (Keyword: 'COLUMNS'; Token: kwCOLUMNS), 
        (Keyword: 'CONDITION'; Token: kwCONDITION), 
        (Keyword: 'CONNECTION'; Token: kwCONNECTION), 
        (Keyword: 'CONSTRAINT'; Token: kwCONSTRAINT), 
        (Keyword: 'CONTINUE'; Token: kwCONTINUE), 
        (Keyword: 'CONVERT'; Token: kwCONVERT), 
        (Keyword: 'CREATE'; Token: kwCREATE), 
        (Keyword: 'CROSS'; Token: kwCROSS), 
        (Keyword: 'CURRENT_DATE'; Token: kwCURRENT_DATE), 
        (Keyword: 'CURRENT_TIME'; Token: kwCURRENT_TIME), 
        (Keyword: 'CURRENT_TIMESTAMP'; Token: kwCURRENT_TIMESTAMP), 
        (Keyword: 'CURRENT_USER'; Token: kwCURRENT_USER), 
        (Keyword: 'CURSOR'; Token: kwCURSOR), 
        (Keyword: 'DATABASE'; Token: kwDATABASE), 
        (Keyword: 'DATABASES'; Token: kwDATABASES), 
        (Keyword: 'DAY_HOUR'; Token: kwDAY_HOUR), 
        (Keyword: 'DAY_MICROSECOND'; Token: kwDAY_MICROSECOND), 
        (Keyword: 'DAY_MINUTE'; Token: kwDAY_MINUTE), 
        (Keyword: 'DAY_SECOND'; Token: kwDAY_SECOND), 
        (Keyword: 'DEC'; Token: kwDEC), 
        (Keyword: 'DECIMAL'; Token: kwDECIMAL), 
        (Keyword: 'DECLARE'; Token: kwDECLARE), 
        (Keyword: 'DEFAULT'; Token: kwDEFAULT), 
        (Keyword: 'DELAYED'; Token: kwDELAYED), 
        (Keyword: 'DELETE'; Token: kwDELETE), 
        (Keyword: 'DESC'; Token: kwDESC), 
        (Keyword: 'DESCRIBE'; Token: kwDESCRIBE), 
        (Keyword: 'DETERMINISTIC'; Token: kwDETERMINISTIC), 
        (Keyword: 'DISTINCT'; Token: kwDISTINCT), 
        (Keyword: 'DISTINCTROW'; Token: kwDISTINCTROW), 
        (Keyword: 'DIV'; Token: kwDIV), 
        (Keyword: 'DOUBLE'; Token: kwDOUBLE), 
        (Keyword: 'DROP'; Token: kwDROP), 
        (Keyword: 'DUAL'; Token: kwDUAL), 
        (Keyword: 'EACH'; Token: kwEACH), 
        (Keyword: 'ELSE'; Token: kwELSE), 
        (Keyword: 'ELSEIF'; Token: kwELSEIF), 
        (Keyword: 'ENCLOSED'; Token: kwENCLOSED), 
        (Keyword: 'END'; Token: kwEND), 
        (Keyword: 'ESCAPED'; Token: kwESCAPED), 
        (Keyword: 'EXISTS'; Token: kwEXISTS), 
        (Keyword: 'EXIT'; Token: kwEXIT), 
        (Keyword: 'EXPLAIN'; Token: kwEXPLAIN), 
        (Keyword: 'FALSE'; Token: kwFALSE), 
        (Keyword: 'FETCH'; Token: kwFETCH), 
        (Keyword: 'FIELDS'; Token: kwFIELDS), 
        (Keyword: 'FLOAT'; Token: kwFLOAT), 
        (Keyword: 'FOR'; Token: kwFOR), 
        (Keyword: 'FORCE'; Token: kwFORCE), 
        (Keyword: 'FOREIGN'; Token: kwFOREIGN), 
        (Keyword: 'FOUND'; Token: kwFOUND), 
        (Keyword: 'FROM'; Token: kwFROM), 
        (Keyword: 'FULLTEXT'; Token: kwFULLTEXT), 
        (Keyword: 'GOTO'; Token: kwGOTO), 
        (Keyword: 'GRANT'; Token: kwGRANT), 
        (Keyword: 'GROUP'; Token: kwGROUP), 
        (Keyword: 'HAVING'; Token: kwHAVING), 
        (Keyword: 'HIGH_PRIORITY'; Token: kwHIGH_PRIORITY), 
        (Keyword: 'HOUR_MICROSECOND'; Token: kwHOUR_MICROSECOND), 
        (Keyword: 'HOUR_MINUTE'; Token: kwHOUR_MINUTE), 
        (Keyword: 'HOUR_SECOND'; Token: kwHOUR_SECOND), 
        (Keyword: 'IF'; Token: kwIF), 
        (Keyword: 'IGNORE'; Token: kwIGNORE), 
        (Keyword: 'IN'; Token: kwIN), 
        (Keyword: 'INDEX'; Token: kwINDEX), 
        (Keyword: 'INFILE'; Token: kwINFILE), 
        (Keyword: 'INNER'; Token: kwINNER), 
        (Keyword: 'INOUT'; Token: kwINOUT), 
        (Keyword: 'INSENSITIVE'; Token: kwINSENSITIVE), 
        (Keyword: 'INSERT'; Token: kwINSERT), 
        (Keyword: 'INT'; Token: kwINT), 
        (Keyword: 'INTEGER'; Token: kwINTEGER), 
        (Keyword: 'INTERVAL'; Token: kwINTERVAL), 
        (Keyword: 'INTO'; Token: kwINTO), 
        (Keyword: 'IS'; Token: kwIS), 
        (Keyword: 'ITERATE'; Token: kwITERATE), 
        (Keyword: 'JOIN'; Token: kwJOIN), 
        (Keyword: 'KEY'; Token: kwKEY), 
        (Keyword: 'KEYS'; Token: kwKEYS), 
        (Keyword: 'KILL'; Token: kwKILL), 
        (Keyword: 'LEADING'; Token: kwLEADING), 
        (Keyword: 'LEAVE'; Token: kwLEAVE), 
        (Keyword: 'LEFT'; Token: kwLEFT), 
        (Keyword: 'LIKE'; Token: kwLIKE), 
        (Keyword: 'LIMIT'; Token: kwLIMIT), 
        (Keyword: 'LINES'; Token: kwLINES), 
        (Keyword: 'LOAD'; Token: kwLOAD), 
        (Keyword: 'LOCALTIME'; Token: kwLOCALTIME), 
        (Keyword: 'LOCALTIMESTAMP'; Token: kwLOCALTIMESTAMP), 
        (Keyword: 'LOCK'; Token: kwLOCK), 
        (Keyword: 'LONG'; Token: kwLONG), 
        (Keyword: 'LONGBLOB'; Token: kwLONGBLOB), 
        (Keyword: 'LONGTEXT'; Token: kwLONGTEXT), 
        (Keyword: 'LOOP'; Token: kwLOOP), 
        (Keyword: 'LOW_PRIORITY'; Token: kwLOW_PRIORITY), 
        (Keyword: 'MATCH'; Token: kwMATCH), 
        (Keyword: 'MEDIUMBLOB'; Token: kwMEDIUMBLOB), 
        (Keyword: 'MEDIUMINT'; Token: kwMEDIUMINT), 
        (Keyword: 'MEDIUMTEXT'; Token: kwMEDIUMTEXT), 
        (Keyword: 'MIDDLEINT'; Token: kwMIDDLEINT), 
        (Keyword: 'MINUTE_MICROSECOND'; Token: kwMINUTE_MICROSECOND), 
        (Keyword: 'MINUTE_SECOND'; Token: kwMINUTE_SECOND), 
        (Keyword: 'MOD'; Token: kwMOD), 
        (Keyword: 'NATURAL'; Token: kwNATURAL), 
        (Keyword: 'NOT'; Token: kwNOT), 
        (Keyword: 'NO_WRITE_TO_BINLOG'; Token: kwNO_WRITE_TO_BINLOG), 
        (Keyword: 'NULL'; Token: kwNULL), 
        (Keyword: 'NUMERIC'; Token: kwNUMERIC), 
        (Keyword: 'ON'; Token: kwON), 
        (Keyword: 'OPTIMIZE'; Token: kwOPTIMIZE), 
        (Keyword: 'OPTION'; Token: kwOPTION), 
        (Keyword: 'OPTIONALLY'; Token: kwOPTIONALLY), 
        (Keyword: 'OR'; Token: kwOR), 
        (Keyword: 'ORDER'; Token: kwORDER), 
        (Keyword: 'OUT'; Token: kwOUT), 
        (Keyword: 'OUTER'; Token: kwOUTER), 
        (Keyword: 'OUTFILE'; Token: kwOUTFILE), 
        (Keyword: 'PRECISION'; Token: kwPRECISION), 
        (Keyword: 'PRIMARY'; Token: kwPRIMARY), 
        (Keyword: 'PRIVILEGES'; Token: kwPRIVILEGES), 
        (Keyword: 'PROCEDURE'; Token: kwPROCEDURE), 
        (Keyword: 'PURGE'; Token: kwPURGE), 
        (Keyword: 'READ'; Token: kwREAD), 
        (Keyword: 'REAL'; Token: kwREAL), 
        (Keyword: 'REFERENCES'; Token: kwREFERENCES), 
        (Keyword: 'REGEXP'; Token: kwREGEXP), 
        (Keyword: 'RENAME'; Token: kwRENAME), 
        (Keyword: 'REPEAT'; Token: kwREPEAT), 
        (Keyword: 'REPLACE'; Token: kwREPLACE), 
        (Keyword: 'REQUIRE'; Token: kwREQUIRE), 
        (Keyword: 'RESTRICT'; Token: kwRESTRICT), 
        (Keyword: 'RETURN'; Token: kwRETURN), 
        (Keyword: 'RETURNS'; Token: kwRETURNS), 
        (Keyword: 'REVOKE'; Token: kwREVOKE), 
        (Keyword: 'RIGHT'; Token: kwRIGHT), 
        (Keyword: 'RLIKE'; Token: kwRLIKE), 
        (Keyword: 'SCHEMA'; Token: kwSCHEMA), 
        (Keyword: 'SCHEMAS'; Token: kwSCHEMAS), 
        (Keyword: 'SECOND_MICROSECOND'; Token: kwSECOND_MICROSECOND), 
        (Keyword: 'SELECT'; Token: kwSELECT), 
        (Keyword: 'SENSITIVE'; Token: kwSENSITIVE), 
        (Keyword: 'SEPARATOR'; Token: kwSEPARATOR), 
        (Keyword: 'SET'; Token: kwSET), 
        (Keyword: 'SHOW'; Token: kwSHOW), 
        (Keyword: 'SMALLINT'; Token: kwSMALLINT), 
        (Keyword: 'SONAME'; Token: kwSONAME), 
        (Keyword: 'SPATIAL'; Token: kwSPATIAL), 
        (Keyword: 'SPECIFIC'; Token: kwSPECIFIC), 
        (Keyword: 'SQL'; Token: kwSQL), 
        (Keyword: 'SQLEXCEPTION'; Token: kwSQLEXCEPTION), 
        (Keyword: 'SQLSTATE'; Token: kwSQLSTATE), 
        (Keyword: 'SQLWARNING'; Token: kwSQLWARNING), 
        (Keyword: 'SQL_BIG_RESULT'; Token: kwSQL_BIG_RESULT), 
        (Keyword: 'SQL_CALC_FOUND_ROWS'; Token: kwSQL_CALC_FOUND_ROWS), 
        (Keyword: 'SQL_SMALL_RESULT'; Token: kwSQL_SMALL_RESULT), 
        (Keyword: 'SSL'; Token: kwSSL), 
        (Keyword: 'STARTING'; Token: kwSTARTING), 
        (Keyword: 'STRAIGHT_JOIN'; Token: kwSTRAIGHT_JOIN), 
        (Keyword: 'TABLE'; Token: kwTABLE), 
        (Keyword: 'TABLES'; Token: kwTABLES), 
        (Keyword: 'TERMINATED'; Token: kwTERMINATED), 
        (Keyword: 'THEN'; Token: kwTHEN), 
        (Keyword: 'TINYBLOB'; Token: kwTINYBLOB), 
        (Keyword: 'TINYINT'; Token: kwTINYINT), 
        (Keyword: 'TINYTEXT'; Token: kwTINYTEXT), 
        (Keyword: 'TO'; Token: kwTO), 
        (Keyword: 'TRAILING'; Token: kwTRAILING), 
        (Keyword: 'TRIGGER'; Token: kwTRIGGER), 
        (Keyword: 'TRUE'; Token: kwTRUE), 
        (Keyword: 'TRUNCATE'; Token: kwTRUNCATE), 
        (Keyword: 'UNDO'; Token: kwUNDO), 
        (Keyword: 'UNION'; Token: kwUNION), 
        (Keyword: 'UNIQUE'; Token: kwUNIQUE), 
        (Keyword: 'UNLOCK'; Token: kwUNLOCK), 
        (Keyword: 'UNSIGNED'; Token: kwUNSIGNED), 
        (Keyword: 'UPDATE'; Token: kwUPDATE), 
        (Keyword: 'USAGE'; Token: kwUSAGE), 
        (Keyword: 'USE'; Token: kwUSE), 
        (Keyword: 'USING'; Token: kwUSING), 
        (Keyword: 'UTC_DATE'; Token: kwUTC_DATE), 
        (Keyword: 'UTC_TIME'; Token: kwUTC_TIME), 
        (Keyword: 'UTC_TIMESTAMP'; Token: kwUTC_TIMESTAMP), 
        (Keyword: 'VALUES'; Token: kwVALUES), 
        (Keyword: 'VARBINARY'; Token: kwVARBINARY), 
        (Keyword: 'VARCHAR'; Token: kwVARCHAR), 
        (Keyword: 'VARCHARACTER'; Token: kwVARCHARACTER), 
        (Keyword: 'VARYING'; Token: kwVARYING), 
        (Keyword: 'WHEN'; Token: kwWHEN), 
        (Keyword: 'WHERE'; Token: kwWHERE), 
        (Keyword: 'WHILE'; Token: kwWHILE), 
        (Keyword: 'WITH'; Token: kwWITH), 
        (Keyword: 'WRITE'; Token: kwWRITE), 
        (Keyword: 'XOR'; Token: kwXOR), 
        (Keyword: 'YEAR_MONTH'; Token: kwYEAR_MONTH), 
        (Keyword: 'ZEROFILL'; Token: kwZEROFILL)
);

function GetKeywordToken(const S: String): Integer;

// internal search function for keywords

var L, R, K : Integer;
    Res     : Integer;

begin
  Result := 0;

  // binary search
  L := 0;
  R := KeywordCount - 1;
  while L <= R do
  begin
    K := L + (R - L) div 2;
    Res := CompareText(S, Keywords[K].Keyword);
    if Res = 0 then
    begin
      Result := Keywords[K].Token;
      Break;
    end
    else
      if Res > 0 then L := K + 1
                 else R := K - 1;
  end;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
constructor TUCESQLHighlighter.Create(AOwner: TComponent);
 
begin
  inherited;
  // allocate positions array (length is highest possible mark position)
  SetLength(FPositions, MarksHigh[StateCount - 1] + 1);
 
  FCommentAttributes := THighlightAttributes.Create('comment');
  FCommentAttributes.Style := [fsItalic];
  FIdentifierAttributes := THighlightAttributes.Create('identifier');
  FKeyAttributes := THighlightAttributes.Create('reserved word');
  FKeyAttributes.Style := [fsBold];
  FNumberAttributes := THighlightAttributes.Create('number');
  FSpaceAttributes := THighlightAttributes.Create('space');
  FStringAttributes := THighlightAttributes.Create('String');
  FSymbolAttributes := THighlightAttributes.Create('symbol');
  FCommentWithCommandAttributes := THighlightAttributes.Create('comment with command');
  FEmbeddedCommandAttributes := THighlightAttributes.Create('embedded command');
  FSystemVariableAttributes := THighlightAttributes.Create('system variable');
  FUserVariableAttributes := THighlightAttributes.Create('user variable');
 
  FCommentAttributes.Onchange := HighlightChange;
  FIdentifierAttributes.Onchange := HighlightChange;
  FKeyAttributes.Onchange := HighlightChange;
  FNumberAttributes.Onchange := HighlightChange;
  FSpaceAttributes.Onchange := HighlightChange;
  FStringAttributes.Onchange := HighlightChange;
  FSymbolAttributes.Onchange := HighlightChange;
  FCommentWithCommandAttributes.Onchange := HighlightChange;
  FEmbeddedCommandAttributes.Onchange := HighlightChange;
  FSystemVariableAttributes.Onchange := HighlightChange;
  FUserVariableAttributes.Onchange := HighlightChange;
 
  DefaultFilter := 'SQL script files (*.sql)|*.sql';
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
destructor TUCESQLHighlighter.Destroy;
 
begin
  FPositions := nil;
  FMatchStack := nil;
  FCommentAttributes.Free;
  FIdentifierAttributes.Free;
  FKeyAttributes.Free;
  FNumberAttributes.Free;
  FSpaceAttributes.Free;
  FStringAttributes.Free;
  FSymbolAttributes.Free;
  FCommentWithCommandAttributes.Free;
  FEmbeddedCommandAttributes.Free;
  FSystemVariableAttributes.Free;
  FUserVariableAttributes.Free;
 
  inherited;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
function TUCESQLHighlighter.IsKeyword: Boolean;
 
// checks whether the current token is a keyword,
// if so then the current token type is set accordingly
 
var
  Word: string;
 
begin
  SetString(Word, FInput + FTokenPos, FCurrentPos - FTokenPos);
  FCurrentToken := GetKeywordToken(Word);
  if FCurrentToken > 0 then
  begin
    Result := True;
    FDoStop := True;
  end
  else
    Result := False;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
function TUCESQLHighlighter.EOL: Boolean;
 
begin
  Result := (FCurrentToken = -1) or FEOL;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
function TUCESQLHighlighter.GetToken: string;
 
var
  Len: Cardinal;
 
begin
  Len := FCurrentPos - FTokenPos;
  SetString(Result, FInput + FTokenPos, Len);
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
procedure TUCESQLHighlighter.Reset;
 
begin
  FTokenPos := 0;
  FCurrentPos := 0;
  FCurrentToken := 0;
  FLineState := 1;
  FLastChar := #0;
  FMatchCount := 0;
  FEOL := False;
  ResetRange;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
procedure TUCESQLHighlighter.SetToken(Token: Integer);
 
begin
  FCurrentToken := Token;
  FDoStop := True;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
procedure TUCESQLHighlighter.RuleToToken(Rule: Integer);
 
begin
  case Rule of
    // <Normal>integer
      0: 
        SetToken(INTEGERNUMBER);
       
    // <Normal>realinteger
      1: 
        SetToken(FLOATNUMBER);
       
    // <Normal>white+
      2: 
        SetToken(WHITESPACE);
       
    // <Normal>identifier
      3: 
        if IsKeyword then
          SetToken(KEYWORD)
        else
          SetToken(IDENTIFIER);
       
    // <Normal>`identifier`
      4: 
        if IsKeyword then
          SetToken(KEYWORD)
        else
          SetToken(IDENTIFIER);
       
    // <Normal>@identifier
      5: 
        SetToken(USER_VARIABLE);
       
    // <Normal>@@identifier
      6: 
        SetToken(SYSTEM_VARIABLE);
       
    // <Normal>'
      7: 
        repeat
          case CurrentChar of
            '''',
            CR, #0 :
              begin
                if CurrentChar = '''' then
                  NextChar;
                SetToken(STRINGCONSTANT);
                Break;
              end;
            '\': // Escape character, skip this and the next one.
              NextChar;
          end;
          NextChar;
        until False;
       
    // <Normal>\"
      8: 
        repeat
          case CurrentChar of
            '"',
            CR, #0 :
              begin
                if CurrentChar = '"' then
                  NextChar;
                SetToken(STRINGCONSTANT);
                Break;
              end;
            '\': // Escape character, skip this and the next one.
              NextChar;
          end;
          NextChar;
        until False;
       
    // <Normal>"--"
      9: 
        if CurrentChar in [CR, #0, ' '] then
        begin
          SetToken(SLCOMMENT);
          if CurrentChar = ' ' then
            repeat
              case CurrentChar of
                CR, #0:
                  begin
                    SetToken(SLCOMMENT);
                    Break;
                  end;
              end;
              NextChar;
            until False;
        end
        else
          SetToken(SYMBOL);
       
    // <Normal>"#"
      10: 
        repeat
          case CurrentChar of
            CR, #0:
              begin
                SetToken(SLCOMMENT);
                Break;
              end;
            end;
          NextChar;
        until False;
       
    // <Normal>"/*"
      11: 
        repeat
          case CurrentChar of
            '*':
              if Lookahead = '/' then
              begin
                // skip lookahead and break loop
                NextChar;
                NextChar;
                SetToken(MLCOMMENT);
                Break;
              end;
            #0:
              begin
                State := MultilineComment;
                SetToken(MLCOMMENT);
                Break;
              end;
            '!': // Very special syntax for MySQL: command in comment.
              begin
                State := EmbeddedCommand;
                SetToken(COMMENT_WITH_COMMAND);
                Break;
              end;
          end;
          NextChar;
        until False;
       
    // <MultilineComment>[^\*]+
      12: 
        SetToken(MLCOMMENT);
       
    // <MultilineComment>\*
      13: 
        begin
          SetToken(MLCOMMENT);
          if CurrentChar = '/' then
          begin
            NextChar;
            State := Normal;
          end;
        end;
       
    // <EmbeddedCommand>[^\*]*
      14: 
        SetToken(EMBEDDED_COMMAND);
       
    // <EmbeddedCommand>\*
      15: 
        begin
          if CurrentChar = '/' then
          begin
            SetToken(COMMENT_WITH_COMMAND);
            NextChar;
            State := Normal;
          end
          else
            SetToken(EMBEDDED_COMMAND);
        end;
       
    // <Normal>.
      16: 
        SetToken(SYMBOL); // Any other char not catchd before.
       
    // eof
      17: 
        SetToken(-1); // Special token to mark input end. Not really necessary since EOI is catched automatically.
  end;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
function TUCESQLHighlighter.MatchRule(var Rule: Integer): Boolean;
 
// finds the last match and the corresponding marked position and adjusts
// the matched string accordingly;
// returns:
// - True if a rule has been matched, False otherwise
// - Rule: the number of the matched rule
 
begin
  FRejected := False;
  while (FMatchCount > 0) and (FPositions[FMatchStack[FMatchCount - 1]] = 0) do
    Dec(FMatchCount);
 
  if FMatchCount > 0 then
  begin
    Rule := FMatchStack[FMatchCount - 1];
    FCurrentPos := FTokenPos + FPositions[Rule];
    FPositions[Rule] := 0;
    if (FCurrentPos - FTokenPos) > 0 then
      FLastChar := FInput[FCurrentPos]
    else
      FLastChar := #0;
    Result := True;
  end
  else
  begin
    // return position to starting point
    FCurrentPos := FTokenPos;
    FLastChar := #0;
    Result := False;
  end
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
function TUCESQLHighlighter.DoDefault: Boolean;
 
begin
  FRejected := False;
  if NextChar <> #0 then
    Result := True
  else
  begin
    FLineState := 1;
    Result := False;
  end;
  if not FEOL then
    FLastChar := FInput[FCurrentPos];
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
procedure TUCESQLHighlighter.Next;
 
// scans for the next token and determines its kind (FCurrentToken and FTokenPos
// are set appropriately)
 
var
  I: Integer;
  Len: Cardinal;
  Matched: Boolean;
 
begin
  FDoStop := False;
 
  repeat
    // initialize run
    FTokenPos := FCurrentPos;
 
    if FLastChar <> #0 then
      if FLastChar = LF then
        FLineState := 1
      else
        FLineState := 0;
    FCurrentState := FStartState + FLineState;
 
    repeat // character scan loop
      // mark positions and matches
      Len := FCurrentPos - FTokenPos;
      for I := MarksLow[FCurrentState] to MarksHigh[FCurrentState] do
        FPositions[MarkPositionTable[I]] := Len;
      for I := MatchesHigh[FCurrentState] downto MatchesLow[FCurrentState] do
        SetMatch(MatchTable[I]);
 
      if TransitionsLow[FCurrentState] > TransitionsHigh[FCurrentState] then
        Break; // dead state, do action
 
      // determine action
      I := TransitionsLow[FCurrentState];
      while (I <= TransitionsHigh[FCurrentState]) and not (FInput[FCurrentPos] in TransitionTable[I].CharClass) do
        Inc(I);
 
      if I > TransitionsHigh[FCurrentState] then
        Break; // no transition on current char in this state
 
      // get next character
      NextChar;
 
      // switch to new state
      FCurrentState := TransitionTable[I].NextState;
 
    until False;
 
    repeat
      Matched := MatchRule(I);
      if Matched then
        RuleToToken(I)
      else
        Break;
      // FRejected can be set in RuleToToken by calling Reject
    until Matched and not FRejected;
 
    if not (Matched or DoDefault) then
    begin
      FStartState := Normal;
      FLineState := 1;
      FLastChar := #0;
      SetToken(0);
    end;
  until FDoStop;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
procedure TUCESQLHighlighter.SetLine(const NewValue: string);
 
begin
  FInput := PChar(NewValue);
  Reset;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
function TUCESQLHighlighter.GetNextChar: Char;
 
begin
  if not FEOL and (FInput[FCurrentPos] = #0) then
    FEOL := True;
  Inc(FCurrentPos);
  if not FEOL then
  begin
    FLookahead := FInput[FCurrentPos + 1];
    Result := FInput[FCurrentPos];
  end
  else
    Result := #0;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
procedure TUCESQLHighlighter.SetState(Value: Cardinal);
 
begin
  FStartState := Value;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
procedure TUCESQLHighlighter.SetMatch(I: Integer);
 
begin
  if FMatchCount >= Length(FMatchStack) then
    SetLength(FMatchStack, FMatchCount + 1);
  FMatchStack[FMatchCount] := I;
  Inc(FMatchCount);
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
procedure TUCESQLHighlighter.Reject;
 
begin
  FRejected := True;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
function TUCESQLHighlighter.GetTokenInfo: TTokenData;
 
// Returns token string, token position relative to entire input string, and token length in one call.
 
begin
  FillChar(Result, SizeOf(Result), 0);
  with Result do
  begin
    if FEOL then
    begin
      Token := StrEnd(FInput);
      Length := Token - FInput - Integer(FTokenPos);
    end
    else
    begin
      Token := FInput + FTokenPos;
      Length := FCurrentPos - FTokenPos;
    end;
    TokenType := FCurrentToken;
    Position := FTokenPos;
 
    case FCurrentToken of
      SLCOMMENT,
      MLCOMMENT:
        begin
          Background := ColorToRGB(FCommentAttributes.Background);
          Foreground := ColorToRGB(FCommentAttributes.Foreground);
          Style := FCommentAttributes.Style;
        end;
      IDENTIFIER:
        begin
          Background := ColorToRGB(FIdentifierAttributes.Background);
          Foreground := ColorToRGB(FIdentifierAttributes.Foreground);
          Style := FIdentifierAttributes.Style;
        end;
      KEYWORD:
        begin
          Background := ColorToRGB(FKeyAttributes.Background);
          Foreground := ColorToRGB(FKeyAttributes.Foreground);
          Style := FKeyAttributes.Style;
        end;
      FLOATNUMBER,
      INTEGERNUMBER:
        begin
          Background := ColorToRGB(FNumberAttributes.Background);
          Foreground := ColorToRGB(FNumberAttributes.Foreground);
          Style := FNumberAttributes.Style;
        end;
      WHITESPACE:
        begin
          Background := ColorToRGB(FSpaceAttributes.Background);
          Foreground := ColorToRGB(FSpaceAttributes.Foreground);
          Style := FSpaceAttributes.Style;
        end;
      STRINGCONSTANT:
        begin
          Background := ColorToRGB(FStringAttributes.Background);
          Foreground := ColorToRGB(FStringAttributes.Foreground);
          Style := FStringAttributes.Style;
        end;
      SYMBOL:
        begin
          Background := ColorToRGB(FSymbolAttributes.Background);
          Foreground := ColorToRGB(FSymbolAttributes.Foreground);
          Style := FSymbolAttributes.Style;
        end;
      COMMENT_WITH_COMMAND:
        begin
          Background := ColorToRGB(FCommentWithCommandAttributes.Background);
          Foreground := ColorToRGB(FCommentWithCommandAttributes.Foreground);
          Style := FEmbeddedCommandAttributes.Style;
        end;
      EMBEDDED_COMMAND:
        begin
          Background := ColorToRGB(FEmbeddedCommandAttributes.Background);
          Foreground := ColorToRGB(FEmbeddedCommandAttributes.Foreground);
          Style := FEmbeddedCommandAttributes.Style;
        end;
      SYSTEM_VARIABLE:
        begin
          Background := ColorToRGB(FSystemVariableAttributes.Background);
          Foreground := ColorToRGB(FSystemVariableAttributes.Foreground);
          Style := FSystemVariableAttributes.Style;
        end;
      USER_VARIABLE:
        begin
          Background := ColorToRGB(FUserVariableAttributes.Background);
          Foreground := ColorToRGB(FUserVariableAttributes.Foreground);
          Style := FUserVariableAttributes.Style;
        end;
    end;
  end;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
function TUCESQLHighlighter.GetCurrentChar: Char;
 
begin
  Result := FInput[FCurrentPos];
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
procedure TUCESQLHighlighter.HighlightChange(Sender: TObject);
 
begin
  WindowList.Invalidate;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
function TUCESQLHighlighter.GetIdentChars: TIdentChars;
 
begin
  Result := ['_', '0'..'9', 'a'..'z', 'A'..'Z'];
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
function TUCESQLHighlighter.GetAttributeCount: Integer;
 
begin
  Result := 7;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
function TUCESQLHighlighter.GetAttribute(Index: Integer): THighlightAttributes;
 
begin
  case Index of
    0:
      Result := FCommentAttributes;
    1:
      Result := FIdentifierAttributes;
    2:
      Result := FNumberAttributes;
    3:
      Result := FKeyAttributes;
    4:
      Result := FSpaceAttributes;
    5:
      Result := FStringAttributes;
    6:
      Result := FSymbolAttributes;
    7:
      Result := FEmbeddedCommandAttributes;
    8:
      Result := FCommentWithCommandAttributes;
    9:
      Result := FSystemVariableAttributes;
    10:
      Result := FUserVariableAttributes;
  else
    Result := nil;
  end;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
function TUCESQLHighlighter.GetLanguageName: string;
 
begin
  Result := 'SQL';
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
procedure TUCESQLHighlighter.SetAttribute(const Index: Integer; const Value: THighlightAttributes);
 
begin
  case Index of
    0:
      FCommentAttributes.Assign(Value);
    1:
      FIdentifierAttributes.Assign(Value);
    2:
      FNumberAttributes.Assign(Value);
    3:
      FKeyAttributes.Assign(Value);
    4:
      FSpaceAttributes.Assign(Value);
    5:
      FStringAttributes.Assign(Value);
    6:
      FSymbolAttributes.Assign(Value);
    7:
      FEmbeddedCommandAttributes.Assign(Value);
    8:
      FCommentWithCommandAttributes.Assign(Value);
    9:
      FSystemVariableAttributes.Assign(Value);
    10:
      FUserVariableAttributes.Assign(Value);
  end;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
function TUCESQLHighlighter.GetRange: Integer;
 
begin
  Result := FStartState;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
procedure TUCESQLHighlighter.SetRange(Value: Integer);
 
begin
  FStartState := Value;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
procedure TUCESQLHighlighter.ResetRange;
 
begin
  FStartState := Normal;
  FCurrentState := Normal;
end;
 
//----------------------------------------------------------------------------------------------------------------------
 
end.
