#!/usr/local/bin/wish
#
# status.tcl - a small demo for nana talking to blt2.1
#
#
#    Copyright (C) 1996  P.J.Maker <pjm@gnu.org>
# 
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Library General Public
#    License as published by the Free Software Foundation; either
#    version 2 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Library General Public License for more details.
# 
#    You should have received a copy of the GNU Library General Public
#    License along with this library; if not, write to the Free
#    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Header: /home/pjm/cvs/nana/tcl/status.tcl,v 1.1.1.1 1997/11/23 11:45:51 pjm Exp  
#

#
# Warning: this code is intended only as a small demo, a proper library
# may be written in the future. 
#
# Suggestion: replace the creation commands (state, etc) with 
#  a automatic creator inside the log method (state:set, etc).
#

button .quit -text "Quit" -command {exit 1}
pack .quit -side top
pack configure .quit -side top -anchor w

proc state {var} {
    global $var
    set $var "undefined"
    frame .$var 
    label .$var.name -text "$var ="
    button .$var.value -textvariable $var
    pack .$var.name .$var.value -side left
    pack .$var -side top 
    pack configure .$var -expand 1 -fill y -anchor w
    pack configure .$var.value -expand 1 -fill y -anchor w

    global $var.past
    set $var.past ""
}

proc state:set {var val} {
    global $var $var.past
    set $var "$val ; [set $var]"
    set $var [string range [set $var] 0 80]
}

proc log {var} {
    frame .$var
    label .$var.title -text $var
    text .$var.log -height 10
    pack .$var.title .$var.log .$var 
}

proc log:set {var val} {
    .$var.log insert end "$val\n"
    .$var.log yview end
}

proc graph:new {var} {
    frame .$var
    global $var.x $var.y
    vector $var.x $var.y

    graph .$var.g 
    .$var.g element create line -xdata $var.x -ydata $var.y
    pack .$var.g
    pack configure .$var -expand 1 -fill y -anchor w
    pack configure .$var.g -expand 1 -fill y -anchor w

    global $var.first
    set $var.first 1
}

proc graph:add {g x y} {
    global $g.x $g.y

    set [set $g].x(++end) $x
    set [set $g].y(++end) $y
}

    
    






