#ifndef NEUTRINO_ID3_H
#define NEUTRINO_ID3_H

#include <glib-object.h>

#define NEUTRINO_TYPE_ID3  (neutrino_id3_get_type())
#define NEUTRINO_ID3(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), \
                              NEUTRINO_TYPE_ID3, \
                              NeutrinoID3 ) )
#define NEUTRINO_ID3_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST( ( klass ), \
				      NEUTRINO_TYPE_ID3, \
                                      NeutrinoID3Class ) )
#define NEUTRINO_IS_ID3(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), \
                                 NEUTRINO_TYPE_ID3 ) )

typedef struct {
	GObjectClass parent_spot;

} NeutrinoID3Class;


typedef struct NeutrinoID3Details NeutrinoID3Details;

typedef struct  {
	GObject parent_object;

	NeutrinoID3Details *details;
} NeutrinoID3;


GType  neutrino_id3_get_type( void );
NeutrinoID3 *neutrino_id3_new( const gchar *uri );

/* not actually in an ID3 tag, but as we know the filesize
   through checking for existance of the file we may as
   well get it from here */
gchar *neutrino_id3_get_filesize( NeutrinoID3 *id3 );

/* V2 tags may contain the length, V1 can't so this
   func will calculate the length if it isn't stored in a tag */
gchar *neutrino_id3_get_length( NeutrinoID3 *id3 );

gchar *neutrino_id3_get_title( NeutrinoID3 *id3 );
gchar *neutrino_id3_get_artist( NeutrinoID3 *id3 );
gchar *neutrino_id3_get_album( NeutrinoID3 *id3 );
gchar *neutrino_id3_get_year( NeutrinoID3 *id3 );
gchar *neutrino_id3_get_comment( NeutrinoID3 *id3 );
gchar *neutrino_id3_get_track( NeutrinoID3 *id3 );
gchar *neutrino_id3_get_genre( NeutrinoID3 *id3 );

void neutrino_id3_tag_v1dot1( const gchar *uri,
			      const gchar *title,
			      const gchar *artist,
			      const gchar *album,
			      const gchar *year,
			      const gchar *track,
			      const gchar *genre );
void neutrino_id3_tag_v2( const gchar *uri,
			  const gchar *title,
			  const gchar *artist,
			  const gchar *album,
			  const gchar *year,
			  const gchar *track,
			  const gchar *genre,
			  const gchar *length );

void neutrino_id3_strip_v1dot1( const gchar *uri );
void neutrino_id3_strip_v2( const gchar *uri );

#endif
