#ifndef NEUTRINO_JUKEBOX_VIEW_H
#define NEUTRINO_JUKEBOX_VIEW_H

#include <gtk/gtkliststore.h>

#include <sys/types.h>
#include <regex.h>

#include "nomad-jukebox.h"
#include "nomad-jukebox-track.h"

typedef enum {
	SEARCH_ARTIST,
	SEARCH_ALBUM,
	SEARCH_TITLE,
	SEARCH_GENRE,
	SEARCH_YEAR
} NeutrinoJukeboxSearchMode;

typedef enum {
	ARTIST_NAME_COL,
	ARTIST_MAX_COL
} NeutrinoJukeboxArtists;

typedef enum {
	ALBUM_NAME_COL,
	ALBUM_MAX_COL
} NeutrinoJukeboxAlbums;

typedef enum {
	TRACK_TRACK_ID_COL,
	TRACK_TITLE_COL,
	TRACK_TRACK_NUM_COL,
	TRACK_GENRE_COL,
	TRACK_LENGTH_COL,
	TRACK_YEAR_COL,
	TRACK_SIZE_COL,
	TRACK_CODEC_COL,
	TRACK_PLAY_ONLY_COL,
	TRACK_MAX_COL
} NeutrinoJukeboxTracks;


typedef struct {
	NomadJukebox *jukebox;

	GtkListStore *artists;
	GtkListStore *albums;
	GtkListStore *tracks;

	gchar *current_artist;	
	gchar *current_album;

	/* 
	   key = artist name, value = hash table of albums 
	   
	   hash table of albums:  
	    
	   key = album name, value = track ids
	   
	   hash table of tracks:

	   key = track id, value = track id
				
	*/
	GHashTable *artist_hash;

	NeutrinoJukeboxSearchMode mode;
	regex_t *search;
	guint num;
} NeutrinoJukeboxView;

NeutrinoJukeboxView *neutrino_jukebox_view_new( void );
void neutrino_jukebox_view_free( NeutrinoJukeboxView *view );

void neutrino_jukebox_view_set_jukebox( NeutrinoJukeboxView *view, 
					NomadJukebox *jukebox );

void neutrino_jukebox_view_select_artist( NeutrinoJukeboxView *view,
					  const gchar *artist );
void neutrino_jukebox_view_select_album( NeutrinoJukeboxView *view,
					 const gchar *album );
void neutrino_jukebox_view_select_playlist( NeutrinoJukeboxView *view,
					    const gchar *playlist );

gboolean neutrino_jukebox_view_search( NeutrinoJukeboxView *view,
				   NeutrinoJukeboxSearchMode mode,
				   const gchar *search_string );

#endif
