/*  Neutrino:  neutrino-wma.c
 *
 *  Copyright (C) 2003 David A Knight <david@ritter.demon.co.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#include <config.h>

#ifdef HAVE_GNOME_VFS
#include <libgnomevfs/gnome-vfs-utils.h>
#endif

#include <glib.h>

#include <libnjb.h>

#include "neutrino-wma.h"

#include "neutrino-filename.h"

NomadTrack *neutrino_wma_track( const gchar *uri )
{
	NomadTrack *track;

	gchar *artist;
	gchar *title;
	gchar *album;
	gchar *genre;
	gchar *length;
	gchar *year;
	gchar *size;
	gchar *tracknum;
	gchar *name;

	artist = title = album = genre = length = 
		year = size = tracknum = NULL;

	neutrino_get_info_from_uri( uri,
				    &artist, &album, &title );

	name = NULL;
#ifdef HAVE_GNOME_VFS
	name = gnome_vfs_get_local_path_from_uri( uri );
#endif
	if( ! name ) {
		name = g_strdup( uri );
	}

	track = nomad_track_new( artist, title, album, genre,
				    length, year, size, NJB_CODEC_WMA,
				    tracknum, name );

	if( artist ) {
		g_free( artist );
	}
	if( title ) {
		g_free( title );
	}
	if( album ) {
		g_free( album );
	}
	if( genre ) {
		g_free( genre );
	}

	if( length ) {
		g_free( length );
	}
	if( year ) {
		g_free( year );
	} 
	if( size ) {
		g_free( size );
	}
	if( tracknum ) {
		g_free( tracknum );
	} 
	if( name ) {
		g_free( name );
	}

	return track;
}

void neutrino_wma_tag_file( const gchar *uri, NomadTrack *track )
{

}
