/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import java.util.Map;
import mlsub.typing.BadSizeEx;
import mlsub.typing.Monotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Variance;
import mlsub.typing.lowlevel.Engine;
import mlsub.typing.lowlevel.Kind;

public final class MonotypeConstructor
extends Monotype {
    public TypeConstructor tc;
    Monotype[] parameters;

    public MonotypeConstructor(TypeConstructor tc, Monotype[] parameters) throws BadSizeEx {
        this.tc = tc;
        this.parameters = parameters;
        if (parameters != null && parameters.length == 0) {
            throw new Error("Not optimal");
        }
        if (tc.variance != null) {
            int len;
            int n = len = parameters == null ? 0 : parameters.length;
            if (tc.arity() != len) {
                throw new BadSizeEx(tc.arity(), len);
            }
        }
    }

    public static MonotypeConstructor apply(TypeConstructor tc, Monotype parameter) throws BadSizeEx {
        return new MonotypeConstructor(tc, new Monotype[]{parameter});
    }

    public TypeConstructor head() {
        return this.tc;
    }

    public TypeConstructor getTC() {
        return this.tc;
    }

    public Monotype[] getTP() {
        return this.parameters;
    }

    public boolean isRigid() {
        return this.tc.isRigid() && Monotype.isRigid(this.parameters);
    }

    Monotype substitute(Map map2) {
        Object newTC = map2.get(this.tc);
        return new MonotypeConstructor(newTC == null ? this.tc : (TypeConstructor)newTC, Monotype.substitute(map2, this.parameters));
    }

    public int getId() {
        throw new Error();
    }

    public void setId(int value) {
        throw new Error();
    }

    public Kind getKind() {
        return this.tc.variance;
    }

    public void setKind(Kind value) {
        if (this.tc.variance == value) {
            return;
        }
        throw new Error("SetKind in " + this + ": " + value + " != " + this.tc.variance);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MonotypeConstructor)) {
            return false;
        }
        MonotypeConstructor that = (MonotypeConstructor)o;
        return this.tc.equals(that.tc) && (this.parameters == null && that.parameters == null || this.parameters.equals(that.parameters));
    }

    public String toString() {
        return this.tc.toString(this.parameters);
    }

    public String toString(boolean isNull, String suffix) {
        return this.tc.toString(this.parameters, isNull, suffix);
    }

    void tag(int variance) {
        Engine.tag(this.tc, variance);
        if (this.tc.variance instanceof Variance) {
            ((Variance)this.tc.variance).tag(this.parameters, variance);
        } else {
            this.parameters[0].tag(variance);
        }
    }

    Monotype canonify() {
        this.tc = (TypeConstructor)Engine.canonify(this.tc);
        this.parameters = Monotype.canonify(this.parameters);
        return this;
    }
}

