#! /bin/sh
cat <<EOF
program nextpp;

(* +------------------------------------------------------------------------+
   |                                                                        |
   |        Recherche du premier nombre pseudopremier  N chifres           |
   |                                                                        |
   +------------------------------------------------------------------------+ *)

(* M. Quercia, le 18/08/2001 *)

uses $MODULENAME;

type pbool = array[0..0] of boolean;
     tbool = ^pbool;

(* Produit des nombres premiers impairs <= n *)
procedure pprime(var p : xint; n : longint);
var l,i,j : longint;
    t     : tbool;
begin
  l := (n-1) div 2;

   (* crible d'Eratosthne : t[i] <=> 2i+3 est premier *)
   t := getmem(l);
   for i:=0 to l-1 do t^[i] := true;
   i := 0; j := 3;
   while j < l do begin
      t^[j] := false;
      j := j + 2*i + 3;
      if j >= l then begin
	 i := i+1;
	 while (i < l) and (not t^[i]) do i := i+1;
	 j := 2*i*(i+3) + 3;
      end;
   end;
    
   (* effectue le produit *)
   copy_int(p,1);
   for i:=0 to l-1 do if t^[i] then mul_1(p,p,2*i+3);
   freemem(t,l);

end;

(* Test de Rabin-Miller *)
function rabin(n,a : xint) : boolean;
var p,q,n1 : xint;
    i,x    : longint;
begin
   
   p  := xnew;
   q  := xnew;
   n1 := xnew;

   (* cherche la 2-valuation de n-1 *)
   sub_1(n1,n,1);
   i := -1;   repeat i := i+1; x := nth_word(n1,i); until x <> 0;
   i := i*16; while not odd(x) do begin i := i+1; x := x div 2; end;

   (* calcule a^((n-1)/2^i) (mod n) *)
   shiftr(q,n1,i);
   powmod(p,a,q,n);
   
  (* lve au carr jusqu' trouver 1 ou -1 *)
   if eq_1(p,1) then rabin := true
   else begin
      while (not eq_1(p,1)) and (not eq(p,n1)) and (i > 1) do begin
	 sqr(p,p);
	 quomod(q,p,p,n);
	 i := i-1;
      end;
      rabin := eq(p,n1);
   end;

   xfree(p);
   xfree(q);
   xfree(n1);

end;

(* programme principal *)
var n,p,a,x,y : xint;
    e         : longint;
    c         : word;
    fini      : boolean;
    s         : ansistring;
begin
   
   n := xnew;
   p := xnew;
   a := xnew;
   x := xnew;
   y := xnew;

   (* dcode les arguments *)
   if (paramcount = 1) and (paramstr(1) = '-test') then begin
      e := 100;
      copy_int(a,2);
   end
   else if paramcount = 2 then begin
      val(paramstr(1),e,c);
      s := paramstr(2);
      copy_string(a,pchar(s));
   end
   else failwith('syntaxe : nextpp <n> <a>');

   (* 10^n *)
   copy_int(n,10); pow(n,n,e);

   (* produit des premiers premiers *)
   pprime(p,1000);

   (* boucle sur n *)
   add_1(x,n,1); fini := false;
   while not fini do begin
      gcd(y,p,x);
      fini := eq_1(y,1) and rabin(x,a);
      if not fini then add_1(x,x,2);
   end;
   sub(x,x,n);

   (* l'affiche *)
   writeln(int_of(x));

   xfree(n);
   xfree(p);
   xfree(a);
   xfree(x);
   xfree(y);

end.