/* $Id: hosts.h,v 1.30 2004/11/08 22:41:37 graziano Exp $ */

#ifndef HOST_H
#define HOST_H

#include <stddef.h>     /* offsetof() */

#include "protocol.h"   /* Socket */
#include "nws_messages.h"   /* Message number ranges */
#include "formatutil.h" /* DataDescriptor */

#ifdef __cplusplus
extern "C" {
#endif


/* Arbitrary limitation on machine name size. */
#define MAX_MACHINE_NAME 64
/* Port numbers go up to 65535. */
#define MAX_PORT_IMAGE 5

/* Limit on host name size, including colon and port */
#define MAX_HOST_NAME (MAX_MACHINE_NAME + 1 + MAX_PORT_IMAGE)

/* Number of seconds between host registrations. */
#define DEFAULT_HOST_BEAT (15 * 60)
#define SHORT_HOST_BEAT (2 * 60)

/* Note: unsigned int (not enum) here so sizeof(HostTypes) is well-known. */
typedef unsigned int HostTypes;
#define FORECASTER_HOST 0
#define MEMORY_HOST 1
#define NAME_SERVER_HOST 2
#define SENSOR_HOST 3
#define PROXY_HOST 4

/**
 * A HostInfo struct accompanies the HOST_TEST_RESULT message.
 * #registrationName# is the name under which this host is registered with its
 * name server; #hostType# is the kind of host; #nameServer# specifies where
 * its registration lives; and #healthy# indicates whether the registration
 * information cached locally matches that stored with the name server.
 */
typedef struct {
	char registrationName[MAX_HOST_NAME];
	HostTypes hostType;
	char nameServer[MAX_HOST_NAME];
	unsigned int healthy;
} HostInfo;
static const DataDescriptor hostInfoDescriptor[] =
  {SIMPLE_MEMBER(CHAR_TYPE, MAX_HOST_NAME,
                 offsetof(HostInfo, registrationName)),
   SIMPLE_MEMBER(UNSIGNED_INT_TYPE, 1, offsetof(HostInfo, hostType)),
   SIMPLE_MEMBER(CHAR_TYPE, MAX_HOST_NAME, offsetof(HostInfo, nameServer)),
   SIMPLE_MEMBER(UNSIGNED_INT_TYPE, 1, offsetof(HostInfo, healthy))};
#define hostInfoDescriptorLength 4

/**
 * An NsInfo struct accompanies the HOST_GOT_NS or the HOST_GOT_MEMORY
 * message.  #nameServer# gives the host name and port, #nsType# is the
 * type of nameserver or memory.
 */
typedef unsigned int NsTypes;
#define NWS_NS 0
#define LDAP_NS 1
#define NWS_MEMORY 2

typedef struct {
	char nameServer[MAX_HOST_NAME];
	NsTypes nsType;
} NsInfo;
static const DataDescriptor nsInfoDescriptor[] =
  {SIMPLE_MEMBER(CHAR_TYPE, MAX_HOST_NAME, offsetof(NsInfo, nameServer)),
   SIMPLE_MEMBER(UNSIGNED_INT_TYPE, 1, offsetof(NsInfo, nsType))};
#define nsInfoDescriptorLength 2

#ifdef __cplusplus
}
#endif

#endif
