/* $Id: nws_state.h,v 1.25 2004/02/12 22:43:27 graziano Exp $ */

#ifndef NWS_STATE_H
#define NWS_STATE_H


#include <sys/types.h> /* size_t */

#ifdef __cplusplus
extern "C" {
#endif

/* Largest allowable record size. */
#define MAX_RECORD_SIZE 512

#ifdef WITH_NETLOGGER
#define MAX_NL_MSG_LEN  1024

int
WriteStateNL(const char* path,
			 const char* id,
			 size_t flength,
			 double time_out,
			 double seq_no,
			 const char *state,
			 size_t stateSize);

#endif /* WITH_NETLOGGER */

/**
 * Initialize the module. #cacheNum# tells how many cache entries you want
 * to keep (0 will disable cache). #memorySize# has to match with the
 * fileSize otherwise bad things will happen. #dir# is the base directory
 * in where to store all the states. Return 1 on success.
 */
int
InitStateModule(	int cacheNum,
			int memorySize,
			const char *dir);

/*
** Reads #count# records from #fname# into the #max-size#-long buffer #state#.
** The newest record is returned at the beginning of #state#, the oldest at
** the end.  Ignores records stamped with a sequence number that is <=
** #earliest_seq_no#.  Returns the earliest time out of any returned record
** in #out_time_out#, the greatest sequence number in #out_seq_no#, the number
** of records returned in #out_count# and the length of each record in
** #out_recordsize#.  Returns 1 if successful, else 0.
*/
int
ReadState(const char *fname,
          char *state,
          int count,
          size_t max_size,
          double earliest_seq_no,
          double *out_time_out,
          double *out_seq_no,
          int *out_count,
          int *out_recordsize);

/*
** Similar to ReadState, except that it reads all available records and stores
** them in the dynamically allocated buffer #state#.  All other parameters
** are the same as with ReadState.
*/
int
ReadFullState(const char *fname,
              char **state,
              double *out_time_out,
              double *out_seq_no,
              int *out_count,
              int *out_recordsize);


/*
** Write the #stateSize#-long buffer #state# into file #fname#.  Marks the
** state record with time out value #timeOut# and sequence number #seqNo#.
** If the file has not previously been opened, #flength# indicates the maximum
** number of records it may hold.  Returns 1 if successful, else 0.
*/
int
WriteState(const char *fname,
           size_t flength,
           double timeOut,
           double seqNo,
           const char *state,
           size_t stateSize);


/**
 * Deletes all the states that have not been accessed within the past
 * #idle# seconds. Returns 1 if succesful.
 */
int
CleanLocalStates(	unsigned long idle);


/**
 * Returns a '\n' separated list of files in the state directory. It can
 * returns NULL.
 */
char *
ReadOldStates();


/** 
 * This function check that file #name# is a good NWS state file. Returns
 *  1 on success, 0 otherwise
 */
int
CheckFileName(const char *name);


#ifdef __cplusplus
}
#endif

#endif
