(* $Id: test.ml,v 1.2 2003/06/02 03:42:43 eric Exp $ *)

open Ocamldap

let _ = 
  try
    let ld = init ~port: 2389 "yourhost" in
    let _ = bind_s ~who:"cn=directory manager,o=csun" ~cred:"yourpas" ld in
    let add_res = add_s ld "cn=test,o=yourorg" 
      [ 
        (`ADD, "objectClass", ["top";"person"]);
        (`ADD, "cn", ["test"]);
        (`ADD, "sn", ["constructor"]);
      ] in
    let mod_res = modify_s ld "cn=test,o=yourorg"
      [ 
        (`REPLACE, "sn", ["modified"]);
      ] in
    let modrdn_res = modrdn_s ld "cn=test,o=yourorg" "cn=test1" in
    let search_res = search_s ~base:"o=yourorg" ~scope:`ONELEVEL ld "(cn=test1)" in
    let delete_res = delete_s ld "cn=test1,o=yourorg" in
    match search_res with
      [] -> print_endline "got no results"
    | _ -> List.iter print_entry search_res;
    unbind ld
  with
    LDAP_Failure x -> Printf.printf "caught ldap error: %s\n" (err2string x)
