#ifndef LANGUAGE_H
#define LANGUAGE_H

extern "C" {
#include <ogle/dvd.h>
}

#include <qstring.h>
#include <qstringlist.h>
#include <qptrlist.h>

class LangCode
{
public:
 LangCode(const QString& /*name*/,const QString& /*code*/);
 QString name;
 QString code;
};
 
class Language
{
public:
 static void init(); // this MUST be called before using the methods below!
 static QString name(DVDLangID_t /*langid*/);
 static QString code(DVDLangID_t /*langid*/);
 static QStringList allNames();
 static QStringList allCodes();
 static DVDLangID_t id(const QString& /*code_639_1*/);
private:
 static QPtrList<LangCode> languages;
};

#endif // LANGUAGE_H
