<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

//
// Note: Does not support DIFF for $lang_var['site']['?????'] = array(....) 
//
include_once("./functions/widgets.php");
include_once("./functions/http.php");

function get_lang_vars_from_file($filename)
{
	include($filename);
	
	if(is_not_empty_array($LANG_VARS))
		return $LANG_VARS;
	else if(is_not_empty_array($lang_var))
		return $lang_var;
	else
		return NULL;
}

function display_changes($prefix, $diff_array)
{
	if(is_array($diff_array))
	{
		reset($diff_array);
		while(list($key,$value) = each($diff_array))
		{
			if(is_array($value))
				display_changes($prefix."['$key']", $value);
			else
			{
				echo($prefix."['$key']");
				echo(" = '".htmlspecialchars($value)."';\n");
			}
		}
	}
}
	
session_start();
if(is_opendb_valid_session())
{ 
	if(is_file_upload_enabled())
	{
		if (is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
		{
			if($HTTP_VARS['op'] == 'diff')
			{
				echo("<div class=\"footer\">[<a href=\"$PHP_SELF?type=$ADMIN_TYPE\">New Diff</a>]</div>");
			
				if(is_uploaded_file($HTTP_POST_FILES['old_file']['tmp_name']))
				{
					$old_lang_vars = get_lang_vars_from_file($HTTP_POST_FILES['old_file']['tmp_name']);
					if(is_uploaded_file($HTTP_POST_FILES['new_file']['tmp_name']))
						$new_lang_vars = get_lang_vars_from_file($HTTP_POST_FILES['new_file']['tmp_name']);
					else
						$new_lang_vars = get_lang_vars_from_file("lang/".$_OPENDB_LANGUAGE.".inc.php");
					
					if(is_array($old_lang_vars) && is_array($new_lang_vars))
					{
						$diffs['added'] = NULL;
						$diffs['updated'] = NULL;
						$diffs['deleted'] = NULL;
			
						// TODO: Support complete nesting diff checking
						while(list($key,$var) = each($old_lang_vars))
						{
							if(isset($new_lang_vars[$key])) // found
							{
								// nested array.
								if(is_array($var))
								{
									if(is_array($new_lang_vars[$key]))
									{
										// Compare the indexes.
										while(list($key2,$value) = each($old_lang_vars[$key]))
										{
											if(isset($new_lang_vars[$key][$key2]))
											{
												// We are not checking nested arrays from this point!!!
												// Generally the $lang_var['site'], is the only 
												// structure that goes to this depth anyway.
												if(!is_array($value))
												{
													if($value != $new_lang_vars[$key][$key2])
														$diffs['updated'][$key][$key2] = $new_lang_vars[$key][$key2];	
												}
												//else ignore as too much nesting.
											}
											else
											{
												$diffs['deleted'][$key][$key2] = $old_lang_vars[$key][$key2];
											}
										}
								
										while(list($key2,$value) = each($new_lang_vars[$key]))
										{
											if(!isset($old_lang_vars[$key][$key2]))
											{
												$diffs['added'][$key][$key2] = $new_lang_vars[$key][$key2];
											}
										}
									}
									else // No longer in new file, so it is deleted.
										$diffs['deleted'][$key] = $var;
								}
								else //normal variable.
								{
									if($var != $new_lang_vars[$key])
										$diffs['updated'][$key] = $new_lang_vars[$key];	
								}
							}
							else
							{
								$diffs['deleted'][$key] = $var;
							}
						}
			
						while(list($key,$var) = each($new_lang_vars))
						{
							if(!isset($old_lang_vars[$key]))
							{
								$diffs['added'][$key] = $new_lang_vars[$key];
							}
						}
			
						if(is_array($diffs['added']))
						{
							ksort($diffs['added']);
				
							echo("<h3>New variables</h3>");
							echo("<pre>");
							display_changes("\$LANG_VARS", $diffs['added']);
							echo("</pre>");
						}
			
						if(is_array($diffs['updated']))
						{
							ksort($diffs['updated']);
				
							echo("<h3>Updated variables</h3>");
							echo("<pre>");
							display_changes("\$LANG_VARS", $diffs['updated']);
							echo("</pre>");
						}
			
						if(is_array($diffs['deleted']))
						{
							ksort($diffs['deleted']);
				
							echo("<h3>Deleted variables</h3>");
							echo("<pre>");
							display_changes("\$LANG_VARS", $diffs['deleted']);
							echo("</pre>");
						}
					}
					else if(is_array($old_lang_vars))
						echo("<div class=\"error\">New language file not specified</div>");
					else if(is_array($new_lang_vars))
						echo("<div class=\"error\">Old language file not specified</div>");
					else
						echo("<div class=\"error\">Old and New language files not specified</div>");
				}
				else
				{
					echo("<div class=\"error\">Old and/or New language files not specified</div>");
				}
			}
			else
			{
				echo("\n<table border=0 frameborder=0 cellspacing=1>");
				echo("\n<form name=\"main\" action=\"$PHP_SELF\" method=\"post\" enctype=\"multipart/form-data\">");
				echo("\n<input type=\"hidden\" name=\"type\" value=\"$ADMIN_TYPE\">");
				echo("\n<input type=\"hidden\" name=\"op\" value=\"diff\">");
				echo(get_input_field("old_file", NULL, 'Old File', "upload(25,*,\"php\")"));
				echo(get_input_field("new_file", NULL, 'New File*', "upload(25,*,\"php\")"));
	
				echo("\n<tr><td colspan=2><input type=submit>");
				echo("\n</td></tr>");
				echo("\n</form>");
				echo("\n</table>");
				
				echo("<p><div class=\"footer\">* If you do not specify a 'New File', the ".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']." <i>lang/".$_OPENDB_LANGUAGE.".inc.php</i> language file will be used.</div></p>");
			}
		}
		else
		{
			echo _theme_error($LANG_VARS['not_authorized_to_page']);
		}	
	}
	else// File upload not supported on server
	{
		echo _theme_error($LANG_VARS['file_upload_not_available']);
	}
}//if(is_opendb_valid_session())
?>