<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./admin/s_attribute_type/functions.php");
include_once("./admin/s_attribute_type_lookup/functions.php");

include_once("./functions/site.php");
include_once("./functions/item_type.php");

function display_s_item_type_insert_form($HTTP_VARS)
{
	global $CONFIG_VARS;
	
	// s_item_type
	echo get_input_field("s_item_type", NULL, "Item Type", "text(10,10)", "Y", $HTTP_VARS['s_item_type']);
	
	//description
	echo get_input_field("description", NULL, "Description", "text(30,60)", "Y", $HTTP_VARS['description']);
	
	//image
	echo get_input_field("image", NULL, "Image", "url(15,*,\"gif,jpg,png\",N)", "N", $HTTP_VARS['image']);
	
	echo format_field("Default Site Type", NULL, 
			custom_select("default_site_type", array_merge(array(''),get_site_type_r()), "%value%", 1, $HTTP_VARS['default_site_type']));
	
	echo("<tr><td colspan=2 class=\"prompt\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<i>- Field Type Attributes -</i></td></tr>");
	
	$lookup_results = fetch_sfieldtype_attribute_type_rs('TITLE');
	echo format_field("Title", NULL, 	
			custom_select("s_field_type[TITLE]", $lookup_results, "%s_attribute_type% - %description%", 1, is_array($HTTP_VARS['s_field_type'])?$HTTP_VARS['s_field_type']['TITLE']:NULL, "s_attribute_type").
			"&nbsp;<a href=\"javascript:popup('admin.php?type=s_item_type&op=help&inc_header=N&s_attribute_type='+document.forms['s_item_type']['s_field_type[TITLE]'].options[document.forms['s_item_type']['s_field_type[TITLE]'].options.selectedIndex].value,'400', '325')\">(?)</a>");

	$lookup_results = fetch_sfieldtype_attribute_type_rs('CATEGORY');
	echo format_field("Category", NULL, 	
			custom_select("s_field_type[CATEGORY]", $lookup_results, "%s_attribute_type% - %description%", 1, is_array($HTTP_VARS['s_field_type'])?$HTTP_VARS['s_field_type']['CATEGORY']:NULL, "s_attribute_type").
			"&nbsp;<a href=\"javascript:popup('admin.php?type=s_item_type&op=help&inc_header=N&s_attribute_type='+document.forms['s_item_type']['s_field_type[CATEGORY]'].options[document.forms['s_item_type']['s_field_type[CATEGORY]'].options.selectedIndex].value,'400', '325')\">(?)</a>");
	
	$lookup_results = fetch_sfieldtype_attribute_type_rs('STATUSTYPE');
	echo format_field("Status Type", NULL, 	
			custom_select("s_field_type[STATUSTYPE]", $lookup_results, "%s_attribute_type% - %description%", 1, is_array($HTTP_VARS['s_field_type'])?$HTTP_VARS['s_field_type']['STATUSTYPE']:NULL, "s_attribute_type").
			"&nbsp;<a href=\"javascript:popup('admin.php?type=s_item_type&op=help&inc_header=N&s_attribute_type='+document.forms['s_item_type']['s_field_type[STATUSTYPE]'].options[document.forms['s_item_type']['s_field_type[STATUSTYPE]'].options.selectedIndex].value,'400', '325')\">(?)</a>");

	$lookup_results = fetch_sfieldtype_attribute_type_rs('STATUSCMNT');
	echo format_field("Status Comment", NULL, 	
			custom_select("s_field_type[STATUSCMNT]", $lookup_results, "%s_attribute_type% - %description%", 1, is_array($HTTP_VARS['s_field_type'])?$HTTP_VARS['s_field_type']['STATUSCMNT']:NULL, "s_attribute_type").
			"&nbsp;<a href=\"javascript:popup('admin.php?type=s_item_type&op=help&inc_header=N&s_attribute_type='+document.forms['s_item_type']['s_field_type[STATUSCMNT]'].options[document.forms['s_item_type']['s_field_type[STATUSCMNT]'].options.selectedIndex].value,'400', '325')\">(?)</a>");
						
	if($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['borrow.duration_support']!==FALSE)
	{
		$lookup_results = fetch_sfieldtype_attribute_type_rs('DURATION');
		echo format_field("Borrow Duration", NULL, 	
				custom_select("s_field_type[DURATION]", $lookup_results, "%s_attribute_type% - %description%", 1, is_array($HTTP_VARS['s_field_type'])?$HTTP_VARS['s_field_type']['DURATION']:NULL, "s_attribute_type").
				"&nbsp;<a href=\"javascript:popup('admin.php?type=s_item_type&op=help&inc_header=N&s_attribute_type='+document.forms['s_item_type']['s_field_type[DURATION]'].options[document.forms['s_item_type']['s_field_type[DURATION]'].options.selectedIndex].value,'400', '325')\">(?)</a>");			
	}			
}

function display_s_item_type_row($item_type_r, $row)
{
	echo("\n<tr>");
	
	$errors = NULL;
	if(check_item_type_structure($item_type_r['s_item_type'], $errors))
		$class = "data";
	else
		$class = "error";
	
	// order_no
	echo("\n<td class=\"$class\" align=center>".get_input_field("order_no[$row]", NULL, NULL, "number(3)", "N", $item_type_r['order_no'], FALSE)."</td>");
	
	// s_attribute_type
	echo("\n<td class=\"$class\">".get_input_field("s_item_type[$row]", NULL, "Item Type", "readonly", "Y", $item_type_r['s_item_type'], FALSE).
		"<input type=hidden name=\"exists_ind[$row]\" value=\"Y\">".
		"</td>");
	
	//description
	echo("\n<td class=\"$class\">".get_input_field("description[$row]", NULL, NULL, "text(30,30)", "N", $item_type_r['description'], FALSE)."</td>");

	echo("<td class=\"$class\" align=center>");
	// Get the theme specific source of the image.
	if(strlen($item_type_r['image'])>0)
	{
		$src = _theme_image_src($item_type_r['image']);
	}
	if($src!==FALSE && strlen($src)>0)
		echo("<img src=\"$src\">");
	else
		echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
	echo("</td>");

	echo("\n<td class=\"$class\">".get_input_field("image[$row]", NULL, NULL, "url(15,*,\"gif,jpg,png\",N)", "N", $item_type_r['image'], FALSE)."</td>");

	// default site type
	$sites = array_merge(array(''),get_site_type_r());
	if(strlen($item_type_r['default_site_type'])>0 && !in_array($item_type_r['default_site_type'], $sites))
		$sites[] = $item_type_r['default_site_type'];
		
	echo ("\n<td class=\"$class\">".format_field(NULL, NULL, custom_select("default_site_type[$row]", $sites, "%value%", 1, $item_type_r['default_site_type']), FALSE)."</td>");
	
	echo("\n<td class=\"$class\">");
	echo("\n<input type=button onclick=\"document.forms['navigate'].s_item_type.value=this.form['s_item_type[$row]'].value; document.forms['navigate'].op.value='edit'; document.forms['navigate'].submit();\" value=\"Edit\">&nbsp;<input type=button onclick=\"document.forms['navigate'].s_item_type.value=this.form['s_item_type[$row]'].value; document.forms['navigate'].op.value='delete_confirm'; document.forms['navigate'].submit();\" value=\"Delete\">");
	if(is_not_empty_array($errors))
		echo("&nbsp;<a href=\"javascript:popup('admin.php?op=errmsg&title=".urlencode(urlencode("Item Type (".$item_type_r['s_item_type'].") Structural Defects"))."&error=".urlencode(urlencode(format_error_block($errors)))."','640', '480')\">[ERROR]</a>");
	else
	{
		echo("\n<input type=button onclick=\"javascript:popup('admin.php?type=s_item_type&op=sql&inc_theme=N&s_item_type='+document.forms['s_item_type']['s_item_type[$row]'].value,'800', '600')\" value=\"SQL\">");
	}
	echo("\n</td>");

	echo("</tr>");
}

// We do not want to build this more than once!
$s_attribute_type_list = NULL;

/*
* Specific item type - s_item_attribute_type block.
*/
function display_s_item_attribute_type_row($s_item_type, $s_item_attribute_type_r, $row, $exists_error_ind=FALSE)
{
	global $s_attribute_type_list;
	
	echo("<tr>");

	// Indicates this record is in error, and we need to make this clear.
	if($exists_error_ind)
		$class = "error";
	else
		$class = "data";
	
	// Delete ind
	echo("<td class=\"$class\" align=center>");
	if(is_not_empty_array($s_item_attribute_type_r))
		echo get_input_field("delete_ind[$row]", NULL, NULL, "simple_checkbox()", "N", "Y", FALSE);
	else
		echo("&nbsp;");
	echo("</td>");

	// s_attribute_type
	if(is_not_empty_array($s_item_attribute_type_r) && $exists_error_ind==FALSE)
	{
		// order_no
		echo("<td class=\"$class\" align=center>".get_input_field("order_no[$row]", NULL, NULL, "number(3)", "Y", $s_item_attribute_type_r['order_no'], FALSE).
			"<input type=hidden name=\"old_order_no[$row]\" value=\"".$s_item_attribute_type_r['order_no']."\">".
			"</td>");
		
		// See if a s_field_type defined for this attribute type
		$attribute_type_r = fetch_s_attribute_type_r($s_item_attribute_type_r['s_attribute_type']);
		if(strlen($attribute_type_r['s_field_type'])>0)
			$value = $s_item_attribute_type_r['s_attribute_type']. " [".$attribute_type_r['s_field_type']."]";
		else
			$value = $s_item_attribute_type_r['s_attribute_type']; 
		
		echo("<td class=\"$class\">".
				format_field("Attribute Type",
						NULL,
						$value."<input type=hidden name=\"s_attribute_type[$row]\" value=\"".$s_item_attribute_type_r['s_attribute_type']."\">".
							"<input type=hidden name=\"exists_ind[$row]\" value=\"Y\">",FALSE).
			"</td>");
		
		echo("<td class=\"$class\"><a href=\"javascript:popup('admin.php?type=s_item_type&op=help&inc_header=N&s_attribute_type='+document.forms['s_item_attribute_type']['s_attribute_type[$row]'].value,'400', '325')\">(?)</a></td>");
	}
	else
	{
		// order_no
		echo("<td class=\"$class\" align=center>".
			($exists_error_ind?_theme_image("rs.gif", NULL, "Duplicate Attribute Type & Order No"):"").
			get_input_field("order_no[$row]", NULL, NULL, "number(3)", "N", $s_item_attribute_type_r['order_no'], FALSE)."</td>");

		if($s_attribute_type_list==null)
		{
			$sat_results = fetch_s_attribute_type_rs();
			while($attribute_type_r = mysql_fetch_array($sat_results, MYSQL_ASSOC))
			{
				if(is_attribute_type_avail_for_item_types($attribute_type_r['s_attribute_type']))
					$s_attribute_type_list[] = $attribute_type_r;
			}
			mysql_free_result($sat_results);
		}
		
		echo("<td class=\"$class\" align=center>".
			"<select name=\"s_attribute_type[$row]\">".
			"\n<option value=\"\">");
		reset($s_attribute_type_list);
		while(list(,$attribute_type_r) = each($s_attribute_type_list))
		{
			if(is_not_empty_array($s_item_attribute_type_r) && $s_item_attribute_type_r['s_attribute_type'] == $attribute_type_r['s_attribute_type'])
				echo("\n<option value=\"".$attribute_type_r['s_attribute_type']."\" SELECTED>".$attribute_type_r['s_attribute_type']);
			else
				echo("\n<option value=\"".$attribute_type_r['s_attribute_type']."\">".$attribute_type_r['s_attribute_type']);
			if(strlen($attribute_type_r['s_field_type'])>0)
				echo(" [".$attribute_type_r['s_field_type']."]");
		}
		echo("\n</select></td>");
		
		echo("<td class=\"$class\"><a href=\"javascript:popup('admin.php?type=s_item_type&op=help&inc_header=N&s_attribute_type='+document.forms['s_item_attribute_type']['s_attribute_type[$row]'].options[document.forms['s_item_attribute_type']['s_attribute_type[$row]'].options.selectedIndex].value,'400', '325')\">(?)</a></td>");
	}

	//prompt
	echo("<td class=\"$class\">".get_input_field("prompt[$row]", NULL, NULL, "text(15,30)", "N", $s_item_attribute_type_r['prompt'], FALSE)."</td>");
	echo("<td class=\"$class\" align=center>".get_input_field("compulsory_ind[$row]", NULL, NULL, "simple_checkbox(".(strtoupper($s_item_attribute_type_r['compulsory_ind'])== "Y"?"CHECKED":"").")", "N", "Y", FALSE)."</td>");
	echo("</tr>");
}

/**
	Display a read-only version of the System Attribute type
	for reference.
*/
function display_s_attribute_type_record($s_attribute_type)
{
	$s_attribute_type_r = fetch_s_attribute_type_r($s_attribute_type);
	if($s_attribute_type_r!=FALSE)
	{
		echo("\n<h3 align=center>System Attribute Type<br>- ".$s_attribute_type." -</h3>");
		echo("<p align=center><table cellspacing=2 border=0>");
		echo format_field("Description", NULL, $s_attribute_type_r['description']);
		echo format_field("Prompt", NULL, $s_attribute_type_r['prompt']);
		echo format_field("Input type", NULL, $s_attribute_type_r['input_type']);
		echo format_field("Display type", NULL, $s_attribute_type_r['display_type']);
		echo format_field("Field type", NULL, $s_attribute_type_r['s_field_type']);
		echo format_field("Site type", NULL, $s_attribute_type_r['site_type']);
		echo("</table></p>");
	}
}

/**
* Generate a complete s_item_type script.
* 
* Data generated:
* 	s_item_type
* 	s_attribute_type's (Those not included in $_ATTRIBUTE_TYPES['core'])
* 	s_item_attribute_type's
* 	s_item_attribute_type_lookup (Those not included in $_ATTRIBUTE_TYPES['core'])
*/
function generate_s_item_type_sql($s_item_type)
{
	global $_CORE_ATTRIBUTE_TYPES;
	
	$s_item_type_r = fetch_s_item_type_r($s_item_type);
	if($s_item_type_r !== FALSE)
	{
		$type_sql ="\n#".
					"\n# Item Type".
					"\n#". 
					"\nINSERT INTO s_item_type (s_item_type, description, image, default_site_type, order_no) VALUES ( '$s_item_type', '".$s_item_type_r['description']."', '".$s_item_type_r['image']."', '".$s_item_type_r['default_site_type']."', '".$s_item_type_r['order_no']."');".
					"\n";
		
		$attr_sql = "\n#".
					"\n# Attributes (non-core)".
					"\n#";
		
		$item_attr_sql ="\n#".
						"\n# Item Attribute structure".
						"\n#";
					
		$attr_lookup_sql = "";
		
		$delete_attr_list = "";
		$delete_lookup_list = "";
		
		$result = fetch_s_item_attribute_type_rs($s_item_type);
		if($result)
		{
			$attr_added = array();
			while($s_item_attribute_type_r = mysql_fetch_array($result, MYSQL_ASSOC))
			{
				// Ensure to also check that the attribute has not already been encountered, in case we have duplicates
				// in s_item_attribute_type structure (such as CDTRACK for instance)
				if( (!is_array($_CORE_ATTRIBUTE_TYPES) || !in_array($s_item_attribute_type_r['s_attribute_type'], $_CORE_ATTRIBUTE_TYPES)) && 
								!in_array($s_item_attribute_type_r['s_attribute_type'], $attr_added))
				{
					// Add s_attribute_type, so we do not insert it twice.
					$attr_added[] = $s_item_attribute_type_r['s_attribute_type'];
					
					$s_attribute_type_r = fetch_s_attribute_type_r($s_item_attribute_type_r['s_attribute_type']);
					
					$attr_sql .= "\nINSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( '".$s_attribute_type_r['s_attribute_type']."', '".$s_attribute_type_r['description']."', '".$s_attribute_type_r['prompt']."', '".$s_attribute_type_r['input_type']."', '".$s_attribute_type_r['display_type']."', , '".$s_attribute_type_r['s_field_type']."', '".$s_attribute_type_r['site_type']."');";
					
					$result2 = fetch_s_attribute_type_lookup_rs($s_item_attribute_type_r['s_attribute_type']);
					if($result2)
					{
						$attr_lookup_sql .= "\n#".
											"\n# Attribute Type Lookup (".$s_item_attribute_type_r['s_attribute_type'].")".
											"\n#";
											
						while($s_attribute_type_lookup_r = mysql_fetch_array($result2, MYSQL_ASSOC))
						{
							$attr_lookup_sql .= "\nINSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( '".$s_item_attribute_type_r['s_attribute_type']."', '".$s_attribute_type_lookup_r['order_no']."', '".$s_attribute_type_lookup_r['value']."', '".$s_attribute_type_lookup_r['display']."', '".$s_attribute_type_lookup_r['img']."', '".$s_attribute_type_lookup_r['checked_ind']."');";	
						}
						mysql_fetch_array($result2);
						
						$attr_lookup_sql .= "\n";

						if(strlen($delete_lookup_list)>0)
							$delete_lookup_list .= ", ";
						$delete_lookup_list .= "'".$s_item_attribute_type_r['s_attribute_type']."'";
					}

					if(strlen($delete_attr_list)>0)
						$delete_attr_list .= ", ";
					$delete_attr_list .= "'".$s_item_attribute_type_r['s_attribute_type']."'";
				}
				
				$item_attr_sql .= "\nINSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( '$s_item_type', '".$s_item_attribute_type_r['s_attribute_type']."', '".$s_item_attribute_type_r['order_no']."', '".$s_item_attribute_type_r['prompt']."', '".$s_item_attribute_type_r['compulsory_ind']."');";
			}
			mysql_fetch_array($result);
		}

		$sqlscript ="#########################################################".
					"\n# OpenDb '$s_item_type' SQL definition".
					"\n#########################################################".
					"\n".
					"\n#".
					"\n# Cleanup".
					"\n#".
					"\nDELETE FROM s_item_type WHERE s_item_type = '$s_item_type';".
					"\nDELETE FROM s_item_attribute_type WHERE s_item_type = '$s_item_type';".
					(strlen($delete_attr_list)>0?"\nDELETE FROM s_attribute_type WHERE s_attribute_type IN($delete_attr_list);":"").
					(strlen($delete_lookup_list)>0?"\nDELETE FROM s_attribute_type_lookup WHERE s_attribute_type IN($delete_lookup_list);":"").
					"\n".
					$type_sql.
					$attr_sql.
					"\n".
					$item_attr_sql.
					"\n".
					$attr_lookup_sql;
					
		return $sqlscript;							
	}
	else
		return NULL;
}

/*
* Remove ALL records associated with an s_item_type, which includes:
* 	review
* 	borrowed_item
* 	item_attribute
* 	item_instance
* 	item
*/
function delete_sitemtype_items($s_item_type)
{
	global $HTTP_SESSION_VARS;
	
	$result = run_opendb_query("SELECT id as item_id FROM item WHERE s_item_type = '".$s_item_type."'");
	if($result && mysql_num_rows($result)>0)
	{
		while($item_r = mysql_fetch_array($result))
		{
			echo("<p class=\"success\">Deleting item ".$item_r['item_id']);
			echo("<ul class=\"success\">");
			
			if(run_opendb_query("DELETE FROM review WHERE item_id = ".$item_r['item_id']) && mysql_affected_rows()>0)
			{
				opendb_log("User deleted system item type review records. (uid=".$HTTP_SESSION_VARS['user_id'].", s_item_type=$s_item_type, item_id=".$item_r['item_id'].")");
				echo("<li>Review record(s)...</li>");
			}
			
			if(run_opendb_query("DELETE FROM borrowed_item WHERE item_id = ".$item_r['item_id']) && mysql_affected_rows()>0)
			{
				opendb_log("User deleted system item type borrowed_item records. (uid=".$HTTP_SESSION_VARS['user_id'].", s_item_type=$s_item_type, item_id=".$item_r['item_id'].")");
				echo("<li>Borrowed record(s)...</li>");
			}

			if(run_opendb_query("DELETE FROM item_attribute WHERE item_id = ".$item_r['item_id']) && mysql_affected_rows()>0)
			{
				opendb_log("User deleted system item type item_attribute records. (uid=".$HTTP_SESSION_VARS['user_id'].", s_item_type=$s_item_type, item_id=".$item_r['item_id'].")");
				echo("<li>Attribute record(s)...</li>");
			}
			
			if(run_opendb_query("DELETE FROM item_instance WHERE item_id = ".$item_r['item_id']) && mysql_affected_rows()>0)
			{
				opendb_log("User deleted system item type item_instance records. (uid=".$HTTP_SESSION_VARS['user_id'].", s_item_type=$s_item_type, item_id=".$item_r['item_id'].")");
				echo("<li>Instance record(s)...</li>");
			}
			
			if(run_opendb_query("DELETE FROM item WHERE id = ".$item_r['item_id']) && mysql_affected_rows()>0)
			{
				opendb_log("User deleted system item type item records. (uid=".$HTTP_SESSION_VARS['user_id'].", s_item_type=$s_item_type, item_id=".$item_r['item_id'].")");
				echo("<li>item record...</li>");
			}
			echo("</ul>");
			echo("</p>");
		}
		mysql_free_result($result);
		
		return TRUE;
	}
	else // By returning false, we make it clear that no items were found.
		return FALSE;
}

if (is_opendb_valid_session())
{
	if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		if($HTTP_VARS['op'] == 'help')
		{
			if(is_exists_attribute_type($HTTP_VARS['s_attribute_type']))
			{
				echo _theme_header("Attribute Type Info", FALSE);
				display_s_attribute_type_record($HTTP_VARS['s_attribute_type']);
			}
			else
			{
				echo _theme_header("Attribute Type Info", FALSE);
				echo _theme_error("System Attribute Type not found");
			}
		}
		else if ($HTTP_VARS['op'] == 'sql' && is_exists_item_type($HTTP_VARS['s_item_type']))
		{
			header("content-type: text/plain");
			echo generate_s_item_type_sql($HTTP_VARS['s_item_type']);
		}
		else if($HTTP_VARS['op'] == 'delete_sitem_type_items')
		{
			if($HTTP_VARS['confirmed'] == 'true')
			{
				echo "<h3>Delete Item Type (".$HTTP_VARS['s_item_type'].") Items</h3>";
				if(!delete_sitemtype_items($HTTP_VARS['s_item_type']))
					echo("<div class=\"success\">No Items found</div><br>");
				
				// Reset these two so the confirm works, and the edit form is NOT displayed.
				$HTTP_VARS['op'] = 'delete_confirm';
				$HTTP_VARS['confirmed'] = '';
				echo get_op_confirm_form(
						$PHP_SELF, 
						"Now that all dependant item(s) are deleted, do you want to delete the \"".$HTTP_VARS['s_item_type']."\" Item Type?",
						$HTTP_VARS);
			}
			else if($HTTP_VARS['confirmed'] == 'false')
			{
				echo "<h3>Delete Item Type (".$HTTP_VARS['s_item_type'].") Items</h3>";	
				echo "<div class=\"success\">Item Type not deleted</div>";
			}
			else //should never happen.
			{
				echo _theme_error('Invalid Operation');
			}
		}
		else if(is_exists_item_type($HTTP_VARS['s_item_type']) && $HTTP_VARS['op'] == 'delete_confirm') // This is initiated from the main s_item_type form.
		{
			// In the case where we are deleting the whole type, there is no need 
			// to check whether individual attributes exist, checking for items
			// is sufficient - we don't care about orphaned attributes.
			if(is_s_item_type_deletable($HTTP_VARS['s_item_type']))
			{
				if($HTTP_VARS['confirmed'] == 'false')
				{
					echo "<h3>Delete Item Type</h3>";	
					echo "<div class=\"success\">Item Type not deleted</div>";
				}
				else if($HTTP_VARS['confirmed'] != 'true')
				{
					echo "<h3>Delete Item Type</h3>";
					echo get_op_confirm_form(
							$PHP_SELF, 
							"Are you sure you want to delete Item Type \"".$HTTP_VARS['s_item_type']."\"?",
							$HTTP_VARS);
				}
				else // $HTTP_VARS['confirmed'] == 'true'
				{
					echo "<h3>Delete Item Type</h3>";
					
					if(delete_s_item_type($HTTP_VARS['s_item_type'], $HTTP_SESSION_VARS['user_id']))
					{
						echo "<div class=\"success\">Item Type \"".$HTTP_VARS['s_item_type']."\" deleted.</div>";
						
						// Check if there are any s_item_attribute_type records.					
						if(is_exists_item_attribute_type($HTTP_VARS['s_item_type'], NULL))
						{
							if(delete_s_item_attribute_type($HTTP_VARS['s_item_type'], NULL, NULL))
								echo "<div class=\"success\">Item Type attributes deleted.</div>";
							else
								echo format_error_block(array('error'=>'Item Type attributes not deleted','detail'=>mysql_error()));
						}
					}					
					else
					{
						echo format_error_block(array('error'=>'Item Type ('.$HTTP_VARS['s_item_type'].') not deleted','detail'=>mysql_error()));
					}
				}						
			}
			else
			{
				echo "<h3>Delete Item Type</h3>";
				echo format_error_block(array('error'=>'Item Type ('.$HTTP_VARS['s_item_type'].') not deleted','detail'=>'Item Type has dependant item(s).'));
				
				$HTTP_VARS['op'] = 'delete_sitem_type_items';
				echo get_op_confirm_form($PHP_SELF, 
										"<b>WARNING: <blink>THIS WILL REMOVE ALL ITEM RELATED RECORDS (review, borrowed_item, item_attribute, item_instance, item) FROM ALL USERS!!!</b></blink>".
												"<br>Do you want to delete all dependant item(s) for Item Type (".$HTTP_VARS['s_item_type'].")?", 
										$HTTP_VARS);
			}
		}
		else if($HTTP_VARS['op'] == 'insert_type')// Insert whole new item type
		{
			// All types are uppercase.
			$HTTP_VARS['s_item_type'] = strtoupper($HTTP_VARS['s_item_type']);
						
			// Get rid of all spaces, and illegal characters.
			$HTTP_VARS['s_item_type'] = preg_replace("/[\s|'|\\\\|\"]+/", "", trim(strip_tags($HTTP_VARS['s_item_type'])));

			if(strlen($HTTP_VARS['s_item_type'])>0)
			{
				if(!is_exists_item_type($HTTP_VARS['s_item_type']))//insert
				{
					// But a s_attribute_type must be supplied for s_field_type's
					// TITLE, STATUS, CATEGORY.   The DURATION is required if 
					// $CONFIG_VARS['borrow.enable'] == TRUE AND $CONFIG_VARS['borrow.duration_support'] == TRUE
					$missing_s_field_types = NULL;
					if(strlen($HTTP_VARS['s_field_type']['TITLE'])==0 || !is_exists_attribute_type($HTTP_VARS['s_field_type']['TITLE']))
						$missing_s_field_types[] = 'TITLE';
					if(strlen($HTTP_VARS['s_field_type']['STATUSCMNT'])==0 || !is_exists_attribute_type($HTTP_VARS['s_field_type']['STATUSCMNT']))
						$missing_s_field_types[] = 'STATUSCMNT';
					if(strlen($HTTP_VARS['s_field_type']['STATUSTYPE'])==0 || !is_exists_attribute_type($HTTP_VARS['s_field_type']['STATUSTYPE']))
						$missing_s_field_types[] = 'STATUSTYPE';
					if(strlen($HTTP_VARS['s_field_type']['CATEGORY'])==0 || !is_exists_attribute_type($HTTP_VARS['s_field_type']['CATEGORY']))
						$missing_s_field_types[] = 'CATEGORY';
					if($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['borrow.duration_support']!==FALSE && (strlen($HTTP_VARS['s_field_type']['DURATION'])==0 || !is_exists_attribute_type($HTTP_VARS['s_field_type']['DURATION'])))
						$missing_s_field_types[] = 'DURATION';
					
					if(is_empty_array($missing_s_field_types))
					{
						if(insert_s_item_type($HTTP_VARS['s_item_type'], $HTTP_VARS['order_no'], $HTTP_VARS['description'], $HTTP_VARS['image'], $HTTP_VARS['default_site_type']))
						{
							//Insert required system s_attribute_type's.
							insert_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_field_type']['TITLE'], '1', NULL, 'Y');
							insert_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_field_type']['CATEGORY'], '10', NULL, 'N');
							
							if($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['borrow.duration_support']!==FALSE)
								insert_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_field_type']['DURATION'], '200', NULL, 'N');
								
							insert_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_field_type']['STATUSTYPE'], '254', NULL, 'N');
							insert_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_field_type']['STATUSCMNT'], '255', NULL, 'N');
							
							echo("<div class=\"success\">Item Type (".$HTTP_VARS['s_item_type'].") inserted.</div>");
							
							// Load the edit_types form now.
							$HTTP_VARS['op'] = 'edit_types';
						}
						else
						{
							$errors[] = array('error'=>'Item Type ('.$HTTP_VARS['s_item_type'].') not inserted.','detail'=>mysql_error());
						}
					}
					else
					{
						$errors[] = array('error'=>'The following Attribute <i>Field Type\'s</i> are missing.',
							'detail'=>$missing_s_field_types);
					}
				}
				else
				{
					$errors[] = array('error'=>'Item Type ('.$HTTP_VARS['s_item_type'].') already exists.','detail'=>'');
				}
			}
			else
			{
				$errors[] = array('error'=>'Item Type not specified.','detail'=>'');
			}
			
			echo format_error_block($errors);
		}
		else if($HTTP_VARS['op'] == 'update_types') // This is initiated from the main s_item_type form.
		{
			if(is_not_empty_array($HTTP_VARS['s_item_type']))
			{
				for($i=0; $i<count($HTTP_VARS['s_item_type']); $i++)
				{
					if(is_exists_item_type($HTTP_VARS['s_item_type'][$i]))
					{
						if(!update_s_item_type($HTTP_VARS['s_item_type'][$i], $HTTP_VARS['order_no'][$i], $HTTP_VARS['description'][$i], $HTTP_VARS['image'][$i], $HTTP_VARS['default_site_type'][$i]))
						{
							$errors[] = array('error'=>'Item Type ('.$HTTP_VARS['s_item_type'][$i].') not updated','detail'=>mysql_error());
						}
					}
					else
					{
						$errors[] = array('error'=>'Item Type ('.$HTTP_VARS['s_item_type'][$i].') not found.', 'detail'=>'');
					}							
				}
				echo format_error_block($errors);
			}
		}
		else if($HTTP_VARS['op'] == 'update') // This is initiated from the lower s_item_attribute_type form.
		{
			if(is_exists_item_type($HTTP_VARS['s_item_type']))
			{
				if(is_not_empty_array($HTTP_VARS['s_attribute_type']))
				{
					for($i=0; $i<count($HTTP_VARS['s_attribute_type']); $i++)
					{
						//update or delete
						if($HTTP_VARS['exists_ind'][$i] == "Y")
						{
							// The 'old_order_no' will often be the same as 'order_no' but for instances where
							// they are different this test will match both!
							if(is_exists_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'][$i], $HTTP_VARS['old_order_no'][$i]))
							{
								// Delete record if delete_ind = Y or the order_no has been changed.
								// In the case of the changed order_no, we will be inserting it in the next
								// for loop, which is why the exists_ind is reset!
								if($HTTP_VARS['delete_ind'][$i] == "Y" || $HTTP_VARS['order_no'][$i] != $HTTP_VARS['old_order_no'][$i])
								{
									// TODO: Provide functionality to convert existing item_attribute records to the new format.
									if(is_s_item_attribute_type_deletable($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'][$i], $HTTP_VARS['old_order_no'][$i]))
									{
										if($HTTP_VARS['order_no'][$i] != $HTTP_VARS['old_order_no'][$i])
											$HTTP_VARS['exists_ind'][$i] = "N";
										
										// Delete old_order_no in both cases!
										if(!delete_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'][$i], $HTTP_VARS['old_order_no'][$i]))
										{
											$errors[] = array('error'=>'Item Attribute type ('.$HTTP_VARS['s_attribute_type'][$i].'['.$HTTP_VARS['old_order_no'][$i].']) not deleted','detail'=>mysql_error());
										}
									}
									else
									{
										$errors[] = array('error'=>'Item Attribute type ('.$HTTP_VARS['s_attribute_type'][$i].'['.$HTTP_VARS['old_order_no'][$i].']) not deleted','detail'=>'Dependant item attribute(s) with the same order_no exist.');
									}
								}
								else // 'old_order_no' IS THE SAME as 'order_no' here!
								{
									// At the moment we are not checking the order_no's for items with the same type.
									if(!update_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'][$i], $HTTP_VARS['order_no'][$i], $HTTP_VARS['prompt'][$i], $HTTP_VARS['compulsory_ind'][$i]))
									{
										$errors[] = array('error'=>'Item Attribute type ('.$HTTP_VARS['s_attribute_type'][$i].'['.$HTTP_VARS['old_order_no'][$i].']) not updated','detail'=>mysql_error());
									}
								}
							}
							else
							{
								$errors[] = array('error'=>'Item Attribute type ('.$HTTP_VARS['s_attribute_type'][$i].'['.$HTTP_VARS['old_order_no'][$i].']) not found','detail'=>mysql_error());
							}
						}
					}

					// Now do the inserts.
					for($i=0; $i<count($HTTP_VARS['s_attribute_type']); $i++)
					{
						// Ignore elements that have no order_no or old_order_no specified.
						if($HTTP_VARS['exists_ind'][$i] != "Y")
						{
							if(strlen($HTTP_VARS['s_attribute_type'][$i])>0)
							{
								if(is_numeric($HTTP_VARS['old_order_no'][$i]) || is_numeric($HTTP_VARS['order_no'][$i]))
								{
									if(!is_exists_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'][$i], $HTTP_VARS['order_no'][$i]))
									{
										if(!insert_s_item_attribute_type($HTTP_VARS['s_item_type'], $HTTP_VARS['s_attribute_type'][$i], $HTTP_VARS['order_no'][$i], $HTTP_VARS['prompt'][$i], $HTTP_VARS['compulsory_ind'][$i]))
										{
											$errors[] = array('error'=>'Item Attribute type ('.$HTTP_VARS['s_attribute_type'][$i].'['.$HTTP_VARS['old_order_no'][$i].']) not inserted','detail'=>mysql_error());
										}
									}
									else
									{
										// Cache any records that could not be inserted.
										$sait_already_exists[] = array('s_attribute_type'=>$HTTP_VARS['s_attribute_type'][$i],'order_no'=>$HTTP_VARS['order_no'][$i],'prompt'=>$HTTP_VARS['prompt'][$i], 'compulsory_ind'=>$HTTP_VARS['compulsory_ind'][$i]);
									}
								}
								else
								{
									$errors[] = array('error'=>'Item Attribute type ('.$HTTP_VARS['s_attribute_type'][$i].') not inserted','detail'=>'No order_no specified.');
								}
							}//if(strlen($HTTP_VARS['s_attribute_type'][$i])>0)
						}
					}
				}
			}
			else
			{
				$errors[] = array('error'=>'Item Type ('.$HTTP_VARS['s_item_type'].') not found', 'detail'=>'');
			}
		}

		// Reload edit page after an update.
		if($HTTP_VARS['op'] == 'edit' || $HTTP_VARS['op'] == 'update')
		{
			echo("<div class=\"footer\">[<a href=\"$PHP_SELF?type=s_item_type&op=edit_types\">Back to Types</a>]</div>");
			
			$item_type_r = fetch_s_item_type_r($HTTP_VARS['s_item_type']);
			if($item_type_r!==FALSE)
			{
				echo get_validation_javascript();

				// Get the theme specific source of the image.
				echo("\n<h3>");
				if(strlen($item_type_r['image'])>0)
				{
					$src = _theme_image_src($item_type_r['image']);
					if($src!==FALSE && strlen($src)>0)
						echo("<img src=\"$src\">&nbsp;");
				}
				echo($item_type_r['s_item_type']." System Attributes</h3>");
				
				if(is_not_empty_array($errors))
				{
					echo format_error_block($errors);
				}
				
				$column_count = 6;
				echo("\n<form name=\"s_item_attribute_type\" action=\"$PHP_SELF\" method=\"post\">");
				echo("<table cellspacing=2 border=0>");
				echo("<tr><td colspan=$column_count>");				
				echo("\n<input type=\"hidden\" name=\"op\" value=\"update\">".
					"\n<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">".
					"\n<input type=\"hidden\" name=\"s_item_type\" value=\"".$HTTP_VARS['s_item_type']."\">".
					"</td></tr>");

				echo("<tr>"
					."<td class=\"navbar\">Delete</td>"
					."<td class=\"navbar\">Order</td>"
					."<td class=\"navbar\" colspan=2>Attribute Type [Field Type]</td>"
					."<td class=\"navbar\">Prompt</td>"
					."<td class=\"navbar\">Compulsory</td>"
					."</tr>");	
				
				$results = fetch_s_item_attribute_type_rs($HTTP_VARS['s_item_type']);
				if($results)
				{
					// value, display, img, checked_ind, order_no
					$row = 0;
					while($item_attribute_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
					{
						display_s_item_attribute_type_row($HTTP_VARS['s_item_type'], $item_attribute_type_r, $row);
						$row++;
					}
					mysql_free_result($results);
				}
	
				// Now display records that could not be inserted.
				if(is_not_empty_array($sait_already_exists))
				{
					while(list(,$sait_r) = each($sait_already_exists))
					{
						display_s_item_attribute_type_row($HTTP_VARS['s_item_type'], $sait_r, $row, TRUE);
						$row++;
					}
				}

				if(is_numeric($HTTP_VARS['blank_rows']))
					$blank_rows = (int)$HTTP_VARS['blank_rows'];
				else
					$blank_rows = 5;

				for($i=$row; $i<$row+$blank_rows; $i++)
				{
					display_s_item_attribute_type_row($HTTP_VARS['s_item_type'], array(), $i);	
				}
			
				echo("<tr>");
				echo("<td colspan=2 align=center>".
					get_input_field("blank_rows", NULL, NULL, "value_select(\"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20\",1)", "N", ifempty($HTTP_VARS['blank_rows'],"5"), FALSE, NULL, "this.form.submit();")
					."</td>");

				echo("<td colspan=".($column_count-2)." align=center>");
				echo("<input type=button value=\"Refresh\" onclick=\"this.form['op'].value='edit'; this.form.submit();\">&nbsp;<input type=button value=\"Update\" onclick=\"this.form['op'].value='update'; this.form.submit();\"></td>");
				echo("</tr>");
				
				echo("</form>");
				echo("</table>");

				// Only display if duplicates exist!
				if(is_not_empty_array($sait_already_exists))
				{
					$help_entries_rs[] = array('img'=>'rs.gif', 'text'=>'Duplicate Attribute Type & Order No');
					while(list(,$help_entries_r) = each($_FORM_HELP['siat']))
						$help_entries_rs[] = $help_entries_r;
					echo(format_help_block($help_entries_rs));
				}	
				else
					echo(format_help_block($_FORM_HELP['siat']));
			}
			else
			{
				echo format_error_block('Item Type ('.$HTTP_VARS['s_item_type'].') not found');
			}				
		}
		else if($HTTP_VARS['op'] == 'new_type' || $HTTP_VARS['op'] == 'insert_type')// Insert type form!
		{
			echo("<div class=\"footer\">[<a href=\"$PHP_SELF?type=s_item_type&op=edit_types\">Back to Types</a>]</div>");
			echo get_validation_javascript();
				
			echo("\n<h3>New Item Type</h3>");

			echo("\n<table cellspacing=2 border=0>");
			echo("\n<form name=\"s_item_type\" action=\"$PHP_SELF\" method=\"post\">");
	
			echo("\n<input type=\"hidden\" name=\"op\" value=\"insert_type\">");
			echo("\n<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">");
				
			display_s_item_type_insert_form($HTTP_VARS['op']=='insert_type'?$HTTP_VARS:NULL);
				
			echo("\n<tr><td colspan=\"2\" align=center>");
			if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
			{
				echo("\n<input type=button value=\"Insert\" onclick=\"if(!checkForm(this.form)){return false;}else{this.form.submit();}\">");
			}
			else
			{
				echo("\n<input type=button value=\"Insert\" onclick=\"this.form.submit();\">");
			}
			echo("\n</td></tr>");

			echo("\n</form>");
			echo("\n</table>");
		}
		
		// There are specific operations where this form should be displayed.
		if(strlen($HTTP_VARS['op'])==0 || (($HTTP_VARS['op'] == 'delete_sitem_type_items' && $HTTP_VARS['confirmed'] == 'false' || $HTTP_VARS['confirmed'] == 'true')) || (($HTTP_VARS['op'] == 'delete_confirm' && $HTTP_VARS['confirmed'] == 'false' || $HTTP_VARS['confirmed'] == 'true')) || $HTTP_VARS['op'] == 'edit_types' || $HTTP_VARS['op'] == 'update_types')
		{
			echo get_validation_javascript();

			echo("<form name=\"navigate\" action=\"$PHP_SELF\" method=\"get\">".
				"<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">".
				"<input type=\"hidden\" name=\"op\" value=\"\">".
				"<input type=\"hidden\" name=\"s_item_type\" value=\"\">".
				"<input type=\"hidden\" name=\"blank_rows\" value=\"5\">".
				"</form>");
			
			echo("<table cellspacing=2 border=0>");
			echo("\n<form name=\"s_item_type\" action=\"$PHP_SELF\" method=\"post\">");

			echo("\n<input type=\"hidden\" name=\"op\" value=\"update_types\">");
			echo("\n<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">");

			echo("<tr>"
				."<td class=\"navbar\">Order</td>"
				."<td class=\"navbar\">Type</td>"
				."<td class=\"navbar\">Description</td>"
				."<td class=\"navbar\" colspan=2>Image</td>"
				."<td class=\"navbar\">Default<br>Site Type</td>"
				."<td class=\"navbar\">&nbsp;</td>"
				."</tr>");	
			$column_count = 7;
			
			$results = fetch_s_item_type_rs();
			if($results)
			{
				// value, display, img, checked_ind, order_no
				$row = 0;
				while($item_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
				{
					display_s_item_type_row($item_type_r, $row);
					$row++;
				}
				mysql_free_result($results);
			}

			echo("<tr>".
				"<td colspan=".($column_count)." align=center>".
				"<input type=button value=\"Refresh\" onclick=\"this.form['op'].value='edit_types'; this.form.submit();\">".
				"&nbsp;".
				"<input type=button value=\"Update\" onclick=\"this.form['op'].value='update_types'; this.form.submit();\">".
				"&nbsp;".
				"<input type=button value=\"Add New Type\" onclick=\"this.form['op'].value='new_type'; this.form.submit();\">".
				"</td>".
				"</tr>");

			echo("</form>");
			echo("</table>");
			
			echo(format_help_block($_FORM_HELP['sit']));
		}			
	}
}
?>
