<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/function.php");
include_once("./functions/utils.php");
include_once("./functions/datetime.php");
include_once("./functions/http.php");
include_once("./functions/user.php");
include_once("./functions/review.php");
include_once("./functions/borrowed_item.php");
include_once("./functions/item.php");
include_once("./functions/widgets.php");
include_once("./functions/item_type.php");
include_once("./functions/listings.php");
include_once("./functions/status_type.php");
include_once("./functions/export.php");
include_once("./functions/item_attribute.php");

//For site plugins.
include_once("./functions/site.php");

/**
	@selected will be currently selected record.

	$borrow_duration is the item_instance.borrow_duration value in all cases, the rest of the values to do
	with borrow duration will be calculated.
*/
function get_item_status_row($class, $item_id, $instance_no, $s_item_type, $owner_id, $borrow_duration, $s_status_type, $status_comment, $listing_link, $selected)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;

	$rowcontents = "\n<tr><td class=\"$class\" align=center>$instance_no";
	if($selected)
		$rowcontents .= "&nbsp;"._theme_image("tick.gif", NULL, $LANG_VARS['current_item_instance']);
	$rowcontents .= "\n</td>";
	
	$rowcontents .= "<td class=\"$class\" align=center>".
			get_list_username($owner_id, NULL, $CONFIG_VARS['item_display.owner_email_link'], $LANG_VARS['back_to_item'], 'item_display.php?item_id='.$item_id.'&instance_no='.$instance_no.'&listing_link='.$listing_link).
			"</td>";
	
	$status_type_r = fetch_status_type_r($s_status_type);		
	
	// ---------------------- Borrow,Reserve,Cancel,Edit,Delete,etc operations here.
	$action_links_rs = NULL;
	
	if($HTTP_SESSION_VARS['user_id'] === $owner_id || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		$action_links_rs[] = array(url=>'item_input.php?op=updateinstance&item_id='.$item_id.'&instance_no='.$instance_no.'&listing_link='.$listing_link,img=>'update.gif',text=>$LANG_VARS['update']);
		$action_links_rs[] = array(url=>'item_input.php?op=edit&item_id='.$item_id.'&instance_no='.$instance_no.'&listing_link='.$listing_link,img=>'edit.gif',text=>$LANG_VARS['edit']);

		// Checks if any legal site plugins defined for $s_item_type
		if(is_item_legal_site_type($s_item_type))
		{
			$action_links_rs[] = array(url=>'item_add.php?item_id='.$item_id.'&instance_no='.$instance_no.'&item_link=y&listing_link='.$listing_link,img=>'refresh.gif',text=>$LANG_VARS['refresh']);
		}
		
		if($status_type_r['delete_ind'] == 'Y' && !is_item_reserved_or_borrowed($item_id, $instance_no))
			$action_links_rs[] = array(url=>'item_input.php?op=delete&item_id='.$item_id.'&instance_no='.$instance_no.'&listing_link='.$listing_link,img=>'delete.gif',text=>$LANG_VARS['delete']);		
		
		// Quick checkout NOT available to Admin user, unless they are also explicitly the owner.
		if($CONFIG_VARS['borrow.enable']!==FALSE && $HTTP_SESSION_VARS['user_id'] === $owner_id && $CONFIG_VARS['borrow.quick_checkout']!==FALSE && ($status_type_r['borrow_ind'] == 'Y' || $status_type_r['borrow_ind'] == 'N'))
		{
			// Cannot quick checkout an item already borrowed.
			if(!is_item_borrowed($item_id, $instance_no))
			{
				$action_links_rs[] = array(url=>'item_borrow.php?op=quick_check_out&item_id='.$item_id.'&instance_no='.$instance_no.'&item_link=y&listing_link='.$listing_link,img=>'quick_check_out.gif',text=>$LANG_VARS['quick_check_out']);
			}						
		}
	}
	
	if($HTTP_SESSION_VARS['user_id'] !== $owner_id && 
				is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) && 
				(strlen($status_type_r['min_display_user_type'])==0 || in_array($status_type_r['min_display_user_type'], get_min_user_type_r($HTTP_SESSION_VARS['user_type'])))
			)
	{
		if($CONFIG_VARS['borrow.enable']!==FALSE)
		{
			// Check if already in reservation session variable.
			if($CONFIG_VARS['borrow.reserve_basket']!==FALSE && is_not_empty_array($HTTP_SESSION_VARS['reserve_basket_listing']) && in_array($item_id."_".$instance_no, $HTTP_SESSION_VARS['reserve_basket_listing']))
			{
				$action_links_rs[] = array(url=>'borrow.php?op=delete_from_my_reserve_basket&item_id='.$item_id.'&instance_no='.$instance_no.'&item_link=y&listing_link='.$listing_link,img=>'delete_from_reserve_list.gif',text=>$LANG_VARS['delete_from_reserve_list']);		
			}
			else if(is_item_reserved_or_borrowed($item_id, $instance_no))
			{
				if(is_item_reserved_by_user($item_id, $instance_no, $HTTP_SESSION_VARS['user_id']))
				{
					$action_links_rs[] = array(url=>'item_borrow.php?op=cancel_reserve&item_id='.$item_id.'&instance_no='.$instance_no.'&item_link=y&listing_link='.$listing_link,img=>'cancel.gif',text=>$LANG_VARS['cancel_reservation']);
				}
				else if(!is_item_borrowed_by_user($item_id, $instance_no, $HTTP_SESSION_VARS['user_id']))
				{
					if($status_type_r['borrow_ind'] == 'Y' &&
								($CONFIG_VARS['borrow.allow_reserve_if_borrowed']!==FALSE || !is_item_borrowed($item_id, $instance_no)) &&
								($CONFIG_VARS['borrow.allow_multi_reserve']!==FALSE || !is_item_reserved($item_id, $instance_no)) )
					{
						if($CONFIG_VARS['borrow.reserve_basket']!==FALSE)
						{
							$action_links_rs[] = array(url=>'borrow.php?op=update_my_reserve_basket&item_id='.$item_id.'&instance_no='.$instance_no.'&item_link=y&listing_link='.$listing_link,img=>'add_to_reserve_list.gif',text=>$LANG_VARS['add_to_reserve_list']);
						}
						else
						{
							$action_links_rs[] = array(url=>'item_borrow.php?op=reserve&item_id='.$item_id.'&instance_no='.$instance_no.'&item_link=y&listing_link='.$listing_link,img=>'reserve.gif',text=>$LANG_VARS['reserve_item']);
						}
					}
				}
			}
			else
			{   
				if($status_type_r['borrow_ind'] == 'Y')
				{
					if($CONFIG_VARS['borrow.reserve_basket']!==FALSE)
					{
						$action_links_rs[] = array(url=>'borrow.php?op=update_my_reserve_basket&item_id='.$item_id.'&instance_no='.$instance_no.'&item_link=y&listing_link='.$listing_link,img=>'add_to_reserve_list.gif',text=>$LANG_VARS['add_to_reserve_list']);
					}
					else
					{
						$action_links_rs[] = array(url=>'item_borrow.php?op=reserve&item_id='.$item_id.'&instance_no='.$instance_no.'&item_link=y&listing_link='.$listing_link,img=>'borrow.gif',text=>$LANG_VARS['borrow_item']);
					}
				}
			}
		}			
	} // else -- guest user
	
	if($CONFIG_VARS['borrow.enable']!==FALSE && ($HTTP_SESSION_VARS['user_id'] === $owner_id || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type'])) && is_exists_item_instance_borrowed_item($item_id, $instance_no))
	{
		$action_links_rs[] = array(url=>'borrow.php?op=my_item_history&item_id='.$item_id.'&instance_no='.$instance_no.'&listing_link='.$listing_link,img=>'item_history.gif',text=>$LANG_VARS['item_history']);
	}
	
	$rowcontents .= format_action_links(
								$action_links_rs,
								"\n<td align=\"center\" class=\"$class\" %nowrap%><font class=\"smlink\">%field%</font></td>",
								$LANG_VARS['not_applicable']);

	// Item Status Image.
	$rowcontents .= "\n<td class=\"$class\" align=center>";
	if(is_item_borrowed($item_id, $instance_no))
	{
		$rowcontents .= _theme_image("borrowed.gif", $LANG_VARS['borrowed'], NULL, NULL, "borrowed_item");
	}
	else if(($status_type_r['borrow_ind'] == 'Y' || $status_type_r['borrow_ind'] == 'N') && is_item_reserved($item_id, $instance_no))
	{
		$rowcontents .= _theme_image("reserved.gif", $LANG_VARS['reserved'], NULL, NULL, "borrowed_item");
	}
	else
	{
		$rowcontents .= _theme_image($status_type_r['img'], $status_type_r['description'], NULL, NULL, "borrowed_item");
	}
	
	$rowcontents .= "\n</td>";
	
	// If a comment is allowed and defined, add it in.
	$rowcontents .= "\n<td class=\"$class\" align=center>";
	if($status_type_r['status_comment_ind'] == 'Y' || ($status_type_r['status_comment_ind'] == 'H' && ($HTTP_SESSION_VARS['user_id'] === $owner_id || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))))
		$rowcontents .= ifempty(nl2br($status_comment),"&nbsp;"); // support newlines in this field
	else
		$rowcontents .= $LANG_VARS['not_applicable'];
	$rowcontents .= "\n</td>";
	
	if($CONFIG_VARS['borrow.enable']!==FALSE)
	{
		if($CONFIG_VARS['borrow.include_borrower_column']!==FALSE)
		{
			$rowcontents .= "\n<td class=\"$class\" align=center>";
			if(is_item_borrowed($item_id, $instance_no))
				$rowcontents .= get_list_username(fetch_item_borrower($item_id, $instance_no), NULL, $CONFIG_VARS['item_display.borrower_email_link'], $LANG_VARS['back_to_item'], 'item_display.php?item_id='.$item_id.'&instance_no='.$instance_no.'&listing_link='.$listing_link);
			else
				$rowcontents .= $LANG_VARS['not_applicable'];
			$rowcontents .= "\n</td>";
		}
		
		if($CONFIG_VARS['borrow.duration_support']!==FALSE)
		{
			// 'Due Back' functionality.	
			$rowcontents .= "\n<td class=\"$class\" align=center>";
			if(is_item_borrowed($item_id, $instance_no))
			{
				$due_date = fetch_item_duedate_timestamp($item_id, $instance_no);
				if(strlen($due_date)>0)
					$rowcontents .= get_localised_timestamp($CONFIG_VARS['borrow.date_mask'], $due_date);
				else
					$rowcontents .= $LANG_VARS['undefined'];
			}
			else if($status_type_r['borrow_ind'] != 'Y' && $status_type_r['borrow_ind'] != 'N')// s_status_type CAN be changed to 
				$rowcontents .= $LANG_VARS['not_applicable'];							// type with borrow_ind=N, even if item checked out / reserved
			else if(is_numeric($borrow_duration))
			{
				$duration_attr_type_r = fetch_sfieldtype_item_attribute_type_r($s_item_type, 'DURATION', TRUE);
				$rowcontents .= get_display_field($duration_attr_type_r['s_attribute_type'], NULL, $duration_attr_type_r['display_type'], $borrow_duration, FALSE);
			}
			else
				$rowcontents .= $LANG_VARS['undefined'];
			$rowcontents .= "\n</td>";
		}
	}
	
	$rowcontents .= "\n</tr>";
	return $rowcontents;		
}

session_start();
if (is_opendb_valid_session())
{
	if(is_numeric($HTTP_VARS['parent_id']) && is_numeric($HTTP_VARS['parent_instance_no']))
		$parent_item_r = fetch_item_instance_r($HTTP_VARS['parent_id'], $HTTP_VARS['parent_instance_no']);
		
	if(is_not_empty_array($parent_item_r))
		$item_r = fetch_child_item_r($HTTP_VARS['item_id']);
	else if(is_numeric($HTTP_VARS['instance_no']))
		$item_r = fetch_item_instance_r($HTTP_VARS['item_id'], $HTTP_VARS['instance_no']);

	if(is_not_empty_array($item_r))
	{
		if(is_not_empty_array($parent_item_r))
			$status_type_r = fetch_status_type_r($parent_item_r['s_status_type']);
		else
			$status_type_r = fetch_status_type_r($item_r['s_status_type']);
		
		if(( (is_not_empty_array($parent_item_r) && $parent_item_r['owner_id'] == $HTTP_SESSION_VARS['user_id']) || 
					(!is_array($parent_item_r) && $item_r['owner_id'] == $HTTP_SESSION_VARS['user_id']) ) ||
					(strlen($status_type_r['min_display_user_type'])==0 || in_array($status_type_r['min_display_user_type'], get_min_user_type_r($HTTP_SESSION_VARS['user_type']))))
		{
			$page_title = expand_item_title_mask($item_r['title'], $item_r['s_item_type'], $item_r['item_id'], $item_r['instance_no'], $item_r['s_status_type'], $CONFIG_VARS['item_display.title_display_mask']);
			echo _theme_header($page_title, $HTTP_VARS['inc_menu']);
		
			echo("<table width=90% border=0 frameborder=0 cellspacing=1>");
			echo("<tr><td valign=bottom>");
	    
			// Show heading...
			echo ("<h2>".$page_title." ".get_item_image($item_r['s_item_type'], $item_r['item_id'], is_numeric($item_r['parent_id']))."</h2>\n");
		
			// --------------------- Indicate whether title has been reviewed or not -----------
			echo("<div class=\"colortext\">");
			if(!is_item_reviewed($item_r['item_id']))
			{
				echo("<b>".$LANG_VARS['not_reviewed']."</b>");
				if(is_user_allowed_to_review($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
					echo ("&nbsp;[<a href=\"item_review.php?op=add&item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link']."\">".$LANG_VARS['review']."</a>]");
			}
			else
			{
				$average = fetch_review_rating($item_r['item_id']);
				echo ("<b>".$LANG_VARS['rating'].":</b> ");
				if ($average == 0)
				{
					echo($LANG_VARS['no_rating']);
				}
				else
				{
					$attribute_type_r = fetch_attribute_type_r("S_RATING");
					echo get_display_field($attribute_type_r['s_attribute_type'], 
								NULL, 
								'review()',
								$average,
								FALSE);
				}
			}
			echo("</div>\n");
			echo ("</td>");

			// ---------------- Display IMAGE attributes ------------------------------------
			// Will bypass the display of images if the config.php $CONFIG_VARS['item_display.show_item_image']
			// variable has been explicitly set to FALSE.  This means that if the variable does 
			// not exist, this block should still execute.
			if($CONFIG_VARS['item_display.show_item_image']!==FALSE)
			{
				echo get_popup_javascript();
			
				// Here we need to get the image_attribute_type and check if it is set.
				$results = fetch_sfieldtype_item_attribute_type_rs($item_r['s_item_type'], 'IMAGE', FALSE, TRUE);
				echo("<td align=right>");
				if($results)
				{
					echo("<table border=0><tr>");
					while($image_attribute_type_r = mysql_fetch_array($results))
					{
						$image_attribute_type_r = fetch_siat_with_prompt_and_val_r($item_r['s_item_type'], $image_attribute_type_r['s_attribute_type'], $image_attribute_type_r['order_no'], $item_r['item_id']);
						// If an image is specified.
						if($image_attribute_type_r && strlen($image_attribute_type_r['attribute_val'])>0)
						{
							$imagetag = $image_attribute_type_r['attribute_val'];
	
							// No need to check_url() as we will show a broken image if not found.
							if(strlen($imagetag)>0 && ( (is_url_absolute($imagetag)) || file_exists($imagetag) ) )
							{
								// Only works for local images - this is for the size of the popup, not the display size of the image.
								if(!is_url_absolute($imagetag))
									$size = getimagesize($imagetag);
								else
								{
									$size=null;
									
									if(strlen($image_attribute_type_r['display_type'])>0)
									{
										$widget = prc_function_spec($image_attribute_type_r['display_type']);
										// The dedicated popupsize or urlpopup, if also displaying in list, can both be used.
										if(($widget['type'] == 'popupsize' || $widget['type'] == 'urlpopup') && is_not_empty_array($widget['args']))
											$size = $widget['args'];
									}
								
									//if still null, default default.
									if($size==null)
										$size = array(0=>"400",1=>"300");
								}
							
								// Check whether item image size has been predefined!
								echo("<td><a href=\"javascript:popup('$imagetag','".($size[0]+20)."', '".($size[1]+25)."')\"><img src=\"$imagetag\" border=0 title=\"".$image_attribute_type_r['prompt']."\" ");
								if(strlen($CONFIG_VARS['item_display.item_image_size'])>0)
									echo($CONFIG_VARS['item_display.item_image_size']);
								else
									echo("width=\"100\" height=\"140\"");
								echo("></a></td>");
							}
						}
					}
					mysql_free_result($results);
					echo("</tr></table>");
				}
				else
					echo("&nbsp;");
				echo("</td>");
				// -------------------------------------------------------------------------
			}
			echo("</tr></table>");

			echo("<table width=90% border=0 frameborder=0 cellspacing=1>");
			// Do all the attributes.  Ignore any attributes that have an input_type of hidden.
			$results = fetch_item_attribute_type_with_val_rs($item_r['s_item_type'], $item_r['item_id'], TRUE, TRUE, TRUE);
			if($results)
			{
				while($item_attribute_type_r = mysql_fetch_array($results))
				{
					// If display_type == '' AND input_type == 'hidden' we set to 'hidden'
					$display_type = trim($item_attribute_type_r['display_type']);
					if(strlen($display_type)==0 && strcasecmp(get_function_type(trim($item_attribute_type_r['input_type'])),'hidden')==0)
					{
						// We allow the get_display_field to handle hidden variable, in case at some stage
						// we might want to change the functionality of 'hidden' to something other than ignore.
						$display_type = "hidden";
					}

					if($item_attribute_type_r['s_field_type'] != 'DURATION')
					{
						if($item_attribute_type_r['s_field_type'] == 'CATEGORY')
							$value = $item_r['category'];
						else if($item_attribute_type_r['s_field_type'] == 'ITEM_ID')
							$value = $item_r['item_id'];
						else
							$value = $item_attribute_type_r['attribute_val'];

						// Only show attributes which have a value.
						if(strlen($value)>0)
						{
							echo get_display_field(
									$item_attribute_type_r['s_attribute_type'],
									$item_attribute_type_r['prompt'],
									$display_type,
									$value);
						}
					}
				}
				mysql_free_result($results);
			}

			// ---------------------Site Link Block -----------------------
			echo("\n<tr><td colspan=2 align=right>");
			echo get_site_links_table($item_r);
			echo("\n</td></tr></table>");
			// -------------------------------------------------------------

			// There are no instances for child items.
			if(!is_array($parent_item_r))
			{
				$instance_info_links = NULL;
			
				if($status_type_r['insert_ind'] == 'Y' && is_user_allowed_to_own($HTTP_SESSION_VARS['user_id']))
				{
				 	if(is_exists_item_instance_with_owner_and_status($item_r['item_id'], $item_r['s_status_type'], $HTTP_SESSION_VARS['user_id']))
					{
						if($CONFIG_VARS['item_input.item_instance_support'] !== FALSE && $status_type_r['new_owner_instance_ind'] == 'Y')
							$instance_info_links[] = array(url=>"item_input.php?op=newinstance&item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['new_item_instance']);
					}
					else if($CONFIG_VARS['item_input.new_instance_owner_only'] !== TRUE && $status_type_r['new_not_owner_instance_ind'] == 'Y')
						$instance_info_links[] = array(url=>"item_input.php?op=newinstance&item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['new_item_instance']);
				
					if($CONFIG_VARS['item_input.clone_item_support'] !== FALSE)
					{
						$instance_info_links[] = array(url=>"item_input.php?op=clone_item&item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['clone_item']);
					}
				}
				
				echo("\n<a name=\"item_instance\"></a>".
					"\n<p><div class=\"colortext\"><b>".$LANG_VARS['instance_info'].":</b> ".
					(is_not_empty_array($instance_info_links)?"[".format_action_links($instance_info_links)."]":"").
					"\n</div>".
					"\n<table width=90% border=0 cellpadding=0 cellspacing=1>".
					"\n<tr>".
					"\n<td class=\"navbar\" align=center>&nbsp;".$LANG_VARS['instance']."&nbsp;</div></td>".
					"\n<td class=\"navbar\" align=center>".$LANG_VARS['owner']."</td>".
					"\n<td class=\"navbar\" align=center>".$LANG_VARS['action']."</td>".
					"\n<td class=\"navbar\" align=center>".$LANG_VARS['s_status_type']."</td>".
					"\n<td class=\"navbar\" align=center>".$LANG_VARS['status_comment']."</td>");
				
				$columns = 4;
				if($CONFIG_VARS['borrow.enable']!==FALSE)
				{
					if($CONFIG_VARS['borrow.include_borrower_column']!==FALSE)
					{
						echo("\n<td class=\"navbar\" align=center>".$LANG_VARS['borrower']."</td>");
						$columns++;
					}
					
					if($CONFIG_VARS['borrow.duration_support']!==FALSE)
					{
						echo("\n<td class=\"navbar\" align=center>".$LANG_VARS['due_date_or_duration']."</td>");
						$columns++;
					}
				}
				echo("\n</tr>");

				// -------------------
				if($CONFIG_VARS['item_input.item_instance_support'] !== FALSE)
				{
					// Now do the Status Info:
					$results = fetch_item_instance_rs($item_r['item_id'], NULL);
					if($results)
					{
						$toggle=TRUE;
						$numrows = mysql_num_rows($results);
						while($item_instance_r = mysql_fetch_array($results))
						{
							if($toggle)
								$color="top";
							else
		 						$color="top2";
							$toggle = !$toggle;
							
							echo get_item_status_row($color,
											$item_instance_r['item_id'], 
											$item_instance_r['instance_no'], 
											$item_r['s_item_type'], 
											$item_instance_r['owner_id'], 
											$item_instance_r['borrow_duration'], 
											$item_instance_r['s_status_type'], 
											$item_instance_r['status_comment'], 
											$HTTP_VARS['listing_link'], 
											$numrows>1 && $item_r['instance_no']===$item_instance_r['instance_no']);
						}
					}
					else
					{	// No instances found, because user has been deactivated and/or items are hidden.
						echo("<tr><td colspan=$columns align=center><div class=\"error\">- ".$LANG_VARS['no_records_found']." -</div></td></tr>");
					}
				}
				else//lone instance only.
				{
					$numrows = 1;
					echo get_item_status_row("top",
								$item_r['item_id'], 
								$item_r['instance_no'], 
								$item_r['s_item_type'], 
								$item_r['owner_id'], 
								$item_r['borrow_duration'], 
								$item_r['s_status_type'], 
								$item_r['status_comment'], 
								$HTTP_VARS['listing_link'], 
								FALSE);
				}
				echo("\n</table>");
				if($numrows>1)
					echo(format_help_block(array('img'=>'tick.gif','text'=>$LANG_VARS['current_item_instance'])));
				else
					echo("\n<br>");
				
				// ---------------------- Child items here.
				$results = fetch_child_item_rs($item_r['item_id']);
				if($results)
				{
					// A interpage link to be used from listings.
					echo("\n<a name=\"linked_item\"></a>".
						"\n<br><div class=\"colortext\"><b>".$LANG_VARS['linked_item(s)'].":</b>&nbsp;");
					
					if($CONFIG_VARS['item_input.linked_item_support'] !== FALSE)
					{
						echo("[<a href=\"item_add.php?".($CONFIG_VARS['item_input.link_same_type_only']===TRUE?"s_item_type=".$item_r['s_item_type']."&":"")."parent_id=".$item_r['item_id']."&parent_instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link']."\">".$LANG_VARS['add_linked']."</a>]");
					}	
					echo("</div>".
						"<table border=0 width=90% cellpadding=0 cellspacing=1>".
						"<tr>".
							"<td class=\"navbar\" align=center>".$LANG_VARS['type']."</div></td>".
							"<td class=\"navbar\" align=center width=40%>".$LANG_VARS['title']."</div></td>".
							"<td class=\"navbar\" align=center>".$LANG_VARS['action']."</div></td>".
							"<td class=\"navbar\" align=center>".$LANG_VARS['category']."</div></td>".
						"</tr>");
					
					$toggle = TRUE;
					// Will not allow edit of child records from here, must go through item_input.php
					while($child_item_r = mysql_fetch_array($results))
					{
						if($toggle)
							$color="top";
						else
		 					$color="top2";
						$toggle = !$toggle;
							
						echo("\n<tr>");
						echo("\n<td class=\"$color\" align=center>".get_item_image($child_item_r['s_item_type'],NULL,TRUE)."</td>");
						
						$child_item_r['title'] = expand_type_title_mask($child_item_r['title'], $child_item_r['s_item_type'], $child_item_r['item_id'], NULL, $child_item_r['s_status_type'], $CONFIG_VARS['listings.title_display_mask'], $parsed_title_mask_r);
						$title = "<a href=\"$PHP_SELF?item_id=".$child_item_r['item_id']."&parent_id=".$item_r['item_id']."&parent_instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link']."\">".$child_item_r['title']."</a>";
						$append_to_title = "";
						if (is_item_reviewed($child_item_r['item_id']))
							$append_to_title = _theme_image("rs.gif", NULL, $LANG_VARS['item_reviewed']); // show star if rated
							
						if($CONFIG_VARS['item_display.show_linked_item_image']!==FALSE)
						{
							echo("<td align=\"center\" class=\"$color\">".
								"<table width=100% border=0 cellpadding=0 cellspacing=0><tr><td width=10% class=\"$color\">".
								get_item_cover_image($child_item_r['item_id'],$child_item_r['s_item_type'], $item_type_rs).
								"</td>".
								"<td align=\"center\" class=\"$color\">".
								$title.
							   	(strlen($append_to_title)>0?"&nbsp;".$append_to_title:"").
								"</td></tr></table></td>");
						}	
						else
						{
							echo("<td align=\"center\" class=\"$color\">".
								$title.
						    	(strlen($append_to_title)>0?"&nbsp;".$append_to_title:"").
								"</td>");
						}
						
						$action_links_rs = NULL;
						
						$action_links_rs[] = array(url=>'item_input.php?op=edit&item_id='.$child_item_r['item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'edit.gif',text=>$LANG_VARS['edit']);
						if($CONFIG_VARS['listings.show_refresh_links'] && is_item_site_type($child_item_r['s_item_type']))
						{
							$action_links_rs[] = array(url=>'item_add.php?item_id='.$child_item_r['item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'refresh.gif',text=>$LANG_VARS['refresh']);
						}
						$action_links_rs[] = array(url=>'item_input.php?op=delete&item_id='.$child_item_r['item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'delete.gif',text=>$LANG_VARS['delete']);
						
						echo(format_action_links(
							$action_links_rs,
							"\n<td align=\"center\" class=\"$color\" %nowrap%>%field%</td>",
							$LANG_VARS['not_applicable'])
						);
						
						$category_value = NULL;
						if(strlen(trim($child_item_r['category']))>0)
						{
							$attribute_type_r = fetch_sfieldtype_item_attribute_type_r($child_item_r['s_item_type'], 'CATEGORY', TRUE);
							if(is_array($attribute_type_r))
								$category_value = get_display_field($attribute_type_r['s_attribute_type'], $attribute_type_r['prompt'], $attribute_type_r['display_type'], $child_item_r['category'], FALSE);
						}
					
						echo("\n<td class=\"$color\" align=center>");
						if(strlen($category_value)>0)
							echo $category_value;
						else
							echo "&nbsp;";
						echo("\n</td></tr>");
					}
					echo("\n</table>");
					echo(format_help_block(array('img'=>'rs.gif','text'=>$LANG_VARS['item_reviewed'])));
				}
			}
		
			// -------------------------- REVIEWS ---------------------------------------------------------
			$result = fetch_review_rs($item_r['item_id']);
			if($result)
			{
				// inter page link
				echo("\n<a name=\"item_review\"></a>");

				echo("\n<br><div class=\"colortext\"><b>".$LANG_VARS['review(s)'].":</b>");
				if(is_user_allowed_to_review($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
					echo ("&nbsp;[<a href=\"item_review.php?op=add&item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link']."\">".$LANG_VARS['review']."</a>]");
				echo("\n</div>");

				echo ("\n<table width=90% border=0 cellpadding=1 cellspacing=1>");
				while($review_r = mysql_fetch_array($result))
				{
					$action_links_rs = NULL;
					if($CONFIG_VARS['item_review.update_support']!==FALSE)
						$action_links_rs[] = array(url=>"item_review.php?op=edit&sequence_number=".$review_r['sequence_number']."&item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link'],img=>'edit.gif',text=>$LANG_VARS['edit']);	
					if($CONFIG_VARS['item_review.delete_support']!==FALSE)
						$action_links_rs[] = array(url=>"item_review.php?op=delete&sequence_number=".$review_r['sequence_number']."&item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link'],img=>'delete.gif',text=>$LANG_VARS['delete']);	
					
					$actions = format_action_links(
								$action_links_rs,
								"<td align=\"center\" class=\"prompt\" %nowrap%><font class=\"smlink\">%field%</font></td>",
								"&nbsp;");
								
					echo("<tr><td class=\"prompt\" align=left><table width=100% cellpadding=0 cellspacing=0 border=0><tr><td class=\"prompt\" align=left>".replace_lang_vars(array('date'=>get_localised_timestamp($CONFIG_VARS['item_display.review_datetime_mask'],$review_r['update_on']),'fullname'=>fetch_user_name($review_r['author_id']), 'user_id'=>$review_r['author_id']), $LANG_VARS['on_date_name_wrote_the_following']).":</td>".
						$actions."</td></tr></table>");
					
					echo("\n<tr><td class=\"data\">");
					echo(nl2br(trim($review_r['comment'])));
					echo("<br><br>");
					$average = $review_r['rating'];
					if ($average == 0)
					{
						echo("".$LANG_VARS['no_rating']."<br>");
					}
					else
					{
						$attribute_type_r = fetch_attribute_type_r("S_RATING");
						echo $LANG_VARS['rating'].":".
							get_display_field($attribute_type_r['s_attribute_type'], 
								NULL, 
								'review()',
								$average,
								FALSE);
					}
					echo("\n<br></td></tr>\n");
				}
				echo ("</table>");
			}
			
			if(!is_array($parent_item_r))
			{
				if(is_legal_export_type($CONFIG_VARS['item_display.export_link']))
				{
					$footer_links_r[] = array(url=>"export.php?op=export&type=".$CONFIG_VARS['item_display.export_link']."&item_id=".$item_r['item_id']."&send_as_format=file",text=>replace_lang_var('type', get_display_export_type($CONFIG_VARS['item_display.export_link']), $LANG_VARS['type_export_item_record']));		
				}
			}
		}
		else // if(!in_array($status_type_r['min_display_user_type'], get_min_user_type_r($HTTP_SESSION_VARS['user_type'])))
		{
			$page_title = replace_lang_vars(array('usertype'=>get_usertype_description($HTTP_SESSION_VARS['user_type']),'s_status_type_desc'=>$status_type_r['description']),$LANG_VARS['s_status_type_display_access_disabled_for_usertype']);
			echo _theme_header($page_title);
			echo("<div class=\"error\">".$page_title."</div>");
		}
	}
	else //if(is_not_empty_array($item_r))
	{
		echo _theme_header($LANG_VARS['item_not_found']);
		echo("<div class=\"error\">".$LANG_VARS['item_not_found']."</div>");
	}//$item_r found
	
	// ------------------------------------------------------------------------------------------
	if(is_not_empty_array($parent_item_r))
	{
		$footer_links_r[] = array(url=>"$PHP_SELF?item_id=".$HTTP_VARS['parent_id']."&instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_parent']);
	}
		
	// Include a Back to Listing link.
	if($HTTP_VARS['listing_link'] === "y" && is_array($HTTP_SESSION_VARS['listing_url_vars']))
	{
		$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
	}

	echo format_footer_links($footer_links_r);
	echo _theme_footer();
}else{
	include("./include/invalidsession.php");
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
